/*
 * Decompiled with CFR 0.152.
 */
package main.seggen;

import gui.JointHistogramPanel;
import gui.LazyInitComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.media.j3d.Transform3D;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import jgridmaker.GMPanel;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.YaDiV;
import main.seggen.SegGen;
import main.seggen.atlas.Atlas;
import main.seggen.atlas.optimization.BestNeighbourOptimization;
import main.seggen.atlas.optimization.NonRigidOptimization;
import main.seggen.atlas.similarity.HistogramPartComputer;
import main.view2d.Viewport2d;
import main.view3d.Viewport3d;
import misc.messages.YObservable;
import misc.transform.AffineTransformation;
import misc.transform.NonrigidTransformation;
import misc.transform.Transformation;
import renderer.AtlasRenderer2d;
import renderer.AtlasRenderer3d;
import settings.JBoolOptionCheckbox;
import settings.JDoubleOptionTextfield;
import settings.JIntegerOptionTextfield;
import settings.Settings;
import settings.SettingsOwner;

public final class SegGenAtlas
extends SegGen
implements SettingsOwner,
LazyInitComponent {
    public static final String OPT_DEF_ATLAS_PATH = Settings.register_str_opt(SegGenAtlas.class, "Default Atlas", "The default atlas for the atlas file dialog", "");
    public static final String OPT_DEF_AFFINE_TRANSFORM_PATH = Settings.register_str_opt(SegGenAtlas.class, "Default Affine Transform", "The default affine transform (used for testing)", "");
    public static final String OPT_THREAD_COUNT = Settings.register_int_opt(SegGenAtlas.class, "Thread Count", "number of threads to use", 8);
    public static final String OPT_ROTATION_MIN = Settings.register_double_opt(SegGenAtlas.class, "rotation min", "Minimum rotation angle for affine registration", 0.05);
    public static final String OPT_ROTATION_MAX = Settings.register_double_opt(SegGenAtlas.class, "rotation max", "Maximum rotation angle for affine registration", 2.0);
    public static final String OPT_TRANS_MIN = Settings.register_double_opt(SegGenAtlas.class, "trans min", "Minimum translate length for affine registration", 0.5);
    public static final String OPT_TRANS_MAX = Settings.register_double_opt(SegGenAtlas.class, "trans max", "Maximum translate length for affine registration", 2.0);
    public static final String OPT_SCALE_MIN = Settings.register_double_opt(SegGenAtlas.class, "scale min factor", "Minimum scale factor for affine registration", 0.005);
    public static final String OPT_SCALE_MAX = Settings.register_double_opt(SegGenAtlas.class, "scale max factor", "Maximum scale factor for affine registration", 0.05);
    public static final String OPT_SCALE_AXIS = Settings.register_bool_opt(SegGenAtlas.class, "scale individual", "Scaling in each axis direction", false);
    public static final String OPT_SCALE_UNIFORM = Settings.register_bool_opt(SegGenAtlas.class, "scale uniform", "Scaling in all three axis directions", true);
    public static final String OPT_SIM_RANDOM_VOXELS = Settings.register_bool_opt(SegGenAtlas.class, "use random voxels", "Use random voxels for similiary calculation.", false);
    public static final String OPT_SIM_VOXELS = Settings.register_int_opt(SegGenAtlas.class, "considered voxels", "Percentage of voxel used for similiary calculation", 5);
    public static final String OPT_GRID_DIM_X = Settings.register_int_opt(SegGenAtlas.class, "Grid Dim X", "Control points in x direction", 5);
    public static final String OPT_GRID_DIM_Y = Settings.register_int_opt(SegGenAtlas.class, "Grid Dim Y", "Control points in Y direction", 5);
    public static final String OPT_GRID_DIM_Z = Settings.register_int_opt(SegGenAtlas.class, "Grid Dim Z", "Control points in z direction", 5);
    public static final String OPT_MUE = Settings.register_double_opt(SegGenAtlas.class, "OPT_MUE", "Follow gradient", 1.0);
    public static final String OPT_DELTA = Settings.register_double_opt(SegGenAtlas.class, "OPT_DELTA", "Finite difference factor", 0.17);
    public static final String OPT_ITERATION_COUNT = Settings.register_int_opt(SegGenAtlas.class, "iteration count", "Number of iterations", 10);
    private static Atlas _atlas = Atlas.get_instance();
    private JointHistogramPanel _jp_joint_hist = new JointHistogramPanel();
    private AtlasRenderer2d _atlas_renderer2d;
    private AtlasPanel _gm_atlas;
    private ManualRegPanel _gm_manual_reg;
    private AffinePanel _gm_affine_reg;
    private ElasticPanel _gm_elastic_reg;
    private SegmentPanel _gm_segments;
    private AtlasRenderer3d _atlas_renderer;

    public SegGenAtlas(Segment seg) {
        super(seg);
    }

    private void setManualTransform(Transform3D scaling) {
        Transformation t = _atlas.get_trans();
        if (t instanceof AffineTransformation) {
            Transform3D trans = ((AffineTransformation)t).getTrans();
            scaling.mul(trans);
            _atlas.set_trans(new AffineTransformation(scaling));
        } else {
            YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "SORRY, CANNOT MANIPULATE NONRIGID REGISTRATIONS YET!");
        }
    }

    @Override
    public void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == Atlas.M_ATLAS_LOADED) {
            HistogramPartComputer.init_voxel_color_tables();
            this._gm_atlas.atlas_loaded(true);
            this._gm_manual_reg.atlas_loaded(true);
            this._gm_affine_reg.atlas_loaded(true);
            this._gm_elastic_reg.atlas_loaded(true);
            this._gm_segments.atlas_loaded(true);
        }
    }

    @Override
    public String get_name() {
        return "SegGenAtlas " + this.getName();
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
    }

    @Override
    public void create_gui() {
        _atlas.addObserver(this, "SegGenAtlas()");
        this._gm_atlas = new AtlasPanel();
        this._gm_manual_reg = new ManualRegPanel();
        this._gm_affine_reg = new AffinePanel();
        this._gm_elastic_reg = new ElasticPanel();
        this._gm_segments = new SegmentPanel();
        JTabbedPane tabs = new JTabbedPane(3);
        tabs.add("atlas", (Component)((Object)this._gm_atlas));
        tabs.add("manual reg", (Component)((Object)this._gm_manual_reg));
        tabs.add("affine reg", (Component)((Object)this._gm_affine_reg));
        tabs.add("elastic reg", (Component)((Object)this._gm_elastic_reg));
        tabs.add("segments", (Component)((Object)this._gm_segments));
        Viewport3d v3d = MasterControl.get_v3d();
        this._atlas_renderer = new AtlasRenderer3d(v3d, 2, v3d.get_mouse_rotate());
        this.add("hist2D", this._jp_joint_hist);
        this.add("tabs", tabs);
        this.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>    <td>::hist2D::</td>    <td>::tabs::</td>  </tr></table>");
    }

    @Override
    public boolean gui_created() {
        return this._gm_atlas != null;
    }

    private final class AffinePanel
    extends GMPanel {
        private final JButton _jb_affine_reg = new JButton("Affine Registration");
        private final JDoubleOptionTextfield _jdotf_min_angle = new JDoubleOptionTextfield(SegGenAtlas.class, OPT_ROTATION_MIN, 4);
        private final JDoubleOptionTextfield _jdotf_max_angle = new JDoubleOptionTextfield(SegGenAtlas.class, OPT_ROTATION_MAX, 4);
        private final JDoubleOptionTextfield _jdotf_min_scale = new JDoubleOptionTextfield(SegGenAtlas.class, OPT_SCALE_MIN, 4);
        private final JDoubleOptionTextfield _jdotf_max_scale = new JDoubleOptionTextfield(SegGenAtlas.class, OPT_SCALE_MAX, 4);
        private final JDoubleOptionTextfield _jdotf_min_trans = new JDoubleOptionTextfield(SegGenAtlas.class, OPT_TRANS_MIN, 4);
        private final JDoubleOptionTextfield _jdotf_max_trans = new JDoubleOptionTextfield(SegGenAtlas.class, OPT_TRANS_MAX, 4);
        private final JBoolOptionCheckbox _jbocb_scale_individual = new JBoolOptionCheckbox(SegGenAtlas.class, OPT_SCALE_AXIS);
        private final JBoolOptionCheckbox _jbocb_scale_uniform = new JBoolOptionCheckbox(SegGenAtlas.class, OPT_SCALE_UNIFORM);

        public AffinePanel() {
            this.atlas_loaded(false);
            this._jb_affine_reg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (_atlas.get_trans() != null && _atlas.get_trans() instanceof AffineTransformation) {
                        AffineTransformation transform = (AffineTransformation)_atlas.get_trans();
                        new BestNeighbourOptimization(_atlas, null, true, transform).start();
                    } else {
                        new BestNeighbourOptimization(_atlas, null, true).start();
                    }
                }
            });
            this._jbocb_scale_individual.setText("individual");
            this._jbocb_scale_uniform.setText("uniform");
            GMPanel gm_scale = new GMPanel();
            gm_scale.add("_jdotf_min_scale", (JComponent)this._jdotf_min_scale);
            gm_scale.add("_jdotf_max_scale", (JComponent)this._jdotf_max_scale);
            gm_scale.add("_jbocb_scale_individual", (JComponent)this._jbocb_scale_individual);
            gm_scale.add("_jbocb_scale_uniform", (JComponent)this._jbocb_scale_uniform);
            gm_scale.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>\t   <td anchor='east'>min</td>    <td anchor='west'>::_jdotf_min_scale::</td>\t   <td anchor='east'>::_jbocb_scale_individual::</td>  </tr><tr>\t   <td anchor='east'>max</td>    <td anchor='west'>::_jdotf_max_scale::</td>    <td anchor='east'>::_jbocb_scale_uniform::</td>  </tr><tr>  </tr></table>");
            gm_scale.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Scale", 2, 2));
            GMPanel gm_trans = new GMPanel();
            gm_trans.add("_jdotf_min_trans", (JComponent)this._jdotf_min_trans);
            gm_trans.add("_jdotf_max_trans", (JComponent)this._jdotf_max_trans);
            gm_trans.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>\t   <td anchor='east'>min</td>    <td anchor='west'>::_jdotf_min_trans::</td>  </tr><tr>\t   <td anchor='east'>max</td>    <td anchor='west'>::_jdotf_max_trans::</td>  </tr></table>");
            gm_trans.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Translate", 2, 2));
            GMPanel gm_rot = new GMPanel();
            gm_rot.add("_jdotf_min_angle", (JComponent)this._jdotf_min_angle);
            gm_rot.add("_jdotf_max_angle", (JComponent)this._jdotf_max_angle);
            gm_rot.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>\t   <td anchor='east'>min</td>    <td anchor='west'>::_jdotf_min_angle::</td>  </tr><tr>\t   <td anchor='east'>max</td>    <td anchor='west'>::_jdotf_max_angle::</td>  </tr></table>");
            gm_rot.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rotate", 2, 2));
            this.add("gm_scale", (JComponent)gm_scale);
            this.add("gm_trans", (JComponent)gm_trans);
            this.add("gm_rot", (JComponent)gm_rot);
            this.add("_jb_affine_reg", this._jb_affine_reg);
            this.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>\t   <td>::gm_scale::</td>\t   <td>::gm_trans::</td>\t   <td>::gm_rot::</td>  </tr><tr>\t   <td colspan='3'>::_jb_affine_reg::</td>  </tr></table>");
        }

        public void atlas_loaded(boolean loaded) {
            this._jb_affine_reg.setEnabled(loaded);
        }
    }

    private final class AtlasPanel
    extends GMPanel {
        private final JTextField _jtf_atlas_path = new JTextField(Settings.get_str_option(SegGenAtlas.class, OPT_DEF_ATLAS_PATH));
        private final JButton _jb_atlas_select = new JButton("...");
        private final JButton _jb_atlas_load = new JButton("Load");
        private final JLabel _jl_atlas_loaded = new JLabel();
        private final JCheckBox _jcb_show_atlas2d = new JCheckBox("Show 2D Atlas");
        private final JCheckBox _jcb_show_atlas3d = new JCheckBox("Show 3D Atlas");
        private final JIntegerOptionTextfield _jiotf_threads = new JIntegerOptionTextfield(SegGenAtlas.class, OPT_THREAD_COUNT, 4);
        private final JIntegerOptionTextfield _jiotf_voxels = new JIntegerOptionTextfield(SegGenAtlas.class, OPT_SIM_VOXELS, 4);
        private final JBoolOptionCheckbox _jbocb_use_random_voxels = new JBoolOptionCheckbox(SegGenAtlas.class, OPT_SIM_RANDOM_VOXELS);

        public AtlasPanel() {
            this._jtf_atlas_path.setColumns(25);
            this._jb_atlas_select.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = new JFileChooser();
                    int state = fc.showOpenDialog(null);
                    if (state == 0) {
                        AtlasPanel.this._jtf_atlas_path.setText(fc.getSelectedFile().getAbsolutePath());
                    }
                }
            });
            this._jb_atlas_load.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtlasPanel.this._jb_atlas_load.setEnabled(false);
                    AtlasPanel.this._jb_atlas_select.setEnabled(false);
                    AtlasPanel.this._jtf_atlas_path.setEnabled(false);
                    _atlas.init_from_dir(AtlasPanel.this._jtf_atlas_path.getText());
                }
            });
            this._jcb_show_atlas2d.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Viewport2d v2d = MasterControl.get_v2d();
                    if (AtlasPanel.this._jcb_show_atlas2d.isSelected()) {
                        SegGenAtlas.this._atlas_renderer2d = new AtlasRenderer2d("AtlasRenderer2d", _atlas);
                        v2d.add_renderer(SegGenAtlas.this._atlas_renderer2d, 105);
                    } else {
                        v2d.del_renderer(SegGenAtlas.this._atlas_renderer2d);
                        SegGenAtlas.this._atlas_renderer2d.cleanup();
                        SegGenAtlas.this._atlas_renderer2d = null;
                    }
                }
            });
            this._jcb_show_atlas3d.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Viewport3d v3d = MasterControl.get_v3d();
                    Settings.set_bool_option(SegGenAtlas.this._atlas_renderer, AtlasRenderer3d.OPT_RENDER_BG, AtlasPanel.this._jcb_show_atlas3d.isSelected());
                }
            });
            this.atlas_loaded(false);
            GMPanel gm_misc = new GMPanel();
            gm_misc.add("_jiotf_threads", (JComponent)this._jiotf_threads);
            gm_misc.add("_jiotf_voxels", (JComponent)this._jiotf_voxels);
            gm_misc.add("_jbocb_use_random_voxels", (JComponent)this._jbocb_use_random_voxels);
            gm_misc.set_layout("<table width='100%' height='100%' cellpadding='2' border='0'>  <tr>\t   <td anchor='east'>Threads</td>    <td anchor='west'>::_jiotf_threads::</td>\t   <td anchor='east'>Voxel %</td>    <td anchor='west'>::_jiotf_voxels::</td>    <td>::_jbocb_use_random_voxels::</td>  </tr></table>");
            gm_misc.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Optimization", 2, 2));
            GMPanel gm_atlas = new GMPanel();
            gm_atlas.add("_jtf_atlas_path", (JComponent)this._jtf_atlas_path);
            gm_atlas.add("_jb_file_select", (JComponent)this._jb_atlas_select);
            gm_atlas.add("_jb_load", (JComponent)this._jb_atlas_load);
            gm_atlas.add("_jl_loaded", (JComponent)this._jl_atlas_loaded);
            gm_atlas.add("_jcb_show_atlas2d", (JComponent)this._jcb_show_atlas2d);
            gm_atlas.add("_jcb_show_atlas3d", (JComponent)this._jcb_show_atlas3d);
            gm_atlas.set_layout("<table width='100%' height='100%' cellpadding='2' border='0'>  <tr>\t   <td>::_jtf_atlas_path::</td>    <td>::_jb_file_select::</td>    <td>::_jb_load::</td>    <td>::_jl_loaded::</td>  </tr><tr>    <td colspan='4'>      <table width='100%' cellpadding='2' border='0'>        <tr>      \t <td>::_jcb_show_atlas2d::</td>          <td>::_jcb_show_atlas3d::</td>        </tr>      </table>    </td>  </tr></table>");
            gm_atlas.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Atlas", 2, 2));
            this.add("gm_atlas", (JComponent)gm_atlas);
            this.add("gm_misc", (JComponent)gm_misc);
            this.set_layout("<table width='100%' height='100%' cellpadding='2' border='0'>  <tr>\t   <td fill='both'>::gm_atlas::</td>  </tr><tr>    <td fill='both'>::gm_misc::</td>  </tr></table>");
        }

        public void atlas_loaded(boolean loaded) {
            if (loaded) {
                this._jl_atlas_loaded.setText("atlas loaded");
            } else {
                this._jl_atlas_loaded.setText("no atlas loaded");
            }
            this._jcb_show_atlas2d.setEnabled(loaded);
            this._jcb_show_atlas3d.setEnabled(loaded);
        }
    }

    private final class ElasticPanel
    extends GMPanel {
        private final JIntegerOptionTextfield _jiotf_grid_x = new JIntegerOptionTextfield(SegGenAtlas.class, OPT_GRID_DIM_X, 4);
        private final JIntegerOptionTextfield _jiotf_grid_y = new JIntegerOptionTextfield(SegGenAtlas.class, OPT_GRID_DIM_Y, 4);
        private final JIntegerOptionTextfield _jiotf_grid_z = new JIntegerOptionTextfield(SegGenAtlas.class, OPT_GRID_DIM_Z, 4);
        private final JIntegerOptionTextfield _jiotf_iterations = new JIntegerOptionTextfield(SegGenAtlas.class, OPT_ITERATION_COUNT, 4);
        private final JIntegerOptionTextfield _jiotf_sim_voxels = new JIntegerOptionTextfield(SegGenAtlas.class, OPT_SIM_VOXELS, 4);
        private final JDoubleOptionTextfield _jdotf_mu = new JDoubleOptionTextfield(SegGenAtlas.class, OPT_MUE, 4);
        private final JDoubleOptionTextfield _jdotf_delta = new JDoubleOptionTextfield(SegGenAtlas.class, OPT_DELTA, 4);
        private final JButton _jb_elastic_reg = new JButton("Elastic Registration");
        private final JButton _jb_inc_res = new JButton("Increase Resolution");

        public ElasticPanel() {
            this.atlas_loaded(false);
            this._jb_elastic_reg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new NonRigidOptimization(_atlas, _atlas.get_trans(), null, true).start();
                }
            });
            this._jb_inc_res.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (_atlas.get_trans() instanceof NonrigidTransformation) {
                        NonrigidTransformation trans = (NonrigidTransformation)_atlas.get_trans();
                        trans.inc_resolution();
                    }
                }
            });
            this.add("_jiotf_grid_x", this._jiotf_grid_x);
            this.add("_jiotf_grid_y", this._jiotf_grid_y);
            this.add("_jiotf_grid_z", this._jiotf_grid_z);
            this.add("_jiotf_iterations", this._jiotf_iterations);
            this.add("_jiotf_sim_voxels", this._jiotf_sim_voxels);
            this.add("_jdotf_mu", this._jdotf_mu);
            this.add("_jdotf_delta", this._jdotf_delta);
            this.add("_jb_nonrigid_reg", this._jb_elastic_reg);
            this.add("_jb_inc_res", this._jb_inc_res);
            this.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>\t   <td anchor='east'>Grid Dim X</td>\t   <td anchor='west'>::_jiotf_grid_x::</td>\t   <td anchor='east'>Iterations</td>\t   <td anchor='west'>::_jiotf_iterations::</td>\t   <td anchor='east'>mu</td>\t   <td anchor='west'>::_jdotf_mu::</td>  </tr><tr>\t   <td anchor='east'>Grid Dim Y</td>\t   <td anchor='west'>::_jiotf_grid_y::</td>\t   <td anchor='east'>Voxel %</td>\t   <td anchor='west'>::_jiotf_sim_voxels::</td>\t   <td anchor='east'>delta</td>\t   <td anchor='west'>::_jdotf_delta::</td>  </tr><tr>\t   <td anchor='east'>Grid Dim Z</td>\t   <td anchor='west'>::_jiotf_grid_z::</td>\t   <td anchor='east'> </td>\t   <td anchor='west'> </td>\t   <td anchor='east'> </td>\t   <td anchor='west'> </td>  </tr><tr>\t   <td colspan='3'>::_jb_inc_res::</td>\t   <td colspan='3'>::_jb_nonrigid_reg::</td>  </tr></table>");
        }

        public void atlas_loaded(boolean loaded) {
            this._jb_elastic_reg.setEnabled(loaded);
            this._jb_inc_res.setEnabled(loaded);
        }
    }

    private final class ManualRegPanel
    extends GMPanel {
        private final JTextField _jtf_factor = new JTextField("1.0");
        private final JButton _jb_scale = new JButton("scale");
        private final JRadioButton _jrb_scale_x = new JRadioButton("x");
        private final JRadioButton _jrb_scale_y = new JRadioButton("y");
        private final JRadioButton _jrb_scale_z = new JRadioButton("z");
        private final JCheckBox _jcb_scale_all = new JCheckBox("all");
        private final JTextField _jt_trans_x = new JTextField("0.0");
        private final JTextField _jt_trans_y = new JTextField("0.0");
        private final JTextField _jt_trans_z = new JTextField("0.0");
        private final JButton _jb_translate = new JButton("translate");
        private final JRadioButton _jrb_rot_x = new JRadioButton("x");
        private final JRadioButton _jrb_rot_y = new JRadioButton("y");
        private final JRadioButton _jrb_rot_z = new JRadioButton("z");
        private final JTextField _jtf_angle = new JTextField("0.0");
        private final JButton _jb_rotate = new JButton("rotate");
        private final JTextField _jtf_transform_path = new JTextField(Settings.get_str_option(SegGenAtlas.class, OPT_DEF_AFFINE_TRANSFORM_PATH));
        private final JButton _jb_trans_reset = new JButton("reset");
        private final JButton _jb_trans_load = new JButton("load");
        private final JButton _jb_trans_save = new JButton("save");

        public ManualRegPanel() {
            this._jrb_scale_z.setSelected(true);
            ButtonGroup bg_scale_group = new ButtonGroup();
            bg_scale_group.add(this._jrb_scale_x);
            bg_scale_group.add(this._jrb_scale_y);
            bg_scale_group.add(this._jrb_scale_z);
            this._jcb_scale_all.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManualRegPanel.this._jrb_scale_x.setEnabled(!ManualRegPanel.this._jcb_scale_all.isSelected());
                    ManualRegPanel.this._jrb_scale_y.setEnabled(!ManualRegPanel.this._jcb_scale_all.isSelected());
                    ManualRegPanel.this._jrb_scale_z.setEnabled(!ManualRegPanel.this._jcb_scale_all.isSelected());
                }
            });
            this._jb_scale.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double fac = 1.0;
                    try {
                        fac = Double.parseDouble(ManualRegPanel.this._jtf_factor.getText());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Point3f center = new Point3f((float)MasterControl.get_is().get_dim_x() / 2.0f, (float)MasterControl.get_is().get_dim_y() / 2.0f, (float)MasterControl.get_is().get_dim_z() / 2.0f);
                    Transform3D translateCenterToOrigin = new Transform3D();
                    translateCenterToOrigin.setTranslation(new Vector3f(-center.x, -center.y, -center.z));
                    Transform3D translateBack = new Transform3D();
                    translateBack.setTranslation(new Vector3f((Tuple3f)center));
                    Transform3D scaling = new Transform3D();
                    if (ManualRegPanel.this._jcb_scale_all.isSelected()) {
                        scaling.setScale(fac);
                    } else {
                        if (ManualRegPanel.this._jrb_scale_x.isSelected()) {
                            scaling.setScale(new Vector3d(fac, 1.0, 1.0));
                        }
                        if (ManualRegPanel.this._jrb_scale_y.isSelected()) {
                            scaling.setScale(new Vector3d(1.0, fac, 1.0));
                        } else if (ManualRegPanel.this._jrb_scale_z.isSelected()) {
                            scaling.setScale(new Vector3d(1.0, 1.0, fac));
                        }
                    }
                    scaling.mul(translateCenterToOrigin);
                    translateBack.mul(scaling);
                    SegGenAtlas.this.setManualTransform(translateBack);
                }
            });
            this._jb_translate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Transform3D translate = new Transform3D();
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    try {
                        x = Double.parseDouble(ManualRegPanel.this._jt_trans_x.getText());
                        y = Double.parseDouble(ManualRegPanel.this._jt_trans_y.getText());
                        z = Double.parseDouble(ManualRegPanel.this._jt_trans_z.getText());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        x = 0.0;
                        y = 0.0;
                        z = 0.0;
                    }
                    translate.setTranslation(new Vector3d(x, y, z));
                    SegGenAtlas.this.setManualTransform(translate);
                }
            });
            this._jrb_rot_z.setSelected(true);
            ButtonGroup group = new ButtonGroup();
            group.add(this._jrb_rot_x);
            group.add(this._jrb_rot_y);
            group.add(this._jrb_rot_z);
            this._jb_rotate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double ang = 0.0;
                    Point3f center = new Point3f((float)MasterControl.get_is().get_dim_x() / 2.0f, (float)MasterControl.get_is().get_dim_y() / 2.0f, (float)MasterControl.get_is().get_dim_z() / 2.0f);
                    Transform3D translateCenterToOrigin = new Transform3D();
                    translateCenterToOrigin.setTranslation(new Vector3f(-center.x, -center.y, -center.z));
                    Transform3D translateBack = new Transform3D();
                    translateBack.setTranslation(new Vector3f((Tuple3f)center));
                    try {
                        ang = Math.PI / 180 * Double.parseDouble(ManualRegPanel.this._jtf_angle.getText());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Transform3D rotation = new Transform3D();
                    if (ManualRegPanel.this._jrb_rot_z.isSelected()) {
                        rotation.rotZ(ang);
                    }
                    if (ManualRegPanel.this._jrb_rot_y.isSelected()) {
                        rotation.rotY(ang);
                    }
                    if (ManualRegPanel.this._jrb_rot_x.isSelected()) {
                        rotation.rotX(ang);
                    }
                    rotation.mul(translateCenterToOrigin);
                    translateBack.mul(rotation);
                    SegGenAtlas.this.setManualTransform(translateBack);
                }
            });
            this._jb_trans_load.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FileInputStream fis = new FileInputStream(ManualRegPanel.this._jtf_transform_path.getText());
                        ObjectInputStream in = new ObjectInputStream(fis);
                        try {
                            Object obj = in.readObject();
                            if (obj instanceof float[]) {
                                float[] arr = (float[])obj;
                                _atlas.set_trans(new AffineTransformation(new Transform3D(arr)));
                            } else if (obj instanceof NonrigidTransformation) {
                                _atlas.set_trans((NonrigidTransformation)obj);
                            } else {
                                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "UNKNOWN TYPE OF LOADED TRANSFORMATION");
                            }
                        }
                        catch (ClassNotFoundException ex) {
                            YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "COULD NOT LOAD TRANSFORM");
                        }
                        in.close();
                        fis.close();
                    }
                    catch (FileNotFoundException ex) {
                        YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "FILE DOES NOT EXIST: " + ex);
                    }
                    catch (IOException ex) {
                        YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "STH IS WRONG WITH THAT: " + ex);
                    }
                }
            });
            this._jb_trans_save.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FileOutputStream fin = new FileOutputStream(ManualRegPanel.this._jtf_transform_path.getText());
                        ObjectOutputStream out = new ObjectOutputStream(fin);
                        Transformation trans = Atlas.get_instance().get_trans();
                        if (trans instanceof AffineTransformation) {
                            float[] arr = new float[16];
                            ((AffineTransformation)trans).getTrans().get(arr);
                            out.writeObject(arr);
                        } else {
                            out.writeObject(Atlas.get_instance().get_trans());
                        }
                        out.close();
                        fin.close();
                    }
                    catch (FileNotFoundException ex) {
                        YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "FILE DOES NOT EXIST: " + ex);
                    }
                    catch (IOException ex) {
                        YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "STH IS WRONG WITH THAT: " + ex);
                    }
                }
            });
            this._jb_trans_reset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    _atlas.reset_trans();
                }
            });
            GMPanel gm_scale = new GMPanel();
            gm_scale.add("jtf_factor", (JComponent)this._jtf_factor);
            gm_scale.add("jb_scale", (JComponent)this._jb_scale);
            gm_scale.add("_jrb_scale_x", (JComponent)this._jrb_scale_x);
            gm_scale.add("_jrb_scale_y", (JComponent)this._jrb_scale_y);
            gm_scale.add("_jrb_scale_z", (JComponent)this._jrb_scale_z);
            gm_scale.add("_jcb_scale_all", (JComponent)this._jcb_scale_all);
            gm_scale.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>\t   <td anchor='east'>factor</td>\t   <td anchor='west'>::jtf_factor::</td>  </tr><tr>\t   <td colspan='2'>\t     <table width='100%' cellpadding='2' border='0'>\t       <tr>\t         <td>axis</td>\t         <td>::_jrb_scale_x::</td>\t     \t <td>::_jrb_scale_y::</td>\t     \t <td>::_jrb_scale_z::</td>\t  \t     <td>::_jcb_scale_all::</td>\t       </tr>\t     </table>    </td>  </tr><tr>\t   <td colspan='2'>::jb_scale::</td>  </tr></table>");
            gm_scale.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Scale", 2, 2));
            GMPanel gm_translate = new GMPanel();
            gm_translate.add("jt_trans_x", (JComponent)this._jt_trans_x);
            gm_translate.add("jt_trans_y", (JComponent)this._jt_trans_y);
            gm_translate.add("jt_trans_z", (JComponent)this._jt_trans_z);
            gm_translate.add("jb_translate", (JComponent)this._jb_translate);
            gm_translate.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>\t   <td anchor='east'>x</td>\t   <td anchor='west'>::jt_trans_x::</td>\t   <td anchor='east'>y</td>\t   <td anchor='west'>::jt_trans_y::</td>\t   <td anchor='east'>z</td>\t   <td anchor='west'>::jt_trans_z::</td>  </tr><tr>\t   <td colspan='6'>::jb_translate::</td>  </tr></table>");
            gm_translate.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Translate", 2, 2));
            GMPanel gm_rot = new GMPanel();
            gm_rot.add("_jrb_rot_x", (JComponent)this._jrb_rot_x);
            gm_rot.add("_jrb_rot_y", (JComponent)this._jrb_rot_y);
            gm_rot.add("_jrb_rot_z", (JComponent)this._jrb_rot_z);
            gm_rot.add("_jtf_angle", (JComponent)this._jtf_angle);
            gm_rot.add("_jb_rotate", (JComponent)this._jb_rotate);
            gm_rot.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>\t   <td width='49%' anchor='east'>angle</td>\t   <td width='1%' anchor='west'>::_jtf_angle::</td>\t   <td width='50%' anchor='west'>\u00b0</td>  </tr><tr>\t   <td colspan='3'>\t     <table width='100%' cellpadding='2' border='0'>\t       <tr>\t         <td>axis</td>\t         <td>::_jrb_rot_x::</td>\t     \t <td>::_jrb_rot_y::</td>\t     \t <td>::_jrb_rot_z::</td>\t       </tr>\t     </table>    </td>  </tr><tr>\t   <td colspan='3'>::_jb_rotate::</td>  </tr></table>");
            gm_rot.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rotate", 2, 2));
            GMPanel gm_transform_load = new GMPanel();
            gm_transform_load.add("_jtf_transform_path", (JComponent)this._jtf_transform_path);
            gm_transform_load.add("_jb_trans_load_button", (JComponent)this._jb_trans_load);
            gm_transform_load.add("_jb_trans_save_button", (JComponent)this._jb_trans_save);
            gm_transform_load.add("_jb_trans_reset", (JComponent)this._jb_trans_reset);
            gm_transform_load.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>\t   <td width='97%' fill='horizontal'>::_jtf_transform_path::</td>    <td width='1%' >::_jb_trans_load_button::</td>    <td width='1%' >::_jb_trans_save_button::</td>    <td width='1%' >::_jb_trans_reset::</td>  </tr></table>");
            gm_transform_load.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Transformation", 2, 2));
            this.add("gm_scale", (JComponent)gm_scale);
            this.add("gm_translate", (JComponent)gm_translate);
            this.add("gm_rotate", (JComponent)gm_rot);
            this.add("gm_transform_load", (JComponent)gm_transform_load);
            this.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>\t   <td fill='both'>::gm_scale::</td>    <td fill='both'>::gm_translate::</td>    <td fill='both'>::gm_rotate::</td>  </tr><tr>\t   <td colspan='3' fill='both'>::gm_transform_load::</td>  </tr></table>");
        }

        public void atlas_loaded(boolean loaded) {
            this._jb_scale.setEnabled(loaded);
            this._jb_translate.setEnabled(loaded);
            this._jb_rotate.setEnabled(loaded);
            this._jb_trans_reset.setEnabled(loaded);
            this._jb_trans_load.setEnabled(loaded);
            this._jb_trans_save.setEnabled(loaded);
            this._jtf_transform_path.setEnabled(loaded);
        }
    }

    private final class SegmentPanel
    extends GMPanel {
        private final JList _segs_list = new JList();
        private final JButton _jb_seg_load = new JButton("Load Segments");
        private final JButton _jb_seg_transform = new JButton("Transform Segments");

        public SegmentPanel() {
            this.atlas_loaded(false);
            this._segs_list.setSelectionMode(2);
            this._segs_list.setLayoutOrientation(2);
            this._segs_list.setVisibleRowCount(-1);
            JScrollPane _jsp_list_scroller = new JScrollPane(this._segs_list, 20, 30);
            _jsp_list_scroller.setPreferredSize(new Dimension(200, 80));
            this._jb_seg_load.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "Loading Segments ...");
                    FilenameFilter filter = new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".seg");
                        }
                    };
                    String path = _atlas.get_dir();
                    path = path.substring(0, path.lastIndexOf(File.separator) + 1);
                    File f = new File(path);
                    File[] list = f.listFiles(filter);
                    SegmentPanel.this._segs_list.setListData(list);
                }
            });
            this._jb_seg_transform.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "not implemented yet");
                }
            });
            this.add("_jsp_list_scroller", _jsp_list_scroller);
            this.add("_jb_seg_load", this._jb_seg_load);
            this.add("_jb_seg_transform", this._jb_seg_transform);
            this.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>\t   <td rowspan='2'>::_jsp_list_scroller::</td>\t   <td>::_jb_seg_load::</td>  </tr><tr>\t   <td>::_jb_seg_transform::</td>  </tr></table>");
        }

        public void atlas_loaded(boolean loaded) {
            this._jb_seg_load.setEnabled(loaded);
        }
    }
}

