/*
 * Decompiled with CFR 0.152.
 */
package main.seggen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.seggen.SegGen;
import main.view2d.Viewport2d;
import main.view3d.Viewport3d;
import misc.AxisAlignedBoundingBox;
import misc.Voxel;
import misc.grid.BitCube;
import misc.helper.MeasuringTools;
import misc.messages.YObservable;
import renderer.BBoxRenderer2d;
import renderer.BBoxRenderer3d;
import settings.JBoolOptionCheckbox;
import settings.Settings;
import settings.SettingsOwner;

public class SegGenBoundingBox
extends SegGen
implements SettingsOwner {
    public static final String OPT_USE_BB = Settings.register_bool_opt(SegGenBoundingBox.class, "Use Bounding Box", "Use Segmentation Bounding Box", false);
    public static final String OPT_SHOW_BB = Settings.register_bool_opt(SegGenBoundingBox.class, "Show Bounding Box", "Show Segmentation Bounding Box", false);
    public static final String OPT_RESIZE_FROMCENTER = Settings.register_bool_opt(SegGenBoundingBox.class, "Resize BB from center", "Resize BB from center", false);
    private JSpinner _js_box_pos_x;
    private JSpinner _js_box_pos_y;
    private JSpinner _js_box_pos_z;
    private JLabel _jl_box_pos_x_mm;
    private JLabel _jl_box_pos_y_mm;
    private JLabel _jl_box_pos_z_mm;
    private JSpinner _js_box_dim_x;
    private JSpinner _js_box_dim_y;
    private JSpinner _js_box_dim_z;
    private JLabel _jl_box_dim_x_mm;
    private JLabel _jl_box_dim_y_mm;
    private JLabel _jl_box_dim_z_mm;
    private JBoolOptionCheckbox _jboc_use_box;
    private JBoolOptionCheckbox _jboc_show_box;
    private JBoolOptionCheckbox _jboc_resize_from_center_box;
    private JButton _jb_use_seeds;
    private JButton _jb_use_current_slice;
    private JButton _jb_center_to_seed;
    private SpinnerNumberModel _sm_box_pos_x;
    private SpinnerNumberModel _sm_box_pos_y;
    private SpinnerNumberModel _sm_box_pos_z;
    private SpinnerNumberModel _sm_box_dim_x;
    private SpinnerNumberModel _sm_box_dim_y;
    private SpinnerNumberModel _sm_box_dim_z;

    public SegGenBoundingBox(Segment seg) {
        super(seg);
        this.init_values();
    }

    private final void init_values() {
        BitCube bc = _seg.get_bc();
        int dim_x = bc.get_dim_x() - 1;
        int dim_y = bc.get_dim_y() - 1;
        int dim_z = bc.get_dim_z() - 1;
        _seg_gen_bb.set_box(0, 0, 0, dim_x, dim_y, dim_z);
        if (this.gui_created()) {
            this._sm_box_pos_x.setMaximum(Integer.valueOf(dim_x));
            this._sm_box_pos_y.setMaximum(Integer.valueOf(dim_y));
            this._sm_box_pos_z.setMaximum(Integer.valueOf(dim_z));
            this._sm_box_dim_x.setMaximum(Integer.valueOf(dim_x));
            this._sm_box_dim_y.setMaximum(Integer.valueOf(dim_y));
            this._sm_box_dim_z.setMaximum(Integer.valueOf(dim_z));
        }
    }

    private void show_bb() {
        Viewport2d v2d = MasterControl.get_v2d();
        Viewport3d v3d = MasterControl.get_v3d();
        if (Settings.get_bool_option(SegGenBoundingBox.class, OPT_SHOW_BB).booleanValue()) {
            Settings.set_bool_option(v3d.get_seg_bbox_renderer(), BBoxRenderer3d.OPT_VISIBLE, true);
            Settings.set_bool_option(v2d.get_seg_bbox_renderer(), BBoxRenderer2d.OPT_VISIBLE, true);
        } else {
            Settings.set_bool_option(v3d.get_seg_bbox_renderer(), BBoxRenderer3d.OPT_VISIBLE, false);
            Settings.set_bool_option(v2d.get_seg_bbox_renderer(), BBoxRenderer2d.OPT_VISIBLE, false);
        }
    }

    private void update_box() {
        ImageStack is = MasterControl.get_is();
        int dim_x = is.get_dim_x() - 1;
        int dim_y = is.get_dim_y() - 1;
        int dim_z = is.get_dim_z() - 1;
        int box_pos_x = this._sm_box_pos_x.getNumber().intValue();
        int box_pos_y = this._sm_box_pos_y.getNumber().intValue();
        int box_pos_z = this._sm_box_pos_z.getNumber().intValue();
        int box_dim_x = this._sm_box_dim_x.getNumber().intValue();
        int box_dim_y = this._sm_box_dim_y.getNumber().intValue();
        int box_dim_z = this._sm_box_dim_z.getNumber().intValue();
        this._sm_box_pos_x.setMaximum(Integer.valueOf(dim_x - box_dim_x));
        this._sm_box_pos_y.setMaximum(Integer.valueOf(dim_y - box_dim_y));
        this._sm_box_pos_z.setMaximum(Integer.valueOf(dim_z - box_dim_z));
        this._sm_box_dim_x.setMaximum(Integer.valueOf(dim_x - box_pos_x));
        this._sm_box_dim_y.setMaximum(Integer.valueOf(dim_y - box_pos_y));
        this._sm_box_dim_z.setMaximum(Integer.valueOf(dim_z - box_pos_z));
        this._jl_box_pos_x_mm.setText(MeasuringTools.get_length_string((double)box_pos_x * is.get_x_spacing()));
        this._jl_box_pos_y_mm.setText(MeasuringTools.get_length_string((double)box_pos_y * is.get_y_spacing()));
        this._jl_box_pos_z_mm.setText(MeasuringTools.get_length_string((double)box_pos_z * is.get_z_spacing()));
        this._jl_box_dim_x_mm.setText(MeasuringTools.get_length_string((double)box_dim_x * is.get_x_spacing()));
        this._jl_box_dim_y_mm.setText(MeasuringTools.get_length_string((double)box_dim_y * is.get_y_spacing()));
        this._jl_box_dim_z_mm.setText(MeasuringTools.get_length_string((double)box_dim_z * is.get_z_spacing()));
        _seg_gen_bb.set_box(box_pos_x, box_pos_y, box_pos_z, box_pos_x + box_dim_x, box_pos_y + box_dim_y, box_pos_z + box_dim_z);
    }

    private void update_from_box() {
        if (this._sm_box_pos_x != null) {
            this._sm_box_pos_x.setValue(_seg_gen_bb.get_min_x());
            this._sm_box_pos_y.setValue(_seg_gen_bb.get_min_y());
            this._sm_box_pos_z.setValue(_seg_gen_bb.get_min_z());
            this._sm_box_dim_x.setValue(_seg_gen_bb.get_max_x() - _seg_gen_bb.get_min_x());
            this._sm_box_dim_y.setValue(_seg_gen_bb.get_max_y() - _seg_gen_bb.get_min_y());
            this._sm_box_dim_z.setValue(_seg_gen_bb.get_max_z() - _seg_gen_bb.get_min_z());
        }
    }

    private void center_to_seed() {
    }

    @Override
    public final void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == ImageStack.M_LOADING_END || m._type == ImageStack.M_RESIZE_END) {
            this.init_values();
        } else if (m._type == AxisAlignedBoundingBox.M_BB_CHANGED) {
            this.update_from_box();
        }
    }

    @Override
    public String get_name() {
        return "SegGen Bounding Box";
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (obj == SegGenBoundingBox.class) {
            if (opt_name == OPT_USE_BB) {
                SegGen.use_bb(Settings.get_bool_option(SegGenBoundingBox.class, OPT_USE_BB));
            } else if (opt_name == OPT_SHOW_BB) {
                this.show_bb();
            }
        }
    }

    @Override
    public void create_gui() {
        BitCube bc = _seg.get_bc();
        this._jboc_use_box = new JBoolOptionCheckbox(SegGenBoundingBox.class, OPT_USE_BB);
        this._jboc_show_box = new JBoolOptionCheckbox(SegGenBoundingBox.class, OPT_SHOW_BB);
        this._jboc_resize_from_center_box = new JBoolOptionCheckbox(SegGenBoundingBox.class, OPT_RESIZE_FROMCENTER);
        this._jb_center_to_seed = new JButton("Center to Seed");
        this._jb_center_to_seed.setToolTipText("Centers selected bounding box at seed");
        this._jb_center_to_seed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenBoundingBox.this.center_to_seed();
            }
        });
        this._jb_use_seeds = new JButton("Use Seed Dimenions");
        this._jb_use_seeds.setToolTipText("Use the seeds to define SegGen Bounding Box");
        this._jb_use_seeds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageStack is = MasterControl.get_is();
                LinkedList<Voxel> seeds = is.get_seeds();
                Iterator si = seeds.iterator();
                Voxel v = (Voxel)si.next();
                Voxel seed_min = new Voxel(v);
                Voxel seed_max = new Voxel(v);
                while (si.hasNext()) {
                    v = (Voxel)si.next();
                    if (v._x < seed_min._x) {
                        seed_min._x = v._x;
                    }
                    if (v._y < seed_min._y) {
                        seed_min._y = v._y;
                    }
                    if (v._z < seed_min._z) {
                        seed_min._z = v._z;
                    }
                    if (v._x > seed_max._x) {
                        seed_max._x = v._x;
                    }
                    if (v._y > seed_max._y) {
                        seed_max._y = v._y;
                    }
                    if (v._z <= seed_max._z) continue;
                    seed_max._z = v._z;
                }
                SegGenBoundingBox.this._sm_box_pos_x.setValue(seed_min._x);
                SegGenBoundingBox.this._sm_box_pos_y.setValue(seed_min._y);
                SegGenBoundingBox.this._sm_box_pos_z.setValue(seed_min._z);
                SegGenBoundingBox.this._sm_box_dim_x.setValue(seed_max._x - seed_min._x);
                SegGenBoundingBox.this._sm_box_dim_y.setValue(seed_max._y - seed_min._y);
                SegGenBoundingBox.this._sm_box_dim_z.setValue(seed_max._z - seed_min._z);
            }
        });
        this._jb_use_current_slice = new JButton("Use View2D Slice");
        this._jb_use_current_slice.setToolTipText("Use image shown in View2d");
        this._jb_use_current_slice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int active_image = MasterControl.get_v2d().get_model().get_active_image();
                ImageStack is = MasterControl.get_is();
                switch (MasterControl.get_v2d().get_model().get_view_mode()) {
                    case 0: {
                        SegGenBoundingBox.this._sm_box_pos_x.setValue(0);
                        SegGenBoundingBox.this._sm_box_pos_y.setValue(0);
                        SegGenBoundingBox.this._sm_box_pos_z.setValue(active_image);
                        SegGenBoundingBox.this._sm_box_dim_x.setValue(is.get_dim_x() - 1);
                        SegGenBoundingBox.this._sm_box_dim_y.setValue(is.get_dim_y() - 1);
                        SegGenBoundingBox.this._sm_box_dim_z.setValue(0);
                        break;
                    }
                    case 1: {
                        SegGenBoundingBox.this._sm_box_pos_x.setValue(active_image);
                        SegGenBoundingBox.this._sm_box_pos_y.setValue(0);
                        SegGenBoundingBox.this._sm_box_pos_z.setValue(0);
                        SegGenBoundingBox.this._js_box_dim_x.setValue(0);
                        SegGenBoundingBox.this._js_box_dim_z.setValue(is.get_dim_z() - 1);
                        SegGenBoundingBox.this._js_box_dim_y.setValue(is.get_dim_y() - 1);
                        break;
                    }
                    case 2: {
                        SegGenBoundingBox.this._sm_box_pos_x.setValue(0);
                        SegGenBoundingBox.this._sm_box_pos_y.setValue(active_image);
                        SegGenBoundingBox.this._sm_box_pos_z.setValue(0);
                        SegGenBoundingBox.this._js_box_dim_x.setValue(is.get_dim_x() - 1);
                        SegGenBoundingBox.this._js_box_dim_z.setValue(0);
                        SegGenBoundingBox.this._js_box_dim_y.setValue(is.get_dim_z() - 1);
                    }
                }
            }
        });
        int dim_x = bc.get_dim_x();
        int dim_y = bc.get_dim_y();
        int dim_z = bc.get_dim_z();
        _seg_gen_bb.set_box(0, 0, 0, dim_x, dim_y, dim_z);
        ChangeListener trigger_update = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SegGenBoundingBox.this.update_box();
            }
        };
        JLabel jl_template = new JLabel("10000.005 mm");
        Dimension d = jl_template.getPreferredSize();
        this._jl_box_pos_x_mm = new JLabel("0");
        this._jl_box_pos_x_mm.setPreferredSize(new Dimension(d.width, d.height));
        this._jl_box_pos_y_mm = new JLabel("0");
        this._jl_box_pos_y_mm.setPreferredSize(new Dimension(d.width, d.height));
        this._jl_box_pos_z_mm = new JLabel("0");
        this._jl_box_pos_z_mm.setPreferredSize(new Dimension(d.width, d.height));
        this._jl_box_dim_x_mm = new JLabel("0");
        this._jl_box_dim_x_mm.setPreferredSize(new Dimension(d.width, d.height));
        this._jl_box_dim_y_mm = new JLabel("0");
        this._jl_box_dim_y_mm.setPreferredSize(new Dimension(d.width, d.height));
        this._jl_box_dim_z_mm = new JLabel("0");
        this._jl_box_dim_z_mm.setPreferredSize(new Dimension(d.width, d.height));
        this._sm_box_pos_x = new SpinnerNumberModel(0, 0, dim_x, 1);
        this._sm_box_pos_x.addChangeListener(trigger_update);
        this._js_box_pos_x = new JSpinner(this._sm_box_pos_x);
        this._sm_box_pos_y = new SpinnerNumberModel(0, 0, dim_y, 1);
        this._sm_box_pos_y.addChangeListener(trigger_update);
        this._js_box_pos_y = new JSpinner(this._sm_box_pos_y);
        this._sm_box_pos_z = new SpinnerNumberModel(0, 0, dim_z, 1);
        this._sm_box_pos_z.addChangeListener(trigger_update);
        this._js_box_pos_z = new JSpinner(this._sm_box_pos_z);
        this._sm_box_dim_x = new SpinnerNumberModel(0, 0, dim_x, 1);
        this._sm_box_dim_x.addChangeListener(trigger_update);
        this._js_box_dim_x = new JSpinner(this._sm_box_dim_x);
        this._sm_box_dim_y = new SpinnerNumberModel(0, 0, dim_y, 1);
        this._sm_box_dim_y.addChangeListener(trigger_update);
        this._js_box_dim_y = new JSpinner(this._sm_box_dim_y);
        this._sm_box_dim_z = new SpinnerNumberModel(0, 0, dim_z, 1);
        this._sm_box_dim_z.addChangeListener(trigger_update);
        this._js_box_dim_z = new JSpinner(this._sm_box_dim_z);
        GMPanel gmp_pos = new GMPanel();
        gmp_pos.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "position", 2, 2));
        gmp_pos.add("box_pos_x", (JComponent)this._js_box_pos_x);
        gmp_pos.add("box_pos_y", (JComponent)this._js_box_pos_y);
        gmp_pos.add("box_pos_z", (JComponent)this._js_box_pos_z);
        gmp_pos.add("box_pos_x_mm", (JComponent)this._jl_box_pos_x_mm);
        gmp_pos.add("box_pos_y_mm", (JComponent)this._jl_box_pos_y_mm);
        gmp_pos.add("box_pos_z_mm", (JComponent)this._jl_box_pos_z_mm);
        gmp_pos.set_layout("<table width='100%' cellpadding='2' border='0'>  <colgroup>    <col width='1%'/>    <col width='98%'/>    <col width='1%'/>  </colgroup>  <tr>    <td>x pos</td>    <td fill='horizontal'>::box_pos_x::</td>    <td>::box_pos_x_mm::</td>  </tr><tr>    <td>y pos</td>    <td fill='horizontal'>::box_pos_y::</td>    <td>::box_pos_y_mm::</td>  </tr><tr>    <td>z pos</td>    <td fill='horizontal'>::box_pos_z::</td>    <td>::box_pos_z_mm::</td>  </tr></table>");
        GMPanel gmp_dim = new GMPanel();
        gmp_dim.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "size", 2, 2));
        gmp_dim.add("box_dim_x", (JComponent)this._js_box_dim_x);
        gmp_dim.add("box_dim_y", (JComponent)this._js_box_dim_y);
        gmp_dim.add("box_dim_z", (JComponent)this._js_box_dim_z);
        gmp_dim.add("box_dim_x_mm", (JComponent)this._jl_box_dim_x_mm);
        gmp_dim.add("box_dim_y_mm", (JComponent)this._jl_box_dim_y_mm);
        gmp_dim.add("box_dim_z_mm", (JComponent)this._jl_box_dim_z_mm);
        gmp_dim.set_layout("<table width='100%' cellpadding='2' border='0'>  <colgroup>    <col width='1%'/>    <col width='98%'/>    <col width='1%'/>  </colgroup>  <tr>    <td>x size</td>    <td fill='horizontal'>::box_dim_x::</td>    <td>::box_dim_x_mm::</td>  </tr><tr>    <td>y size</td>    <td fill='horizontal'>::box_dim_y::</td>    <td>::box_dim_y_mm::</td>  </tr><tr>    <td>z size</td>    <td fill='horizontal'>::box_dim_z::</td>    <td>::box_dim_z_mm::</td>  </tr></table>");
        GMPanel gmp_other = new GMPanel();
        gmp_other.add("jb_center_to_seed", (JComponent)this._jb_center_to_seed);
        gmp_other.add("jb_use_seeds", (JComponent)this._jb_use_seeds);
        gmp_other.add("jb_use_current_slice", (JComponent)this._jb_use_current_slice);
        gmp_other.set_layout("<table cellpadding='2' border='0'>  <tr>    <td fill='horizontal'>::jb_center_to_seed::</td>  </tr><tr>    <td fill='horizontal'>::jb_use_seeds::</td>  </tr><tr>    <td fill='horizontal'>::jb_use_current_slice::</td>  </tr></table>");
        this.add("gmp_pos", (JComponent)gmp_pos);
        this.add("gmp_dim", (JComponent)gmp_dim);
        this.add("gmp_other", (JComponent)gmp_other);
        this.add("_jb_show_box", this._jboc_use_box);
        this.add("_jb_use_box", this._jboc_show_box);
        this.add("_jb_resize_from_center_box", this._jboc_resize_from_center_box);
        this.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>    <td fill='both' width='49%'>::gmp_pos::</td>    <td fill='both' width='49%'>::gmp_dim::</td>    <td width='2%'>::gmp_other::</td>  </tr><tr>    <td colspan='3'>      <table>        <tr>          <td anchor='east'>::_jb_use_box::</td>          <td anchor='west'>::_jb_show_box::</td>          <td anchor='west'>::_jb_resize_from_center_box::</td>        </tr>      </table>    </td>  </tr></table>");
        this.show_bb();
        Settings.register_class_listener(SegGenBoundingBox.class, this);
        this.init_values();
        this.check_state();
        this.update_from_box();
    }

    @Override
    public boolean gui_created() {
        return this._jboc_use_box != null;
    }
}

