/*
 * Decompiled with CFR 0.152.
 */
package main.seggen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.YDialogs;
import main.YaDiV;
import main.seggen.SegGen;
import main.seggen.connect.CompareType;
import main.seggen.connect.ConnectedPart;
import main.seggen.connect.PartRenderer2d;
import main.seggen.connect.PartRenderer3d;
import misc.Voxel;
import misc.grid.BitCube;
import misc.grid.PaddedBitCube;
import misc.grid.RegularGrid3i;
import misc.messages.YObservable;
import threads.RSThread;

public class SegGenConnect
extends SegGen {
    private GMPanel _gmp_gen_val_border = new GMPanel();
    private JButton _jb_gen_connect = new JButton("Calculate Connectivity");
    private JButton _jb_gen_value_border = new JButton("Go");
    private JButton _jb_export_stats = new JButton("Export Statistics");
    private JButton _jb_del_parts = new JButton("Delete");
    private JTextField _jtf_border_value = new JTextField("0");
    private final ArrayList<ConnectedPart> _parts = new ArrayList();
    private PartTable _part_table;
    private boolean _gui_created = false;
    private boolean _connectivity_calculated = false;
    private boolean _val_border_calculated = false;
    private boolean _just_updated = false;
    private PartRenderer2d _part_renderer2d;
    private PartRenderer3d _part_renderer3d;

    public void update_buttons() {
        this._jb_gen_connect.setEnabled(true);
        this._gmp_gen_val_border.setEnabled(this._connectivity_calculated);
        this._jb_del_parts.setEnabled(this._part_table.getSelectedRowCount() != 0);
        this._jb_export_stats.setEnabled(this._connectivity_calculated);
    }

    public SegGenConnect(Segment seg) {
        super(seg);
    }

    private void export_statistics() {
        String file_name;
        File file;
        JFileChooser fc = new JFileChooser();
        int ret_val = fc.showSaveDialog(null);
        if (ret_val == 0 && (!(file = new File(file_name = fc.getSelectedFile().getAbsolutePath())).exists() || YDialogs.overwrite_file_dialog(file.getName()))) {
            ImageStack is = MasterControl.get_is();
            double voxel_volume = is.get_x_spacing() * is.get_y_spacing() * is.get_z_spacing();
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(file_name));
                bw.write("Part #;Voxel #;Volume (mm\u00b3);min;max;mean;Volume Border;Value Border\n");
                int i = 0;
                while (i < this._parts.size()) {
                    ConnectedPart p = this._parts.get(i);
                    String line = String.valueOf(i + 1) + ";" + p.get_voxel_number() + ";" + (double)p.get_voxel_number() * voxel_volume;
                    line = String.valueOf(line) + ";" + p.get_min() + ";" + p.get_max() + ";" + p.get_mean();
                    line = String.valueOf(line) + ";" + p.touches_volume_border();
                    line = String.valueOf(line) + ";" + (this._val_border_calculated ? Boolean.valueOf(p.touches_value_border()) : "?");
                    line = String.valueOf(line) + "\n";
                    bw.write(line);
                    ++i;
                }
                bw.close();
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "Statistics saved (" + this._parts.size() + ")");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void delete_parts() {
        RSThread t = new RSThread(null, true, false){

            @Override
            public void my_run() {
                int row;
                int[] selected_rows = SegGenConnect.this._part_table.getSelectedRows();
                this.init_progress_measure("deleting parts ...", 0, selected_rows.length, 0);
                ArrayList<Integer> del_numbers = new ArrayList<Integer>();
                int i = selected_rows.length - 1;
                while (i >= 0) {
                    row = SegGenConnect.this._part_table.convertRowIndexToModel(selected_rows[i]);
                    del_numbers.add(row);
                    --i;
                }
                Collections.sort(del_numbers);
                i = del_numbers.size() - 1;
                while (i >= 0) {
                    row = (Integer)del_numbers.get(i);
                    ConnectedPart p = (ConnectedPart)SegGenConnect.this._parts.get(row);
                    p.delete();
                    SegGenConnect.this._parts.remove(row);
                    this.inc_progress_value(1);
                    --i;
                }
                SegGenConnect.this._part_table.clearSelection();
                SegGenConnect.this._part_table.update();
                SegGenConnect.this._just_updated = true;
                _seg.new_data(true);
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "deleted " + selected_rows.length + " parts");
            }
        };
        t.start();
    }

    private void detect_value_border(Segment seg, final int border_value) {
        RSThread t = new RSThread(null, true, false){

            @Override
            public void my_run() {
                RegularGrid3i vc = MasterControl.get_is().get_voxel_cube();
                this.init_progress_measure("detecting border parts ...", 0, SegGenConnect.this._parts.size(), 0);
                int i = 0;
                while (i < SegGenConnect.this._parts.size()) {
                    ConnectedPart p = (ConnectedPart)SegGenConnect.this._parts.get(i);
                    p.detect_value_border(vc, border_value, CompareType.EQUALS);
                    this.inc_progress_value(1);
                    ++i;
                }
                SegGenConnect.this._val_border_calculated = true;
                SegGenConnect.this._part_table.update();
                SegGenConnect.this.update_buttons();
            }
        };
        t.start();
    }

    private PaddedBitCube init_gotcha(BitCube bc) {
        int z;
        PaddedBitCube gotcha = new PaddedBitCube(bc.get_dim_x(), bc.get_dim_y(), bc.get_dim_z(), 1);
        int min_x_border = _bb_min[0] - 1;
        int max_x_border = _bb_max[0] + 1;
        int min_y_border = _bb_min[1] - 1;
        int max_y_border = _bb_max[1] + 1;
        int min_z_border = _bb_min[2] - 1;
        int max_z_border = _bb_max[2] + 1;
        int x = min_x_border;
        while (x < max_x_border) {
            int y = min_y_border;
            while (y < max_y_border) {
                gotcha.setXYZ(x, y, min_z_border, true);
                gotcha.setXYZ(x, y, max_z_border, true);
                ++y;
            }
            ++x;
        }
        x = min_x_border;
        while (x < max_x_border) {
            z = min_z_border;
            while (z < max_z_border) {
                gotcha.setXYZ(x, min_y_border, z, true);
                gotcha.setXYZ(x, max_y_border, z, true);
                ++z;
            }
            ++x;
        }
        int y = min_y_border;
        while (y < max_y_border) {
            z = min_z_border;
            while (z < max_z_border) {
                gotcha.setXYZ(min_x_border, y, z, true);
                gotcha.setXYZ(max_x_border, y, z, true);
                ++z;
            }
            ++y;
        }
        return gotcha;
    }

    private void detect_connected_parts(final Segment seg) {
        RSThread t = new RSThread(null, true, false){

            @Override
            public void my_run() {
                BitCube seg_bc = seg.get_bc();
                int dim_x = seg_bc.get_dim_x();
                int dim_y = seg_bc.get_dim_y();
                int dim_z = seg_bc.get_dim_z();
                SegGenConnect.this._part_table.clearSelection();
                SegGenConnect.this._parts.clear();
                SegGenConnect.this._part_table.update();
                PaddedBitCube gotcha = SegGenConnect.this.init_gotcha(seg_bc);
                BitCube border_gotcha = new BitCube(dim_x, dim_y, dim_z);
                RegularGrid3i vc = MasterControl.get_is().get_voxel_cube();
                int processed_voxel_num = 0;
                int slice_size = (_bb_max[1] - _bb_min[1]) * (_bb_max[0] - _bb_min[0]);
                int slize_number = _bb_max[2] - _bb_min[1];
                System.out.println("slice_size = " + slice_size);
                this.init_progress_measure("scanning segment ...", 0, slize_number, 0);
                int z = _bb_min[2];
                while (z <= _bb_max[2]) {
                    int y = _bb_min[1];
                    while (y <= _bb_max[1]) {
                        int x = _bb_min[0];
                        while (x <= _bb_max[0]) {
                            if (!gotcha.getXYZ(x, y, z) && seg_bc.getXYZ(x, y, z)) {
                                ConnectedPart p = new ConnectedPart(_seg.get_bc(), new Voxel(x, y, z));
                                border_gotcha.clear();
                                processed_voxel_num += p.trace(vc, gotcha, border_gotcha, this, processed_voxel_num, slice_size);
                                SegGenConnect.this._parts.add(p);
                            } else if (++processed_voxel_num % slice_size == 0) {
                                this.inc_progress_value(1);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                this.set_progress_val(slize_number);
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "detected " + SegGenConnect.this._parts.size() + " parts");
                SegGenConnect.this._connectivity_calculated = true;
                SegGenConnect.this._part_table.update();
                SegGenConnect.this.update_buttons();
            }
        };
        t.start();
    }

    @Override
    public void update(YObservable o, Message m) {
        super.update(o, m);
        if (o == _seg && m._type == Segment.M_SEG_CHANGED) {
            if (this._just_updated) {
                this._just_updated = false;
            } else {
                this._connectivity_calculated = false;
                this._val_border_calculated = false;
                this._parts.clear();
                this._part_table.update();
                this.update_buttons();
            }
        }
    }

    @Override
    public void create_gui() {
        this._jb_gen_connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenConnect.this.detect_connected_parts(_seg);
            }
        });
        this._jb_gen_value_border.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenConnect.this.detect_value_border(_seg, Integer.parseInt(SegGenConnect.this._jtf_border_value.getText()));
            }
        });
        this._jb_export_stats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenConnect.this.export_statistics();
            }
        });
        this._jb_del_parts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenConnect.this.delete_parts();
            }
        });
        this._jtf_border_value.setColumns(5);
        this._gmp_gen_val_border.add("jb_gen_value_border", (JComponent)this._jb_gen_value_border);
        this._gmp_gen_val_border.add("jtf_border_value", (JComponent)this._jtf_border_value);
        this._gmp_gen_val_border.set_layout("<table cellpadding='0' border='0'>  <tr>    <td>Calculate value</td>    <td>::jtf_border_value::</td>    <td>contact</td>    <td>::jb_gen_value_border::</td>  </tr></table>");
        this._part_table = new PartTable();
        this._part_table.setFillsViewportHeight(true);
        JScrollPane table_scroller = new JScrollPane(this._part_table){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 100);
            }
        };
        this._part_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selected_row_number = SegGenConnect.this._part_table.getSelectedRowCount();
                SegGenConnect.this._jb_del_parts.setEnabled(selected_row_number != 0);
                ConnectedPart[] selected_parts = null;
                if (selected_row_number != 0) {
                    int[] selected_rows = SegGenConnect.this._part_table.getSelectedRows();
                    selected_parts = new ConnectedPart[selected_rows.length];
                    int i = 0;
                    while (i < selected_parts.length) {
                        int row = selected_rows[i];
                        int part_idx = SegGenConnect.this._part_table.convertRowIndexToModel(row);
                        selected_parts[i] = (ConnectedPart)SegGenConnect.this._parts.get(part_idx);
                        ++i;
                    }
                }
                SegGenConnect.this._part_renderer2d.show_parts(selected_parts);
                SegGenConnect.this._part_renderer3d.show_parts(selected_parts);
            }
        });
        this.add("jb_gen_connect", this._jb_gen_connect);
        this.add("gmp_gen_val_border", (JComponent)this._gmp_gen_val_border);
        this.add("part_table", table_scroller);
        this.add("jb_export_stats", this._jb_export_stats);
        this.add("jb_del_parts", this._jb_del_parts);
        this.set_layout("<table cellpadding='2' border='0' width='100%' height='100%'>  <tr height='99%'>    <td fill='both' colspan='4'>::part_table::</td>  </tr><tr height='1%'>    <td width='99%' anchor='west'>::jb_del_parts::</td>    <td width='1%'>::jb_gen_connect::</td>    <td width='1%'>::gmp_gen_val_border::</td>    <td width='1%'>::jb_export_stats::</td>  </tr></table>");
        _seg.addObserver(this, "ConnectedParts");
        this._part_renderer2d = new PartRenderer2d();
        MasterControl.get_v2d().add_renderer(this._part_renderer2d, 999);
        this._part_renderer3d = new PartRenderer3d(MasterControl.get_v3d());
        this._part_renderer3d.set_visible(false);
        this._part_renderer3d.set_visible(true);
        this.update_buttons();
        this._gui_created = true;
    }

    @Override
    public boolean gui_created() {
        return this._gui_created;
    }

    private class PartTable
    extends JTable {
        private final DefaultTableModel _tm;
        private final String[] _column_names = new String[]{"Part #", " Voxel #", "Volume (mm\u00b3)", "Min", "Max", "Mean", "VoB", "VaB"};

        public PartTable() {
            this._tm = new DefaultTableModel(){

                @Override
                public Class<?> getColumnClass(int col) {
                    Class col_class = Integer.class;
                    if (col == 2 || col == 5) {
                        col_class = Double.class;
                    }
                    if (col == 6 || col == 7) {
                        col_class = String.class;
                    }
                    return col_class;
                }
            };
            Object[][] table_data = new Object[6][this._column_names.length];
            this._tm.setDataVector(table_data, this._column_names);
            this.setAutoResizeMode(2);
            this.setModel(this._tm);
            this.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.setAutoCreateRowSorter(true);
        }

        public void update() {
            final Object[][] table_data = new Object[SegGenConnect.this._parts.size()][this._column_names.length];
            ImageStack is = MasterControl.get_is();
            double voxel_volume = is.get_x_spacing() * is.get_y_spacing() * is.get_z_spacing();
            int i = 0;
            while (i < table_data.length) {
                ConnectedPart p = (ConnectedPart)SegGenConnect.this._parts.get(i);
                table_data[i][0] = new Integer(i + 1);
                table_data[i][1] = new Integer(p.get_voxel_number());
                table_data[i][2] = new Double((double)p.get_voxel_number() * voxel_volume);
                table_data[i][3] = new Integer(p.get_min());
                table_data[i][4] = new Integer(p.get_max());
                table_data[i][5] = new Double(p.get_mean());
                table_data[i][6] = p.touches_volume_border() ? new String("+") : new String(" ");
                table_data[i][7] = SegGenConnect.this._val_border_calculated ? (p.touches_value_border() ? new String("+") : new String(" ")) : new String("?");
                ++i;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PartTable.this._tm.setDataVector(table_data, PartTable.this._column_names);
                }
            });
        }
    }
}

