/*
 * Decompiled with CFR 0.152.
 */
package main.seggen;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.vecmath.Vector3f;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.VoxelCubeHistogram;
import main.seggen.SegGen;
import misc.grid.BitCube;
import misc.grid.RegularGrid3i;
import misc.grid.gradients.GradientCachingMethod;
import misc.grid.gradients.GradientFunction;
import misc.grid.gradients.GradientFunctionFactory;
import misc.grid.gradients.GradientFunctionType;
import misc.messages.YObservable;
import settings.JDoubleOptionTFSlider;
import settings.Settings;

public class SegGenEdge
extends SegGen {
    public static final String OPT_GRADIENT_LENGTH = Settings.register_double_opt(SegGenEdge.class, "Gradient Length", "Gradient Length", 0.1);
    private JDoubleOptionTFSlider _jtf_gl;
    private JComboBox _gradient_selector;

    public SegGenEdge(Segment seg) {
        super(seg);
    }

    private void init_values() {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 2) {
            RegularGrid3i vc = is.get_voxel_cube();
            BitCube bc = _seg.get_bc();
            GradientFunction gradient_function = GradientFunctionFactory.create_gradient_function(vc, GradientFunctionType.CENTRAL_DIFFERENCES, GradientCachingMethod.ON_THE_FLY);
            bc.clear();
            Vector3f gradient = new Vector3f();
            int dim_x = vc.get_dim_x();
            int dim_y = vc.get_dim_y();
            int dim_z = vc.get_dim_z();
            float min = Float.MAX_VALUE;
            float max = Float.MIN_NORMAL;
            int z = 1;
            while (z < dim_z - 1) {
                int y = 1;
                while (y < dim_y - 1) {
                    int idx = z * vc.get_img_size() + y * dim_x;
                    int x = 1;
                    while (x < dim_x - 1) {
                        gradient_function.gradient_at(idx++, gradient);
                        float length = gradient.lengthSquared();
                        if (length < min) {
                            min = length;
                        }
                        if (length > max) {
                            max = length;
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            this._jtf_gl.setMinimum(min);
            this._jtf_gl.setMaximum(max /= 4.0f);
            this._jtf_gl.setValue((max - min) / 2.0f);
        }
    }

    @Override
    public final void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == VoxelCubeHistogram.M_VCH_UPDATE) {
            this.init_values();
        }
    }

    @Override
    public void create_gui() {
        ImageStack is = MasterControl.get_is();
        is.get_vch().addObserver(this, "SegGenEdge()");
        JButton but_gen = new JButton("Generate");
        this._gradient_selector = new JComboBox<GradientFunctionType>(GradientFunctionType.values());
        but_gen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageStack is = MasterControl.get_is();
                RegularGrid3i vc = is.get_voxel_cube();
                BitCube bc = _seg.get_bc();
                GradientFunctionType gradient_function_type = (GradientFunctionType)((Object)SegGenEdge.this._gradient_selector.getSelectedItem());
                GradientFunction gradient_function = GradientFunctionFactory.create_gradient_function(vc, gradient_function_type, GradientCachingMethod.ON_THE_FLY);
                int r = gradient_function.get_filter_radius() + 1;
                bc.clear();
                Vector3f gradient = new Vector3f();
                int[] real_bb_min = new int[3];
                int[] real_bb_max = new int[3];
                int dim_x = vc.get_dim_x();
                int dim_y = vc.get_dim_y();
                int dim_z = vc.get_dim_z();
                real_bb_min[0] = _bb_min[0] < r ? r : _bb_min[0];
                real_bb_min[1] = _bb_min[1] < r ? r : _bb_min[1];
                real_bb_min[2] = _bb_min[2] < r ? r : _bb_min[2];
                real_bb_max[0] = _bb_max[0] > dim_x - r ? dim_x - r - 1 : _bb_max[0];
                real_bb_max[1] = _bb_max[1] > dim_y - r ? dim_y - r - 1 : _bb_max[1];
                real_bb_max[2] = _bb_max[2] > dim_z - r ? dim_z - r - 1 : _bb_max[2];
                float vl = Settings.get_double_option(SegGenEdge.class, OPT_GRADIENT_LENGTH).floatValue();
                int z = real_bb_min[2];
                while (z <= real_bb_max[2]) {
                    int y = real_bb_min[1];
                    while (y <= real_bb_max[1]) {
                        int idx = z * vc.get_img_size() + y * vc.get_dim_y();
                        int x = real_bb_min[0];
                        while (x <= real_bb_max[0]) {
                            gradient_function.gradient_at(idx++, gradient);
                            if (gradient.lengthSquared() > vl) {
                                bc.setXYZ(x, y, z, true);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                _seg.new_data(true);
            }
        });
        this._jtf_gl = new JDoubleOptionTFSlider(SegGenEdge.class, OPT_GRADIENT_LENGTH, 0.0, 0.5, 2, 8);
        GMPanel gm_gradient = new GMPanel();
        gm_gradient.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Gradient based Edge Detection", 2, 2));
        gm_gradient.add("_gradient_selector", (JComponent)this._gradient_selector);
        gm_gradient.add("_jtf_gl", (JComponent)this._jtf_gl);
        gm_gradient.add("but_gen", (JComponent)but_gen);
        gm_gradient.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>    <td colspan='3' fill='horizontal'>::_jtf_gl::</td>  </tr><tr>    <td anchor='east'>Gradient Function</td>    <td anchor='west'>::_gradient_selector::</td>    <td anchor='east'>::but_gen::</td>  </tr></table>");
        this.add("gm_gradient", (JComponent)gm_gradient);
        this.set_layout("<table width='100%' height='100%' cellpadding='2' border='0'>  <tr>    <td fill='both'>::gm_gradient::</td>  </tr></table>");
        this.init_values();
        this.check_state();
    }

    @Override
    public boolean gui_created() {
        return this._gradient_selector != null;
    }
}

