/*
 * Decompiled with CFR 0.152.
 */
package main.seggen;

import gui.JTFSliderDouble;
import gui.JTFSliderInt;
import gui.MyToolbar;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import jgridmaker.GMPanel;
import main.MasterControl;
import main.Segment;
import main.seggen.SegGen;
import main.view2d.Viewport2d;
import misc.grid.BitMask;

public final class SegGenManual
extends SegGen {
    public static int C_BRUSH_NUMBER = 8;
    public static int S_BRUSH_NUMBER = 8;
    public static int START_BRUSH = 3;
    private JCheckBox _jcb_use_variance;
    private ImageIcon[] _c_brush_icons;
    private BitMask[] _c_brush_masks;
    private ImageIcon[] _s_brush_icons;
    private BitMask[] _s_brush_masks;
    private ButtonGroup _brush_group;
    private JTFSliderDouble _jtf_variance;
    private double _variance;
    private int _brush_num = 2;
    public static final double START_VALUE = 0.1;

    public SegGenManual(Segment seg) {
        super(seg);
        this.load_start_brush_image();
    }

    private void load_start_brush_image() {
        ImageIcon _c_brush_icon = new ImageIcon("resources/gfx/freedraw_c" + (START_BRUSH + 1) + ".png");
        BufferedImage bi = new BufferedImage(_c_brush_icon.getIconWidth(), _c_brush_icon.getIconHeight(), 2);
        bi.getGraphics().drawImage(_c_brush_icon.getImage(), 0, 0, (ImageObserver)((Object)this));
        int bb_min_y = Integer.MAX_VALUE;
        int bb_min_x = Integer.MAX_VALUE;
        int bb_max_y = Integer.MIN_VALUE;
        int bb_max_x = Integer.MIN_VALUE;
        int y = 0;
        while (y < _c_brush_icon.getIconHeight()) {
            int x = 0;
            while (x < _c_brush_icon.getIconWidth()) {
                if (bi.getRGB(x, y) != 0) {
                    if (x < bb_min_x) {
                        bb_min_x = x;
                    }
                    if (y < bb_min_y) {
                        bb_min_y = y;
                    }
                    if (x > bb_max_x) {
                        bb_max_x = x;
                    }
                    if (y > bb_max_y) {
                        bb_max_y = y;
                    }
                }
                ++x;
            }
            ++y;
        }
        BitMask _c_brush_mask = new BitMask(bb_max_x - bb_min_x + 1, bb_max_y - bb_min_y + 1);
        int y2 = bb_min_y;
        while (y2 <= bb_max_y) {
            int x = bb_min_x;
            while (x <= bb_max_x) {
                if (bi.getRGB(x, y2) != 0) {
                    _c_brush_mask.setXY(x - bb_min_x, y2 - bb_min_y, true);
                }
                ++x;
            }
            ++y2;
        }
        MasterControl.get_v2d()._draw_seg_listener.set_brush_mask_cursor(_c_brush_mask, _c_brush_icon.getImage());
        MasterControl.get_v2d()._erase_seg_listener.set_brush_mask_cursor(_c_brush_mask, _c_brush_icon.getImage());
    }

    @Override
    public void create_gui() {
        int x;
        int y;
        int bb_max_x;
        int bb_max_y;
        int bb_min_x;
        int bb_min_y;
        BufferedImage bi;
        this._brush_group = new ButtonGroup();
        this._c_brush_icons = new ImageIcon[C_BRUSH_NUMBER];
        this._c_brush_masks = new BitMask[C_BRUSH_NUMBER];
        int i = 0;
        while (i < C_BRUSH_NUMBER) {
            this._c_brush_icons[i] = new ImageIcon("resources/gfx/freedraw_c" + (i + 1) + ".png");
            bi = new BufferedImage(this._c_brush_icons[i].getIconWidth(), this._c_brush_icons[i].getIconHeight(), 2);
            bi.getGraphics().drawImage(this._c_brush_icons[i].getImage(), 0, 0, (ImageObserver)((Object)this));
            bb_min_y = Integer.MAX_VALUE;
            bb_min_x = Integer.MAX_VALUE;
            bb_max_y = Integer.MIN_VALUE;
            bb_max_x = Integer.MIN_VALUE;
            y = 0;
            while (y < this._c_brush_icons[i].getIconHeight()) {
                x = 0;
                while (x < this._c_brush_icons[i].getIconWidth()) {
                    if (bi.getRGB(x, y) != 0) {
                        if (x < bb_min_x) {
                            bb_min_x = x;
                        }
                        if (y < bb_min_y) {
                            bb_min_y = y;
                        }
                        if (x > bb_max_x) {
                            bb_max_x = x;
                        }
                        if (y > bb_max_y) {
                            bb_max_y = y;
                        }
                    }
                    ++x;
                }
                ++y;
            }
            this._c_brush_masks[i] = new BitMask(bb_max_x - bb_min_x + 1, bb_max_y - bb_min_y + 1);
            y = bb_min_y;
            while (y <= bb_max_y) {
                x = bb_min_x;
                while (x <= bb_max_x) {
                    if (bi.getRGB(x, y) != 0) {
                        this._c_brush_masks[i].setXY(x - bb_min_x, y - bb_min_y, true);
                    }
                    ++x;
                }
                ++y;
            }
            ++i;
        }
        this._s_brush_icons = new ImageIcon[S_BRUSH_NUMBER];
        this._s_brush_masks = new BitMask[S_BRUSH_NUMBER];
        i = 0;
        while (i < S_BRUSH_NUMBER) {
            this._s_brush_icons[i] = new ImageIcon("resources/gfx/freedraw_s" + (i + 1) + ".png");
            bi = new BufferedImage(this._s_brush_icons[i].getIconWidth(), this._s_brush_icons[i].getIconHeight(), 2);
            bi.getGraphics().drawImage(this._s_brush_icons[i].getImage(), 0, 0, (ImageObserver)((Object)this));
            bb_min_y = Integer.MAX_VALUE;
            bb_min_x = Integer.MAX_VALUE;
            bb_max_y = Integer.MIN_VALUE;
            bb_max_x = Integer.MIN_VALUE;
            y = 0;
            while (y < this._s_brush_icons[i].getIconHeight()) {
                x = 0;
                while (x < this._s_brush_icons[i].getIconWidth()) {
                    if (bi.getRGB(x, y) != 0) {
                        if (x < bb_min_x) {
                            bb_min_x = x;
                        }
                        if (y < bb_min_y) {
                            bb_min_y = y;
                        }
                        if (x > bb_max_x) {
                            bb_max_x = x;
                        }
                        if (y > bb_max_y) {
                            bb_max_y = y;
                        }
                    }
                    ++x;
                }
                ++y;
            }
            this._s_brush_masks[i] = new BitMask(bb_max_x - bb_min_x + 1, bb_max_y - bb_min_y + 1);
            y = bb_min_y;
            while (y <= bb_max_y) {
                x = bb_min_x;
                while (x <= bb_max_x) {
                    if (bi.getRGB(x, y) != 0) {
                        this._s_brush_masks[i].setXY(x - bb_min_x, y - bb_min_y, true);
                    }
                    ++x;
                }
                ++y;
            }
            ++i;
        }
        MasterControl.get_v2d()._draw_seg_listener.set_brush_mask_cursor(this._c_brush_masks[START_BRUSH], this._c_brush_icons[START_BRUSH].getImage());
        MasterControl.get_v2d()._erase_seg_listener.set_brush_mask_cursor(this._c_brush_masks[START_BRUSH], this._c_brush_icons[START_BRUSH].getImage());
        CBrushToolBar cbtb = new CBrushToolBar();
        SBrushToolBar sbtb = new SBrushToolBar();
        this._jcb_use_variance = new JCheckBox("Use Variance");
        this._jcb_use_variance.setToolTipText("Hold shift key to toggle while drawing");
        this._jcb_use_variance.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Viewport2d v2d = MasterControl.get_v2d();
                v2d._draw_seg_listener.use_brush_variance(SegGenManual.this._jcb_use_variance.isSelected());
                v2d._draw_seg_listener.set_brush_variance(SegGenManual.this._variance);
                v2d._erase_seg_listener.use_brush_variance(SegGenManual.this._jcb_use_variance.isSelected());
                v2d._erase_seg_listener.set_brush_variance(SegGenManual.this._variance);
            }
        });
        this._jtf_variance = new JTFSliderDouble(0.0, 1.0, 0.1);
        this._jtf_variance.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                if (JTFSliderInt.JTF_CHANGE.equals(property)) {
                    Viewport2d v2d = MasterControl.get_v2d();
                    SegGenManual.this._variance = (Double)propertyChangeEvent.getNewValue();
                    v2d._draw_seg_listener.set_brush_variance(SegGenManual.this._variance);
                    v2d._erase_seg_listener.set_brush_variance(SegGenManual.this._variance);
                }
            }
        });
        GMPanel gm_brushes = new GMPanel();
        gm_brushes.add("cbtb", (JComponent)cbtb);
        gm_brushes.add("sbtb", (JComponent)sbtb);
        gm_brushes.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::cbtb::</td>  </tr><tr>    <td>::sbtb::</td>  </tr></table>");
        GMPanel gm_variance = new GMPanel();
        gm_variance.add("_jcb_use_variance", (JComponent)this._jcb_use_variance);
        gm_variance.add("_jtf_variance", (JComponent)this._jtf_variance);
        gm_variance.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::_jtf_variance::</td>  </tr><tr>    <td>::_jcb_use_variance::</td>  </tr></table>");
        gm_brushes.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Brushes", 2, 2));
        gm_variance.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Variance", 2, 2));
        this.add("gm_brushes", (JComponent)gm_brushes);
        this.add("gm_variance", (JComponent)gm_variance);
        this.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::gm_brushes::</td>    <td>::gm_variance::</td>  </tr></table>");
        this.check_state();
    }

    @Override
    public boolean gui_created() {
        return this._jcb_use_variance != null;
    }

    private final class CBrushToolBar
    extends MyToolbar {
        public CBrushToolBar() {
            int i = 0;
            while (i < C_BRUSH_NUMBER) {
                AbstractAction act_brush = new AbstractAction("brush " + (i + 1), SegGenManual.this._c_brush_icons[i]){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JToggleButton jtb = (JToggleButton)e.getSource();
                        Action aa = jtb.getAction();
                        SegGenManual.this._brush_num = (Integer)aa.getValue("brush_number");
                        Viewport2d v2d = MasterControl.get_v2d();
                        v2d._draw_seg_listener.set_brush_mask_cursor(SegGenManual.this._c_brush_masks[SegGenManual.this._brush_num], SegGenManual.this._c_brush_icons[SegGenManual.this._brush_num].getImage());
                        v2d._erase_seg_listener.set_brush_mask_cursor(SegGenManual.this._c_brush_masks[SegGenManual.this._brush_num], SegGenManual.this._c_brush_icons[SegGenManual.this._brush_num].getImage());
                    }
                };
                act_brush.putValue("brush_number", new Integer(i));
                JToggleButton jtb = this.add_toggle_button(act_brush, "Choose Circle Brush " + (i + 1), i == SegGenManual.this._brush_num, SegGenManual.this._brush_group);
                if (i == START_BRUSH) {
                    jtb.setSelected(true);
                }
                ++i;
            }
        }
    }

    private final class SBrushToolBar
    extends MyToolbar {
        public SBrushToolBar() {
            int i = 0;
            while (i < S_BRUSH_NUMBER) {
                AbstractAction act_brush = new AbstractAction("brush " + (i + 1), SegGenManual.this._s_brush_icons[i]){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JToggleButton jtb = (JToggleButton)e.getSource();
                        Action aa = jtb.getAction();
                        SegGenManual.this._brush_num = (Integer)aa.getValue("brush_number");
                        Viewport2d v2d = MasterControl.get_v2d();
                        v2d._draw_seg_listener.set_brush_mask_cursor(SegGenManual.this._s_brush_masks[SegGenManual.this._brush_num], SegGenManual.this._s_brush_icons[SegGenManual.this._brush_num].getImage());
                        v2d._erase_seg_listener.set_brush_mask_cursor(SegGenManual.this._s_brush_masks[SegGenManual.this._brush_num], SegGenManual.this._s_brush_icons[SegGenManual.this._brush_num].getImage());
                    }
                };
                act_brush.putValue("brush_number", new Integer(i));
                JToggleButton jToggleButton = this.add_toggle_button(act_brush, "Choose Square Brush " + (i + 1), i == SegGenManual.this._brush_num, SegGenManual.this._brush_group);
                ++i;
            }
        }
    }
}

