/*
 * Decompiled with CFR 0.152.
 */
package main.seggen;

import gui.HistoPanel;
import gui.JRangeSlider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.VoxelCubeHistogram;
import main.seggen.SegGen;
import misc.Voxel;
import misc.grid.BitCube;
import misc.grid.RegularGrid3i;
import misc.messages.YObservable;
import settings.JBoolOptionCheckbox;
import settings.JEnumOptionComboBox;
import settings.Settings;
import settings.SettingsOwner;
import threads.SegmentingThread;

public final class SegGenRange
extends SegGen
implements SettingsOwner {
    public static final String OPT_AUTO_UPDATE = Settings.register_bool_opt(SegGenRange.class, "Auto Update", "Update Segment immidiately when min or max changes", true);
    public static final String OPT_MIN = Settings.register_int_opt(SegGenRange.class, "Minimum", "Range Minimum", 0);
    public static final String OPT_MAX = Settings.register_int_opt(SegGenRange.class, "Maximum", "Range Maximum", 0);
    public static final String OPT_VALUE_TYPE = Settings.register_enum_opt(SegGenRange.class, "Value Type", "Value Type", ValueTypes.RAW);
    public static final Color HIGHLITE_COLOR = new Color(255, 0, 0, 64);
    private JFormattedTextField _jftf_min;
    private JFormattedTextField _jftf_max;
    private JRangeSlider _jrs;
    private JButton _but_gen;
    private JButton _use_seeds_min;
    private JButton _use_seeds_max;
    private JEnumOptionComboBox _jeoc_value_type;
    private JBoolOptionCheckbox _jbcb_auto_update;
    private HistoPanel _hp;
    private boolean _init_phase = false;

    public void paint(Graphics g) {
        super.paint(g);
    }

    public SegGenRange(Segment seg) {
        super(seg);
    }

    private void init_values() {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 2) {
            int min = is.get_vch()._min_nonzero_index;
            int max = is.get_vch()._max_nonzero_index;
            this._init_phase = true;
            this._jrs.setMinimum(min);
            this._jrs.setMaximum(max);
            this._jrs.setRange(min + (max - min) / 2, min + (max - min) / 2);
            Settings.set_class_int_option(SegGenRange.class, OPT_MIN, min + (max - min) / 2);
            Settings.set_class_int_option(SegGenRange.class, OPT_MAX, min + (max - min) / 2);
            this.update_text_fields();
            this._init_phase = false;
        }
    }

    private void update_text_fields() {
        int min = Settings.get_int_option(SegGenRange.class, OPT_MIN);
        int max = Settings.get_int_option(SegGenRange.class, OPT_MAX);
        ValueTypes type = (ValueTypes)Settings.get_enum_option(SegGenRange.class, OPT_VALUE_TYPE);
        ImageStack is = MasterControl.get_is();
        if (type == ValueTypes.RAW) {
            min = is.get_raw_value(min);
            max = is.get_raw_value(max);
        } else {
            min = is.get_scaled_value(min);
            max = is.get_scaled_value(max);
        }
        this._jftf_min.setValue(new Integer(min));
        this._jftf_max.setValue(new Integer(max));
    }

    @Override
    public final void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == VoxelCubeHistogram.M_VCH_UPDATE) {
            this.init_values();
        }
    }

    @Override
    public String get_name() {
        return "SegGen Range";
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (obj == SegGenRange.class) {
            if (opt_name == OPT_MIN || opt_name == OPT_MAX) {
                this._jrs.setRange(Settings.get_int_option(SegGenRange.class, OPT_MIN), Settings.get_int_option(SegGenRange.class, OPT_MAX));
                int min = Settings.get_int_option(SegGenRange.class, OPT_MIN);
                int max = Settings.get_int_option(SegGenRange.class, OPT_MAX);
                this._hp.highlight_interval(min, max, HIGHLITE_COLOR);
                if (!this._init_phase && Settings.get_bool_option(SegGenRange.class, OPT_AUTO_UPDATE).booleanValue() && max - min > 0) {
                    CreateRangeSegThread rg_thread = new CreateRangeSegThread(true, this);
                    rg_thread.run();
                }
                this.update_text_fields();
            } else if (opt_name == OPT_VALUE_TYPE) {
                this.update_text_fields();
            }
            this.repaint();
        }
    }

    @Override
    public void create_gui() {
        Settings.register_class_listener(SegGenRange.class, this);
        ImageStack is = MasterControl.get_is();
        is.get_vch().addObserver(this, "SegGenRange()");
        this._jftf_min = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this._jftf_min.setColumns(8);
        this._jftf_min.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int min = Integer.parseInt(SegGenRange.this._jftf_min.getText());
                ValueTypes type = (ValueTypes)Settings.get_enum_option(SegGenRange.class, OPT_VALUE_TYPE);
                ImageStack is = MasterControl.get_is();
                if (type == ValueTypes.RAW) {
                    min = is.get_voxel_value(min);
                } else {
                    min = is.calc_undo_dicom_rescale(min);
                    min = is.get_voxel_value(min);
                }
                Settings.set_class_int_option(SegGenRange.class, OPT_MIN, min);
            }
        });
        this._jftf_max = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this._jftf_max.setColumns(8);
        this._jftf_max.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int max = Integer.parseInt(SegGenRange.this._jftf_max.getText());
                ValueTypes type = (ValueTypes)Settings.get_enum_option(SegGenRange.class, OPT_VALUE_TYPE);
                ImageStack is = MasterControl.get_is();
                if (type == ValueTypes.RAW) {
                    max = is.get_voxel_value(max);
                } else {
                    max = is.calc_undo_dicom_rescale(max);
                    max = is.get_voxel_value(max);
                }
                Settings.set_class_int_option(SegGenRange.class, OPT_MAX, max);
            }
        });
        this._jbcb_auto_update = new JBoolOptionCheckbox(SegGenRange.class, OPT_AUTO_UPDATE);
        this._hp = new HistoPanel(is.get_vch(), "HPRange", false, false);
        JPanel hp_container = new JPanel();
        hp_container.setBorder(new EmptyBorder(0, 16, 0, 16));
        hp_container.setLayout(new BorderLayout());
        hp_container.add((Component)this._hp, "Center");
        Settings.set_bool_option(this._hp, HistoPanel.OPT_SHOW_ALL, false);
        this._but_gen = new JButton("Generate");
        final SegGenRange instance = this;
        this._but_gen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateRangeSegThread rg_threat = new CreateRangeSegThread(true, instance);
                rg_threat.start();
            }
        });
        this._jrs = new JRangeSlider(0, 1000, 100, 300, 1);
        this._jrs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Settings.set_class_int_option(SegGenRange.class, OPT_MIN, SegGenRange.this._jrs.getLowValue());
                Settings.set_class_int_option(SegGenRange.class, OPT_MAX, SegGenRange.this._jrs.getHighValue());
            }
        });
        this.init_values();
        this._use_seeds_min = new JButton("use seed(s)");
        this._use_seeds_min.setToolTipText("Sets range min to minimum of all selected seed values");
        this._use_seeds_min.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageStack is = MasterControl.get_is();
                Iterator vi = is.get_seeds().iterator();
                int min = Integer.MAX_VALUE;
                while (vi.hasNext()) {
                    Voxel v = (Voxel)vi.next();
                    int val = is.get_voxel_cube().get(v._x, v._y, v._z);
                    if (val >= min) continue;
                    min = val;
                }
                Settings.set_class_int_option(SegGenRange.class, OPT_MIN, min);
            }
        });
        this._use_seeds_max = new JButton("use seed(s)");
        this._use_seeds_max.setToolTipText("Sets range max to maximum of all selected seed values");
        this._use_seeds_max.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageStack is = MasterControl.get_is();
                Iterator vi = is.get_seeds().iterator();
                int max = Integer.MIN_VALUE;
                while (vi.hasNext()) {
                    Voxel v = (Voxel)vi.next();
                    int val = is.get_voxel_cube().get(v._x, v._y, v._z);
                    if (val <= max) continue;
                    max = val;
                }
                Settings.set_class_int_option(SegGenRange.class, OPT_MAX, max);
            }
        });
        this._jeoc_value_type = new JEnumOptionComboBox(SegGenRange.class, OPT_VALUE_TYPE);
        this.add("_auto_update", this._jbcb_auto_update);
        this.add("but_gen", this._but_gen);
        this.add("jcb_auto", this._jbcb_auto_update);
        this.add("but_gen", this._but_gen);
        this.add("_hp", hp_container);
        this.add("tf_min", this._jftf_min);
        this.add("tf_max", this._jftf_max);
        this.add("_jrs", this._jrs);
        this.add("use_min", this._use_seeds_min);
        this.add("use_max", this._use_seeds_max);
        this.add("value_type", this._jeoc_value_type);
        this.set_layout("<table width='100%' height='100%' cellpadding='0' border='0'>  <tr height='97%'>    <td fill='both'>::_hp::</td>  </tr><tr height='6%'>    <td fill='horizontal'>::_jrs::</td>  </tr><tr height='1%'>    <td fill='horizontal'>     <table width='100%' cellpadding='0' cellspacing='0' margin='0' border='0'>       <tr>         <td width='1%' anchor='west'>::tf_min::</td>         <td width='1%' anchor='west'>Min</td>         <td width='96%'>::value_type::</td>         <td width='1%' anchor='east'>Max</td>         <td width='1%' anchor='east'>::tf_max::</td>       </tr>     </table>   </td>  </tr><tr height='1%'>    <td fill='horizontal'>     <table width='100%' cellpadding='0' cellspacing='0' margin='0' border='0'>       <tr>         <td width='1%' colspan='2' anchor='west'>::use_min::</td>         <td width='98%' >           <table cellpadding='0' cellspacing='0' margin='0'>             <tr>               <td>::but_gen::</td>               <td>::jcb_auto::</td>             </tr>           </table>         </td>         <td width='1%'  colspan='2' anchor='east'>::use_max::</td>       </tr>     </table>   </td>  </tr></table>");
        this.check_state();
    }

    @Override
    public boolean gui_created() {
        return this._jftf_min != null;
    }

    private final class CreateRangeSegThread
    extends SegmentingThread {
        public CreateRangeSegThread(boolean monitor, SettingsOwner parent) {
            super(parent, monitor);
            this._label = "range segmentation";
        }

        @Override
        public void my_run() {
            ImageStack is = MasterControl.get_is();
            RegularGrid3i vc = is.get_voxel_cube();
            BitCube bc = _seg.get_bc();
            int min = Settings.get_int_option(SegGenRange.class, OPT_MIN);
            int max = Settings.get_int_option(SegGenRange.class, OPT_MAX);
            this.init_progress_measure("Range Seg", _bb_min[2], _bb_max[2], _bb_min[2]);
            bc.clear();
            int z = _bb_min[2];
            while (z <= _bb_max[2]) {
                this.set_progress_val(z);
                int y = _bb_min[1];
                while (y <= _bb_max[1]) {
                    int x = _bb_min[0];
                    while (x <= _bb_max[0]) {
                        int value = vc.get(x, y, z);
                        if (value >= min && value <= max) {
                            bc.setXYZ(x, y, z, true);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            _seg.new_data(true);
        }
    }

    public static enum ValueTypes {
        RAW,
        SCALED;

    }
}

