/*
 * Decompiled with CFR 0.152.
 */
package main.seggen;

import gui.HistoPanel;
import gui.SegSelector;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.seggen.SegGen;
import misc.StopWatch;
import misc.Voxel;
import misc.VoxelQueue;
import misc.grid.BitCube;
import misc.grid.RegularGrid3i;
import misc.messages.YObservable;
import renderer.BGImageRenderer2d;
import settings.JBoolOptionCheckbox;
import settings.JDoubleOptionTFSlider;
import settings.Settings;
import settings.SettingsOwner;
import threads.SegmentingThread;

public final class SegGenRegionGrow
extends SegGen
implements SettingsOwner {
    public static final String OPT_VARIANCE = Settings.register_double_opt(SegGenRegionGrow.class, "Variance", "The variance used for region grow algorithm (each voxel that differsvariance * max possible value from the seed value is accepted).", 0.1);
    public static final String OPT_AUTO_UPDATE = Settings.register_bool_opt(SegGenRegionGrow.class, "Auto Update", "Update Segment immidiately when variance changes", false);
    public static final String OPT_USE_ROI_VALUES = Settings.register_bool_opt(SegGenRegionGrow.class, "Use ROI Values", "If enabled, the voxel the visual voxel values (= voxel values modified by ROI function) are used", false);
    public static final String OPT_USE_SPACING = Settings.register_bool_opt(SegGenRegionGrow.class, "Use Spacing", "If enabled, the variance is scaled with the voxel spacing in x-, y- and z-direction", true);
    public static final Color HIGHLITE_COLOR = new Color(255, 0, 0, 64);
    private JDoubleOptionTFSlider _jtf_variance;
    private JBoolOptionCheckbox _jbocb_auto_update;
    private JBoolOptionCheckbox _jbocb_use_visuell_grad;
    private JBoolOptionCheckbox _jbocb_use_spacing;
    private SegSelector _seg_sel;
    private CreateRegionGrowThread _rg_thread;
    private HistoPanel _hp;
    private AllowedRange _ar = new AllowedRange();
    private static SegGenRegionGrow _instance;

    public SegGenRegionGrow(Segment seg) {
        super(seg);
        Settings.register_class_listener(SegGenRegionGrow.class, this);
    }

    public static void start_stop() {
        if (_instance == null) {
            return;
        }
        if (SegGenRegionGrow._instance._rg_thread == null || SegGenRegionGrow._instance._rg_thread.getState() == Thread.State.TERMINATED) {
            _instance.start_region_grow();
        } else {
            SegGenRegionGrow._instance._rg_thread.stop_soon();
        }
    }

    private void start_region_grow() {
        if (this._rg_thread == null || this._rg_thread.getState() == Thread.State.TERMINATED) {
            this._rg_thread = new CreateRegionGrowThread(true, this);
            this._rg_thread.start();
        } else {
            this._rg_thread.restart();
        }
    }

    private void update_range() {
        this.init_value_mapping(Settings.get_bool_option(SegGenRegionGrow.class, OPT_USE_ROI_VALUES));
        this._ar.calc_range();
        int min = Math.min(Math.min(this._ar._min_x, this._ar._min_y), this._ar._min_z);
        int max = Math.max(Math.max(this._ar._max_x, this._ar._max_y), this._ar._max_z);
        if (Settings.get_bool_option(SegGenRegionGrow.class, OPT_USE_ROI_VALUES).booleanValue()) {
            ImageStack is = MasterControl.get_is();
            BGImageRenderer2d v2d_renderer = MasterControl.get_v2d().get_bg_image_renderer();
            int intercept = is.get_intercept();
            int slope = is.get_slope();
            int w_width = Settings.get_int_option(v2d_renderer, BGImageRenderer2d.OPT_W_WIDTH);
            int c_center = (Settings.get_int_option(v2d_renderer, BGImageRenderer2d.OPT_W_CENTER) - intercept) / slope;
            int w_min = c_center - w_width / 2;
            int w_max = c_center + w_width / 2;
            double fact = (double)w_width / 256.0;
            min = w_min + (int)Math.round(fact * (double)min);
            max = w_max + (int)Math.round(fact * (double)max);
        }
        this._hp.highlight_interval(min, max, HIGHLITE_COLOR);
    }

    @Override
    public void create_gui() {
        ImageStack is = MasterControl.get_is();
        this._seg_sel = new SegSelector("Block Segment(s)");
        this._seg_sel.setSelectionMode(2);
        this._jbocb_use_spacing = new JBoolOptionCheckbox(SegGenRegionGrow.class, OPT_USE_SPACING);
        this._jbocb_auto_update = new JBoolOptionCheckbox(SegGenRegionGrow.class, OPT_AUTO_UPDATE);
        this._jtf_variance = new JDoubleOptionTFSlider(SegGenRegionGrow.class, OPT_VARIANCE, 0.0, 0.5);
        this._jbocb_use_visuell_grad = new JBoolOptionCheckbox(SegGenRegionGrow.class, OPT_USE_ROI_VALUES);
        this._hp = new HistoPanel(is.get_vch(), "HPRegionGrow", false, true);
        JButton but_gen = new JButton("Generate");
        but_gen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenRegionGrow.this.start_region_grow();
            }
        });
        JPanel jp_generate = new JPanel();
        jp_generate.add(but_gen);
        jp_generate.add(this._jbocb_auto_update);
        GMPanel yp_variance = new GMPanel();
        yp_variance.add("_jbocb_use_visuell_grad", (JComponent)this._jbocb_use_visuell_grad);
        yp_variance.add("_jbocb_use_spacing", (JComponent)this._jbocb_use_spacing);
        yp_variance.add("_jtf_variance", (JComponent)this._jtf_variance);
        yp_variance.add("_hp", (JComponent)this._hp);
        yp_variance.add("jp_generate", (JComponent)jp_generate);
        yp_variance.set_layout("<table width='100%' height='100%' border='0'>  <tr height='97%'>    <td colspan='3' fill='both'>::_hp::</td>  </tr><tr height='1%'>    <td width='98%' anchor='west'>Variance:</td>    <td width='1%' anchor='east'>::_jbocb_use_spacing::</td>    <td width='1%' anchor='east'>::_jbocb_use_visuell_grad::</td>  </tr><tr height='1%'>    <td colspan='3' fill='horizontal'>::_jtf_variance::</td>  </tr><tr height='1%'>    <td colspan='3'>::jp_generate::</td>  </tr></table>");
        this.add("yp_variance", (JComponent)yp_variance);
        this.add("_auto_update", this._jbocb_auto_update);
        this.add("_seg_sel", this._seg_sel);
        this.add("but_gen", but_gen);
        this.set_layout("<table width='100%' height='100%' cellpadding='2' border='0'>  <tr>    <td width='99%' fill='both'>::yp_variance::</td>    <td width='1%' fill='both'>::_seg_sel::</td>  </tr></table>");
        this.update_range();
        this.check_state();
        _instance = this;
    }

    @Override
    public boolean gui_created() {
        return this._jtf_variance != null;
    }

    @Override
    public String get_name() {
        return "SegGen Region Grow";
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (obj == SegGenRegionGrow.class) {
            this.update_range();
            if (opt_name == OPT_VARIANCE && Settings.get_bool_option(SegGenRegionGrow.class, OPT_AUTO_UPDATE).booleanValue()) {
                this.start_region_grow();
            }
        }
    }

    @Override
    public void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == ImageStack.M_SELECTXYZ && this.gui_created()) {
            this.update_range();
        }
    }

    public class AllowedRange {
        public int _min_x;
        public int _min_y;
        public int _min_z;
        public int _max_x;
        public int _max_y;
        public int _max_z;

        public void calc_range() {
            ImageStack is = MasterControl.get_is();
            RegularGrid3i vc = is.get_voxel_cube();
            double seed_value = 0.0;
            LinkedList<Voxel> seeds = is.get_seeds();
            for (Voxel seed : seeds) {
                if (_use_bb && !_seg_gen_bb.is_inside(seed)) continue;
                System.out.println("_value_mapping = " + SegGenRegionGrow.this._value_mapping);
                System.out.println("seed = " + seed);
                seed_value += (double)SegGenRegionGrow.this._value_mapping[vc.get(seed._x, seed._y, seed._z)];
            }
            seed_value /= (double)is.get_seeds().size();
            int total_max = Settings.get_bool_option(SegGenRegionGrow.class, OPT_USE_ROI_VALUES) != false ? 128 : is.get_voxel_value_range() / 2;
            double variance = Settings.get_double_option(SegGenRegionGrow.class, OPT_VARIANCE);
            if (Settings.get_bool_option(SegGenRegionGrow.class, OPT_USE_SPACING).booleanValue()) {
                double min_spacing = is.get_min_spacing();
                double x_factor = is.get_x_spacing() / min_spacing;
                double y_factor = is.get_y_spacing() / min_spacing;
                double z_factor = is.get_z_spacing() / min_spacing;
                this._min_x = (int)Math.round(seed_value - variance * (double)total_max * x_factor);
                this._max_x = (int)Math.round(seed_value + variance * (double)total_max * x_factor);
                this._min_y = (int)Math.round(seed_value - variance * (double)total_max * y_factor);
                this._max_y = (int)Math.round(seed_value + variance * (double)total_max * y_factor);
                this._min_z = (int)Math.round(seed_value - variance * (double)total_max * z_factor);
                this._max_z = (int)Math.round(seed_value + variance * (double)total_max * z_factor);
            } else {
                this._min_x = (int)Math.round(seed_value - variance * (double)total_max);
                this._max_x = (int)Math.round(seed_value + variance * (double)total_max);
                this._min_y = (int)Math.round(seed_value - variance * (double)total_max);
                this._max_y = (int)Math.round(seed_value + variance * (double)total_max);
                this._min_z = (int)Math.round(seed_value - variance * (double)total_max);
                this._max_z = (int)Math.round(seed_value + variance * (double)total_max);
            }
        }
    }

    private final class CreateRegionGrowThread
    extends SegmentingThread {
        private BitCube _gotcha;

        public CreateRegionGrowThread(boolean monitor, SettingsOwner parent) {
            super(parent, monitor);
            this._label = "region grow segmentation";
        }

        private void init_gotcha() {
            int z;
            BitCube bc = _seg.get_bc();
            this._gotcha = new BitCube(bc.get_dim_x() + 2, bc.get_dim_y() + 2, bc.get_dim_z() + 2);
            int min_x_border = 1 + _bb_min[0] - 1;
            int max_x_border = 1 + _bb_max[0] + 1;
            int min_y_border = 1 + _bb_min[1] - 1;
            int max_y_border = 1 + _bb_max[1] + 1;
            int min_z_border = 1 + _bb_min[2] - 1;
            int max_z_border = 1 + _bb_max[2] + 1;
            int x = min_x_border;
            while (x < max_x_border) {
                int y = min_y_border;
                while (y < max_y_border) {
                    this._gotcha.setXYZ(x, y, min_z_border, true);
                    this._gotcha.setXYZ(x, y, max_z_border, true);
                    ++y;
                }
                ++x;
            }
            x = min_x_border;
            while (x < max_x_border) {
                z = min_z_border;
                while (z < max_z_border) {
                    this._gotcha.setXYZ(x, min_y_border, z, true);
                    this._gotcha.setXYZ(x, max_y_border, z, true);
                    ++z;
                }
                ++x;
            }
            int y = min_y_border;
            while (y < max_y_border) {
                z = min_z_border;
                while (z < max_z_border) {
                    this._gotcha.setXYZ(min_x_border, y, z, true);
                    this._gotcha.setXYZ(max_x_border, y, z, true);
                    ++z;
                }
                ++y;
            }
            if (SegGenRegionGrow.this._seg_sel.get_selected_segments() != null && SegGenRegionGrow.this._seg_sel.get_selected_segments().size() > 0) {
                LinkedList<Segment> block_list = SegGenRegionGrow.this._seg_sel.get_selected_segments();
                for (Segment block_seg : block_list) {
                    BitCube shifted_block_bc = new BitCube(this._gotcha.get_dim_x(), this._gotcha.get_dim_y(), this._gotcha.get_dim_z());
                    shifted_block_bc.copy_data_from(block_seg.get_bc(), 1, 1, 1);
                    this._gotcha.add(shifted_block_bc);
                }
            }
        }

        @Override
        public void my_run() {
            do {
                this._restart = false;
                SegGenRegionGrow.this.init_value_mapping(Settings.get_bool_option(SegGenRegionGrow.class, OPT_USE_ROI_VALUES));
                if (this._monitor) {
                    this.init_progress_measure("Region Grow Seg", 0, 0, 0);
                    this.set_progress_min(0);
                    this.set_progress_val(0);
                }
                ImageStack is = MasterControl.get_is();
                BitCube bc = _seg.get_bc();
                RegularGrid3i vc = is.get_voxel_cube();
                VoxelQueue todo = new VoxelQueue(1024);
                this.init_gotcha();
                for (Voxel seed : is.get_seeds()) {
                    if (_use_bb && !_seg_gen_bb.is_inside(seed)) continue;
                    todo.store(seed);
                }
                SegGenRegionGrow.this._ar.calc_range();
                bc.clear();
                int num = 0;
                int max = 0;
                StopWatch sw = new StopWatch();
                sw.start();
                Voxel next = new Voxel();
                while (todo.size() > 0 && !this._restart) {
                    if (todo.size() > max) {
                        max = todo.size();
                    }
                    if (this._stop_soon) {
                        return;
                    }
                    if (this._restart) continue;
                    if (this._monitor) {
                        this.set_progress_max(num + todo.size());
                        this.set_progress_val(num + 1);
                        if (sw.get_ms() >= 50L) {
                            _seg.new_data(true);
                            sw.reset();
                        }
                    }
                    ++num;
                    todo.fetch(next);
                    bc.setXYZ(next._x, next._y, next._z, true);
                    if (!this._gotcha.getXYZ(next._x, next._y + 1, next._z + 1)) {
                        this._gotcha.setXYZ(next._x, next._y + 1, next._z + 1, true);
                        int value = SegGenRegionGrow.this._value_mapping[vc.get(next._x - 1, next._y, next._z)];
                        if (value > ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._min_x && value < ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._max_x) {
                            todo.store(next._x - 1, next._y, next._z);
                        }
                    }
                    if (!this._gotcha.getXYZ(next._x + 2, next._y + 1, next._z + 1)) {
                        this._gotcha.setXYZ(next._x + 2, next._y + 1, next._z + 1, true);
                        int value = SegGenRegionGrow.this._value_mapping[vc.get(next._x + 1, next._y, next._z)];
                        if (value > ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._min_x && value < ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._max_x) {
                            todo.store(next._x + 1, next._y, next._z);
                        }
                    }
                    if (!this._gotcha.getXYZ(next._x + 1, next._y, next._z + 1)) {
                        this._gotcha.setXYZ(next._x + 1, next._y, next._z + 1, true);
                        int value = SegGenRegionGrow.this._value_mapping[vc.get(next._x, next._y - 1, next._z)];
                        if (value > ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._min_y && value < ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._max_y) {
                            todo.store(next._x, next._y - 1, next._z);
                        }
                    }
                    if (!this._gotcha.getXYZ(next._x + 1, next._y + 2, next._z + 1)) {
                        this._gotcha.setXYZ(next._x + 1, next._y + 2, next._z + 1, true);
                        int value = SegGenRegionGrow.this._value_mapping[vc.get(next._x, next._y + 1, next._z)];
                        if (value > ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._min_y && value < ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._max_y) {
                            todo.store(next._x, next._y + 1, next._z);
                        }
                    }
                    if (!this._gotcha.getXYZ(next._x + 1, next._y + 1, next._z)) {
                        this._gotcha.setXYZ(next._x + 1, next._y + 1, next._z, true);
                        int value = SegGenRegionGrow.this._value_mapping[vc.get(next._x, next._y, next._z - 1)];
                        if (value > ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._min_z && value < ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._max_z) {
                            todo.store(next._x, next._y, next._z - 1);
                        }
                    }
                    if (this._gotcha.getXYZ(next._x + 1, next._y + 1, next._z + 2)) continue;
                    this._gotcha.setXYZ(next._x + 1, next._y + 1, next._z + 2, true);
                    int value = SegGenRegionGrow.this._value_mapping[vc.get(next._x, next._y, next._z + 1)];
                    if (value <= ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._min_z || value >= ((SegGenRegionGrow)SegGenRegionGrow.this)._ar._max_z) continue;
                    todo.store(next._x, next._y, next._z + 1);
                }
            } while (this._restart);
            _seg.new_data(true);
        }
    }
}

