/*
 * Decompiled with CFR 0.152.
 */
package main.seggen;

import gui.JTFSliderInt;
import gui.JVerticalLabel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.seggen.SegGen;
import misc.Voxel;
import misc.grid.BitCube;
import misc.messages.YObservable;

public final class SegGenSimpleGeo
extends SegGen {
    private int _sphere_r;
    private int _sphere_r_max;
    private int _torus_R;
    private int _torus_R_max;
    private int _torus_r;
    private int _torus_r_max;
    private int _box_r;
    private int _box_r_max;
    private JTFSliderInt _jtf_sphere;
    private JTFSliderInt _jtf_torus_R;
    private JTFSliderInt _jtf_torus_r;
    private JTFSliderInt _jtf_box_r;
    private JRadioButton _jrb_t;
    private JRadioButton _jrb_s;
    private JRadioButton _jrb_f;

    public SegGenSimpleGeo(Segment seg) {
        super(seg);
    }

    private int my_max(double d_value, int i_value) {
        if (d_value < (double)i_value) {
            return i_value;
        }
        return (int)Math.round(d_value);
    }

    private int my_min(double d_value, int i_value) {
        if (d_value > (double)i_value) {
            return i_value;
        }
        return (int)Math.round(d_value);
    }

    public final void create_box_seg(int a) {
        ImageStack is = MasterControl.get_is();
        BitCube bc = _seg.get_bc();
        bc.clear();
        double dx = is.get_x_spacing();
        double dy = is.get_y_spacing();
        double dz = is.get_z_spacing();
        for (Voxel seed : is.get_seeds()) {
            int xmin = this.my_max((double)seed._x - (double)(a / 2) / dx, _bb_min[0]);
            int ymin = this.my_max((double)seed._y - (double)(a / 2) / dy, _bb_min[1]);
            int zmin = this.my_max((double)seed._z - (double)(a / 2) / dz, _bb_min[2]);
            int xmax = this.my_min((double)seed._x + (double)(a / 2) / dx, _bb_max[0]);
            int ymax = this.my_min((double)seed._y + (double)(a / 2) / dy, _bb_max[1]);
            int zmax = this.my_min((double)seed._z + (double)(a / 2) / dz, _bb_max[2]);
            int z = zmin;
            while (z <= zmax) {
                int y = ymin;
                while (y <= ymax) {
                    int x = xmin;
                    while (x <= xmax) {
                        bc.setXYZ(x, y, z, true);
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            if (xmin < bc._bb_min[0]) {
                bc._bb_min[0] = xmin;
            }
            if (ymin < bc._bb_min[1]) {
                bc._bb_min[1] = ymin;
            }
            if (zmin < bc._bb_min[2]) {
                bc._bb_min[2] = zmin;
            }
            if (xmax > bc._bb_max[0]) {
                bc._bb_max[0] = xmax;
            }
            if (ymax > bc._bb_max[1]) {
                bc._bb_max[1] = ymax;
            }
            if (zmax <= bc._bb_max[2]) continue;
            bc._bb_max[2] = zmax;
        }
        _seg.new_data(false);
    }

    public final void create_sphere_seg(int radius) {
        ImageStack is = MasterControl.get_is();
        BitCube bc = _seg.get_bc();
        bc.clear();
        double xs = is.get_x_spacing();
        double ys = is.get_y_spacing();
        double zs = is.get_z_spacing();
        double xsxs = xs * xs;
        double ysys = ys * ys;
        double zszs = zs * zs;
        int radius_sqr = radius * radius;
        for (Voxel seed : is.get_seeds()) {
            int xmin = this.my_max((double)seed._x - (double)radius / xs, _bb_min[0]);
            int ymin = this.my_max((double)seed._y - (double)radius / ys, _bb_min[1]);
            int zmin = this.my_max((double)seed._z - (double)radius / zs, _bb_min[2]);
            int xmax = this.my_min((double)seed._x + (double)radius / xs, _bb_max[0]);
            int ymax = this.my_min((double)seed._y + (double)radius / ys, _bb_max[1]);
            int zmax = this.my_min((double)seed._z + (double)radius / zs, _bb_max[2]);
            int z = zmin;
            while (z <= zmax) {
                double zz = (double)((z - seed._z) * (z - seed._z)) * zszs;
                int y = ymin;
                while (y <= ymax) {
                    double yy = (double)((y - seed._y) * (y - seed._y)) * ysys + zz;
                    int x = xmin;
                    while (x <= xmax) {
                        double dist_sqr = (double)((x - seed._x) * (x - seed._x)) * xsxs + yy;
                        if (dist_sqr < (double)radius_sqr) {
                            bc.setXYZ(x, y, z, true);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        bc.calc_bb();
        _seg.new_data(false);
    }

    /*
     * Unable to fully structure code
     */
    public final void create_torus_seg(int R, int r) {
        block16: {
            block15: {
                is = MasterControl.get_is();
                bc = SegGenSimpleGeo._seg.get_bc();
                bc.clear();
                RR = R * R;
                rr = r * r;
                RR_rr = R * R + r * r;
                tt = is.get_z_spacing() * is.get_z_spacing();
                vi = is.get_seeds().iterator();
                if (!this._jrb_t.isSelected()) break block15;
                while (vi.hasNext()) {
                    seed = (Voxel)vi.next();
                    z = SegGenSimpleGeo._bb_min[2];
                    while (z <= SegGenSimpleGeo._bb_max[2]) {
                        zz = (double)((z - seed._z) * (z - seed._z)) * tt;
                        max = (double)(4 * RR) * ((double)rr - zz);
                        y = SegGenSimpleGeo._bb_min[1];
                        while (y <= SegGenSimpleGeo._bb_max[1]) {
                            yy = (y - seed._y) * (y - seed._y);
                            x = SegGenSimpleGeo._bb_min[0];
                            while (x <= SegGenSimpleGeo._bb_max[0]) {
                                xx = (x - seed._x) * (x - seed._x);
                                if ((xx + yy + zz - (double)RR_rr) * (xx + yy + zz - (double)RR_rr) <= max) {
                                    bc.setXYZ(x, y, z, true);
                                }
                                ++x;
                            }
                            ++y;
                        }
                        ++z;
                    }
                }
                break block16;
            }
            if (!this._jrb_s.isSelected()) ** GOTO lbl75
            while (vi.hasNext()) {
                seed = (Voxel)vi.next();
                x = 0;
                while (x < bc.get_dim_x()) {
                    xx = (x - seed._x) * (x - seed._x);
                    max = (double)(4 * RR) * ((double)rr - xx);
                    z = 0;
                    while (z < bc.get_dim_z()) {
                        zz = (double)((z - seed._z) * (z - seed._z)) * tt;
                        y = 0;
                        while (y < bc.get_dim_y()) {
                            yy = (y - seed._y) * (y - seed._y);
                            if ((xx + yy + zz - (double)RR_rr) * (xx + yy + zz - (double)RR_rr) <= max) {
                                bc.setXYZ(x, y, z, true);
                            }
                            ++y;
                        }
                        ++z;
                    }
                    ++x;
                }
            }
            break block16;
lbl-1000:
            // 1 sources

            {
                seed = (Voxel)vi.next();
                y = 0;
                while (y < bc.get_dim_y()) {
                    yy = (y - seed._y) * (y - seed._y);
                    max = (double)(4 * RR) * ((double)rr - yy);
                    z = 0;
                    while (z < bc.get_dim_z()) {
                        zz = (double)((z - seed._z) * (z - seed._z)) * tt;
                        x = 0;
                        while (x < bc.get_dim_x()) {
                            xx = (x - seed._x) * (x - seed._x);
                            if ((xx + yy + zz - (double)RR_rr) * (xx + yy + zz - (double)RR_rr) <= max) {
                                bc.setXYZ(x, y, z, true);
                            }
                            ++x;
                        }
                        ++z;
                    }
                    ++y;
                }
lbl75:
                // 2 sources

                ** while (vi.hasNext())
            }
        }
        SegGenSimpleGeo._seg.new_data(true);
    }

    private final void init_values() {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 0) {
            this._sphere_r_max = 0;
            this._sphere_r = 0;
            this._torus_r_max = 0;
            this._torus_r = 0;
            this._torus_R_max = 0;
            this._torus_R = 0;
            this._box_r_max = 0;
            this._box_r = 0;
        } else {
            int max_x = is.get_dim_x();
            int max_y = is.get_dim_y();
            int max_z = is.get_dim_z();
            int diag = (int)Math.sqrt(max_x * max_x + max_y * max_y + max_z * max_z);
            this._sphere_r_max = (int)((double)diag * 0.5);
            this._sphere_r = this._sphere_r_max / 2;
            this._jtf_sphere.setMaximum(this._sphere_r_max);
            this._jtf_sphere.setValue(this._sphere_r);
            this._torus_R_max = (int)((double)diag * 0.8);
            this._torus_r_max = (int)((double)diag * 0.2);
            this._torus_R = this._torus_R_max / 2;
            this._torus_r = this._torus_r_max / 2;
            this._box_r_max = max_x;
            this._box_r = max_x / 2;
            this._jtf_sphere.setMaximum(this._sphere_r_max);
            this._jtf_sphere.setValue(this._sphere_r);
            this._jtf_torus_R.setMaximum(this._torus_R_max);
            this._jtf_torus_R.setValue(this._torus_R);
            this._jtf_torus_r.setMaximum(this._torus_r_max);
            this._jtf_torus_r.setValue(this._torus_r);
            this._jtf_box_r.setMaximum(this._box_r_max);
            this._jtf_box_r.setValue(this._box_r);
        }
    }

    @Override
    public final void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == ImageStack.M_LOADING_END && this.gui_created()) {
            this.init_values();
        }
    }

    @Override
    public void create_gui() {
        this._jtf_sphere = new JTFSliderInt(0, this._sphere_r_max, this._sphere_r);
        this._jtf_torus_R = new JTFSliderInt(0, this._torus_R_max, this._torus_R);
        this._jtf_torus_r = new JTFSliderInt(0, this._torus_r_max, this._torus_r);
        this._jtf_box_r = new JTFSliderInt(0, this._box_r_max, this._box_r);
        this._jtf_sphere.get_ftf().setColumns(3);
        this._jtf_torus_R.get_ftf().setColumns(3);
        this._jtf_torus_r.get_ftf().setColumns(3);
        this._jtf_box_r.get_ftf().setColumns(3);
        this.init_values();
        this._jtf_sphere.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                if (JTFSliderInt.JTF_CHANGE.equals(property)) {
                    SegGenSimpleGeo.this._sphere_r = (Integer)propertyChangeEvent.getNewValue();
                    SegGenSimpleGeo.this.create_sphere_seg(SegGenSimpleGeo.this._sphere_r);
                }
            }
        });
        this._jtf_torus_R.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                if (JTFSliderInt.JTF_CHANGE.equals(property)) {
                    SegGenSimpleGeo.this._torus_R = (Integer)propertyChangeEvent.getNewValue();
                    SegGenSimpleGeo.this.create_torus_seg(SegGenSimpleGeo.this._torus_R, SegGenSimpleGeo.this._torus_r);
                }
            }
        });
        this._jtf_torus_r.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                if (JTFSliderInt.JTF_CHANGE.equals(property)) {
                    SegGenSimpleGeo.this._torus_r = (Integer)propertyChangeEvent.getNewValue();
                    SegGenSimpleGeo.this.create_torus_seg(SegGenSimpleGeo.this._torus_R, SegGenSimpleGeo.this._torus_r);
                }
            }
        });
        this._jtf_box_r.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                if (JTFSliderInt.JTF_CHANGE.equals(property)) {
                    SegGenSimpleGeo.this._box_r = (Integer)propertyChangeEvent.getNewValue();
                    SegGenSimpleGeo.this.create_box_seg(SegGenSimpleGeo.this._box_r);
                }
            }
        });
        this._jrb_t = new JRadioButton("T");
        this._jrb_s = new JRadioButton("S");
        this._jrb_f = new JRadioButton("F");
        ActionListener al_mode = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenSimpleGeo.this.create_torus_seg(SegGenSimpleGeo.this._torus_R, SegGenSimpleGeo.this._torus_r);
            }
        };
        this._jrb_t.addActionListener(al_mode);
        this._jrb_s.addActionListener(al_mode);
        this._jrb_f.addActionListener(al_mode);
        ButtonGroup group = new ButtonGroup();
        group.add(this._jrb_t);
        group.add(this._jrb_s);
        group.add(this._jrb_f);
        JPanel radio_panel = new JPanel();
        radio_panel.setLayout(new BoxLayout(radio_panel, 3));
        radio_panel.add(this._jrb_t);
        radio_panel.add(this._jrb_s);
        radio_panel.add(this._jrb_f);
        this._jrb_t.setSelected(true);
        GMPanel yp_sphere = new GMPanel();
        yp_sphere.add("_jtf_sphere", (JComponent)this._jtf_sphere);
        yp_sphere.set_layout("<table width='100%' height='100%' cellpadding='2' border='0'>  <tr>    <td width='1%'>r:</td>    <td width='99%' fill='horizontal'>::_jtf_sphere::</td>  </tr></table>");
        GMPanel yp_box = new GMPanel();
        yp_box.add("_jtf_box_r", (JComponent)this._jtf_box_r);
        yp_box.set_layout("<table width='100%' height='100%' cellpadding='2' border='0'>  <colgroup>    <col width='1%' />    <col width='99%' />  </colgroup>  <tr>    <td >r:</td>    <td fill='horizontal'>::_jtf_box_r::</td>  </tr></table>");
        GMPanel yp_torus = new GMPanel();
        yp_torus.add("_jtf_torus_R", (JComponent)this._jtf_torus_R);
        yp_torus.add("_jtf_torus_r", (JComponent)this._jtf_torus_r);
        yp_torus.add("jvl_orient", (JComponent)new JVerticalLabel("Orientation"));
        yp_torus.add("radio_panel", (JComponent)radio_panel);
        yp_torus.set_layout("<table width='100%' height='100%' cellpadding='2' border='0'>  <colgroup>    <col width='1%' />    <col width='97%' />    <col width='1%' />    <col width='1%' />  </colgroup>  <tr>    <td fill='horizontal'>R:</td>    <td fill='horizontal'>::_jtf_torus_R::</td>    <td rowspan='2'>::radio_panel::</td>    <td rowspan='2'>::jvl_orient::</td>  </tr><tr>    <td fill='horizontal'>r:</td>    <td fill='horizontal'>::_jtf_torus_r::</td>  </tr></table>");
        yp_sphere.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sphere Creator", 2, 2));
        yp_box.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Box Creator", 2, 2));
        yp_torus.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Torus Creator", 2, 2));
        this.add("yp_sphere", (JComponent)yp_sphere);
        this.add("yp_box", (JComponent)yp_box);
        this.add("yp_torus", (JComponent)yp_torus);
        this.set_layout("<table width='100%' height='100%' cellpadding='2' border='0'>  <tr>    <td fill='both' width='50%'>::yp_sphere::</td>    <td fill='both' width='50%'>::yp_box::</td>  </tr><tr>    <td fill='both' colspan='2'>::yp_torus::</td>  </tr></table>");
        this.check_state();
    }

    @Override
    public boolean gui_created() {
        return this._jtf_sphere != null;
    }
}

