/*
 * Decompiled with CFR 0.152.
 */
package main.seggen;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.YaDiV;
import main.seggen.SegGen;
import main.seggen.levelset.DistanceFunction;
import main.view2d.Viewport2d;
import misc.StopWatch;
import misc.Voxel;
import misc.VoxelColorTable;
import misc.grid.BitCube;
import misc.grid.BitMask;
import misc.grid.RegularGrid3i;
import misc.grid.VoxelCube;
import misc.messages.YObservable;
import renderer.SnakeDistanceRenderer2d;
import renderer.SnakeSpeedRenderer2d;
import settings.JDoubleOptionTextfield;
import settings.JIntegerOptionTextfield;
import settings.Settings;
import settings.SettingsOwner;
import threads.SegmentingThread;

public final class SegGenSnake
extends SegGen
implements SettingsOwner {
    public static final String OPT_EPSILON = Settings.register_double_opt(SegGenSnake.class, "epsilon", "Controls influence of snake curvature. Smaller values result in less influence of curvature (more \"fingers\").", 0.025);
    public static final String OPT_RADIUS = Settings.register_int_opt(SegGenSnake.class, "radius", "Initial sphere radius when using seeds.", 3);
    public static final String OPT_SPEED = Settings.register_double_opt(SegGenSnake.class, "speed", "Front propagation speed (\"inner pressure\").", 0.1);
    public static final String OPT_ITERATIONS = Settings.register_int_opt(SegGenSnake.class, "iterations", "Number of iterations per init/expand.", 100);
    public static final String OPT_USE_NARROWBAND = Settings.register_bool_opt(SegGenSnake.class, "Narrow Band", "Use narrowband optimization. If in doubt, set to true.", true);
    public static final String OPT_USE_FAST_SEARCH = Settings.register_bool_opt(SegGenSnake.class, "Fast Search", "Use the onion method to find the closest contour point.", true);
    public static final String OPT_BAND_SIZE = Settings.register_int_opt(SegGenSnake.class, "Narrow Band Size", "Size of the narrow band, used for better performance. If the size is to small, it might lead to errors.Tests have shown that 2 seems to be an optimal value.", 2);
    public static final String OPT_BAND_ITERATIONS = Settings.register_int_opt(SegGenSnake.class, "band iterations", "Number of band iterations per init/expand.", 10);
    public static final String OPT_USE_SEG = Settings.register_bool_opt(SegGenSnake.class, "Use Segment", "Use the the currently active segement selection as start contour.", false);
    public static final String OPT_USE_FAST_REINIT = Settings.register_bool_opt(SegGenSnake.class, "Fast Reinitialization", "Use an improved method for reinitialization of the distance function (\"onion method\").", true);
    public static final String OPT_STOPPING_FUNC = Settings.register_int_opt(SegGenSnake.class, "Stopping Function", "Determines which stopping function should be used.", 0);
    public static final String OPT_USE_DISTANCE_SPACING = Settings.register_bool_opt(SegGenSnake.class, "Distance Spacing", "If enabled, the x-, y-, and z-spacing from the volume data is used. Should always be true.", true);
    public static final String OPT_USE_AUTO_REINIT = Settings.register_bool_opt(SegGenSnake.class, "Auto Reinitialization", "Reinitialize automatically after a given number of steps.", true);
    public static final String OPT_AUTO_REINIT_STEPS = Settings.register_int_opt(SegGenSnake.class, "Reinitialization Steps", "Number of steps for automatic reinitialization.", 100);
    public static final String OPT_STOPPING_EXP = Settings.register_double_opt(SegGenSnake.class, "Stopping Function Exponent", "Exponent of the stopping function: greater values result in a behaviour that the method stops fasterat edges, but noise will have a greater influence on the final contour.", 1.0);
    public static final String OPT_GREY_STOPPING_VALUE = Settings.register_double_opt(SegGenSnake.class, "Grey Stopping", "Grey value for stopping function #2.", 0.0);
    public static final String OPT_USE_AUTO_GREY_STOPPING = Settings.register_bool_opt(SegGenSnake.class, "Auto Grey Stopping", "If enabeld, the given grey value for stopping function #2 is ignored and computed diretly as the mean valueinside the contour.", false);
    public static final String OPT_GREY_STOPPING_STEPS = Settings.register_int_opt(SegGenSnake.class, "Auto Grey Stopping Steps", "The grey value for stopping function #2 is recalculated after the givne number of steps.", 10);
    private double _eps;
    private int _radius;
    private double _speed;
    private int _iterations;
    private boolean _use_narrow_band;
    private boolean _use_fast_search;
    private int _band_size;
    private int _band_iterations;
    private boolean _use_seg;
    private boolean _use_fast_reinit;
    private int _stopping;
    private JDoubleOptionTextfield _jdotf_eps;
    private JDoubleOptionTextfield _jdotf_speed;
    private JIntegerOptionTextfield _jiotf_radius;
    private JIntegerOptionTextfield _jiotf_iterations;
    private JIntegerOptionTextfield _jiotf_band_iterations;
    private JCheckBox _box_show_dist;
    private JCheckBox _box_show_speed;
    private JButton _but_exp2D;
    private JButton _but_exp3D;
    private JButton _but_reint2D;
    private JButton _but_reint3D;
    private JButton _but_final_seg;
    private JComboBox _jl_stopping_func;
    private DistanceFunction _phi;
    private final ArrayList<Voxel> _front = new ArrayList();
    private double[][] _stopping2D;
    private double[][][] _stopping3D;
    private double _grey_stopping_value;
    private int _reinit_step;
    private int _reinit_grey_stopping_step;
    private int _selected_idx;
    private ArrayList<Voxel> _narrow_band = new ArrayList();
    private SnakeDistanceRenderer2d _dist_ren;
    private SnakeSpeedRenderer2d _speed_ren;
    private int _dim_x;
    private int _dim_y;
    private int _dim_z;
    private double _spacing_x;
    private double _spacing_y;
    private double _spacing_z;
    private VoxelCube _neighbours;
    private BitCube _gotcha;
    private BitCube _gotcha_diag2;
    private BitCube _gotcha_diag3;
    private BitCube _gotcha_final;

    private void build_todo_2d(LinkedList<Voxel> todo, LinkedList<Voxel> todo_next, LinkedList<Voxel> todo_diag) {
        while (!todo.isEmpty()) {
            Voxel next = todo.poll();
            double speed = this._phi.get_speed(next._x, next._y, next._z);
            if (next._x < _bb_max[0] && !this._gotcha_final.getXYZ(next._x + 1, next._y, 0)) {
                if (!this._gotcha.getXYZ(next._x + 1, next._y, 0)) {
                    this._gotcha.setXYZ(next._x + 1, next._y, 0, true);
                    todo_next.add(new Voxel(next._x + 1, next._y, 0));
                    this._phi.set_speed(next._x + 1, next._y, 0, speed);
                    this._neighbours.set(next._x + 1, next._y, 0, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y, 0, this._phi.get_speed(next._x + 1, next._y, 0) + speed);
                    this._neighbours.add(next._x + 1, next._y, 0, 1);
                }
            }
            if (next._x > _bb_min[0] && !this._gotcha_final.getXYZ(next._x - 1, next._y, 0)) {
                if (!this._gotcha.getXYZ(next._x - 1, next._y, 0)) {
                    this._gotcha.setXYZ(next._x - 1, next._y, 0, true);
                    todo_next.add(new Voxel(next._x - 1, next._y, 0));
                    this._phi.set_speed(next._x - 1, next._y, 0, speed);
                    this._neighbours.set(next._x - 1, next._y, 0, 1);
                } else {
                    this._phi.set_speed(next._x - 1, next._y, 0, this._phi.get_speed(next._x - 1, next._y, 0) + speed);
                    this._neighbours.add(next._x - 1, next._y, 0, 1);
                }
            }
            if (next._y < _bb_max[1] && !this._gotcha_final.getXYZ(next._x, next._y + 1, 0)) {
                if (!this._gotcha.getXYZ(next._x, next._y + 1, 0)) {
                    this._gotcha.setXYZ(next._x, next._y + 1, 0, true);
                    todo_next.add(new Voxel(next._x, next._y + 1, 0));
                    this._phi.set_speed(next._x, next._y + 1, 0, speed);
                    this._neighbours.set(next._x, next._y + 1, 0, 1);
                } else {
                    this._phi.set_speed(next._x, next._y + 1, 0, this._phi.get_speed(next._x, next._y + 1, 0) + speed);
                    this._neighbours.add(next._x, next._y + 1, 0, 1);
                }
            }
            if (next._y > _bb_min[1] && !this._gotcha_final.getXYZ(next._x, next._y - 1, 0)) {
                if (!this._gotcha.getXYZ(next._x, next._y - 1, 0)) {
                    this._gotcha.setXYZ(next._x, next._y - 1, 0, true);
                    todo_next.add(new Voxel(next._x, next._y - 1, 0));
                    this._phi.set_speed(next._x, next._y - 1, 0, speed);
                    this._neighbours.set(next._x, next._y - 1, 0, 1);
                } else {
                    this._phi.set_speed(next._x, next._y - 1, 0, this._phi.get_speed(next._x, next._y - 1, 0) + speed);
                    this._neighbours.add(next._x, next._y - 1, 0, 1);
                }
            }
            if (next._x < _bb_max[0] && next._y < _bb_max[1] && !this._gotcha_final.getXYZ(next._x + 1, next._y + 1, 0) && !this._gotcha.getXYZ(next._x + 1, next._y + 1, 0)) {
                if (!this._gotcha_diag2.getXYZ(next._x + 1, next._y + 1, 0)) {
                    this._gotcha_diag2.setXYZ(next._x + 1, next._y + 1, 0, true);
                    todo_diag.add(new Voxel(next._x + 1, next._y + 1, 0));
                    this._phi.set_speed(next._x + 1, next._y + 1, 0, speed);
                    this._neighbours.set(next._x + 1, next._y + 1, 0, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y + 1, 0, this._phi.get_speed(next._x + 1, next._y + 1, 0) + speed);
                    this._neighbours.add(next._x + 1, next._y + 1, 0, 1);
                }
            }
            if (next._x < _bb_max[0] && next._y > _bb_min[1] && !this._gotcha_final.getXYZ(next._x + 1, next._y - 1, 0) && !this._gotcha.getXYZ(next._x + 1, next._y - 1, 0)) {
                if (!this._gotcha_diag2.getXYZ(next._x + 1, next._y - 1, 0)) {
                    this._gotcha_diag2.setXYZ(next._x + 1, next._y - 1, 0, true);
                    todo_diag.add(new Voxel(next._x + 1, next._y - 1, 0));
                    this._phi.set_speed(next._x + 1, next._y - 1, 0, speed);
                    this._neighbours.set(next._x + 1, next._y - 1, 0, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y - 1, 0, this._phi.get_speed(next._x + 1, next._y - 1, 0) + speed);
                    this._neighbours.add(next._x + 1, next._y - 1, 0, 1);
                }
            }
            if (next._x > _bb_min[0] && next._y < _bb_max[1] && !this._gotcha_final.getXYZ(next._x - 1, next._y + 1, 0) && !this._gotcha.getXYZ(next._x - 1, next._y + 1, 0)) {
                if (!this._gotcha_diag2.getXYZ(next._x - 1, next._y + 1, 0)) {
                    this._gotcha_diag2.setXYZ(next._x - 1, next._y + 1, 0, true);
                    todo_diag.add(new Voxel(next._x - 1, next._y + 1, 0));
                    this._phi.set_speed(next._x - 1, next._y + 1, 0, speed);
                    this._neighbours.set(next._x - 1, next._y + 1, 0, 1);
                } else {
                    this._phi.set_speed(next._x - 1, next._y + 1, 0, this._phi.get_speed(next._x - 1, next._y + 1, 0) + speed);
                    this._neighbours.add(next._x - 1, next._y + 1, 0, 1);
                }
            }
            if (next._x <= _bb_min[0] || next._y <= _bb_min[1] || this._gotcha_final.getXYZ(next._x - 1, next._y - 1, 0) || this._gotcha.getXYZ(next._x - 1, next._y - 1, 0)) continue;
            if (!this._gotcha_diag2.getXYZ(next._x - 1, next._y - 1, 0)) {
                this._gotcha_diag2.setXYZ(next._x - 1, next._y - 1, 0, true);
                todo_diag.add(new Voxel(next._x - 1, next._y - 1, 0));
                this._phi.set_speed(next._x - 1, next._y - 1, 0, speed);
                this._neighbours.set(next._x - 1, next._y - 1, 0, 1);
                continue;
            }
            this._phi.set_speed(next._x - 1, next._y - 1, 0, this._phi.get_speed(next._x - 1, next._y - 1, 0) + speed);
            this._neighbours.add(next._x - 1, next._y - 1, 0, 1);
        }
    }

    private void generate_speed_2d() {
        int fi = 0;
        while (fi < this._front.size()) {
            Voxel fv = this._front.get(fi);
            double speed_tmp = this._phi.compute_speed2d(fv._x, fv._y, this._eps, this._stopping2D[fv._x][fv._y]);
            this._phi.set_speed(fv._x, fv._y, 0, speed_tmp);
            ++fi;
        }
        if (this._use_narrow_band) {
            if (this._use_fast_search) {
                this._narrow_band.clear();
                LinkedList<Voxel> todo = new LinkedList<Voxel>();
                LinkedList<Voxel> todo_next = new LinkedList<Voxel>();
                LinkedList<Voxel> todo_diag = new LinkedList<Voxel>();
                this._gotcha.clear();
                this._gotcha_diag2.clear();
                this._gotcha_final.clear();
                int fi2 = 0;
                while (fi2 < this._front.size()) {
                    Voxel fv = this._front.get(fi2);
                    todo.add(fv);
                    this._narrow_band.add(fv);
                    this._gotcha_final.setXYZ(fv._x, fv._y, 0, true);
                    ++fi2;
                }
                int i = 0;
                while (i < this._band_size) {
                    Voxel next;
                    this.build_todo_2d(todo, todo_next, todo_diag);
                    while (!todo_next.isEmpty()) {
                        next = todo_next.poll();
                        if (this._gotcha_final.getXYZ(next._x, next._y, 0)) continue;
                        this._phi.set_speed(next._x, next._y, 0, this._phi.get_speed(next._x, next._y, 0) / (double)this._neighbours.get(next._x, next._y, 0));
                        todo.add(next);
                        this._gotcha_final.setXYZ(next._x, next._y, 0, true);
                        this._narrow_band.add(next);
                    }
                    while (!todo_diag.isEmpty()) {
                        next = todo_diag.poll();
                        if (this._gotcha.getXYZ(next._x, next._y, 0)) continue;
                        this._phi.set_speed(next._x, next._y, 0, this._phi.get_speed(next._x, next._y, 0) / (double)this._neighbours.get(next._x, next._y, 0));
                        todo.add(next);
                        this._narrow_band.add(next);
                        this._gotcha_final.setXYZ(next._x, next._y, 0, true);
                    }
                    ++i;
                }
            } else {
                LinkedList<Voxel> closest = new LinkedList<Voxel>();
                for (Voxel nbv : this._narrow_band) {
                    int dist_min_sqr = Integer.MAX_VALUE;
                    for (Voxel fv : this._front) {
                        int dist_sqr = (nbv._x - fv._x) * (nbv._x - fv._x) + (nbv._y - fv._y) * (nbv._y - fv._y);
                        if (dist_sqr < dist_min_sqr) {
                            dist_min_sqr = dist_sqr;
                            closest.clear();
                            closest.add(fv);
                            continue;
                        }
                        if (dist_sqr != dist_min_sqr) continue;
                        closest.add(fv);
                    }
                    Iterator ci = closest.iterator();
                    double speed = 0.0;
                    while (ci.hasNext()) {
                        Voxel cv = (Voxel)ci.next();
                        speed += this._phi.get_speed(cv._x, cv._y, 0);
                    }
                    this._phi.set_speed(nbv._x, nbv._y, 0, speed /= (double)closest.size());
                }
            }
        } else if (this._use_fast_search) {
            LinkedList<Voxel> todo = new LinkedList<Voxel>();
            LinkedList<Voxel> todo_diag = new LinkedList<Voxel>();
            LinkedList<Voxel> todo_next = new LinkedList<Voxel>();
            this._gotcha.clear();
            this._gotcha_diag2.clear();
            this._gotcha_final.clear();
            int i = 0;
            while (i < this._front.size()) {
                Voxel v = this._front.get(i);
                todo.add(v);
                this._gotcha_final.setXYZ(v._x, v._y, 0, true);
                ++i;
            }
            while (!todo.isEmpty()) {
                this.build_todo_2d(todo, todo_next, todo_diag);
                while (!todo_next.isEmpty()) {
                    Voxel next = todo_next.poll();
                    if (this._gotcha_final.getXYZ(next._x, next._y, 0)) continue;
                    this._phi.set_speed(next._x, next._y, 0, this._phi.get_speed(next._x, next._y, 0) / (double)this._neighbours.get(next._x, next._y, 0));
                    todo.add(next);
                    this._gotcha_final.setXYZ(next._x, next._y, 0, true);
                }
                while (!todo_diag.isEmpty()) {
                    Voxel next = todo_diag.poll();
                    if (this._gotcha_final.getXYZ(next._x, next._y, 0)) continue;
                    this._phi.set_speed(next._x, next._y, 0, this._phi.get_speed(next._x, next._y, 0) / (double)this._neighbours.get(next._x, next._y, 0));
                    todo.add(next);
                    this._gotcha_final.setXYZ(next._x, next._y, 0, true);
                }
            }
        } else {
            LinkedList<Voxel> closest = new LinkedList<Voxel>();
            int y = _bb_min[1];
            while (y <= _bb_max[1]) {
                int x = _bb_min[0];
                while (x <= _bb_max[0]) {
                    int dist_min_sqr = Integer.MAX_VALUE;
                    for (Voxel fv : this._front) {
                        int dist_sqr = (x - fv._x) * (x - fv._x) + (y - fv._y) * (y - fv._y);
                        if (dist_sqr < dist_min_sqr) {
                            dist_min_sqr = dist_sqr;
                            closest.clear();
                            closest.add(fv);
                            continue;
                        }
                        if (dist_sqr != dist_min_sqr) continue;
                        closest.add(fv);
                    }
                    Iterator ci = closest.iterator();
                    double speed = 0.0;
                    while (ci.hasNext()) {
                        Voxel cv = (Voxel)ci.next();
                        speed += this._phi.get_speed(cv._x, cv._y, 0);
                    }
                    this._phi.set_speed(x, y, 0, speed /= (double)closest.size());
                    ++x;
                }
                ++y;
            }
        }
        if (this._box_show_speed.isSelected()) {
            this._speed_ren.new_speed_data(this._narrow_band, this._use_narrow_band);
        }
    }

    private void build_todo_3d(LinkedList<Voxel> todo, LinkedList<Voxel> todo_next, LinkedList<Voxel> todo_diag) {
        while (!todo.isEmpty()) {
            Voxel next = todo.poll();
            double speed = this._phi.get_speed(next._x, next._y, next._z);
            if (next._x < _bb_max[0] && !this._gotcha_final.getXYZ(next._x + 1, next._y, next._z)) {
                if (!this._gotcha.getXYZ(next._x + 1, next._y, next._z)) {
                    this._gotcha.setXYZ(next._x + 1, next._y, next._z, true);
                    todo_next.add(new Voxel(next._x + 1, next._y, next._z));
                    this._phi.set_speed(next._x + 1, next._y, next._z, speed);
                    this._neighbours.set(next._x + 1, next._y, next._z, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y, next._z, this._phi.get_speed(next._x + 1, next._y, next._z) + speed);
                    this._neighbours.add(next._x + 1, next._y, next._z, 1);
                }
            }
            if (next._x > _bb_min[0] && !this._gotcha_final.getXYZ(next._x - 1, next._y, next._z)) {
                if (!this._gotcha.getXYZ(next._x - 1, next._y, next._z)) {
                    this._gotcha.setXYZ(next._x - 1, next._y, next._z, true);
                    todo_next.add(new Voxel(next._x - 1, next._y, next._z));
                    this._phi.set_speed(next._x - 1, next._y, next._z, speed);
                    this._neighbours.set(next._x - 1, next._y, next._z, 1);
                } else {
                    this._phi.set_speed(next._x - 1, next._y, next._z, this._phi.get_speed(next._x - 1, next._y, next._z) + speed);
                    this._neighbours.add(next._x - 1, next._y, next._z, 1);
                }
            }
            if (next._y < _bb_max[1] && !this._gotcha_final.getXYZ(next._x, next._y + 1, next._z)) {
                if (!this._gotcha.getXYZ(next._x, next._y + 1, next._z)) {
                    this._gotcha.setXYZ(next._x, next._y + 1, next._z, true);
                    todo_next.add(new Voxel(next._x, next._y + 1, next._z));
                    this._phi.set_speed(next._x, next._y + 1, next._z, speed);
                    this._neighbours.set(next._x, next._y + 1, next._z, 1);
                } else {
                    this._phi.set_speed(next._x, next._y + 1, next._z, this._phi.get_speed(next._x, next._y + 1, next._z) + speed);
                    this._neighbours.add(next._x, next._y + 1, next._z, 1);
                }
            }
            if (next._y > _bb_min[1] && !this._gotcha_final.getXYZ(next._x, next._y - 1, next._z)) {
                if (!this._gotcha.getXYZ(next._x, next._y - 1, next._z)) {
                    this._gotcha.setXYZ(next._x, next._y - 1, next._z, true);
                    todo_next.add(new Voxel(next._x, next._y - 1, next._z));
                    this._phi.set_speed(next._x, next._y - 1, next._z, speed);
                    this._neighbours.set(next._x, next._y - 1, next._z, 1);
                } else {
                    this._phi.set_speed(next._x, next._y - 1, next._z, this._phi.get_speed(next._x, next._y - 1, next._z) + speed);
                    this._neighbours.add(next._x, next._y - 1, next._z, 1);
                }
            }
            if (next._z < _bb_max[2] && !this._gotcha_final.getXYZ(next._x, next._y, next._z + 1)) {
                if (!this._gotcha.getXYZ(next._x, next._y, next._z + 1)) {
                    this._gotcha.setXYZ(next._x, next._y, next._z + 1, true);
                    todo_next.add(new Voxel(next._x, next._y, next._z + 1));
                    this._phi.set_speed(next._x, next._y, next._z + 1, speed);
                    this._neighbours.set(next._x, next._y, next._z + 1, 1);
                } else {
                    this._phi.set_speed(next._x, next._y, next._z + 1, this._phi.get_speed(next._x, next._y, next._z + 1) + speed);
                    this._neighbours.add(next._x, next._y, next._z + 1, 1);
                }
            }
            if (next._z > _bb_min[2] && !this._gotcha_final.getXYZ(next._x, next._y, next._z - 1)) {
                if (!this._gotcha.getXYZ(next._x, next._y, next._z - 1)) {
                    this._gotcha.setXYZ(next._x, next._y, next._z - 1, true);
                    todo_next.add(new Voxel(next._x, next._y, next._z - 1));
                    this._phi.set_speed(next._x, next._y, next._z - 1, speed);
                    this._neighbours.set(next._x, next._y, next._z - 1, 1);
                } else {
                    this._phi.set_speed(next._x, next._y, next._z - 1, this._phi.get_speed(next._x, next._y, next._z - 1) + speed);
                    this._neighbours.add(next._x, next._y, next._z - 1, 1);
                }
            }
            if (next._x < _bb_max[0] && next._y < _bb_max[1] && !this._gotcha_final.getXYZ(next._x + 1, next._y + 1, next._z) && !this._gotcha.getXYZ(next._x + 1, next._y + 1, next._z)) {
                if (!this._gotcha_diag2.getXYZ(next._x + 1, next._y + 1, next._z)) {
                    this._gotcha_diag2.setXYZ(next._x + 1, next._y + 1, next._z, true);
                    todo_diag.add(new Voxel(next._x + 1, next._y + 1, next._z));
                    this._phi.set_speed(next._x + 1, next._y + 1, next._z, speed);
                    this._neighbours.set(next._x + 1, next._y + 1, next._z, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y + 1, next._z, this._phi.get_speed(next._x + 1, next._y + 1, next._z) + speed);
                    this._neighbours.add(next._x + 1, next._y + 1, next._z, 1);
                }
            }
            if (next._x < _bb_max[0] && next._z < _bb_max[2] && !this._gotcha_final.getXYZ(next._x + 1, next._y, next._z + 1) && !this._gotcha.getXYZ(next._x + 1, next._y, next._z + 1)) {
                if (!this._gotcha_diag2.getXYZ(next._x + 1, next._y, next._z + 1)) {
                    this._gotcha_diag2.setXYZ(next._x + 1, next._y, next._z + 1, true);
                    todo_diag.add(new Voxel(next._x + 1, next._y, next._z + 1));
                    this._phi.set_speed(next._x + 1, next._y, next._z + 1, speed);
                    this._neighbours.set(next._x + 1, next._y, next._z + 1, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y, next._z + 1, this._phi.get_speed(next._x + 1, next._y, next._z + 1) + speed);
                    this._neighbours.add(next._x + 1, next._y, next._z + 1, 1);
                }
            }
            if (next._y < _bb_max[1] && next._z < _bb_max[2] && !this._gotcha_final.getXYZ(next._x, next._y + 1, next._z + 1) && !this._gotcha.getXYZ(next._x, next._y + 1, next._z + 1)) {
                if (!this._gotcha_diag2.getXYZ(next._x, next._y + 1, next._z + 1)) {
                    this._gotcha_diag2.setXYZ(next._x, next._y + 1, next._z + 1, true);
                    todo_diag.add(new Voxel(next._x, next._y + 1, next._z + 1));
                    this._phi.set_speed(next._x, next._y + 1, next._z + 1, speed);
                    this._neighbours.set(next._x, next._y + 1, next._z + 1, 1);
                } else {
                    this._phi.set_speed(next._x, next._y + 1, next._z + 1, this._phi.get_speed(next._x, next._y + 1, next._z + 1) + speed);
                    this._neighbours.add(next._x, next._y + 1, next._z + 1, 1);
                }
            }
            if (next._x < _bb_max[0] && next._y > _bb_min[1] && !this._gotcha_final.getXYZ(next._x + 1, next._y - 1, next._z) && !this._gotcha.getXYZ(next._x + 1, next._y - 1, next._z)) {
                if (!this._gotcha_diag2.getXYZ(next._x + 1, next._y - 1, next._z)) {
                    this._gotcha_diag2.setXYZ(next._x + 1, next._y - 1, next._z, true);
                    todo_diag.add(new Voxel(next._x + 1, next._y - 1, next._z));
                    this._phi.set_speed(next._x + 1, next._y - 1, next._z, speed);
                    this._neighbours.set(next._x + 1, next._y - 1, next._z, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y - 1, next._z, this._phi.get_speed(next._x + 1, next._y - 1, next._z) + speed);
                    this._neighbours.add(next._x + 1, next._y - 1, next._z, 1);
                }
            }
            if (next._x > _bb_min[0] && next._y < _bb_max[1] && !this._gotcha_final.getXYZ(next._x - 1, next._y + 1, next._z) && !this._gotcha.getXYZ(next._x - 1, next._y + 1, next._z)) {
                if (!this._gotcha_diag2.getXYZ(next._x - 1, next._y + 1, next._z)) {
                    this._gotcha_diag2.setXYZ(next._x - 1, next._y + 1, next._z, true);
                    todo_diag.add(new Voxel(next._x - 1, next._y + 1, next._z));
                    this._phi.set_speed(next._x - 1, next._y + 1, next._z, speed);
                    this._neighbours.set(next._x - 1, next._y + 1, next._z, 1);
                } else {
                    this._phi.set_speed(next._x - 1, next._y + 1, next._z, this._phi.get_speed(next._x - 1, next._y + 1, next._z) + speed);
                    this._neighbours.add(next._x - 1, next._y + 1, next._z, 1);
                }
            }
            if (next._x < _bb_max[0] && next._z > _bb_min[2] && !this._gotcha_final.getXYZ(next._x + 1, next._y, next._z - 1) && !this._gotcha.getXYZ(next._x + 1, next._y, next._z - 1)) {
                if (!this._gotcha_diag2.getXYZ(next._x + 1, next._y, next._z - 1)) {
                    this._gotcha_diag2.setXYZ(next._x + 1, next._y, next._z - 1, true);
                    todo_diag.add(new Voxel(next._x + 1, next._y, next._z - 1));
                    this._phi.set_speed(next._x + 1, next._y, next._z - 1, speed);
                    this._neighbours.set(next._x + 1, next._y, next._z - 1, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y, next._z - 1, this._phi.get_speed(next._x + 1, next._y, next._z - 1) + speed);
                    this._neighbours.add(next._x + 1, next._y, next._z - 1, 1);
                }
            }
            if (next._x > _bb_min[0] && next._z < _bb_max[2] && !this._gotcha_final.getXYZ(next._x - 1, next._y, next._z + 1) && !this._gotcha.getXYZ(next._x - 1, next._y, next._z + 1)) {
                if (!this._gotcha_diag2.getXYZ(next._x - 1, next._y, next._z + 1)) {
                    this._gotcha_diag2.setXYZ(next._x - 1, next._y, next._z + 1, true);
                    todo_diag.add(new Voxel(next._x - 1, next._y, next._z + 1));
                    this._phi.set_speed(next._x - 1, next._y, next._z + 1, speed);
                    this._neighbours.set(next._x - 1, next._y, next._z + 1, 1);
                } else {
                    this._phi.set_speed(next._x - 1, next._y, next._z + 1, this._phi.get_speed(next._x - 1, next._y, next._z + 1) + speed);
                    this._neighbours.add(next._x - 1, next._y, next._z + 1, 1);
                }
            }
            if (next._y < _bb_max[1] && next._z > _bb_min[2] && !this._gotcha_final.getXYZ(next._x, next._y + 1, next._z - 1) && !this._gotcha.getXYZ(next._x, next._y + 1, next._z - 1)) {
                if (!this._gotcha_diag2.getXYZ(next._x, next._y + 1, next._z - 1)) {
                    this._gotcha_diag2.setXYZ(next._x, next._y + 1, next._z - 1, true);
                    todo_diag.add(new Voxel(next._x, next._y + 1, next._z - 1));
                    this._phi.set_speed(next._x, next._y + 1, next._z - 1, speed);
                    this._neighbours.set(next._x, next._y + 1, next._z - 1, 1);
                } else {
                    this._phi.set_speed(next._x, next._y + 1, next._z - 1, this._phi.get_speed(next._x, next._y + 1, next._z - 1) + speed);
                    this._neighbours.add(next._x, next._y + 1, next._z - 1, 1);
                }
            }
            if (next._y > _bb_min[1] && next._z < _bb_max[2] && !this._gotcha_final.getXYZ(next._x, next._y - 1, next._z + 1) && !this._gotcha.getXYZ(next._x, next._y - 1, next._z + 1)) {
                if (!this._gotcha_diag2.getXYZ(next._x, next._y - 1, next._z + 1)) {
                    this._gotcha_diag2.setXYZ(next._x, next._y - 1, next._z + 1, true);
                    todo_diag.add(new Voxel(next._x, next._y - 1, next._z + 1));
                    this._phi.set_speed(next._x, next._y - 1, next._z + 1, speed);
                    this._neighbours.set(next._x, next._y - 1, next._z + 1, 1);
                } else {
                    this._phi.set_speed(next._x, next._y - 1, next._z + 1, this._phi.get_speed(next._x, next._y - 1, next._z + 1) + speed);
                    this._neighbours.add(next._x, next._y - 1, next._z + 1, 1);
                }
            }
            if (next._x > _bb_min[0] && next._y > _bb_min[1] && !this._gotcha_final.getXYZ(next._x - 1, next._y - 1, next._z) && !this._gotcha.getXYZ(next._x - 1, next._y - 1, next._z)) {
                if (!this._gotcha_diag2.getXYZ(next._x - 1, next._y - 1, next._z)) {
                    this._gotcha_diag2.setXYZ(next._x - 1, next._y - 1, next._z, true);
                    todo_diag.add(new Voxel(next._x - 1, next._y - 1, next._z));
                    this._phi.set_speed(next._x - 1, next._y - 1, next._z, speed);
                    this._neighbours.set(next._x - 1, next._y - 1, next._z, 1);
                } else {
                    this._phi.set_speed(next._x - 1, next._y - 1, next._z, this._phi.get_speed(next._x - 1, next._y - 1, next._z) + speed);
                    this._neighbours.add(next._x - 1, next._y - 1, next._z, 1);
                }
            }
            if (next._x > _bb_min[0] && next._z > _bb_min[2] && !this._gotcha_final.getXYZ(next._x - 1, next._y, next._z - 1) && !this._gotcha.getXYZ(next._x - 1, next._y, next._z - 1)) {
                if (!this._gotcha_diag2.getXYZ(next._x - 1, next._y, next._z - 1)) {
                    this._gotcha_diag2.setXYZ(next._x - 1, next._y, next._z - 1, true);
                    todo_diag.add(new Voxel(next._x - 1, next._y, next._z - 1));
                    this._phi.set_speed(next._x - 1, next._y, next._z - 1, speed);
                    this._neighbours.set(next._x - 1, next._y, next._z - 1, 1);
                } else {
                    this._phi.set_speed(next._x - 1, next._y, next._z - 1, this._phi.get_speed(next._x - 1, next._y, next._z - 1) + speed);
                    this._neighbours.add(next._x - 1, next._y, next._z - 1, 1);
                }
            }
            if (next._y > _bb_min[1] && next._z > _bb_min[2] && !this._gotcha_final.getXYZ(next._x, next._y - 1, next._z - 1) && !this._gotcha.getXYZ(next._x, next._y - 1, next._z - 1)) {
                if (!this._gotcha_diag2.getXYZ(next._x, next._y - 1, next._z - 1)) {
                    this._gotcha_diag2.setXYZ(next._x, next._y - 1, next._z - 1, true);
                    todo_diag.add(new Voxel(next._x, next._y - 1, next._z - 1));
                    this._phi.set_speed(next._x, next._y - 1, next._z - 1, speed);
                    this._neighbours.set(next._x, next._y - 1, next._z - 1, 1);
                } else {
                    this._phi.set_speed(next._x, next._y - 1, next._z - 1, this._phi.get_speed(next._x, next._y - 1, next._z - 1) + speed);
                    this._neighbours.add(next._x, next._y - 1, next._z - 1, 1);
                }
            }
            if (!(next._x >= _bb_max[0] || next._y >= _bb_max[1] || next._z >= _bb_max[2] || this._gotcha_final.getXYZ(next._x + 1, next._y + 1, next._z + 1) || this._gotcha.getXYZ(next._x + 1, next._y + 1, next._z + 1) || this._gotcha_diag2.getXYZ(next._x + 1, next._y + 1, next._z + 1))) {
                if (!this._gotcha_diag3.getXYZ(next._x + 1, next._y + 1, next._z + 1)) {
                    this._gotcha_diag3.setXYZ(next._x + 1, next._y + 1, next._z + 1, true);
                    todo_diag.add(new Voxel(next._x + 1, next._y + 1, next._z + 1));
                    this._phi.set_speed(next._x + 1, next._y + 1, next._z + 1, speed);
                    this._neighbours.set(next._x + 1, next._y + 1, next._z + 1, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y + 1, next._z + 1, this._phi.get_speed(next._x + 1, next._y + 1, next._z + 1) + speed);
                    this._neighbours.add(next._x + 1, next._y + 1, next._z + 1, 1);
                }
            }
            if (!(next._x >= _bb_max[0] || next._y >= _bb_max[1] || next._z <= _bb_min[2] || this._gotcha_final.getXYZ(next._x + 1, next._y + 1, next._z - 1) || this._gotcha.getXYZ(next._x + 1, next._y + 1, next._z - 1) || this._gotcha_diag2.getXYZ(next._x + 1, next._y + 1, next._z - 1))) {
                if (!this._gotcha_diag3.getXYZ(next._x + 1, next._y + 1, next._z - 1)) {
                    this._gotcha_diag3.setXYZ(next._x + 1, next._y + 1, next._z - 1, true);
                    todo_diag.add(new Voxel(next._x + 1, next._y + 1, next._z - 1));
                    this._phi.set_speed(next._x + 1, next._y + 1, next._z - 1, speed);
                    this._neighbours.set(next._x + 1, next._y + 1, next._z - 1, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y + 1, next._z - 1, this._phi.get_speed(next._x + 1, next._y + 1, next._z - 1) + speed);
                    this._neighbours.add(next._x + 1, next._y + 1, next._z - 1, 1);
                }
            }
            if (!(next._x >= _bb_max[0] || next._y <= _bb_min[1] || next._z >= _bb_max[2] || this._gotcha_final.getXYZ(next._x + 1, next._y - 1, next._z + 1) || this._gotcha.getXYZ(next._x + 1, next._y - 1, next._z + 1) || this._gotcha_diag2.getXYZ(next._x + 1, next._y - 1, next._z + 1))) {
                if (!this._gotcha_diag3.getXYZ(next._x + 1, next._y - 1, next._z + 1)) {
                    this._gotcha_diag3.setXYZ(next._x + 1, next._y - 1, next._z + 1, true);
                    todo_diag.add(new Voxel(next._x + 1, next._y - 1, next._z + 1));
                    this._phi.set_speed(next._x + 1, next._y - 1, next._z + 1, speed);
                    this._neighbours.set(next._x + 1, next._y - 1, next._z + 1, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y - 1, next._z + 1, this._phi.get_speed(next._x + 1, next._y - 1, next._z + 1) + speed);
                    this._neighbours.add(next._x + 1, next._y - 1, next._z + 1, 1);
                }
            }
            if (!(next._x <= _bb_min[0] || next._y >= _bb_max[1] || next._z >= _bb_max[2] || this._gotcha_final.getXYZ(next._x - 1, next._y + 1, next._z + 1) || this._gotcha.getXYZ(next._x - 1, next._y + 1, next._z + 1) || this._gotcha_diag2.getXYZ(next._x - 1, next._y + 1, next._z + 1))) {
                if (!this._gotcha_diag3.getXYZ(next._x - 1, next._y + 1, next._z + 1)) {
                    this._gotcha_diag3.setXYZ(next._x - 1, next._y + 1, next._z + 1, true);
                    todo_diag.add(new Voxel(next._x - 1, next._y + 1, next._z + 1));
                    this._phi.set_speed(next._x - 1, next._y + 1, next._z + 1, speed);
                    this._neighbours.set(next._x - 1, next._y + 1, next._z + 1, 1);
                } else {
                    this._phi.set_speed(next._x - 1, next._y + 1, next._z + 1, this._phi.get_speed(next._x - 1, next._y + 1, next._z + 1) + speed);
                    this._neighbours.add(next._x - 1, next._y + 1, next._z + 1, 1);
                }
            }
            if (!(next._x >= _bb_max[0] || next._y <= _bb_min[1] || next._z <= _bb_min[2] || this._gotcha_final.getXYZ(next._x + 1, next._y - 1, next._z - 1) || this._gotcha.getXYZ(next._x + 1, next._y - 1, next._z - 1) || this._gotcha_diag2.getXYZ(next._x + 1, next._y - 1, next._z - 1))) {
                if (!this._gotcha_diag3.getXYZ(next._x + 1, next._y - 1, next._z - 1)) {
                    this._gotcha_diag3.setXYZ(next._x + 1, next._y - 1, next._z - 1, true);
                    todo_diag.add(new Voxel(next._x + 1, next._y - 1, next._z - 1));
                    this._phi.set_speed(next._x + 1, next._y - 1, next._z - 1, speed);
                    this._neighbours.set(next._x + 1, next._y - 1, next._z - 1, 1);
                } else {
                    this._phi.set_speed(next._x + 1, next._y - 1, next._z - 1, this._phi.get_speed(next._x + 1, next._y - 1, next._z - 1) + speed);
                    this._neighbours.add(next._x + 1, next._y - 1, next._z - 1, 1);
                }
            }
            if (!(next._x <= _bb_min[0] || next._y >= _bb_max[1] || next._z <= _bb_min[2] || this._gotcha_final.getXYZ(next._x - 1, next._y + 1, next._z - 1) || this._gotcha.getXYZ(next._x - 1, next._y + 1, next._z - 1) || this._gotcha_diag2.getXYZ(next._x - 1, next._y + 1, next._z - 1))) {
                if (!this._gotcha_diag3.getXYZ(next._x - 1, next._y + 1, next._z - 1)) {
                    this._gotcha_diag3.setXYZ(next._x - 1, next._y + 1, next._z - 1, true);
                    todo_diag.add(new Voxel(next._x - 1, next._y + 1, next._z - 1));
                    this._phi.set_speed(next._x - 1, next._y + 1, next._z - 1, speed);
                    this._neighbours.set(next._x - 1, next._y + 1, next._z - 1, 1);
                } else {
                    this._phi.set_speed(next._x - 1, next._y + 1, next._z - 1, this._phi.get_speed(next._x - 1, next._y + 1, next._z - 1) + speed);
                    this._neighbours.add(next._x - 1, next._y + 1, next._z - 1, 1);
                }
            }
            if (!(next._x <= _bb_min[0] || next._y <= _bb_min[1] || next._z >= _bb_max[2] || this._gotcha_final.getXYZ(next._x - 1, next._y - 1, next._z + 1) || this._gotcha.getXYZ(next._x - 1, next._y - 1, next._z + 1) || this._gotcha_diag2.getXYZ(next._x - 1, next._y - 1, next._z + 1))) {
                if (!this._gotcha_diag3.getXYZ(next._x - 1, next._y - 1, next._z + 1)) {
                    this._gotcha_diag3.setXYZ(next._x - 1, next._y - 1, next._z + 1, true);
                    todo_diag.add(new Voxel(next._x - 1, next._y - 1, next._z + 1));
                    this._phi.set_speed(next._x - 1, next._y - 1, next._z + 1, speed);
                    this._neighbours.set(next._x - 1, next._y - 1, next._z + 1, 1);
                } else {
                    this._phi.set_speed(next._x - 1, next._y - 1, next._z + 1, this._phi.get_speed(next._x - 1, next._y - 1, next._z + 1) + speed);
                    this._neighbours.add(next._x - 1, next._y - 1, next._z + 1, 1);
                }
            }
            if (next._x <= _bb_min[0] || next._y <= _bb_min[1] || next._z <= _bb_min[2] || this._gotcha_final.getXYZ(next._x - 1, next._y - 1, next._z - 1) || this._gotcha.getXYZ(next._x - 1, next._y - 1, next._z - 1) || this._gotcha_diag2.getXYZ(next._x - 1, next._y - 1, next._z - 1)) continue;
            if (!this._gotcha_diag3.getXYZ(next._x - 1, next._y - 1, next._z - 1)) {
                this._gotcha_diag3.setXYZ(next._x - 1, next._y - 1, next._z - 1, true);
                todo_diag.add(new Voxel(next._x - 1, next._y - 1, next._z - 1));
                this._phi.set_speed(next._x - 1, next._y - 1, next._z - 1, speed);
                this._neighbours.set(next._x - 1, next._y - 1, next._z - 1, 1);
                continue;
            }
            this._phi.set_speed(next._x - 1, next._y - 1, next._z - 1, this._phi.get_speed(next._x - 1, next._y - 1, next._z - 1) + speed);
            this._neighbours.add(next._x - 1, next._y - 1, next._z - 1, 1);
        }
    }

    private void generate_speed_3d() {
        LinkedList<Voxel> todo_next;
        int fi = 0;
        while (fi < this._front.size()) {
            Voxel fv = this._front.get(fi);
            double speed = this._phi.compute_speed3d(fv._x, fv._y, fv._z, this._eps, this._stopping3D[fv._x][fv._y][fv._z]);
            this._phi.set_speed(fv._x, fv._y, fv._z, speed);
            ++fi;
        }
        if (this._use_narrow_band) {
            if (this._use_fast_search) {
                LinkedList<Voxel> todo = new LinkedList<Voxel>();
                todo_next = new LinkedList<Voxel>();
                LinkedList<Voxel> todo_diag = new LinkedList<Voxel>();
                this._gotcha.clear();
                this._gotcha_diag2.clear();
                this._gotcha_diag3.clear();
                this._gotcha_final.clear();
                this._narrow_band.clear();
                int f = 0;
                while (f < this._front.size()) {
                    Voxel fv = this._front.get(f);
                    todo.add(fv);
                    this._narrow_band.add(fv);
                    this._gotcha_final.setXYZ(fv._x, fv._y, fv._z, true);
                    ++f;
                }
                int i = 0;
                while (i < this._band_size) {
                    Voxel next;
                    this.build_todo_3d(todo, todo_next, todo_diag);
                    while (!todo_next.isEmpty()) {
                        next = todo_next.poll();
                        if (this._gotcha_final.getXYZ(next._x, next._y, next._z)) continue;
                        this._phi.set_speed(next._x, next._y, next._z, this._phi.get_speed(next._x, next._y, next._z) / (double)this._neighbours.get(next._x, next._y, next._z));
                        todo.add(next);
                        this._narrow_band.add(next);
                        this._gotcha_final.setXYZ(next._x, next._y, next._z, true);
                    }
                    while (!todo_diag.isEmpty()) {
                        next = todo_diag.poll();
                        if (this._gotcha.getXYZ(next._x, next._y, next._z)) continue;
                        this._phi.set_speed(next._x, next._y, next._z, this._phi.get_speed(next._x, next._y, next._z) / (double)this._neighbours.get(next._x, next._y, next._z));
                        todo.add(next);
                        this._narrow_band.add(next);
                        this._gotcha_final.setXYZ(next._x, next._y, next._z, true);
                    }
                    ++i;
                }
            } else {
                LinkedList<Voxel> closest = new LinkedList<Voxel>();
                for (Voxel nbv : this._narrow_band) {
                    int dist_min_sqr = Integer.MAX_VALUE;
                    for (Voxel fv : this._front) {
                        int dist_sqr = (nbv._x - fv._x) * (nbv._x - fv._x) + (nbv._y - fv._y) * (nbv._y - fv._y) + (nbv._z - fv._z) * (nbv._z - fv._z);
                        if (dist_sqr < dist_min_sqr) {
                            dist_min_sqr = dist_sqr;
                            closest.clear();
                            closest.add(fv);
                            continue;
                        }
                        if (dist_sqr != dist_min_sqr) continue;
                        closest.add(fv);
                    }
                    Iterator ci = closest.iterator();
                    double speed = 0.0;
                    while (ci.hasNext()) {
                        Voxel cv = (Voxel)ci.next();
                        speed += this._phi.get_speed(cv._x, cv._y, cv._z);
                    }
                    this._phi.set_speed(nbv._x, nbv._y, nbv._z, speed /= (double)closest.size());
                }
            }
        } else if (this._use_fast_search) {
            LinkedList<Voxel> todo = new LinkedList<Voxel>();
            todo_next = new LinkedList();
            LinkedList<Voxel> todo_diag = new LinkedList<Voxel>();
            this._gotcha.clear();
            this._gotcha_diag2.clear();
            this._gotcha_diag3.clear();
            this._gotcha_final.clear();
            int f = 0;
            while (f < this._front.size()) {
                Voxel v = this._front.get(f);
                todo.add(v);
                this._gotcha_final.setXYZ(v._x, v._y, v._z, true);
                ++f;
            }
            while (!todo.isEmpty()) {
                this.build_todo_3d(todo, todo_next, todo_diag);
                while (!todo_next.isEmpty()) {
                    Voxel next = todo_next.poll();
                    if (this._gotcha_final.getXYZ(next._x, next._y, next._z)) continue;
                    this._phi.set_speed(next._x, next._y, next._z, this._phi.get_speed(next._x, next._y, next._z) / (double)this._neighbours.get(next._x, next._y, next._z));
                    todo.add(next);
                    this._gotcha_final.setXYZ(next._x, next._y, next._z, true);
                }
                while (!todo_diag.isEmpty()) {
                    Voxel next = todo_diag.poll();
                    if (this._gotcha.getXYZ(next._x, next._y, next._z)) continue;
                    this._phi.set_speed(next._x, next._y, next._z, this._phi.get_speed(next._x, next._y, next._z) / (double)this._neighbours.get(next._x, next._y, next._z));
                    todo.add(next);
                    this._gotcha_final.setXYZ(next._x, next._y, next._z, true);
                }
            }
        } else {
            LinkedList<Voxel> closest = new LinkedList<Voxel>();
            int z = _bb_min[2];
            while (z <= _bb_max[2]) {
                int y = _bb_min[1];
                while (y <= _bb_max[1]) {
                    int x = _bb_min[0];
                    while (x <= _bb_max[0]) {
                        double dist_min_sqr = 2.147483647E9;
                        for (Voxel fv : this._front) {
                            double dist_sqr = (x - fv._x) * (x - fv._x) + (y - fv._y) * (y - fv._y) + (z - fv._z) * (z - fv._z);
                            if (dist_sqr < dist_min_sqr) {
                                dist_min_sqr = dist_sqr;
                                closest.clear();
                                closest.add(fv);
                                continue;
                            }
                            if (dist_sqr != dist_min_sqr) continue;
                            closest.add(fv);
                        }
                        Iterator ci = closest.iterator();
                        double speed = 0.0;
                        while (ci.hasNext()) {
                            Voxel cv = (Voxel)ci.next();
                            speed += this._phi.get_speed(cv._x, cv._y, cv._z);
                        }
                        this._phi.set_speed(x, y, z, speed /= (double)closest.size());
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        if (this._box_show_speed.isSelected()) {
            this._speed_ren.new_speed_data(this._narrow_band, this._use_narrow_band);
        }
    }

    private void generate_stopping() {
        int max_z;
        StopWatch sw = new StopWatch(true);
        RegularGrid3i vc = MasterControl.get_is().get_voxel_cube();
        VoxelColorTable vct = MasterControl.get_v2d().get_bg_image_renderer().get_voxel_color_table();
        int min_x = _bb_min[0] > 0 ? _bb_min[0] : _bb_min[0] + 1;
        int min_y = _bb_min[1] > 0 ? _bb_min[1] : _bb_min[1] + 1;
        int min_z = _bb_min[2] > 0 ? _bb_min[2] : _bb_min[2] + 1;
        int max_x = _bb_max[0] < this._dim_x - 1 ? _bb_max[0] : _bb_max[0] - 1;
        int max_y = _bb_max[1] < this._dim_y - 1 ? _bb_max[1] : _bb_max[1] - 1;
        int n = max_z = _bb_max[2] < this._dim_z - 1 ? _bb_max[2] : _bb_max[2] - 1;
        if (this._phi.is_3d()) {
            int z = min_z;
            while (z <= max_z) {
                int y = min_y;
                while (y <= max_y) {
                    int x = min_x;
                    while (x <= max_x) {
                        switch (this._stopping) {
                            case 0: {
                                double im_x = (double)(vc.get(x + 1, y, z) - vc.get(x - 1, y, z)) * 0.5;
                                double im_y = (double)(vc.get(x, y + 1, z) - vc.get(x, y - 1, z)) * 0.5;
                                double im_z = (double)(vc.get(x, y, z + 1) - vc.get(x, y, z - 1)) * 0.5;
                                double tmp = Math.sqrt(im_x * im_x + im_y * im_y + im_z * im_z);
                                tmp = Math.pow(tmp, Settings.get_double_option(SegGenSnake.class, OPT_STOPPING_EXP));
                                this._stopping3D[x][y][z] = 1.0 / (1.0 + Math.sqrt(tmp));
                                break;
                            }
                            case 1: {
                                double im_x = (double)(vct._colors[vc.get(x + 1, y, z)] & 255 - vct._colors[vc.get(x - 1, y, z)] & 0xFF) * 0.5;
                                double im_y = (double)(vct._colors[vc.get(x, y + 1, z)] & 255 - vct._colors[vc.get(x, y - 1, z)] & 0xFF) * 0.5;
                                double im_z = (double)(vct._colors[vc.get(x, y, z + 1)] & 255 - vct._colors[vc.get(x, y, z - 1)] & 0xFF) * 0.5;
                                double tmp = Math.sqrt(im_x * im_x + im_y * im_y + im_z * im_z);
                                tmp = Math.pow(tmp, Settings.get_double_option(SegGenSnake.class, OPT_STOPPING_EXP));
                                this._stopping3D[x][y][z] = 1.0 / (1.0 + Math.sqrt(tmp));
                                break;
                            }
                            case 2: {
                                double im_x = (double)(vct._colors[vc.get(x + 1, y, z)] & 255 - vct._colors[vc.get(x - 1, y, z)] & 0xFF) * 0.5;
                                double im_y = (double)(vct._colors[vc.get(x, y + 1, z)] & 255 - vct._colors[vc.get(x, y - 1, z)] & 0xFF) * 0.5;
                                double im_z = (double)(vct._colors[vc.get(x, y, z + 1)] & 255 - vct._colors[vc.get(x, y, z - 1)] & 0xFF) * 0.5;
                                double tmp = Math.sqrt(im_x * im_x + im_y * im_y + im_z * im_z);
                                tmp = Math.pow(tmp, Settings.get_double_option(SegGenSnake.class, OPT_STOPPING_EXP));
                                double tmp2 = (double)vct._colors[vc.get(x, y, z)] - this._grey_stopping_value;
                                tmp2 *= tmp2;
                                this._stopping3D[x][y][z] = 1.0 / (1.0 + Math.sqrt(tmp) + Math.sqrt(tmp2));
                                break;
                            }
                            case 3: {
                                double im_x = (double)(vc.get(x + 1, y, z) - vc.get(x - 1, y, z)) * 0.5;
                                double im_y = (double)(vc.get(x, y + 1, z) - vc.get(x, y - 1, z)) * 0.5;
                                double im_z = (double)(vc.get(x, y, z + 1) - vc.get(x, y, z - 1)) * 0.5;
                                this._stopping3D[x][y][z] = Math.exp(-Math.sqrt(im_x * im_x + im_y * im_y + im_z * im_z));
                                break;
                            }
                            case 4: {
                                double im_x = (double)(vct._colors[vc.get(x + 1, y, z)] & 255 - vct._colors[vc.get(x - 1, y, z)] & 0xFF) * 0.5;
                                double im_y = (double)(vct._colors[vc.get(x, y + 1, z)] & 255 - vct._colors[vc.get(x, y - 1, z)] & 0xFF) * 0.5;
                                double im_z = (double)(vct._colors[vc.get(x, y, z + 1)] & 255 - vct._colors[vc.get(x, y, z - 1)] & 0xFF) * 0.5;
                                this._stopping3D[x][y][z] = Math.exp(-Math.sqrt(im_x * im_x + im_y * im_y + im_z * im_z));
                            }
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            System.out.println("generate_stopping 3d: " + sw);
        } else {
            int y = _bb_min[1] + 1;
            while (y <= _bb_max[1] - 1) {
                int x = _bb_min[0] + 1;
                while (x <= _bb_max[0] - 1) {
                    switch (this._stopping) {
                        case 0: {
                            double im_x = (double)(vc.get(x + 1, y, this._selected_idx) - vc.get(x - 1, y, this._selected_idx)) * 0.5;
                            double im_y = (double)(vc.get(x, y + 1, this._selected_idx) - vc.get(x, y - 1, this._selected_idx)) * 0.5;
                            double tmp = Math.sqrt(im_x * im_x + im_y * im_y);
                            tmp = Math.pow(tmp, Settings.get_double_option(SegGenSnake.class, OPT_STOPPING_EXP));
                            this._stopping2D[x][y] = 1.0 / (1.0 + Math.sqrt(tmp));
                            break;
                        }
                        case 1: {
                            double im_x = (double)(vct._colors[vc.get(x + 1, y, this._selected_idx)] & 255 - vct._colors[vc.get(x - 1, y, this._selected_idx)] & 0xFF) * 0.5;
                            double im_y = (double)(vct._colors[vc.get(x, y + 1, this._selected_idx)] & 255 - vct._colors[vc.get(x, y - 1, this._selected_idx)] & 0xFF) * 0.5;
                            double tmp = Math.sqrt(im_x * im_x + im_y * im_y);
                            tmp = Math.pow(tmp, Settings.get_double_option(SegGenSnake.class, OPT_STOPPING_EXP));
                            this._stopping2D[x][y] = 1.0 / (1.0 + Math.sqrt(tmp));
                            break;
                        }
                        case 2: {
                            double im_x = (double)(vct._colors[vc.get(x + 1, y, this._selected_idx)] & 255 - vct._colors[vc.get(x - 1, y, this._selected_idx) & 0xFF]) * 0.5;
                            double im_y = (double)(vct._colors[vc.get(x, y + 1, this._selected_idx)] & 255 - vct._colors[vc.get(x, y - 1, this._selected_idx)] & 0xFF) * 0.5;
                            double tmp = im_x * im_x + im_y * im_y;
                            tmp = Math.sqrt(tmp);
                            tmp = Math.pow(tmp, Settings.get_double_option(SegGenSnake.class, OPT_STOPPING_EXP));
                            double tmp2 = (double)vct._colors[vc.get(x, y, this._selected_idx)] - this._grey_stopping_value;
                            tmp2 *= tmp2;
                            this._stopping2D[x][y] = 1.0 / (1.0 + Math.sqrt(tmp) + Math.sqrt(tmp2));
                            break;
                        }
                        case 3: {
                            double im_x = (double)(vc.get(x + 1, y, this._selected_idx) - vc.get(x - 1, y, this._selected_idx)) * 0.5;
                            double im_y = (double)(vc.get(x, y + 1, this._selected_idx) - vc.get(x, y - 1, this._selected_idx)) * 0.5;
                            this._stopping2D[x][y] = Math.exp(-Math.sqrt(im_x * im_x + im_y * im_y));
                            break;
                        }
                        case 4: {
                            double im_x = (double)(vct._colors[vc.get(x + 1, y, this._selected_idx)] & 255 - vct._colors[vc.get(x - 1, y, this._selected_idx)] & 0xFF) * 0.5;
                            double im_y = (double)(vct._colors[vc.get(x, y + 1, this._selected_idx)] & 255 - vct._colors[vc.get(x, y - 1, this._selected_idx)] & 0xFF) * 0.5;
                            this._stopping2D[x][y] = Math.exp(-Math.sqrt(im_x * im_x + im_y * im_y));
                        }
                    }
                    ++x;
                }
                ++y;
            }
            System.out.println("generate_stopping 2d: " + sw);
        }
    }

    private void generate_narrow_band_2d() {
        BitMask gotcha = new BitMask(this._dim_x, this._dim_y);
        this._narrow_band.clear();
        int fi = 0;
        while (fi < this._front.size()) {
            Voxel fv = this._front.get(fi);
            int y_min = fv._y - this._band_size < _bb_min[1] ? _bb_min[1] : fv._y - this._band_size;
            int y_max = fv._y + this._band_size > _bb_max[1] ? _bb_max[1] : fv._y + this._band_size;
            int y = y_min;
            while (y <= y_max) {
                int x_min = fv._x - this._band_size < _bb_min[0] ? _bb_min[0] : fv._x - this._band_size;
                int x_max = fv._x + this._band_size > _bb_max[0] ? _bb_max[0] : fv._x + this._band_size;
                int x = x_min;
                while (x <= x_max) {
                    if (!gotcha.getXY(x, y)) {
                        this._narrow_band.add(new Voxel(x, y, 0));
                        gotcha.setXY(x, y, true);
                        break;
                    }
                    ++x;
                }
                ++y;
            }
            ++fi;
        }
    }

    private void generate_narrow_band_3d() {
        BitCube gotcha = new BitCube(this._dim_x, this._dim_y, this._dim_z);
        this._narrow_band.clear();
        int f = 0;
        while (f < this._front.size()) {
            Voxel fv = this._front.get(f);
            int z_min = fv._z - this._band_size < _bb_min[2] ? _bb_min[2] : fv._z - this._band_size;
            int z_max = fv._z + this._band_size > _bb_max[2] ? _bb_max[2] : fv._z + this._band_size;
            int z = z_min;
            while (z <= z_max) {
                int y_min = fv._y - this._band_size < _bb_min[1] ? _bb_min[1] : fv._y - this._band_size;
                int y_max = fv._y + this._band_size > _bb_max[1] ? _bb_max[1] : fv._y + this._band_size;
                int y = y_min;
                while (y <= y_max) {
                    int x_min = fv._x - this._band_size < _bb_min[0] ? _bb_min[0] : fv._x - this._band_size;
                    int x_max = fv._x + this._band_size > _bb_max[0] ? _bb_max[0] : fv._x + this._band_size;
                    int x = x_min;
                    while (x <= x_max) {
                        if (!gotcha.getXYZ(x, y, z)) {
                            this._narrow_band.add(new Voxel(x, y, z));
                            gotcha.setXYZ(x, y, z, true);
                            break;
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            ++f;
        }
    }

    private void calulate_grey_stopping_value() {
        StopWatch sw = new StopWatch(true);
        if (Settings.get_bool_option(SegGenSnake.class, OPT_USE_AUTO_GREY_STOPPING).booleanValue()) {
            this._grey_stopping_value = Settings.get_double_option(SegGenSnake.class, OPT_GREY_STOPPING_VALUE);
        } else {
            RegularGrid3i vc = MasterControl.get_is().get_voxel_cube();
            VoxelColorTable vct = MasterControl.get_v2d().get_bg_image_renderer().get_voxel_color_table();
            double grey = 0.0;
            int innerpoints = 0;
            if (this._phi.is_3d()) {
                int z = _bb_min[2];
                while (z <= _bb_max[2]) {
                    int y = _bb_min[1];
                    while (y <= _bb_max[1]) {
                        int x = _bb_min[0];
                        while (x <= _bb_max[0]) {
                            if (this._phi.get_dist(x, y, z) <= 0.0) {
                                grey += (double)vct._colors[vc.get(x, y, z)];
                                ++innerpoints;
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                System.out.println("calculate_grey_stopping_value 3d: " + sw);
            } else {
                int y = _bb_min[1];
                while (y <= _bb_max[1]) {
                    int x = _bb_min[0];
                    while (x <= _bb_max[0]) {
                        if (this._phi.get_dist(x, y, 0) <= 0.0) {
                            grey += (double)vct._colors[vc.get(x, y, this._selected_idx)];
                            ++innerpoints;
                        }
                        ++x;
                    }
                    ++y;
                }
                System.out.println("calculate_grey_stopping_value 2d: " + sw);
            }
            this._grey_stopping_value = grey /= (double)innerpoints;
        }
    }

    private void generate_speed() {
        if (this._phi.is_3d()) {
            this.generate_speed_3d();
        } else {
            this.generate_speed_2d();
        }
    }

    public SegGenSnake(Segment seg) {
        super(seg);
    }

    @Override
    public String get_name() {
        return "SegGen Snake";
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_EPSILON) {
            this._eps = Settings.get_double_option(SegGenSnake.class, OPT_EPSILON);
            if (this._phi != null) {
                this.generate_speed();
            }
        } else if (opt_name == OPT_RADIUS) {
            this._radius = Settings.get_int_option(SegGenSnake.class, OPT_RADIUS);
        } else if (opt_name == OPT_SPEED) {
            this._speed = Settings.get_double_option(SegGenSnake.class, OPT_SPEED);
        } else if (opt_name == OPT_ITERATIONS) {
            this._iterations = Settings.get_int_option(SegGenSnake.class, OPT_ITERATIONS);
        } else if (opt_name == OPT_USE_NARROWBAND) {
            this._use_narrow_band = Settings.get_bool_option(SegGenSnake.class, OPT_USE_NARROWBAND);
            if (this._use_narrow_band && this._phi != null) {
                if (this._phi.is_3d()) {
                    this.generate_narrow_band_3d();
                } else {
                    this.generate_narrow_band_2d();
                }
            }
            if (this._phi != null) {
                this.generate_speed();
            }
            if (this._box_show_dist.isSelected()) {
                this._dist_ren.new_distance_data();
            }
        } else if (opt_name == OPT_USE_FAST_SEARCH) {
            this._use_fast_search = Settings.get_bool_option(SegGenSnake.class, OPT_USE_FAST_SEARCH);
            if (this._phi != null) {
                this.generate_speed();
            }
        } else if (opt_name == OPT_BAND_SIZE) {
            this._band_size = Settings.get_int_option(SegGenSnake.class, OPT_BAND_SIZE);
            if (this._phi != null) {
                if (!this._use_fast_search) {
                    if (this._phi.is_3d()) {
                        this.generate_narrow_band_3d();
                    } else {
                        this.generate_narrow_band_2d();
                    }
                }
                if (this._use_narrow_band) {
                    this.generate_speed();
                }
            }
        } else if (opt_name == OPT_BAND_ITERATIONS) {
            this._band_iterations = Settings.get_int_option(SegGenSnake.class, OPT_BAND_ITERATIONS);
        } else if (opt_name == OPT_USE_SEG) {
            this._use_seg = Settings.get_bool_option(SegGenSnake.class, OPT_USE_SEG);
        } else if (opt_name == OPT_USE_FAST_REINIT) {
            this._use_fast_reinit = Settings.get_bool_option(SegGenSnake.class, OPT_USE_FAST_REINIT);
        } else if (opt_name == OPT_STOPPING_FUNC) {
            this._stopping = Settings.get_int_option(SegGenSnake.class, OPT_STOPPING_FUNC);
            this._jl_stopping_func.setSelectedIndex(this._stopping);
            if (this._phi != null) {
                this.generate_stopping();
                this.generate_speed();
            }
        } else if (opt_name == OPT_USE_DISTANCE_SPACING) {
            if (Settings.get_bool_option(SegGenSnake.class, OPT_USE_DISTANCE_SPACING).booleanValue()) {
                ImageStack is = MasterControl.get_is();
                this._spacing_x = is.get_x_spacing();
                this._spacing_y = is.get_y_spacing();
                this._spacing_z = is.get_z_spacing();
            } else {
                this._spacing_x = 1.0;
                this._spacing_y = 1.0;
                this._spacing_z = 1.0;
            }
        }
    }

    private void init_after_load() {
        ImageStack is = MasterControl.get_is();
        this._dim_x = is.get_dim_x();
        this._dim_y = is.get_dim_y();
        this._dim_z = is.get_dim_z();
        this._gotcha = new BitCube(this._dim_x, this._dim_y, this._dim_z);
        this._gotcha_diag2 = new BitCube(this._dim_x, this._dim_y, this._dim_z);
        this._gotcha_diag3 = new BitCube(this._dim_x, this._dim_y, this._dim_z);
        this._gotcha_final = new BitCube(this._dim_x, this._dim_y, this._dim_z);
        this._neighbours = null;
    }

    @Override
    public void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == ImageStack.M_RESIZE_END || m._type == ImageStack.M_LOADING_END) {
            this.init_after_load();
        } else if (m._type == ImageStack.M_SEG_END || m._type == ImageStack.M_RESIZE_END || m._type == ImageStack.M_FILTER3D_END) {
            if (this._phi == null) {
                this._but_exp2D.setEnabled(false);
                this._but_reint2D.setEnabled(false);
                this._but_exp3D.setEnabled(false);
                this._but_reint3D.setEnabled(false);
            } else if (this._phi.is_3d()) {
                this._but_exp2D.setEnabled(false);
                this._but_reint2D.setEnabled(false);
            } else {
                this._but_exp3D.setEnabled(false);
                this._but_reint3D.setEnabled(false);
            }
        }
    }

    @Override
    public void create_gui() {
        final SegGenSnake instance = this;
        JButton but_gen3D = new JButton("Init 3D Snake");
        JButton but_gen2D = new JButton("Init 2D Snake");
        this._but_exp2D = new JButton("Expand 2D Snake");
        this._but_exp3D = new JButton("Expand 3D Snake");
        this._but_reint2D = new JButton("Generate 2D distance");
        this._but_reint3D = new JButton("Generate 3D distance");
        this._but_final_seg = new JButton("Show Final Segment");
        Settings.register_class_listener(SegGenSnake.class, this);
        this._jdotf_eps = new JDoubleOptionTextfield(SegGenSnake.class, OPT_EPSILON, 6);
        this._jdotf_speed = new JDoubleOptionTextfield(SegGenSnake.class, OPT_SPEED, 6);
        this._jiotf_radius = new JIntegerOptionTextfield(SegGenSnake.class, OPT_RADIUS, 4);
        this._jiotf_iterations = new JIntegerOptionTextfield(SegGenSnake.class, OPT_ITERATIONS, 4);
        this._jiotf_band_iterations = new JIntegerOptionTextfield(SegGenSnake.class, OPT_BAND_ITERATIONS, 4);
        this._box_show_speed = new JCheckBox("Show Speed");
        this._box_show_dist = new JCheckBox("Show Distance");
        String[] listData = new String[]{"<html>1/(1+&radic;(grad)<sup>p</sup></html>)", "<html>1/(1+&radic;(vis_grad)<sup>p</sup>)</html>", "<html>1/(1+&radic;(vis_grad)<sup>p</sup></sup>+&radic;((u<sub>0</sub>-gs)<sup>2</sup>)</html>", "<html>e<sup>-grad</sup></html>", "<html>e<sup>-vis_grad</sup></html>"};
        this._jl_stopping_func = new JComboBox<String>(listData);
        this._jl_stopping_func.setSelectedIndex(0);
        this._but_exp2D.setEnabled(false);
        this._but_exp3D.setEnabled(false);
        this._box_show_speed.setEnabled(false);
        this._box_show_dist.setEnabled(false);
        this._but_reint2D.setEnabled(false);
        this._but_reint3D.setEnabled(false);
        this._but_final_seg.setEnabled(false);
        this._box_show_dist.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Viewport2d v2d = MasterControl.get_v2d();
                if (SegGenSnake.this._box_show_dist.isSelected()) {
                    SegGenSnake.this._dist_ren = new SnakeDistanceRenderer2d(SegGenSnake.this._phi);
                    v2d.add_renderer(SegGenSnake.this._dist_ren, 100);
                } else {
                    v2d.del_renderer(SegGenSnake.this._dist_ren);
                }
            }
        });
        this._box_show_speed.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Viewport2d v2d = MasterControl.get_v2d();
                if (SegGenSnake.this._box_show_speed.isSelected()) {
                    SegGenSnake.this._speed_ren = new SnakeSpeedRenderer2d(SegGenSnake.this._phi, SegGenSnake.this._use_narrow_band, SegGenSnake.this._narrow_band);
                    v2d.add_renderer(SegGenSnake.this._speed_ren, 101);
                } else {
                    v2d.del_renderer(SegGenSnake.this._speed_ren);
                }
            }
        });
        this._but_reint2D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenSnake.this._phi.reinitialize_distances2d(SegGenSnake.this._front, SegGenSnake.this._use_fast_reinit);
                if (SegGenSnake.this._box_show_dist.isSelected()) {
                    SegGenSnake.this._dist_ren.new_distance_data();
                }
                if (SegGenSnake.this._use_narrow_band && !SegGenSnake.this._use_fast_search) {
                    SegGenSnake.this.generate_narrow_band_2d();
                }
                SegGenSnake.this.generate_speed_2d();
            }
        });
        this._but_reint3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenSnake.this._phi.reinitialize_distances3d(SegGenSnake.this._front, SegGenSnake.this._use_fast_reinit);
                if (SegGenSnake.this._box_show_dist.isSelected()) {
                    SegGenSnake.this._dist_ren.new_distance_data();
                }
                if (SegGenSnake.this._use_narrow_band && !SegGenSnake.this._use_fast_search) {
                    SegGenSnake.this.generate_narrow_band_3d();
                }
                SegGenSnake.this.generate_speed_3d();
            }
        });
        but_gen2D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenSnake.this._selected_idx = MasterControl.get_is().get_seeds().getFirst()._z;
                CreateSnakeThread2d snake_threat = new CreateSnakeThread2d(instance, true);
                snake_threat.init2d();
                snake_threat.start();
            }
        });
        this._but_exp2D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateSnakeThread2d snake_threat = new CreateSnakeThread2d(instance, true);
                snake_threat.start();
            }
        });
        but_gen3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateSnakeThread3d snake_threat = new CreateSnakeThread3d(instance, true);
                snake_threat.init3d();
                snake_threat.start();
            }
        });
        this._but_exp3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateSnakeThread3d snake_threat = new CreateSnakeThread3d(instance, true);
                snake_threat.start();
            }
        });
        this._but_final_seg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BitCube bc = _seg.get_bc();
                bc.clear();
                if (SegGenSnake.this._phi.is_3d()) {
                    int z = _bb_min[2];
                    while (z <= _bb_max[2]) {
                        int y = _bb_min[1];
                        while (y <= _bb_max[1]) {
                            int x = _bb_min[0];
                            while (x <= _bb_max[0]) {
                                if (SegGenSnake.this._phi.get_dist(x, y, z) <= 0.0) {
                                    bc.setXYZ(x, y, z, true);
                                }
                                ++x;
                            }
                            ++y;
                        }
                        ++z;
                    }
                } else {
                    int y = _bb_min[1];
                    while (y <= _bb_max[1]) {
                        int x = _bb_min[0];
                        while (x <= _bb_max[0]) {
                            if (SegGenSnake.this._phi.get_dist(x, y, 0) <= 0.0) {
                                bc.setXYZ(x, y, SegGenSnake.this._selected_idx, true);
                            }
                            ++x;
                        }
                        ++y;
                    }
                }
                bc.calc_bb();
                _seg.set_bc(bc);
            }
        });
        this._jl_stopping_func.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.set_class_int_option(SegGenSnake.class, OPT_STOPPING_FUNC, SegGenSnake.this._jl_stopping_func.getSelectedIndex());
            }
        });
        GMPanel yp_show = new GMPanel();
        yp_show.add("but_show_dist", (JComponent)this._box_show_dist);
        yp_show.add("but_show_speed", (JComponent)this._box_show_speed);
        yp_show.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::but_show_dist::</td>  </tr><tr>    <td>::but_show_speed::</td>  </tr></table>");
        GMPanel yp_stopping = new GMPanel();
        yp_stopping.add("_jl_stopping_func", (JComponent)this._jl_stopping_func);
        yp_stopping.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>Stopping Function:</td>    <td>::_jl_stopping_func::</td>  </tr></table>");
        GMPanel yp_buttons = new GMPanel();
        yp_buttons.add("but_gen2D", (JComponent)but_gen2D);
        yp_buttons.add("but_exp2D", (JComponent)this._but_exp2D);
        yp_buttons.add("but_gen3D", (JComponent)but_gen3D);
        yp_buttons.add("but_exp3D", (JComponent)this._but_exp3D);
        yp_buttons.add("but_reint2D", (JComponent)this._but_reint2D);
        yp_buttons.add("but_reint3D", (JComponent)this._but_reint3D);
        yp_buttons.add("yp_show", (JComponent)yp_show);
        yp_buttons.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::but_gen2D::</td>    <td>::but_exp2D::</td>    <td>::but_reint2D::</td>    <td rowspan='2'>::yp_show::</td>  </tr><tr>    <td>::but_gen3D::</td>    <td>::but_exp3D::</td>    <td>::but_reint3D::</td>  </tr></table>");
        this.add("yp_stopping", (JComponent)yp_stopping);
        this.add("yp_buttons", (JComponent)yp_buttons);
        this.add("_text_eps", this._jdotf_eps);
        this.add("_text_speed", this._jdotf_speed);
        this.add("_text_radius", this._jiotf_radius);
        this.add("_text_iterations", this._jiotf_iterations);
        this.add("_text_band_iterations", this._jiotf_band_iterations);
        this.add("but_final_seg", this._but_final_seg);
        this.set_layout("<table cellpadding='2' border='0'>  <colgroup>    <col width='1%' />    <col width='33%' />    <col width='1%' />    <col width='33%' />    <col width='1%' />    <col width='33%' />  </colgroup>  <tr>    <td anchor='east'>Epsilon:</td>    <td anchor='west'>::_text_eps::</td>    <td anchor='east'>Speed:</td>    <td anchor='west'>::_text_speed::</td>    <td anchor='east'>Radius:</td>    <td anchor='west'>::_text_radius::</td>  </tr><tr>    <td colspan='6'>      <table>        <tr>          <td anchor='east'>I:</td>          <td anchor='west'>::_text_iterations::</td>          <td anchor='east'>BI:</td>          <td anchor='west'>::_text_band_iterations::</td>          <td>::yp_stopping::</td>        </tr>     </table>    </td>  </tr><tr>    <td colspan='6'>::yp_buttons::</td>  </tr><tr>    <td colspan='6'>::but_final_seg::</td>  </tr></table>");
        this._eps = Settings.get_double_option(SegGenSnake.class, OPT_EPSILON);
        this._radius = Settings.get_int_option(SegGenSnake.class, OPT_RADIUS);
        this._speed = Settings.get_double_option(SegGenSnake.class, OPT_SPEED);
        this._iterations = Settings.get_int_option(SegGenSnake.class, OPT_ITERATIONS);
        this._use_narrow_band = Settings.get_bool_option(SegGenSnake.class, OPT_USE_NARROWBAND);
        this._use_fast_search = Settings.get_bool_option(SegGenSnake.class, OPT_USE_FAST_SEARCH);
        this._band_size = Settings.get_int_option(SegGenSnake.class, OPT_BAND_SIZE);
        this._band_iterations = Settings.get_int_option(SegGenSnake.class, OPT_BAND_ITERATIONS);
        this._use_seg = Settings.get_bool_option(SegGenSnake.class, OPT_USE_SEG);
        this._use_fast_reinit = Settings.get_bool_option(SegGenSnake.class, OPT_USE_FAST_REINIT);
        this._stopping = Settings.get_int_option(SegGenSnake.class, OPT_STOPPING_FUNC);
        this._jl_stopping_func.setSelectedIndex(this._stopping);
        ImageStack is = MasterControl.get_is();
        if (Settings.get_bool_option(SegGenSnake.class, OPT_USE_DISTANCE_SPACING).booleanValue()) {
            this._spacing_x = is.get_x_spacing();
            this._spacing_y = is.get_y_spacing();
            this._spacing_z = is.get_z_spacing();
        } else {
            this._spacing_x = 1.0;
            this._spacing_y = 1.0;
            this._spacing_z = 1.0;
        }
        if (is.get_state() == 2) {
            this.init_after_load();
        }
        this.check_state();
    }

    @Override
    public boolean gui_created() {
        return this._but_exp2D != null;
    }

    private final class CreateSnakeThread2d
    extends SegmentingThread {
        public CreateSnakeThread2d(SettingsOwner parent, boolean monitor) {
            super(parent, monitor);
        }

        private void init2d() {
            StopWatch sw = new StopWatch(true);
            if (SegGenSnake.this._neighbours == null) {
                SegGenSnake.this._neighbours = new VoxelCube(SegGenSnake.this._dim_x, SegGenSnake.this._dim_y, SegGenSnake.this._dim_z);
            }
            if (SegGenSnake.this._phi == null) {
                if (SegGenSnake.this._use_seg) {
                    SegGenSnake.this._phi = new DistanceFunction(_seg.get_bc(), SegGenSnake.this._selected_idx, SegGenSnake.this._dim_x, SegGenSnake.this._dim_y, SegGenSnake.this._dim_z, SegGenSnake.this._spacing_x, SegGenSnake.this._spacing_y, SegGenSnake.this._spacing_z, _bb_min, _bb_max, false);
                } else {
                    SegGenSnake.this._phi = new DistanceFunction(MasterControl.get_is().get_seeds(), SegGenSnake.this._radius, SegGenSnake.this._dim_x, SegGenSnake.this._dim_y, SegGenSnake.this._dim_z, SegGenSnake.this._spacing_x, SegGenSnake.this._spacing_y, SegGenSnake.this._spacing_z, _bb_min, _bb_max, false);
                }
            } else if (SegGenSnake.this._use_seg) {
                SegGenSnake.this._phi.reinitialize_distance_function(_seg.get_bc(), SegGenSnake.this._selected_idx, SegGenSnake.this._dim_x, SegGenSnake.this._dim_y, SegGenSnake.this._dim_z, SegGenSnake.this._spacing_x, SegGenSnake.this._spacing_y, SegGenSnake.this._spacing_z, _bb_min, _bb_max, false);
            } else {
                SegGenSnake.this._phi.reinitialize_distance_function(MasterControl.get_is().get_seeds(), SegGenSnake.this._radius, SegGenSnake.this._dim_x, SegGenSnake.this._dim_y, SegGenSnake.this._dim_z, SegGenSnake.this._spacing_x, SegGenSnake.this._spacing_y, SegGenSnake.this._spacing_z, _bb_min, _bb_max, false);
            }
            SegGenSnake.this._reinit_step = 0;
            SegGenSnake.this._reinit_grey_stopping_step = 0;
            SegGenSnake.this._stopping2D = new double[SegGenSnake.this._dim_x][SegGenSnake.this._dim_y];
            SegGenSnake.this.calulate_grey_stopping_value();
            SegGenSnake.this.generate_stopping();
            SegGenSnake.this._front.clear();
            int y = _bb_min[1];
            while (y <= _bb_max[1]) {
                int x = _bb_min[0];
                while (x <= _bb_max[0]) {
                    if (SegGenSnake.this._phi.is_front2d(x, y)) {
                        SegGenSnake.this._front.add(new Voxel(x, y, 0));
                    }
                    ++x;
                }
                ++y;
            }
            if (SegGenSnake.this._use_seg) {
                SegGenSnake.this._phi.reinitialize_distances2d(SegGenSnake.this._front, SegGenSnake.this._use_fast_reinit);
            }
            if (SegGenSnake.this._use_narrow_band) {
                SegGenSnake.this._narrow_band = new ArrayList();
                if (!SegGenSnake.this._use_fast_search) {
                    SegGenSnake.this.generate_narrow_band_2d();
                }
            }
            SegGenSnake.this.generate_speed_2d();
            if (SegGenSnake.this._box_show_dist.isSelected()) {
                SegGenSnake.this._dist_ren.new_distance_data();
            }
            this.update_front_seg(_seg.get_bc());
            sw.stop();
            YaDiV.report(YaDiV.ReportType.REPORT_TIME, "SegGenSnake: init2d = " + sw.toString());
        }

        private void expand_without_nb(BitCube bc) {
            int bb_dim_y = _bb_max[1] - _bb_min[1] + 1;
            this.init_progress_measure("2D Expanding (no NB)", 0, 3 * SegGenSnake.this._iterations * bb_dim_y, 0);
            int i = 0;
            while (i < SegGenSnake.this._iterations) {
                int x;
                if (this._stop_soon) {
                    return;
                }
                int y = _bb_min[1];
                while (y <= _bb_max[1]) {
                    if (this._monitor) {
                        this.inc_progress_value(1);
                    }
                    x = _bb_min[0];
                    while (x <= _bb_max[0]) {
                        double tmp = SegGenSnake.this._phi.get_dist(x, y, 0) - SegGenSnake.this._speed * SegGenSnake.this._phi.get_speed(x, y, 0);
                        SegGenSnake.this._phi.set_dist(x, y, 0, tmp);
                        ++x;
                    }
                    ++y;
                }
                SegGenSnake.this._front.clear();
                y = _bb_min[1];
                while (y <= _bb_max[1]) {
                    if (this._monitor) {
                        this.inc_progress_value(1);
                    }
                    x = _bb_min[0];
                    while (x <= _bb_max[0]) {
                        if (SegGenSnake.this._phi.is_front2d(x, y)) {
                            SegGenSnake.this._front.add(new Voxel(x, y, 0));
                        }
                        ++x;
                    }
                    ++y;
                }
                SegGenSnake segGenSnake = SegGenSnake.this;
                segGenSnake._reinit_step = segGenSnake._reinit_step + 1;
                if (Settings.get_bool_option(SegGenSnake.class, OPT_USE_AUTO_REINIT).booleanValue() && SegGenSnake.this._reinit_step >= Settings.get_int_option(SegGenSnake.class, OPT_AUTO_REINIT_STEPS)) {
                    SegGenSnake.this._reinit_step = 0;
                    YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "Reinitialized distances");
                    SegGenSnake.this._phi.reinitialize_distances2d(SegGenSnake.this._front, SegGenSnake.this._use_fast_reinit);
                }
                SegGenSnake segGenSnake2 = SegGenSnake.this;
                segGenSnake2._reinit_grey_stopping_step = segGenSnake2._reinit_grey_stopping_step + 1;
                if (Settings.get_bool_option(SegGenSnake.class, OPT_USE_AUTO_GREY_STOPPING).booleanValue() && SegGenSnake.this._reinit_grey_stopping_step >= Settings.get_int_option(SegGenSnake.class, OPT_GREY_STOPPING_STEPS)) {
                    SegGenSnake.this._reinit_grey_stopping_step = 0;
                    SegGenSnake.this.calulate_grey_stopping_value();
                    SegGenSnake.this.generate_stopping();
                }
                SegGenSnake.this.generate_speed_2d();
                if (this._monitor) {
                    this.inc_progress_value(bb_dim_y);
                }
                this.update_front_seg(bc);
                if (SegGenSnake.this._box_show_dist.isSelected()) {
                    SegGenSnake.this._dist_ren.new_distance_data();
                }
                ++i;
            }
        }

        private void expand_with_nb(BitCube bc) {
            this.init_progress_measure("2D Expanding (NB)", 0, SegGenSnake.this._iterations * SegGenSnake.this._band_iterations, 0);
            StopWatch sw = new StopWatch();
            int i = 0;
            while (i < SegGenSnake.this._iterations) {
                if (this._stop_soon) {
                    return;
                }
                sw.reset();
                sw.start();
                System.out.print(String.valueOf(i) + ": front=" + SegGenSnake.this._front.size() + "/");
                int bi = 0;
                while (bi < SegGenSnake.this._band_iterations) {
                    Voxel nbv;
                    int nbi = 0;
                    while (nbi < SegGenSnake.this._narrow_band.size()) {
                        nbv = (Voxel)SegGenSnake.this._narrow_band.get(nbi);
                        double new_dist = SegGenSnake.this._phi.get_dist(nbv._x, nbv._y, 0) - SegGenSnake.this._speed * SegGenSnake.this._phi.get_speed(nbv._x, nbv._y, 0);
                        SegGenSnake.this._phi.set_dist(nbv._x, nbv._y, 0, new_dist);
                        ++nbi;
                    }
                    SegGenSnake.this._front.clear();
                    nbi = 0;
                    while (nbi < SegGenSnake.this._narrow_band.size()) {
                        nbv = (Voxel)SegGenSnake.this._narrow_band.get(nbi);
                        if (SegGenSnake.this._phi.is_front2d(nbv._x, nbv._y)) {
                            SegGenSnake.this._front.add(new Voxel(nbv._x, nbv._y, 0));
                        }
                        ++nbi;
                    }
                    SegGenSnake segGenSnake = SegGenSnake.this;
                    segGenSnake._reinit_step = segGenSnake._reinit_step + 1;
                    if (Settings.get_bool_option(SegGenSnake.class, OPT_USE_AUTO_REINIT).booleanValue() && SegGenSnake.this._reinit_step >= Settings.get_int_option(SegGenSnake.class, OPT_AUTO_REINIT_STEPS)) {
                        SegGenSnake.this._reinit_step = 0;
                        SegGenSnake.this._phi.reinitialize_distances2d(SegGenSnake.this._front, SegGenSnake.this._use_fast_reinit);
                    }
                    SegGenSnake segGenSnake2 = SegGenSnake.this;
                    segGenSnake2._reinit_grey_stopping_step = segGenSnake2._reinit_grey_stopping_step + 1;
                    if (Settings.get_bool_option(SegGenSnake.class, OPT_USE_AUTO_GREY_STOPPING).booleanValue() && SegGenSnake.this._reinit_grey_stopping_step >= Settings.get_int_option(SegGenSnake.class, OPT_GREY_STOPPING_STEPS)) {
                        SegGenSnake.this._reinit_grey_stopping_step = 0;
                        SegGenSnake.this.calulate_grey_stopping_value();
                        SegGenSnake.this.generate_stopping();
                    }
                    SegGenSnake.this.generate_speed_2d();
                    if (this._monitor) {
                        this.inc_progress_value(1);
                    }
                    ++bi;
                }
                if (!SegGenSnake.this._use_fast_search) {
                    SegGenSnake.this.generate_narrow_band_2d();
                }
                SegGenSnake.this.generate_speed_2d();
                this.update_front_seg(bc);
                if (SegGenSnake.this._box_show_dist.isSelected()) {
                    SegGenSnake.this._dist_ren.new_distance_data();
                }
                sw.stop();
                System.out.println(String.valueOf(SegGenSnake.this._front.size()) + "  time=" + sw.toString());
                ++i;
            }
        }

        private void update_front_seg(BitCube bc) {
            bc.clear();
            int f = 0;
            while (f < SegGenSnake.this._front.size()) {
                Voxel v = (Voxel)SegGenSnake.this._front.get(f);
                bc.setXYZ(v._x, v._y, SegGenSnake.this._selected_idx, true);
                ++f;
            }
            bc.calc_bb();
            _seg.set_bc(bc);
        }

        @Override
        public void my_run() {
            if (this._monitor) {
                this.set_progress_min(0);
                this.set_progress_val(0);
            }
            StopWatch sw1 = new StopWatch();
            sw1.start();
            BitCube bc = _seg.get_bc();
            if (!SegGenSnake.this._use_narrow_band) {
                this.expand_without_nb(bc);
            } else {
                this.expand_with_nb(bc);
            }
            sw1.stop();
            System.out.println("create_snake_seg_2d total_time (_use_narrow_band=" + SegGenSnake.this._use_narrow_band + ") " + sw1.toString());
            bc.calc_bb();
            _seg.set_bc(bc);
        }
    }

    private final class CreateSnakeThread3d
    extends SegmentingThread {
        public CreateSnakeThread3d(SettingsOwner parent, boolean monitor) {
            super(parent, monitor);
        }

        private void init3d() {
            StopWatch sw = new StopWatch(true);
            System.out.println();
            System.out.println("Init3d called with (" + _bb_min[0] + "," + _bb_min[1] + "," + _bb_min[2] + ") (" + _bb_max[0] + "," + _bb_max[1] + "," + _bb_max[2] + ")");
            if (SegGenSnake.this._neighbours == null) {
                SegGenSnake.this._neighbours = new VoxelCube(SegGenSnake.this._dim_x, SegGenSnake.this._dim_y, SegGenSnake.this._dim_z);
            }
            if (SegGenSnake.this._phi == null) {
                if (SegGenSnake.this._use_seg) {
                    SegGenSnake.this._phi = new DistanceFunction(_seg.get_bc(), MasterControl.get_v2d().get_model().get_active_image(0), SegGenSnake.this._dim_x, SegGenSnake.this._dim_y, SegGenSnake.this._dim_z, SegGenSnake.this._spacing_x, SegGenSnake.this._spacing_y, SegGenSnake.this._spacing_z, _bb_min, _bb_max, true);
                } else {
                    SegGenSnake.this._phi = new DistanceFunction(MasterControl.get_is().get_seeds(), SegGenSnake.this._radius, SegGenSnake.this._dim_x, SegGenSnake.this._dim_y, SegGenSnake.this._dim_z, SegGenSnake.this._spacing_x, SegGenSnake.this._spacing_z, SegGenSnake.this._spacing_z, _bb_min, _bb_max, true);
                }
            } else if (SegGenSnake.this._use_seg) {
                SegGenSnake.this._phi.reinitialize_distance_function(_seg.get_bc(), MasterControl.get_v2d().get_model().get_active_image(0), SegGenSnake.this._dim_x, SegGenSnake.this._dim_y, SegGenSnake.this._dim_z, SegGenSnake.this._spacing_x, SegGenSnake.this._spacing_z, SegGenSnake.this._spacing_z, _bb_min, _bb_max, true);
            } else {
                SegGenSnake.this._phi.reinitialize_distance_function(MasterControl.get_is().get_seeds(), SegGenSnake.this._radius, SegGenSnake.this._dim_x, SegGenSnake.this._dim_y, SegGenSnake.this._dim_z, SegGenSnake.this._spacing_x, SegGenSnake.this._spacing_z, SegGenSnake.this._spacing_z, _bb_min, _bb_max, true);
            }
            SegGenSnake.this._reinit_step = 0;
            SegGenSnake.this._reinit_grey_stopping_step = 0;
            SegGenSnake.this._stopping3D = new double[SegGenSnake.this._dim_x][SegGenSnake.this._dim_y][SegGenSnake.this._dim_z];
            SegGenSnake.this.calulate_grey_stopping_value();
            SegGenSnake.this.generate_stopping();
            SegGenSnake.this._front.clear();
            int z = _bb_min[2];
            while (z <= _bb_max[2]) {
                int y = _bb_min[1];
                while (y <= _bb_max[1]) {
                    int x = _bb_min[0];
                    while (x <= _bb_max[0]) {
                        if (SegGenSnake.this._phi.is_front3d(x, y, z)) {
                            SegGenSnake.this._front.add(new Voxel(x, y, z));
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            if (SegGenSnake.this._use_seg) {
                SegGenSnake.this._phi.reinitialize_distances3d(SegGenSnake.this._front, SegGenSnake.this._use_fast_reinit);
            }
            if (SegGenSnake.this._use_narrow_band) {
                SegGenSnake.this._narrow_band = new ArrayList();
                if (!SegGenSnake.this._use_fast_search) {
                    SegGenSnake.this.generate_narrow_band_3d();
                }
            }
            SegGenSnake.this.generate_speed_3d();
            if (SegGenSnake.this._box_show_dist.isSelected()) {
                SegGenSnake.this._dist_ren.new_distance_data();
            }
            this.update_front_seg(_seg.get_bc());
            sw.stop();
            System.out.println("init3d: " + sw.toString());
        }

        private void expand_without_nb(BitCube bc) {
            StopWatch sw = new StopWatch();
            int bb_dim_z = _bb_max[2] - _bb_min[2] + 1;
            this.init_progress_measure("3D Expanding (no NB)", 0, 2 * SegGenSnake.this._iterations * bb_dim_z + 10, 0);
            int i = 0;
            while (i < SegGenSnake.this._iterations) {
                int x;
                int y;
                if (this._stop_soon) {
                    return;
                }
                sw.reset();
                sw.start();
                int z = _bb_min[2];
                while (z <= _bb_max[2]) {
                    if (this._stop_soon) {
                        return;
                    }
                    if (this._monitor) {
                        this.inc_progress_value(1);
                    }
                    y = _bb_min[1];
                    while (y <= _bb_max[1]) {
                        x = _bb_min[0];
                        while (x <= _bb_max[0]) {
                            double tmp = SegGenSnake.this._phi.get_dist(x, y, z) - SegGenSnake.this._speed * SegGenSnake.this._phi.get_speed(x, y, z);
                            SegGenSnake.this._phi.set_dist(x, y, z, tmp);
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                sw.stop();
                System.out.println(String.valueOf(i) + "/" + SegGenSnake.this._iterations + ": step 1 = " + sw.toString());
                sw.reset();
                sw.start();
                SegGenSnake.this._front.clear();
                z = _bb_min[2];
                while (z <= _bb_max[2]) {
                    if (this._stop_soon) {
                        return;
                    }
                    if (this._monitor) {
                        this.inc_progress_value(1);
                    }
                    y = _bb_min[1];
                    while (y <= _bb_max[1]) {
                        x = _bb_min[0];
                        while (x <= _bb_max[0]) {
                            if (SegGenSnake.this._phi.is_front3d(x, y, z)) {
                                SegGenSnake.this._front.add(new Voxel(x, y, z));
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                SegGenSnake segGenSnake = SegGenSnake.this;
                segGenSnake._reinit_step = segGenSnake._reinit_step + 1;
                if (Settings.get_bool_option(SegGenSnake.class, OPT_USE_AUTO_REINIT).booleanValue() && SegGenSnake.this._reinit_step >= Settings.get_int_option(SegGenSnake.class, OPT_AUTO_REINIT_STEPS)) {
                    SegGenSnake.this._reinit_step = 0;
                    System.out.println("Reinitialized distances");
                    SegGenSnake.this._phi.reinitialize_distances3d(SegGenSnake.this._front, SegGenSnake.this._use_fast_reinit);
                }
                SegGenSnake segGenSnake2 = SegGenSnake.this;
                segGenSnake2._reinit_grey_stopping_step = segGenSnake2._reinit_grey_stopping_step + 1;
                if (Settings.get_bool_option(SegGenSnake.class, OPT_USE_AUTO_GREY_STOPPING).booleanValue() && SegGenSnake.this._reinit_grey_stopping_step >= Settings.get_int_option(SegGenSnake.class, OPT_GREY_STOPPING_STEPS)) {
                    SegGenSnake.this._reinit_grey_stopping_step = 0;
                    SegGenSnake.this.calulate_grey_stopping_value();
                    SegGenSnake.this.generate_stopping();
                }
                sw.stop();
                System.out.println(String.valueOf(i) + "/" + SegGenSnake.this._iterations + ": step 2 = " + sw.toString());
                sw.reset();
                sw.start();
                SegGenSnake.this.generate_speed_3d();
                if (this._monitor) {
                    this.inc_progress_value(10);
                }
                if (SegGenSnake.this._box_show_dist.isSelected()) {
                    SegGenSnake.this._dist_ren.new_distance_data();
                }
                this.update_front_seg(_seg.get_bc());
                sw.stop();
                System.out.println(String.valueOf(i) + "/" + SegGenSnake.this._iterations + ": step 3 = " + sw.toString());
                ++i;
            }
        }

        private void expand_with_nb(BitCube bc) {
            StopWatch sw = new StopWatch();
            this.init_progress_measure("3D Expanding (NB)", 0, SegGenSnake.this._iterations * SegGenSnake.this._band_iterations, 0);
            StopWatch sw_speed_gen = new StopWatch();
            StopWatch sw_narrow_gen = new StopWatch();
            int i = 0;
            while (i < SegGenSnake.this._iterations) {
                if (this._stop_soon) {
                    return;
                }
                sw.reset();
                sw.start();
                System.out.print(String.valueOf(i) + ": front=" + SegGenSnake.this._front.size() + "/");
                int bi = 0;
                while (bi < SegGenSnake.this._band_iterations) {
                    Voxel nbv;
                    double dt = SegGenSnake.this._speed;
                    int nbi = 0;
                    while (nbi < SegGenSnake.this._narrow_band.size()) {
                        nbv = (Voxel)SegGenSnake.this._narrow_band.get(nbi);
                        double tmp = SegGenSnake.this._phi.get_dist(nbv._x, nbv._y, nbv._z) - dt * SegGenSnake.this._phi.get_speed(nbv._x, nbv._y, nbv._z);
                        SegGenSnake.this._phi.set_dist(nbv._x, nbv._y, nbv._z, tmp);
                        ++nbi;
                    }
                    SegGenSnake.this._front.clear();
                    nbi = 0;
                    while (nbi < SegGenSnake.this._narrow_band.size()) {
                        nbv = (Voxel)SegGenSnake.this._narrow_band.get(nbi);
                        if (SegGenSnake.this._phi.is_front3d(nbv._x, nbv._y, nbv._z)) {
                            SegGenSnake.this._front.add(new Voxel(nbv._x, nbv._y, nbv._z));
                        }
                        ++nbi;
                    }
                    SegGenSnake segGenSnake = SegGenSnake.this;
                    segGenSnake._reinit_step = segGenSnake._reinit_step + 1;
                    if (Settings.get_bool_option(SegGenSnake.class, OPT_USE_AUTO_REINIT).booleanValue() && SegGenSnake.this._reinit_step >= Settings.get_int_option(SegGenSnake.class, OPT_AUTO_REINIT_STEPS)) {
                        SegGenSnake.this._reinit_step = 0;
                        System.out.print(" (Reinitialized distances) ");
                        SegGenSnake.this._phi.reinitialize_distances3d(SegGenSnake.this._front, SegGenSnake.this._use_fast_reinit);
                    }
                    SegGenSnake segGenSnake2 = SegGenSnake.this;
                    segGenSnake2._reinit_grey_stopping_step = segGenSnake2._reinit_grey_stopping_step + 1;
                    if (Settings.get_bool_option(SegGenSnake.class, OPT_USE_AUTO_GREY_STOPPING).booleanValue() && SegGenSnake.this._reinit_grey_stopping_step >= Settings.get_int_option(SegGenSnake.class, OPT_GREY_STOPPING_STEPS)) {
                        SegGenSnake.this._reinit_grey_stopping_step = 0;
                        SegGenSnake.this.calulate_grey_stopping_value();
                        SegGenSnake.this.generate_stopping();
                    }
                    sw_speed_gen.start();
                    SegGenSnake.this.generate_speed_3d();
                    sw_speed_gen.stop();
                    if (this._monitor) {
                        this.inc_progress_value(1);
                    }
                    ++bi;
                }
                if (!SegGenSnake.this._use_fast_search) {
                    sw_narrow_gen.start();
                    SegGenSnake.this.generate_narrow_band_3d();
                    sw_narrow_gen.stop();
                }
                sw_speed_gen.start();
                SegGenSnake.this.generate_speed_3d();
                sw_speed_gen.stop();
                if (SegGenSnake.this._box_show_dist.isSelected()) {
                    SegGenSnake.this._dist_ren.new_distance_data();
                }
                this.update_front_seg(_seg.get_bc());
                sw.stop();
                System.out.println(String.valueOf(SegGenSnake.this._front.size()) + "  nb=" + SegGenSnake.this._narrow_band.size() + "  time=" + sw.toString());
                ++i;
            }
            System.out.println("time for generating narrow band: " + sw_narrow_gen.toString());
            System.out.println("time for calculating speed: " + sw_speed_gen.toString());
        }

        private void update_front_seg(BitCube bc) {
            bc.clear();
            int f = 0;
            while (f < SegGenSnake.this._front.size()) {
                Voxel v = (Voxel)SegGenSnake.this._front.get(f);
                bc.setXYZ(v._x, v._y, v._z, true);
                ++f;
            }
            bc.calc_bb();
            _seg.set_bc(bc);
        }

        @Override
        public void my_run() {
            if (this._monitor) {
                this.set_progress_min(0);
                this.set_progress_val(0);
            }
            StopWatch sw1 = new StopWatch();
            sw1.start();
            BitCube bc = _seg.get_bc();
            if (!SegGenSnake.this._use_narrow_band) {
                this.expand_without_nb(bc);
            } else {
                this.expand_with_nb(bc);
            }
            if (SegGenSnake.this._box_show_dist.isSelected()) {
                SegGenSnake.this._dist_ren.new_distance_data();
            }
            bc.clear();
            int f = 0;
            while (f < SegGenSnake.this._front.size()) {
                Voxel v = (Voxel)SegGenSnake.this._front.get(f);
                bc.setXYZ(v._x, v._y, v._z, true);
                ++f;
            }
            sw1.stop();
            System.out.println("create_snake_seg_3d total_time :" + sw1);
            bc.calc_bb();
            _seg.set_bc(bc);
        }
    }
}

