/*
 * Decompiled with CFR 0.152.
 */
package main.seggen;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.seggen.SegGen;
import main.seggen.SegGenSnake;
import main.seggen.levelset.DistanceFunction;
import main.seggen.levelset.EnergyIntegralTerms;
import main.seggen.levelset.Heaviside;
import main.seggen.levelset.Heaviside0;
import main.seggen.levelset.Heaviside1;
import main.seggen.levelset.Heaviside2;
import main.view2d.Viewport2d;
import misc.StopWatch;
import misc.Voxel;
import misc.grid.BitCube;
import misc.grid.RegularGrid3i;
import misc.messages.YObservable;
import renderer.SnakeDistanceRenderer2d;
import settings.JBoolOptionCheckbox;
import settings.JDoubleOptionTextfield;
import settings.JIntegerOptionTextfield;
import settings.Settings;
import settings.SettingsOwner;
import threads.SegmentingThread;

public final class SegGenSnakeEnergy
extends SegGen
implements SettingsOwner {
    public static final String OPT_VOXEL_VALUE_MIN = Settings.register_int_opt(SegGenSnakeEnergy.class, "voxel value min", "Voxel values below this value do not count.", 100);
    public static final String OPT_VOXEL_VALUE_MAX = Settings.register_int_opt(SegGenSnakeEnergy.class, "voxel value max", "Voxel values above this value do not count.", 100);
    public static final String OPT_EPSILON = Settings.register_double_opt(SegGenSnakeEnergy.class, "epsilon", "Controls the Heavyside Function.", 1.0);
    public static final String OPT_RADIUS = Settings.register_int_opt(SegGenSnakeEnergy.class, "radius", "Initial sphere radius when using seeds.", 3);
    public static final String OPT_SPEED = Settings.register_double_opt(SegGenSnakeEnergy.class, "speed", "Controls the expansion speed.", 0.1);
    public static final String OPT_ITERATIONS = Settings.register_int_opt(SegGenSnakeEnergy.class, "iterations", "Number of iterations per init/expand.", 1);
    public static final String OPT_MU = Settings.register_double_opt(SegGenSnakeEnergy.class, "mu", "Area Weight", 1.0);
    public static final String OPT_NU = Settings.register_double_opt(SegGenSnakeEnergy.class, "nu", "Volume Weight", 1.0);
    public static final String OPT_LAMBDA1 = Settings.register_double_opt(SegGenSnakeEnergy.class, "lambda1", "Inner Weight", 1.0);
    public static final String OPT_LAMBDA2 = Settings.register_double_opt(SegGenSnakeEnergy.class, "lambda2", "Outer Weight", 1.0);
    public static final String OPT_USE_VISUAL_GRAD = Settings.register_bool_opt(SegGenSnakeEnergy.class, "Use Visual Gradient", "If enabled, the voxel the visual voxel values (= voxel values modified by ROI function) are used", false);
    public static final String OPT_USE_DISTANCE_SPACING = Settings.register_bool_opt(SegGenSnakeEnergy.class, "Distance Spacing", "If enabled, the x-, y-, and z-spacing from the volume data is used. Should be set to true.", true);
    public static final String OPT_USE_FAST_REINIT = Settings.register_bool_opt(SegGenSnakeEnergy.class, "Fast Reinitialization", "When this option is true, the distance function uses an improved method for reinitialization (\"onion method\")", true);
    public static final String OPT_USE_AUTO_REINIT = Settings.register_bool_opt(SegGenSnakeEnergy.class, "Auto Reinitialization", "Reinitialize automatically after a given number of steps.", true);
    public static final String OPT_AUTO_REINIT_STEPS = Settings.register_int_opt(SegGenSnakeEnergy.class, "Reinitialization Steps", "Number of steps for automatic reinitialization.", 1);
    public static final String OPT_USE_NARROW_BAND = Settings.register_bool_opt(SegGenSnakeEnergy.class, "Narrow Band", "True if the narrow band optimization should be used. If in doubt, set to false.", false);
    public static final String OPT_BAND_SIZE = Settings.register_int_opt(SegGenSnakeEnergy.class, "Narrow Band Size", "Size of the narrow band, used for better performance. If the size is to small, it might lead to errors.Tests have shown that 2 seems to be an optimal value.", 2);
    public static final String OPT_USE_LOGARITHM = Settings.register_bool_opt(SegGenSnakeEnergy.class, "Use Logartithm", "Use the logarithm in the energy functionial.", false);
    public static final String OPT_USE_SEG = Settings.register_bool_opt(SegGenSnakeEnergy.class, "Use Segment", "Use the the currently active segement selection as start contour.", false);
    public static final String OPT_POWER_OF_AREA = Settings.register_int_opt(SegGenSnakeEnergy.class, "Power of the area", "Increases the influence of the active contour area in the energy functional. The value of 1 corresponds to thechan-vese functional.", 1);
    private JButton _but_exp2D;
    private JButton _but_exp3D;
    private JButton _but_reint2D;
    private JButton _but_reint3D;
    private JCheckBox _but_show_dist;
    private JButton _jb_min_value;
    private JButton _jb_max_value;
    private DistanceFunction _phi;
    private double _mu;
    private double _nu;
    private double _lambda1;
    private double _lambda2;
    private double _eps;
    private int _radius;
    private double _speed;
    private int _iterations;
    private boolean _expand;
    private int _reinit_step;
    private final ArrayList<Voxel> _front = new ArrayList();
    private final ArrayList<Voxel> _narrow_band = new ArrayList();
    private boolean _use_fast_reinit = true;
    private int _dim_x;
    private int _dim_y;
    private int _dim_z;
    private double _spacing_x;
    private double _spacing_y;
    private double _spacing_z;
    private Heaviside _heavi;
    private int _voxel_value_min;
    private int _voxel_value_max;
    private int _selected_slice;
    private SnakeDistanceRenderer2d _dist_ren;

    public SegGenSnakeEnergy(Segment seg) {
        super(seg);
    }

    @Override
    public final String get_name() {
        return "SegGenSnakeEnergy";
    }

    @Override
    public final void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_EPSILON) {
            this._eps = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_EPSILON);
        } else if (opt_name == OPT_RADIUS) {
            this._radius = Settings.get_int_option(SegGenSnakeEnergy.class, OPT_RADIUS);
        } else if (opt_name == OPT_SPEED) {
            this._speed = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_SPEED);
        } else if (opt_name == OPT_ITERATIONS) {
            this._iterations = Settings.get_int_option(SegGenSnakeEnergy.class, OPT_ITERATIONS);
        } else if (opt_name == OPT_MU) {
            this._mu = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_MU);
        } else if (opt_name == OPT_NU) {
            this._nu = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_NU);
        } else if (opt_name == OPT_LAMBDA1) {
            this._lambda1 = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_LAMBDA1);
        } else if (opt_name == OPT_LAMBDA2) {
            this._lambda2 = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_LAMBDA2);
        } else if (opt_name == OPT_USE_FAST_REINIT) {
            this._use_fast_reinit = Settings.get_bool_option(SegGenSnakeEnergy.class, OPT_USE_FAST_REINIT);
        } else if (opt_name == OPT_VOXEL_VALUE_MIN) {
            this._voxel_value_min = Settings.get_int_option(SegGenSnakeEnergy.class, OPT_VOXEL_VALUE_MIN);
            this._heavi.set_voxel_value_min(this._voxel_value_min);
        } else if (opt_name == OPT_VOXEL_VALUE_MAX) {
            this._voxel_value_max = Settings.get_int_option(SegGenSnakeEnergy.class, OPT_VOXEL_VALUE_MAX);
            this._heavi.set_voxel_value_max(this._voxel_value_max);
        } else if (opt_name == OPT_USE_DISTANCE_SPACING) {
            if (Settings.get_bool_option(SegGenSnakeEnergy.class, OPT_USE_DISTANCE_SPACING).booleanValue()) {
                ImageStack is = MasterControl.get_is();
                this._spacing_x = is.get_x_spacing();
                this._spacing_y = is.get_y_spacing();
                this._spacing_z = is.get_z_spacing();
            } else {
                this._spacing_x = 1.0;
                this._spacing_y = 1.0;
                this._spacing_z = 1.0;
            }
        }
    }

    private void init_after_load() {
        ImageStack is = MasterControl.get_is();
        this._dim_x = is.get_dim_x();
        this._dim_y = is.get_dim_y();
        this._dim_z = is.get_dim_z();
        Settings.set_class_int_option(SegGenSnakeEnergy.class, OPT_VOXEL_VALUE_MIN, 0);
        Settings.set_class_int_option(SegGenSnakeEnergy.class, OPT_VOXEL_VALUE_MAX, is.get_voxel_value_range());
    }

    @Override
    public void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == ImageStack.M_SELECTXYZ) {
            ImageStack is = MasterControl.get_is();
            if (is.get_seeds().size() != 1) {
                this._jb_min_value.setEnabled(false);
                this._jb_max_value.setEnabled(false);
            } else {
                this._jb_min_value.setEnabled(true);
                this._jb_max_value.setEnabled(true);
            }
        } else if (m._type == ImageStack.M_LOADING_END || m._type == ImageStack.M_RESIZE_END) {
            this.init_after_load();
        } else if (m._type == ImageStack.M_SEG_END || m._type == ImageStack.M_RESIZE_END || m._type == ImageStack.M_FILTER3D_END) {
            if (this._phi == null) {
                this._but_exp2D.setEnabled(false);
                this._but_reint2D.setEnabled(false);
                this._but_exp3D.setEnabled(false);
                this._but_reint3D.setEnabled(false);
            } else if (this._phi.is_3d()) {
                this._but_exp2D.setEnabled(false);
                this._but_reint2D.setEnabled(false);
            } else {
                this._but_exp3D.setEnabled(false);
                this._but_reint3D.setEnabled(false);
            }
        }
    }

    @Override
    public void create_gui() {
        final SegGenSnakeEnergy instance = this;
        JButton but_gen2D = new JButton("Init 2D Energy");
        this._but_exp2D = new JButton("Expand 2D Energy");
        JButton but_gen3D = new JButton("Init 3D Energy");
        this._but_exp3D = new JButton("Expand 3D Energy");
        this._but_exp2D.setEnabled(false);
        this._but_exp3D.setEnabled(false);
        this._but_reint2D = new JButton("Generate 2D distance");
        this._but_reint3D = new JButton("Generate 3D distance");
        this._but_reint2D.setEnabled(false);
        this._but_reint3D.setEnabled(false);
        Settings.register_class_listener(SegGenSnakeEnergy.class, this);
        JDoubleOptionTextfield jdotf_eps = new JDoubleOptionTextfield(SegGenSnakeEnergy.class, OPT_EPSILON, 6);
        JIntegerOptionTextfield jiotf_radius = new JIntegerOptionTextfield(SegGenSnakeEnergy.class, OPT_RADIUS, 4);
        JDoubleOptionTextfield jdotf_speed = new JDoubleOptionTextfield(SegGenSnakeEnergy.class, OPT_SPEED, 6);
        JIntegerOptionTextfield jiotf_iterations = new JIntegerOptionTextfield(SegGenSnakeEnergy.class, OPT_ITERATIONS, 4);
        JDoubleOptionTextfield jdotf_mu = new JDoubleOptionTextfield(SegGenSnakeEnergy.class, OPT_MU, 6);
        JDoubleOptionTextfield jdotf_nu = new JDoubleOptionTextfield(SegGenSnakeEnergy.class, OPT_NU, 6);
        JDoubleOptionTextfield jdotf_lambda1 = new JDoubleOptionTextfield(SegGenSnakeEnergy.class, OPT_LAMBDA1, 6);
        JDoubleOptionTextfield jdotf_lambda2 = new JDoubleOptionTextfield(SegGenSnakeEnergy.class, OPT_LAMBDA2, 6);
        JIntegerOptionTextfield jiotf_value_min = new JIntegerOptionTextfield(SegGenSnakeEnergy.class, OPT_VOXEL_VALUE_MIN, 4);
        JIntegerOptionTextfield jiotf_value_max = new JIntegerOptionTextfield(SegGenSnakeEnergy.class, OPT_VOXEL_VALUE_MAX, 4);
        JBoolOptionCheckbox _jbocb_use_seg = new JBoolOptionCheckbox(SegGenSnakeEnergy.class, OPT_USE_SEG);
        JBoolOptionCheckbox _jbocb_use_visuell_grad = new JBoolOptionCheckbox(SegGenSnakeEnergy.class, OPT_USE_VISUAL_GRAD);
        String[] listData = new String[]{"<html>H(z) = &frac12;+1/PI * atan(z/&epsilon;)</html>", "<html>H(z) = &frac12; * (1 + z/eps + sin(&pi;*z/&epsilon;)/&pi;</html>", "<html>H(z) = &frac12; * (1 + tanh(z/&epsilon;))</html>"};
        final JComboBox<String> jl_heaviside_func = new JComboBox<String>(listData);
        jl_heaviside_func.setSelectedIndex(0);
        this._but_show_dist = new JCheckBox("Show Distance");
        this._but_show_dist.setEnabled(false);
        this._but_show_dist.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Viewport2d v2d = MasterControl.get_v2d();
                if (SegGenSnakeEnergy.this._but_show_dist.isSelected()) {
                    SegGenSnakeEnergy.this._dist_ren = new SnakeDistanceRenderer2d(SegGenSnakeEnergy.this._phi);
                    v2d.add_renderer(SegGenSnakeEnergy.this._dist_ren, 100);
                } else {
                    v2d.del_renderer(SegGenSnakeEnergy.this._dist_ren);
                }
                v2d.repaint();
            }
        });
        but_gen2D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenSnakeEnergy.this._expand = false;
                CreateEnergySnake2dThread energy_threat = new CreateEnergySnake2dThread(instance, true);
                energy_threat.start();
            }
        });
        this._but_exp2D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenSnakeEnergy.this._expand = true;
                CreateEnergySnake2dThread energy_threat = new CreateEnergySnake2dThread(instance, true);
                energy_threat.start();
            }
        });
        but_gen3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenSnakeEnergy.this._expand = false;
                CreateEnergySnake3dThread energy_threat = new CreateEnergySnake3dThread(instance, true);
                energy_threat.start();
            }
        });
        this._but_exp3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenSnakeEnergy.this._expand = true;
                CreateEnergySnake3dThread energy_threat = new CreateEnergySnake3dThread(instance, true);
                energy_threat.start();
            }
        });
        this._but_reint2D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenSnakeEnergy.this._phi.reinitialize_distances2d(SegGenSnakeEnergy.this._front, Settings.get_bool_option(SegGenSnake.class, OPT_USE_FAST_REINIT));
                if (SegGenSnakeEnergy.this._but_show_dist.isSelected()) {
                    SegGenSnakeEnergy.this._dist_ren.new_distance_data();
                }
            }
        });
        this._but_reint3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegGenSnakeEnergy.this._phi.reinitialize_distances3d(SegGenSnakeEnergy.this._front, Settings.get_bool_option(SegGenSnake.class, OPT_USE_FAST_REINIT));
                if (SegGenSnakeEnergy.this._but_show_dist.isSelected()) {
                    SegGenSnakeEnergy.this._dist_ren.new_distance_data();
                }
            }
        });
        this._heavi = new Heaviside0(this._voxel_value_min, this._voxel_value_max);
        jl_heaviside_func.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int heaviside = jl_heaviside_func.getSelectedIndex();
                switch (heaviside) {
                    case 0: {
                        SegGenSnakeEnergy.this._heavi = new Heaviside0(SegGenSnakeEnergy.this._voxel_value_min, SegGenSnakeEnergy.this._voxel_value_max);
                        break;
                    }
                    case 1: {
                        SegGenSnakeEnergy.this._heavi = new Heaviside1(SegGenSnakeEnergy.this._voxel_value_min, SegGenSnakeEnergy.this._voxel_value_max);
                        break;
                    }
                    case 2: {
                        SegGenSnakeEnergy.this._heavi = new Heaviside2(SegGenSnakeEnergy.this._voxel_value_min, SegGenSnakeEnergy.this._voxel_value_max);
                    }
                }
            }
        });
        this._jb_min_value = new JButton("Use seed");
        this._jb_min_value.setEnabled(false);
        this._jb_min_value.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageStack is = MasterControl.get_is();
                RegularGrid3i vc = is.get_voxel_cube();
                Voxel seed = is.get_seeds().getFirst();
                int value = vc.get(seed._x, seed._y, seed._z);
                Settings.set_class_int_option(SegGenSnakeEnergy.class, OPT_VOXEL_VALUE_MIN, value);
            }
        });
        this._jb_max_value = new JButton("Use seed");
        this._jb_max_value.setEnabled(false);
        this._jb_max_value.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageStack is = MasterControl.get_is();
                RegularGrid3i vc = is.get_voxel_cube();
                Voxel seed = is.get_seeds().getFirst();
                int value = vc.get(seed._x, seed._y, seed._z);
                Settings.set_class_int_option(SegGenSnakeEnergy.class, OPT_VOXEL_VALUE_MAX, value);
            }
        });
        GMPanel yp_min = new GMPanel();
        yp_min.add("jiotf_value_min", (JComponent)jiotf_value_min);
        yp_min.add("_jb_min_value", (JComponent)this._jb_min_value);
        yp_min.set_layout("<table cellpadding='2' border='0'>  <tr>    <td anchor='east'>Voxel Min:</td>    <td anchor='west'>::jiotf_value_min::</td>    <td anchor='west'>::_jb_min_value::</td>  </tr></table>");
        GMPanel yp_max = new GMPanel();
        yp_max.add("jiotf_value_max", (JComponent)jiotf_value_max);
        yp_max.add("_jb_max_value", (JComponent)this._jb_max_value);
        yp_max.set_layout("<table cellpadding='2' border='0'>  <tr>    <td anchor='east'>Voxel Max:</td>    <td anchor='west'>::jiotf_value_max::</td>    <td anchor='west'>::_jb_max_value::</td>  </tr></table>");
        GMPanel yp_heavi = new GMPanel();
        yp_heavi.add("_jl_heaviside_func", jl_heaviside_func);
        yp_heavi.add("_jbocb_use_visuell_grad", (JComponent)_jbocb_use_visuell_grad);
        yp_heavi.add("_jbocb_use_seg", (JComponent)_jbocb_use_seg);
        yp_heavi.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>Heaviside:</td>    <td>::_jl_heaviside_func::</td>    <td>::_jbocb_use_visuell_grad::</td>    <td>::_jbocb_use_seg::</td>  </tr></table>");
        GMPanel yp_show = new GMPanel();
        yp_show.add("but_show_dist", (JComponent)this._but_show_dist);
        yp_show.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::but_show_dist::</td>  </tr></table>");
        GMPanel yp_buttons = new GMPanel();
        yp_buttons.add("but_gen2D", (JComponent)but_gen2D);
        yp_buttons.add("but_exp2D", (JComponent)this._but_exp2D);
        yp_buttons.add("but_gen3D", (JComponent)but_gen3D);
        yp_buttons.add("but_exp3D", (JComponent)this._but_exp3D);
        yp_buttons.add("but_reint2D", (JComponent)this._but_reint2D);
        yp_buttons.add("but_reint3D", (JComponent)this._but_reint3D);
        yp_buttons.add("yp_show", (JComponent)yp_show);
        yp_buttons.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::but_gen2D::</td>    <td>::but_exp2D::</td>    <td>::but_reint2D::</td>    <td rowspan='2'>::yp_show::</td>  </tr><tr>    <td>::but_gen3D::</td>    <td>::but_exp3D::</td>    <td>::but_reint3D::</td>  </tr></table>");
        this.add("yp_min", (JComponent)yp_min);
        this.add("yp_max", (JComponent)yp_max);
        this.add("yp_heavi", (JComponent)yp_heavi);
        this.add("yp_buttons", (JComponent)yp_buttons);
        this.add("_text_eps", jdotf_eps);
        this.add("_text_radius", jiotf_radius);
        this.add("_text_speed", jdotf_speed);
        this.add("_text_iterations", jiotf_iterations);
        this.add("_text_mu", jdotf_mu);
        this.add("_text_nu", jdotf_nu);
        this.add("_text_lambda1", jdotf_lambda1);
        this.add("_text_lambda2", jdotf_lambda2);
        this.set_layout("<table cellpadding='2' border='0'>  <colgroup>    <col width='1%' />    <col width='33%' />    <col width='1%' />    <col width='33%' />    <col width='1%' />    <col width='33%' />    <col width='1%' />    <col width='33%' />  </colgroup>  <tr>    <td anchor='east'>Radius:</td>    <td anchor='west'>::_text_radius::</td>    <td anchor='east'>Iterations:</td>    <td anchor='west'>::_text_iterations::</td>    <td anchor='east'>Speed:</td>    <td anchor='west'>::_text_speed::</td>    <td anchor='east'>Epsilon:</td>    <td anchor='west'>::_text_eps::</td>  </tr><tr>    <td anchor='east'>Lambda1:</td>    <td anchor='west'>::_text_lambda1::</td>    <td anchor='east'>Lambda2:</td>    <td anchor='west'>::_text_lambda2::</td>    <td anchor='east'>Mu:</td>    <td anchor='west'>::_text_mu::</td>    <td anchor='east'>Nu:</td>    <td anchor='west'>::_text_nu::</td>  </tr><tr>    <td colspan='4'>::yp_min::</td>    <td colspan='4'>::yp_max::</td>  </tr><tr>    <td colspan='8'>::yp_heavi::</td>  </tr><tr>    <td colspan='8'>::yp_buttons::</td>  </tr></table>");
        this._eps = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_EPSILON);
        this._radius = Settings.get_int_option(SegGenSnakeEnergy.class, OPT_RADIUS);
        this._speed = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_SPEED);
        this._iterations = Settings.get_int_option(SegGenSnakeEnergy.class, OPT_ITERATIONS);
        this._mu = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_MU);
        this._nu = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_NU);
        this._lambda1 = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_LAMBDA1);
        this._lambda2 = Settings.get_double_option(SegGenSnakeEnergy.class, OPT_LAMBDA2);
        this._use_fast_reinit = Settings.get_bool_option(SegGenSnakeEnergy.class, OPT_USE_FAST_REINIT);
        this._voxel_value_min = Settings.get_int_option(SegGenSnakeEnergy.class, OPT_VOXEL_VALUE_MIN);
        this._voxel_value_max = Settings.get_int_option(SegGenSnakeEnergy.class, OPT_VOXEL_VALUE_MAX);
        ImageStack is = MasterControl.get_is();
        if (Settings.get_bool_option(SegGenSnakeEnergy.class, OPT_USE_DISTANCE_SPACING).booleanValue()) {
            this._spacing_x = is.get_x_spacing();
            this._spacing_y = is.get_y_spacing();
            this._spacing_z = is.get_z_spacing();
        } else {
            this._spacing_x = 1.0;
            this._spacing_y = 1.0;
            this._spacing_z = 1.0;
        }
        if (is.get_state() == 2) {
            this.init_after_load();
        }
        this.check_state();
    }

    @Override
    public boolean gui_created() {
        return this._but_exp2D != null;
    }

    static /* synthetic */ boolean access$0(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._expand;
    }

    static /* synthetic */ int access$2(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._radius;
    }

    static /* synthetic */ int access$3(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._dim_x;
    }

    static /* synthetic */ int access$4(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._dim_y;
    }

    static /* synthetic */ int access$5(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._dim_z;
    }

    static /* synthetic */ double access$6(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._spacing_x;
    }

    static /* synthetic */ double access$7(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._spacing_y;
    }

    static /* synthetic */ double access$8(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._spacing_z;
    }

    static /* synthetic */ void access$9(SegGenSnakeEnergy segGenSnakeEnergy, DistanceFunction distanceFunction) {
        segGenSnakeEnergy._phi = distanceFunction;
    }

    static /* synthetic */ void access$10(SegGenSnakeEnergy segGenSnakeEnergy, int n) {
        segGenSnakeEnergy._reinit_step = n;
    }

    static /* synthetic */ int access$12(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._selected_slice;
    }

    static /* synthetic */ boolean access$13(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._use_fast_reinit;
    }

    static /* synthetic */ int access$16(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._iterations;
    }

    static /* synthetic */ Heaviside access$17(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._heavi;
    }

    static /* synthetic */ double access$18(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._eps;
    }

    static /* synthetic */ double access$21(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._mu;
    }

    static /* synthetic */ double access$22(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._nu;
    }

    static /* synthetic */ double access$23(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._lambda1;
    }

    static /* synthetic */ double access$24(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._lambda2;
    }

    static /* synthetic */ double access$25(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._speed;
    }

    static /* synthetic */ int access$26(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._reinit_step;
    }

    static /* synthetic */ ArrayList access$27(SegGenSnakeEnergy segGenSnakeEnergy) {
        return segGenSnakeEnergy._narrow_band;
    }

    private final class CreateEnergySnake2dThread
    extends SegmentingThread {
        public CreateEnergySnake2dThread(SettingsOwner parent, boolean monitor) {
            super(parent, monitor);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void my_run() {
            block62: {
                block61: {
                    sw = new StopWatch(true);
                    SegGenSnakeEnergy.this.init_value_mapping(Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_VISUAL_GRAD));
                    System.out.println("create_energy_snake_seg_2d: " + MasterControl.get_is().get_seeds());
                    bc = SegGenSnakeEnergy._seg.get_bc();
                    z = MasterControl.get_is().get_seeds().getFirst()._z;
                    is = MasterControl.get_is();
                    if (this._monitor) {
                        this.set_progress_min(0);
                        this.set_progress_val(0);
                    }
                    if (!SegGenSnakeEnergy.access$0(SegGenSnakeEnergy.this)) {
                        if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this) == null) {
                            if (!Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_SEG).booleanValue()) {
                                SegGenSnakeEnergy.access$9(SegGenSnakeEnergy.this, new DistanceFunction(MasterControl.get_is().get_seeds(), SegGenSnakeEnergy.access$2(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$5(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$6(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$7(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$8(SegGenSnakeEnergy.this), SegGenSnakeEnergy._bb_min, SegGenSnakeEnergy._bb_max, false));
                            } else {
                                SegGenSnakeEnergy.access$9(SegGenSnakeEnergy.this, new DistanceFunction(bc, MasterControl.get_v2d().get_model().get_active_image(0), SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$5(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$6(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$7(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$8(SegGenSnakeEnergy.this), SegGenSnakeEnergy._bb_min, SegGenSnakeEnergy._bb_max, false));
                            }
                        } else if (!Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_SEG).booleanValue()) {
                            SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).reinitialize_distance_function(MasterControl.get_is().get_seeds(), SegGenSnakeEnergy.access$2(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$5(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$6(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$7(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$8(SegGenSnakeEnergy.this), SegGenSnakeEnergy._bb_min, SegGenSnakeEnergy._bb_max, false);
                        } else {
                            SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).reinitialize_distance_function(bc, MasterControl.get_v2d().get_model().get_active_image(0), SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$5(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$6(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$7(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$8(SegGenSnakeEnergy.this), SegGenSnakeEnergy._bb_min, SegGenSnakeEnergy._bb_max, false);
                        }
                        SegGenSnakeEnergy.access$10(SegGenSnakeEnergy.this, 0);
                    }
                    SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).clear();
                    y = SegGenSnakeEnergy._bb_min[1];
                    while (y <= SegGenSnakeEnergy._bb_max[1]) {
                        x = SegGenSnakeEnergy._bb_min[0];
                        while (x <= SegGenSnakeEnergy._bb_max[0]) {
                            if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).is_front2d(x, y)) {
                                SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).add(new Voxel(x, y, SegGenSnakeEnergy.access$12(SegGenSnakeEnergy.this)));
                            }
                            ++x;
                        }
                        ++y;
                    }
                    if (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_SEG).booleanValue()) {
                        SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).reinitialize_distances2d(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$13(SegGenSnakeEnergy.this));
                    }
                    vc = is.get_voxel_cube();
                    if (SegGenSnakeEnergy.access$14(SegGenSnakeEnergy.this).isSelected()) {
                        SegGenSnakeEnergy.access$15(SegGenSnakeEnergy.this).new_distance_data();
                    }
                    progress_counter = 0;
                    if (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_NARROW_BAND).booleanValue()) break block61;
                    box_dim_y = SegGenSnakeEnergy._bb_max[1] - SegGenSnakeEnergy._bb_min[1];
                    this.set_progress_max(SegGenSnakeEnergy.access$16(SegGenSnakeEnergy.this) * (box_dim_y + box_dim_y + box_dim_y) + 1);
                    i = 0;
                    while (i < SegGenSnakeEnergy.access$16(SegGenSnakeEnergy.this)) {
                        eit = new EnergyIntegralTerms();
                        y = SegGenSnakeEnergy._bb_min[1];
                        while (y <= SegGenSnakeEnergy._bb_max[1]) {
                            if (this._stop_soon) {
                                return;
                            }
                            if (this._monitor) {
                                this.set_progress_val(progress_counter++);
                            }
                            x = SegGenSnakeEnergy._bb_min[0];
                            while (x <= SegGenSnakeEnergy._bb_max[0]) {
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(x, y, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(x, y, z)], vc.get(x, y, z), eit);
                                ++x;
                            }
                            ++y;
                        }
                        eit.normalize();
                        p = Settings.get_int_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_POWER_OF_AREA);
                        y = SegGenSnakeEnergy._bb_min[1];
                        while (y <= SegGenSnakeEnergy._bb_max[1]) {
                            if (this._stop_soon) {
                                return;
                            }
                            if (this._monitor) {
                                this.set_progress_val(progress_counter++);
                            }
                            x = SegGenSnakeEnergy._bb_min[0];
                            while (x <= SegGenSnakeEnergy._bb_max[0]) {
                                val = SegGenSnakeEnergy.this._value_mapping[vc.get(x, y, z)];
                                curvature = SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).compute_curvature2d(x, y);
                                new_speed = vc.get(x, y, z) >= SegGenSnakeEnergy.access$19(SegGenSnakeEnergy.this) && vc.get(x, y, z) <= SegGenSnakeEnergy.access$20(SegGenSnakeEnergy.this) ? (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_LOGARITHM).booleanValue() ? SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).dirac(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(x, y, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this)) * (SegGenSnakeEnergy.access$21(SegGenSnakeEnergy.this) * (double)p * Math.pow(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).size(), p - 1) * curvature + SegGenSnakeEnergy.access$22(SegGenSnakeEnergy.this) + SegGenSnakeEnergy.access$23(SegGenSnakeEnergy.this) * Math.log((val - eit._c1) * (val - eit._c1)) - SegGenSnakeEnergy.access$24(SegGenSnakeEnergy.this) * Math.log((val - eit._c2) * (val - eit._c2))) : SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).dirac(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(x, y, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this)) * (SegGenSnakeEnergy.access$21(SegGenSnakeEnergy.this) * (double)p * Math.pow(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).size(), p - 1) * curvature + SegGenSnakeEnergy.access$22(SegGenSnakeEnergy.this) + SegGenSnakeEnergy.access$23(SegGenSnakeEnergy.this) * (val - eit._c1) * (val - eit._c1) - SegGenSnakeEnergy.access$24(SegGenSnakeEnergy.this) * (val - eit._c2) * (val - eit._c2))) : 0.0;
                                SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).set_speed(x, y, 0, new_speed);
                                ++x;
                            }
                            ++y;
                        }
                        y = SegGenSnakeEnergy._bb_min[1];
                        while (y <= SegGenSnakeEnergy._bb_max[1]) {
                            if (this._monitor) {
                                this.set_progress_val(progress_counter++);
                            }
                            x = SegGenSnakeEnergy._bb_min[0];
                            while (x <= SegGenSnakeEnergy._bb_max[0]) {
                                SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).set_dist(x, y, 0, SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(x, y, 0) + SegGenSnakeEnergy.access$25(SegGenSnakeEnergy.this) * SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_speed(x, y, 0));
                                ++x;
                            }
                            ++y;
                        }
                        v0 = SegGenSnakeEnergy.this;
                        SegGenSnakeEnergy.access$10(v0, SegGenSnakeEnergy.access$26(v0) + 1);
                        if (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_AUTO_REINIT).booleanValue() && SegGenSnakeEnergy.access$26(SegGenSnakeEnergy.this) >= Settings.get_int_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_AUTO_REINIT_STEPS)) {
                            SegGenSnakeEnergy.access$10(SegGenSnakeEnergy.this, 0);
                            SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).clear();
                            y = SegGenSnakeEnergy._bb_min[1];
                            while (y <= SegGenSnakeEnergy._bb_max[1]) {
                                x = SegGenSnakeEnergy._bb_min[0];
                                while (x <= SegGenSnakeEnergy._bb_max[0]) {
                                    if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).is_front2d(x, y)) {
                                        SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).add(new Voxel(x, y, SegGenSnakeEnergy.access$12(SegGenSnakeEnergy.this)));
                                    }
                                    ++x;
                                }
                                ++y;
                            }
                            SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).reinitialize_distances2d(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$13(SegGenSnakeEnergy.this));
                        }
                        if (SegGenSnakeEnergy.access$14(SegGenSnakeEnergy.this).isSelected()) {
                            SegGenSnakeEnergy.access$15(SegGenSnakeEnergy.this).new_distance_data();
                        }
                        ++i;
                    }
                    break block62;
                }
                if (this._monitor) {
                    this.set_progress_max(SegGenSnakeEnergy.access$16(SegGenSnakeEnergy.this) * 3);
                }
                i = 0;
                while (i < SegGenSnakeEnergy.access$16(SegGenSnakeEnergy.this)) {
                    if (this._stop_soon) {
                        return;
                    }
                    eit = new EnergyIntegralTerms();
                    SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).clear();
                    SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).clear();
                    y = 0;
                    while (y < SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this)) {
                        if (this._stop_soon) {
                            return;
                        }
                        x = 0;
                        while (x < SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this)) {
                            if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).is_front2d(x, y)) {
                                SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).add(new Voxel(x, y, 0));
                            }
                            ++x;
                        }
                        ++y;
                    }
                    if (this._monitor) {
                        this.set_progress_val(progress_counter++);
                    }
                    todo = new LinkedList<Voxel>();
                    todo_next = new LinkedList<Voxel>();
                    _gotcha_final = new BitCube(SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this), 1);
                    fi = 0;
                    while (fi < SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).size()) {
                        fv = (Voxel)SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).get(fi);
                        todo.add(fv);
                        SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(fv);
                        _gotcha_final.setXYZ(fv._x, fv._y, 0, true);
                        SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(fv._x, fv._y, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(fv._x, fv._y, z)], vc.get(fv._x, fv._y, z), eit);
                        ++fi;
                    }
                    nb = 0;
                    while (nb < Settings.get_int_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_BAND_SIZE)) {
                        if (!this._stop_soon) ** GOTO lbl210
                        return;
lbl-1000:
                        // 1 sources

                        {
                            next = (Voxel)todo.poll();
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && !_gotcha_final.getXYZ(next._x + 1, next._y, 0)) {
                                todo_next.add(new Voxel(next._x + 1, next._y, 0));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y, z)], vc.get(next._x + 1, next._y, z), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y, 0, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y, 0));
                            }
                            if (next._x > SegGenSnakeEnergy._bb_min[0] && !_gotcha_final.getXYZ(next._x - 1, next._y, 0)) {
                                todo_next.add(new Voxel(next._x - 1, next._y, SegGenSnakeEnergy.access$12(SegGenSnakeEnergy.this)));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y, z)], vc.get(next._x - 1, next._y, z), eit);
                                _gotcha_final.setXYZ(next._x - 1, next._y, 0, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y, 0));
                            }
                            if (next._y < SegGenSnakeEnergy._bb_max[1] && !_gotcha_final.getXYZ(next._x, next._y + 1, 0)) {
                                todo_next.add(new Voxel(next._x, next._y + 1, SegGenSnakeEnergy.access$12(SegGenSnakeEnergy.this)));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x, next._y + 1, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x, next._y + 1, z)], vc.get(next._x, next._y + 1, z), eit);
                                _gotcha_final.setXYZ(next._x, next._y + 1, 0, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x, next._y + 1, 0));
                            }
                            if (next._y > SegGenSnakeEnergy._bb_min[1] && !_gotcha_final.getXYZ(next._x, next._y - 1, 0)) {
                                todo_next.add(new Voxel(next._x, next._y - 1, SegGenSnakeEnergy.access$12(SegGenSnakeEnergy.this)));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x, next._y - 1, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x, next._y - 1, z)], vc.get(next._x, next._y - 1, z), eit);
                                _gotcha_final.setXYZ(next._x, next._y - 1, 0, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x, next._y - 1, 0));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._y < SegGenSnakeEnergy._bb_max[1] && !_gotcha_final.getXYZ(next._x + 1, next._y + 1, 0)) {
                                todo_next.add(new Voxel(next._x + 1, next._y + 1, SegGenSnakeEnergy.access$12(SegGenSnakeEnergy.this)));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y + 1, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y + 1, z)], vc.get(next._x + 1, next._y + 1, z), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y + 1, 0, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y + 1, 0));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._y > SegGenSnakeEnergy._bb_min[1] && !_gotcha_final.getXYZ(next._x + 1, next._y - 1, 0)) {
                                todo_next.add(new Voxel(next._x + 1, next._y - 1, SegGenSnakeEnergy.access$12(SegGenSnakeEnergy.this)));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y - 1, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y - 1, z)], vc.get(next._x + 1, next._y - 1, z), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y - 1, 0, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y - 1, 0));
                            }
                            if (next._x > SegGenSnakeEnergy._bb_min[0] && next._y < SegGenSnakeEnergy._bb_max[1] && !_gotcha_final.getXYZ(next._x - 1, next._y + 1, 0)) {
                                todo_next.add(new Voxel(next._x - 1, next._y + 1, SegGenSnakeEnergy.access$12(SegGenSnakeEnergy.this)));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y + 1, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y + 1, z)], vc.get(next._x - 1, next._y + 1, z), eit);
                                _gotcha_final.setXYZ(next._x - 1, next._y + 1, 0, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y + 1, 0));
                            }
                            if (next._x <= SegGenSnakeEnergy._bb_min[0] || next._y <= SegGenSnakeEnergy._bb_min[1] || _gotcha_final.getXYZ(next._x - 1, next._y - 1, 0)) continue;
                            todo_next.add(new Voxel(next._x - 1, next._y - 1, SegGenSnakeEnergy.access$12(SegGenSnakeEnergy.this)));
                            SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y - 1, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y - 1, z)], vc.get(next._x - 1, next._y - 1, z), eit);
                            _gotcha_final.setXYZ(next._x - 1, next._y - 1, 0, true);
                            SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y - 1, 0));
lbl210:
                            // 3 sources

                            ** while (!todo.isEmpty())
                        }
lbl211:
                        // 1 sources

                        todo = todo_next;
                        todo_next = new LinkedList<E>();
                        ++nb;
                    }
                    eit.normalize();
                    p = Settings.get_int_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_POWER_OF_AREA);
                    nbi = 0;
                    while (nbi < SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).size()) {
                        nbv = (Voxel)SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).get(nbi);
                        if (this._monitor) {
                            this.set_progress_val(progress_counter++);
                        }
                        val = SegGenSnakeEnergy.this._value_mapping[vc.get(nbv._x, nbv._y, z)];
                        curvature = SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).compute_curvature2d(nbv._x, nbv._y);
                        new_speed = vc.get(nbv._x, nbv._y, z) >= SegGenSnakeEnergy.access$19(SegGenSnakeEnergy.this) && vc.get(nbv._x, nbv._y, z) <= SegGenSnakeEnergy.access$20(SegGenSnakeEnergy.this) ? (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_LOGARITHM).booleanValue() ? SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).dirac(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(nbv._x, nbv._y, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this)) * (SegGenSnakeEnergy.access$21(SegGenSnakeEnergy.this) * (double)p * Math.pow(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).size(), p - 1) * curvature + SegGenSnakeEnergy.access$22(SegGenSnakeEnergy.this) + SegGenSnakeEnergy.access$23(SegGenSnakeEnergy.this) * Math.log((val - eit._c1) * (val - eit._c1)) - SegGenSnakeEnergy.access$24(SegGenSnakeEnergy.this) * Math.log((val - eit._c2) * (val - eit._c2))) : SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).dirac(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(nbv._x, nbv._y, 0), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this)) * (SegGenSnakeEnergy.access$21(SegGenSnakeEnergy.this) * (double)p * Math.pow(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).size(), p - 1) * curvature + SegGenSnakeEnergy.access$22(SegGenSnakeEnergy.this) + SegGenSnakeEnergy.access$23(SegGenSnakeEnergy.this) * (val - eit._c1) * (val - eit._c1) - SegGenSnakeEnergy.access$24(SegGenSnakeEnergy.this) * (val - eit._c2) * (val - eit._c2))) : 0.0;
                        SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).set_speed(nbv._x, nbv._y, 0, new_speed);
                        ++nbi;
                    }
                    nbi = 0;
                    while (nbi < SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).size()) {
                        nbv = (Voxel)SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).get(nbi);
                        if (this._monitor) {
                            this.set_progress_val(progress_counter++);
                        }
                        SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).set_dist(nbv._x, nbv._y, 0, SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(nbv._x, nbv._y, 0) + SegGenSnakeEnergy.access$25(SegGenSnakeEnergy.this) * SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_speed(nbv._x, nbv._y, 0));
                        ++nbi;
                    }
                    v1 = SegGenSnakeEnergy.this;
                    SegGenSnakeEnergy.access$10(v1, SegGenSnakeEnergy.access$26(v1) + 1);
                    if (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_AUTO_REINIT).booleanValue() && SegGenSnakeEnergy.access$26(SegGenSnakeEnergy.this) >= Settings.get_int_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_AUTO_REINIT_STEPS)) {
                        SegGenSnakeEnergy.access$10(SegGenSnakeEnergy.this, 0);
                        SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).clear();
                        y = 0;
                        while (y < SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this)) {
                            x = 0;
                            while (x < SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this)) {
                                if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).is_front2d(x, y)) {
                                    SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).add(new Voxel(x, y, SegGenSnakeEnergy.access$12(SegGenSnakeEnergy.this)));
                                }
                                ++x;
                            }
                            ++y;
                        }
                        SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).reinitialize_distances2d(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$13(SegGenSnakeEnergy.this));
                    }
                    ++i;
                }
            }
            if (SegGenSnakeEnergy.access$14(SegGenSnakeEnergy.this).isSelected()) {
                SegGenSnakeEnergy.access$15(SegGenSnakeEnergy.this).new_distance_data();
            }
            bc.clear();
            y = SegGenSnakeEnergy._bb_min[1];
            while (y <= SegGenSnakeEnergy._bb_max[1]) {
                x = SegGenSnakeEnergy._bb_min[0];
                while (x <= SegGenSnakeEnergy._bb_max[0]) {
                    if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(x, y, 0) <= 0.0) {
                        bc.setXYZ(x, y, z, true);
                    }
                    ++x;
                }
                ++y;
            }
            if (this._monitor) {
                this.set_progress_val(this.get_progress_max());
            }
            sw.stop();
            System.out.println("create_energy_snake_seg_2d time=" + sw.toString());
            SegGenSnakeEnergy._seg.set_bc(bc);
        }
    }

    private final class CreateEnergySnake3dThread
    extends SegmentingThread {
        public CreateEnergySnake3dThread(SettingsOwner parent, boolean monitor) {
            super(parent, monitor);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void my_run() {
            block90: {
                block89: {
                    sw1 = new StopWatch(true);
                    SegGenSnakeEnergy.this.init_value_mapping(Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_VISUAL_GRAD));
                    sw2 = new StopWatch();
                    System.out.println("create_energy_snake_seg_3d: " + MasterControl.get_is().get_seeds());
                    bc = SegGenSnakeEnergy._seg.get_bc();
                    is = MasterControl.get_is();
                    if (this._monitor) {
                        this.set_progress_min(0);
                        this.set_progress_val(0);
                    }
                    if (!SegGenSnakeEnergy.access$0(SegGenSnakeEnergy.this)) {
                        if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this) == null) {
                            if (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_SEG).booleanValue()) {
                                SegGenSnakeEnergy.access$9(SegGenSnakeEnergy.this, new DistanceFunction(bc, MasterControl.get_v2d().get_model().get_active_image(0), SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$5(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$6(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$7(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$8(SegGenSnakeEnergy.this), SegGenSnakeEnergy._bb_min, SegGenSnakeEnergy._bb_max, true));
                            } else {
                                SegGenSnakeEnergy.access$9(SegGenSnakeEnergy.this, new DistanceFunction(MasterControl.get_is().get_seeds(), SegGenSnakeEnergy.access$2(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$5(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$6(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$7(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$8(SegGenSnakeEnergy.this), SegGenSnakeEnergy._bb_min, SegGenSnakeEnergy._bb_max, true));
                            }
                        } else if (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_SEG).booleanValue()) {
                            SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).reinitialize_distance_function(bc, MasterControl.get_v2d().get_model().get_active_image(0), SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$5(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$6(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$7(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$8(SegGenSnakeEnergy.this), SegGenSnakeEnergy._bb_min, SegGenSnakeEnergy._bb_max, true);
                        } else {
                            SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).reinitialize_distance_function(MasterControl.get_is().get_seeds(), SegGenSnakeEnergy.access$2(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$5(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$6(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$7(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$8(SegGenSnakeEnergy.this), SegGenSnakeEnergy._bb_min, SegGenSnakeEnergy._bb_max, true);
                        }
                        SegGenSnakeEnergy.access$10(SegGenSnakeEnergy.this, 0);
                    }
                    SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).clear();
                    z = SegGenSnakeEnergy._bb_min[2];
                    while (z <= SegGenSnakeEnergy._bb_max[2]) {
                        y = SegGenSnakeEnergy._bb_min[1];
                        while (y <= SegGenSnakeEnergy._bb_max[1]) {
                            x = SegGenSnakeEnergy._bb_min[0];
                            while (x <= SegGenSnakeEnergy._bb_max[0]) {
                                if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).is_front3d(x, y, z)) {
                                    SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).add(new Voxel(x, y, z));
                                }
                                ++x;
                            }
                            ++y;
                        }
                        ++z;
                    }
                    if (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_SEG).booleanValue()) {
                        SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).reinitialize_distances3d(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$13(SegGenSnakeEnergy.this));
                    }
                    vc = is.get_voxel_cube();
                    if (SegGenSnakeEnergy.access$14(SegGenSnakeEnergy.this).isSelected()) {
                        SegGenSnakeEnergy.access$15(SegGenSnakeEnergy.this).new_distance_data();
                    }
                    if (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_NARROW_BAND).booleanValue()) break block89;
                    box__dim_z = SegGenSnakeEnergy._bb_max[2] - SegGenSnakeEnergy._bb_min[2];
                    progress_counter = 0;
                    this.set_progress_max(SegGenSnakeEnergy.access$16(SegGenSnakeEnergy.this) * (box__dim_z + box__dim_z + box__dim_z) + 1);
                    i = 0;
                    while (i < SegGenSnakeEnergy.access$16(SegGenSnakeEnergy.this)) {
                        eit = new EnergyIntegralTerms();
                        sw2.start();
                        z = SegGenSnakeEnergy._bb_min[2];
                        while (z <= SegGenSnakeEnergy._bb_max[2]) {
                            if (this._stop_soon) {
                                return;
                            }
                            if (this._monitor) {
                                this.set_progress_val(progress_counter++);
                            }
                            y = SegGenSnakeEnergy._bb_min[1];
                            while (y <= SegGenSnakeEnergy._bb_max[1]) {
                                x = SegGenSnakeEnergy._bb_min[0];
                                while (x <= SegGenSnakeEnergy._bb_max[0]) {
                                    SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(x, y, z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(x, y, z)], vc.get(x, y, z), eit);
                                    ++x;
                                }
                                ++y;
                            }
                            ++z;
                        }
                        eit.normalize();
                        sw2.stop();
                        System.out.println("computation of c1 and c2\t\t= " + sw2.toString());
                        sw2.reset();
                        sw2.start();
                        p = Settings.get_int_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_POWER_OF_AREA);
                        z = SegGenSnakeEnergy._bb_min[2];
                        while (z <= SegGenSnakeEnergy._bb_max[2]) {
                            if (this._stop_soon) {
                                return;
                            }
                            if (this._monitor) {
                                this.set_progress_val(progress_counter++);
                            }
                            y = SegGenSnakeEnergy._bb_min[1];
                            while (y <= SegGenSnakeEnergy._bb_max[1]) {
                                x = SegGenSnakeEnergy._bb_min[0];
                                while (x <= SegGenSnakeEnergy._bb_max[0]) {
                                    val = SegGenSnakeEnergy.this._value_mapping[vc.get(x, y, z)];
                                    curvature = SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).compute_curvature3d(x, y, z);
                                    new_speed = vc.get(x, y, z) >= SegGenSnakeEnergy.access$19(SegGenSnakeEnergy.this) && vc.get(x, y, z) <= SegGenSnakeEnergy.access$20(SegGenSnakeEnergy.this) ? (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_LOGARITHM).booleanValue() ? SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).dirac(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(x, y, z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this)) * (SegGenSnakeEnergy.access$21(SegGenSnakeEnergy.this) * (double)p * Math.pow(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).size(), p - 1) * curvature + SegGenSnakeEnergy.access$22(SegGenSnakeEnergy.this) + SegGenSnakeEnergy.access$23(SegGenSnakeEnergy.this) * Math.log((val - eit._c1) * (val - eit._c1)) - SegGenSnakeEnergy.access$24(SegGenSnakeEnergy.this) * Math.log((val - eit._c2) * (val - eit._c2))) : SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).dirac(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(x, y, z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this)) * (SegGenSnakeEnergy.access$21(SegGenSnakeEnergy.this) * (double)p * Math.pow(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).size(), p - 1) * curvature + SegGenSnakeEnergy.access$22(SegGenSnakeEnergy.this) + SegGenSnakeEnergy.access$23(SegGenSnakeEnergy.this) * (val - eit._c1) * (val - eit._c1) - SegGenSnakeEnergy.access$24(SegGenSnakeEnergy.this) * (val - eit._c2) * (val - eit._c2))) : 0.0;
                                    SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).set_speed(x, y, z, new_speed);
                                    ++x;
                                }
                                ++y;
                            }
                            ++z;
                        }
                        sw2.stop();
                        System.out.println("Compute Energy\t\t\t\t= " + sw2.toString());
                        sw2.reset();
                        sw2.start();
                        z = SegGenSnakeEnergy._bb_min[2];
                        while (z <= SegGenSnakeEnergy._bb_max[2]) {
                            if (this._stop_soon) {
                                return;
                            }
                            if (this._monitor) {
                                this.set_progress_val(progress_counter++);
                            }
                            y = SegGenSnakeEnergy._bb_min[1];
                            while (y <= SegGenSnakeEnergy._bb_max[1]) {
                                x = SegGenSnakeEnergy._bb_min[0];
                                while (x <= SegGenSnakeEnergy._bb_max[0]) {
                                    SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).set_dist(x, y, z, SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(x, y, z) + SegGenSnakeEnergy.access$25(SegGenSnakeEnergy.this) * SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_speed(x, y, z));
                                    ++x;
                                }
                                ++y;
                            }
                            ++z;
                        }
                        sw2.stop();
                        System.out.println("Extend Energy\t\t\t\t= " + sw2.toString());
                        sw2.reset();
                        v0 = SegGenSnakeEnergy.this;
                        SegGenSnakeEnergy.access$10(v0, SegGenSnakeEnergy.access$26(v0) + 1);
                        if (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_AUTO_REINIT).booleanValue() && SegGenSnakeEnergy.access$26(SegGenSnakeEnergy.this) >= Settings.get_int_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_AUTO_REINIT_STEPS)) {
                            SegGenSnakeEnergy.access$10(SegGenSnakeEnergy.this, 0);
                            SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).clear();
                            z = SegGenSnakeEnergy._bb_min[2];
                            while (z <= SegGenSnakeEnergy._bb_max[2]) {
                                y = SegGenSnakeEnergy._bb_min[1];
                                while (y <= SegGenSnakeEnergy._bb_max[1]) {
                                    x = SegGenSnakeEnergy._bb_min[0];
                                    while (x <= SegGenSnakeEnergy._bb_max[0]) {
                                        if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).is_front3d(x, y, z)) {
                                            SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).add(new Voxel(x, y, z));
                                        }
                                        ++x;
                                    }
                                    ++y;
                                }
                                ++z;
                            }
                            SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).reinitialize_distances3d(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$13(SegGenSnakeEnergy.this));
                        }
                        if (SegGenSnakeEnergy.access$14(SegGenSnakeEnergy.this).isSelected()) {
                            SegGenSnakeEnergy.access$15(SegGenSnakeEnergy.this).new_distance_data();
                        }
                        ++i;
                    }
                    break block90;
                }
                progress_counter = 0;
                if (this._monitor) {
                    this.set_progress_max(SegGenSnakeEnergy.access$16(SegGenSnakeEnergy.this) * 3);
                }
                i = 0;
                while (i < SegGenSnakeEnergy.access$16(SegGenSnakeEnergy.this)) {
                    if (this._stop_soon) {
                        return;
                    }
                    eit = new EnergyIntegralTerms();
                    SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).clear();
                    SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).clear();
                    z = SegGenSnakeEnergy._bb_min[2];
                    while (z <= SegGenSnakeEnergy._bb_max[2]) {
                        if (this._stop_soon) {
                            return;
                        }
                        y = SegGenSnakeEnergy._bb_min[1];
                        while (y <= SegGenSnakeEnergy._bb_max[1]) {
                            x = SegGenSnakeEnergy._bb_min[0];
                            while (x <= SegGenSnakeEnergy._bb_max[0]) {
                                if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).is_front3d(x, y, z)) {
                                    SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).add(new Voxel(x, y, z));
                                }
                                ++x;
                            }
                            ++y;
                        }
                        ++z;
                    }
                    if (this._monitor) {
                        this.set_progress_val(progress_counter++);
                    }
                    todo = new LinkedList<Voxel>();
                    todo_next = new LinkedList<Voxel>();
                    _gotcha_final = new BitCube(SegGenSnakeEnergy.access$3(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$4(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$5(SegGenSnakeEnergy.this));
                    j = 0;
                    while (j < SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).size()) {
                        fv = (Voxel)SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).get(j);
                        todo.add(fv);
                        SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(fv._x, fv._y, fv._z));
                        _gotcha_final.setXYZ(fv._x, fv._y, fv._z, true);
                        SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(fv._x, fv._y, fv._z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(fv._x, fv._y, fv._z)], vc.get(fv._x, fv._y, fv._z), eit);
                        ++j;
                    }
                    nb = 0;
                    while (nb < Settings.get_int_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_BAND_SIZE)) {
                        if (!this._stop_soon) ** GOTO lbl375
                        return;
lbl-1000:
                        // 1 sources

                        {
                            next = (Voxel)todo.poll();
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && !_gotcha_final.getXYZ(next._x + 1, next._y, next._z)) {
                                todo_next.add(new Voxel(next._x + 1, next._y, next._z));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y, next._z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y, next._z)], vc.get(next._x + 1, next._y, next._z), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y, next._z, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y, next._z));
                            }
                            if (next._x > SegGenSnakeEnergy._bb_min[0] && !_gotcha_final.getXYZ(next._x - 1, next._y, next._z)) {
                                todo_next.add(new Voxel(next._x - 1, next._y, next._z));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y, next._z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y, next._z)], vc.get(next._x - 1, next._y, next._z), eit);
                                _gotcha_final.setXYZ(next._x - 1, next._y, next._z, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y, next._z));
                            }
                            if (next._y < SegGenSnakeEnergy._bb_max[1] && !_gotcha_final.getXYZ(next._x, next._y + 1, next._z)) {
                                todo_next.add(new Voxel(next._x, next._y + 1, next._z));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x, next._y + 1, next._z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x, next._y + 1, next._z)], vc.get(next._x, next._y + 1, next._z), eit);
                                _gotcha_final.setXYZ(next._x, next._y + 1, next._z, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x, next._y + 1, next._z));
                            }
                            if (next._y > SegGenSnakeEnergy._bb_min[1] && !_gotcha_final.getXYZ(next._x, next._y - 1, next._z)) {
                                todo_next.add(new Voxel(next._x, next._y - 1, next._z));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x, next._y - 1, next._z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x, next._y - 1, next._z)], vc.get(next._x, next._y - 1, next._z), eit);
                                _gotcha_final.setXYZ(next._x, next._y - 1, next._z, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x, next._y - 1, next._z));
                            }
                            if (next._z < SegGenSnakeEnergy._bb_max[2] && !_gotcha_final.getXYZ(next._x, next._y, next._z + 1)) {
                                todo_next.add(new Voxel(next._x, next._y, next._z + 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x, next._y, next._z + 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x, next._y, next._z + 1)], vc.get(next._x, next._y, next._z + 1), eit);
                                _gotcha_final.setXYZ(next._x, next._y, next._z + 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x, next._y, next._z + 1));
                            }
                            if (next._z > SegGenSnakeEnergy._bb_min[2] && !_gotcha_final.getXYZ(next._x, next._y, next._z - 1)) {
                                todo_next.add(new Voxel(next._x, next._y, next._z - 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x, next._y, next._z - 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x, next._y, next._z - 1)], vc.get(next._x, next._y, next._z - 1), eit);
                                _gotcha_final.setXYZ(next._x, next._y - 1, next._z, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x, next._y, next._z + 1));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._y < SegGenSnakeEnergy._bb_max[1] && !_gotcha_final.getXYZ(next._x + 1, next._y + 1, next._z)) {
                                todo_next.add(new Voxel(next._x + 1, next._y + 1, next._z));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y + 1, next._z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y + 1, next._z)], vc.get(next._x + 1, next._y + 1, next._z), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y + 1, next._z, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y + 1, next._z));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._y > SegGenSnakeEnergy._bb_min[1] && !_gotcha_final.getXYZ(next._x + 1, next._y - 1, next._z)) {
                                todo_next.add(new Voxel(next._x + 1, next._y - 1, next._z));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y - 1, next._z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y - 1, next._z)], vc.get(next._x + 1, next._y - 1, next._z), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y - 1, next._z, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y - 1, next._z));
                            }
                            if (next._x > SegGenSnakeEnergy._bb_min[0] && next._y > SegGenSnakeEnergy._bb_min[1] && !_gotcha_final.getXYZ(next._x - 1, next._y - 1, next._z)) {
                                todo_next.add(new Voxel(next._x - 1, next._y - 1, next._z));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y - 1, next._z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y - 1, next._z)], vc.get(next._x - 1, next._y - 1, next._z), eit);
                                _gotcha_final.setXYZ(next._x - 1, next._y - 1, next._z, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y - 1, next._z));
                            }
                            if (next._x > SegGenSnakeEnergy._bb_min[0] && next._y < SegGenSnakeEnergy._bb_max[1] && !_gotcha_final.getXYZ(next._x - 1, next._y + 1, next._z)) {
                                todo_next.add(new Voxel(next._x - 1, next._y + 1, next._z));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y + 1, next._z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y + 1, next._z)], vc.get(next._x - 1, next._y + 1, next._z), eit);
                                _gotcha_final.setXYZ(next._x - 1, next._y + 1, next._z, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y + 1, next._z));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._z < SegGenSnakeEnergy._bb_max[2] && !_gotcha_final.getXYZ(next._x + 1, next._y, next._z + 1)) {
                                todo_next.add(new Voxel(next._x + 1, next._y, next._z + 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y, next._z + 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y, next._z + 1)], vc.get(next._x + 1, next._y, next._z + 1), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y, next._z + 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y, next._z + 1));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._z > SegGenSnakeEnergy._bb_min[2] && !_gotcha_final.getXYZ(next._x + 1, next._y, next._z - 1)) {
                                todo_next.add(new Voxel(next._x + 1, next._y, next._z - 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y, next._z - 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y, next._z - 1)], vc.get(next._x + 1, next._y, next._z - 1), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y, next._z - 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y, next._z - 1));
                            }
                            if (next._x > SegGenSnakeEnergy._bb_min[0] && next._z > SegGenSnakeEnergy._bb_min[2] && !_gotcha_final.getXYZ(next._x - 1, next._y, next._z - 1)) {
                                todo_next.add(new Voxel(next._x - 1, next._y, next._z - 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y, next._z - 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y, next._z - 1)], vc.get(next._x - 1, next._y, next._z - 1), eit);
                                _gotcha_final.setXYZ(next._x - 1, next._y, next._z - 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y, next._z - 1));
                            }
                            if (next._x > SegGenSnakeEnergy._bb_min[0] && next._z < SegGenSnakeEnergy._bb_max[2] && !_gotcha_final.getXYZ(next._x - 1, next._y, next._z + 1)) {
                                todo_next.add(new Voxel(next._x - 1, next._y, next._z + 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y, next._z + 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y, next._z + 1)], vc.get(next._x - 1, next._y, next._z + 1), eit);
                                _gotcha_final.setXYZ(next._x - 1, next._y, next._z + 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y, next._z + 1));
                            }
                            if (next._y < SegGenSnakeEnergy._bb_max[1] && next._z < SegGenSnakeEnergy._bb_max[2] && !_gotcha_final.getXYZ(next._x, next._y + 1, next._z + 1)) {
                                todo_next.add(new Voxel(next._x, next._y + 1, next._z + 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x, next._y + 1, next._z + 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x, next._y + 1, next._z + 1)], vc.get(next._x, next._y + 1, next._z + 1), eit);
                                _gotcha_final.setXYZ(next._x, next._y + 1, next._z + 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x, next._y + 1, next._z + 1));
                            }
                            if (next._y < SegGenSnakeEnergy._bb_max[1] && next._z > SegGenSnakeEnergy._bb_min[2] && !_gotcha_final.getXYZ(next._x, next._y + 1, next._z - 1)) {
                                todo_next.add(new Voxel(next._x, next._y + 1, next._z - 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x, next._y + 1, next._z - 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x, next._y + 1, next._z - 1)], vc.get(next._x, next._y + 1, next._z - 1), eit);
                                _gotcha_final.setXYZ(next._x, next._y + 1, next._z - 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x, next._y + 1, next._z - 1));
                            }
                            if (next._x > SegGenSnakeEnergy._bb_min[0] && next._z > SegGenSnakeEnergy._bb_min[2] && !_gotcha_final.getXYZ(next._x, next._y - 1, next._z - 1)) {
                                todo_next.add(new Voxel(next._x, next._y - 1, next._z - 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x, next._y - 1, next._z - 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x, next._y - 1, next._z - 1)], vc.get(next._x, next._y - 1, next._z - 1), eit);
                                _gotcha_final.setXYZ(next._x, next._y - 1, next._z - 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x, next._y - 1, next._z - 1));
                            }
                            if (next._x > SegGenSnakeEnergy._bb_min[0] && next._z < SegGenSnakeEnergy._bb_max[2] && !_gotcha_final.getXYZ(next._x, next._y - 1, next._z + 1)) {
                                todo_next.add(new Voxel(next._x, next._y - 1, next._z + 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x, next._y - 1, next._z + 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x, next._y - 1, next._z + 1)], vc.get(next._x, next._y - 1, next._z + 1), eit);
                                _gotcha_final.setXYZ(next._x, next._y - 1, next._z + 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x, next._y - 1, next._z + 1));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._y < SegGenSnakeEnergy._bb_max[1] && next._z < SegGenSnakeEnergy._bb_max[2] && !_gotcha_final.getXYZ(next._x + 1, next._y + 1, next._z + 1)) {
                                todo_next.add(new Voxel(next._x + 1, next._y + 1, next._z + 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y + 1, next._z + 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y + 1, next._z + 1)], vc.get(next._x + 1, next._y + 1, next._z + 1), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y + 1, next._z + 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y + 1, next._z + 1));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._y < SegGenSnakeEnergy._bb_max[1] && next._z > SegGenSnakeEnergy._bb_min[2] && !_gotcha_final.getXYZ(next._x + 1, next._y + 1, next._z - 1)) {
                                todo_next.add(new Voxel(next._x + 1, next._y + 1, next._z - 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y + 1, next._z - 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y + 1, next._z - 1)], vc.get(next._x + 1, next._y + 1, next._z - 1), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y + 1, next._z - 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y + 1, next._z - 1));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._y > SegGenSnakeEnergy._bb_min[1] && next._z < SegGenSnakeEnergy._bb_max[2] && !_gotcha_final.getXYZ(next._x + 1, next._y - 1, next._z + 1)) {
                                todo_next.add(new Voxel(next._x + 1, next._y - 1, next._z + 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y - 1, next._z + 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y - 1, next._z + 1)], vc.get(next._x + 1, next._y - 1, next._z + 1), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y - 1, next._z + 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y - 1, next._z + 1));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._y > SegGenSnakeEnergy._bb_min[1] && next._z > SegGenSnakeEnergy._bb_min[2] && !_gotcha_final.getXYZ(next._x + 1, next._y - 1, next._z - 1)) {
                                todo_next.add(new Voxel(next._x + 1, next._y - 1, next._z - 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x + 1, next._y - 1, next._z - 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x + 1, next._y - 1, next._z - 1)], vc.get(next._x + 1, next._y - 1, next._z - 1), eit);
                                _gotcha_final.setXYZ(next._x + 1, next._y - 1, next._z - 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x + 1, next._y - 1, next._z - 1));
                            }
                            if (next._x > SegGenSnakeEnergy._bb_min[0] && next._y < SegGenSnakeEnergy._bb_max[1] && next._z < SegGenSnakeEnergy._bb_max[2] && !_gotcha_final.getXYZ(next._x - 1, next._y + 1, next._z + 1)) {
                                todo_next.add(new Voxel(next._x - 1, next._y + 1, next._z + 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y + 1, next._z + 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y + 1, next._z + 1)], vc.get(next._x - 1, next._y + 1, next._z + 1), eit);
                                _gotcha_final.setXYZ(next._x - 1, next._y + 1, next._z + 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y + 1, next._z + 1));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._y < SegGenSnakeEnergy._bb_max[1] && next._z > SegGenSnakeEnergy._bb_min[2] && !_gotcha_final.getXYZ(next._x - 1, next._y + 1, next._z - 1)) {
                                todo_next.add(new Voxel(next._x - 1, next._y + 1, next._z - 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y + 1, next._z - 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y + 1, next._z - 1)], vc.get(next._x - 1, next._y + 1, next._z - 1), eit);
                                _gotcha_final.setXYZ(next._x - 1, next._y + 1, next._z - 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y + 1, next._z - 1));
                            }
                            if (next._x < SegGenSnakeEnergy._bb_max[0] && next._y > SegGenSnakeEnergy._bb_min[1] && next._z < SegGenSnakeEnergy._bb_max[2] && !_gotcha_final.getXYZ(next._x - 1, next._y - 1, next._z + 1)) {
                                todo_next.add(new Voxel(next._x - 1, next._y - 1, next._z + 1));
                                SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y - 1, next._z + 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y - 1, next._z + 1)], vc.get(next._x - 1, next._y - 1, next._z + 1), eit);
                                _gotcha_final.setXYZ(next._x - 1, next._y - 1, next._z + 1, true);
                                SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y - 1, next._z + 1));
                            }
                            if (next._x >= SegGenSnakeEnergy._bb_max[0] || next._y <= SegGenSnakeEnergy._bb_min[1] || next._z <= SegGenSnakeEnergy._bb_min[2] || _gotcha_final.getXYZ(next._x - 1, next._y - 1, next._z - 1)) continue;
                            todo_next.add(new Voxel(next._x - 1, next._y - 1, next._z - 1));
                            SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).energy_integral_step(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(next._x - 1, next._y - 1, next._z - 1), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this), SegGenSnakeEnergy.this._value_mapping[vc.get(next._x - 1, next._y - 1, next._z - 1)], vc.get(next._x - 1, next._y - 1, next._z - 1), eit);
                            _gotcha_final.setXYZ(next._x - 1, next._y - 1, next._z - 1, true);
                            SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).add(new Voxel(next._x - 1, next._y - 1, next._z - 1));
lbl375:
                            // 3 sources

                            ** while (!todo.isEmpty())
                        }
lbl376:
                        // 2 sources

                        while (!todo_next.isEmpty()) {
                            todo.add((Voxel)todo_next.poll());
                        }
                        ++nb;
                    }
                    eit.normalize();
                    p = Settings.get_int_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_POWER_OF_AREA);
                    nbi = 0;
                    while (nbi < SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).size()) {
                        nbv = (Voxel)SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).get(nbi);
                        if (this._monitor) {
                            this.set_progress_val(progress_counter++);
                        }
                        val = SegGenSnakeEnergy.this._value_mapping[vc.get(nbv._x, nbv._y, nbv._z)];
                        curvature = SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).compute_curvature3d(nbv._x, nbv._y, nbv._z);
                        new_speed = vc.get(nbv._x, nbv._y, nbv._z) >= SegGenSnakeEnergy.access$19(SegGenSnakeEnergy.this) && vc.get(nbv._x, nbv._y, nbv._z) <= SegGenSnakeEnergy.access$20(SegGenSnakeEnergy.this) ? (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_LOGARITHM).booleanValue() ? SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).dirac(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(nbv._x, nbv._y, nbv._z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this)) * (SegGenSnakeEnergy.access$21(SegGenSnakeEnergy.this) * (double)p * Math.pow(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).size(), p - 1) * curvature + SegGenSnakeEnergy.access$22(SegGenSnakeEnergy.this) + SegGenSnakeEnergy.access$23(SegGenSnakeEnergy.this) * Math.log((val - eit._c1) * (val - eit._c1)) - SegGenSnakeEnergy.access$24(SegGenSnakeEnergy.this) * Math.log((val - eit._c2) * (val - eit._c2))) : SegGenSnakeEnergy.access$17(SegGenSnakeEnergy.this).dirac(SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(nbv._x, nbv._y, nbv._z), SegGenSnakeEnergy.access$18(SegGenSnakeEnergy.this)) * (SegGenSnakeEnergy.access$21(SegGenSnakeEnergy.this) * (double)p * Math.pow(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).size(), p - 1) * curvature + SegGenSnakeEnergy.access$22(SegGenSnakeEnergy.this) + SegGenSnakeEnergy.access$23(SegGenSnakeEnergy.this) * (val - eit._c1) * (val - eit._c1) - SegGenSnakeEnergy.access$24(SegGenSnakeEnergy.this) * (val - eit._c2) * (val - eit._c2))) : 0.0;
                        SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).set_speed(nbv._x, nbv._y, nbv._z, new_speed);
                        ++nbi;
                    }
                    nbi = 0;
                    while (nbi < SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).size()) {
                        nbv = (Voxel)SegGenSnakeEnergy.access$27(SegGenSnakeEnergy.this).get(nbi);
                        if (this._monitor) {
                            this.set_progress_val(progress_counter++);
                        }
                        SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).set_dist(nbv._x, nbv._y, nbv._z, SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(nbv._x, nbv._y, nbv._z) + SegGenSnakeEnergy.access$25(SegGenSnakeEnergy.this) * SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_speed(nbv._x, nbv._y, nbv._z));
                        ++nbi;
                    }
                    v1 = SegGenSnakeEnergy.this;
                    SegGenSnakeEnergy.access$10(v1, SegGenSnakeEnergy.access$26(v1) + 1);
                    if (Settings.get_bool_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_USE_AUTO_REINIT).booleanValue() && SegGenSnakeEnergy.access$26(SegGenSnakeEnergy.this) >= Settings.get_int_option(SegGenSnakeEnergy.class, SegGenSnakeEnergy.OPT_AUTO_REINIT_STEPS)) {
                        SegGenSnakeEnergy.access$10(SegGenSnakeEnergy.this, 0);
                        SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).clear();
                        z = SegGenSnakeEnergy._bb_min[2];
                        while (z <= SegGenSnakeEnergy._bb_max[2]) {
                            y = SegGenSnakeEnergy._bb_min[1];
                            while (y <= SegGenSnakeEnergy._bb_max[1]) {
                                x = SegGenSnakeEnergy._bb_min[0];
                                while (x <= SegGenSnakeEnergy._bb_max[0]) {
                                    if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).is_front3d(x, y, z)) {
                                        SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this).add(new Voxel(x, y, z));
                                    }
                                    ++x;
                                }
                                ++y;
                            }
                            ++z;
                        }
                        SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).reinitialize_distances3d(SegGenSnakeEnergy.access$11(SegGenSnakeEnergy.this), SegGenSnakeEnergy.access$13(SegGenSnakeEnergy.this));
                    }
                    ++i;
                }
            }
            if (SegGenSnakeEnergy.access$14(SegGenSnakeEnergy.this).isSelected()) {
                SegGenSnakeEnergy.access$15(SegGenSnakeEnergy.this).new_distance_data();
            }
            sw2.reset();
            sw2.start();
            bc.clear();
            z = SegGenSnakeEnergy._bb_min[2];
            while (z <= SegGenSnakeEnergy._bb_max[2]) {
                y = SegGenSnakeEnergy._bb_min[1];
                while (y <= SegGenSnakeEnergy._bb_max[1]) {
                    x = SegGenSnakeEnergy._bb_min[0];
                    while (x <= SegGenSnakeEnergy._bb_max[0]) {
                        if (SegGenSnakeEnergy.access$1(SegGenSnakeEnergy.this).get_dist(x, y, z) <= 0.0) {
                            bc.setXYZ(x, y, z, true);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            if (this._monitor) {
                this.set_progress_val(this.get_progress_max());
            }
            sw2.stop();
            System.out.println("Final Segmentation\t\t\t= " + sw2.toString());
            sw2.reset();
            sw1.stop();
            System.out.println("create_energy_snake_seg_3d total time=" + sw1.toString());
            SegGenSnakeEnergy._seg.set_bc(bc);
        }
    }
}

