/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.atlas;

import java.io.File;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import loader.DICOMLoader;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import misc.grid.BitCube;
import misc.grid.RegularGrid3i;
import misc.messages.YObservable;
import misc.messages.YObserver;
import misc.transform.AffineTransformation;
import misc.transform.Transformation;

public final class Atlas
extends YObservable
implements YObserver {
    public static final int M_ATLAS_LOADED = Message.register_message("Atlas Loaded");
    public static final int M_ATLAS_TRANSFORMATION_SET = Message.register_message("Atlas trans changed");
    private RegularGrid3i _vc;
    private ImageStack _atlas_is = null;
    private Transformation _transformation = new AffineTransformation();
    private static Atlas _instance = null;
    private int _voxel_value_range = 0;
    private String _candidate;

    private Atlas() {
    }

    public static Atlas get_instance() {
        if (_instance == null) {
            _instance = new Atlas();
        }
        return _instance;
    }

    public void init_from_dir(String candidate) {
        this._candidate = new String(candidate);
        this._atlas_is = new ImageStack();
        this._atlas_is.addObserver(this, "Atlas::init_from_dir");
        DICOMLoader ddl = new DICOMLoader(this._atlas_is, new File(candidate));
        this._atlas_is.load(ddl);
    }

    public String get_dir() {
        return this._candidate;
    }

    public RegularGrid3i get_voxel_cube() {
        return this._vc;
    }

    public void set_trans(Transformation transformation) {
        this._transformation = transformation;
        this.setChanged();
        this.notifyObservers(new Message(M_ATLAS_TRANSFORMATION_SET, null));
    }

    public Transformation get_trans() {
        return this._transformation;
    }

    public void reset_trans() {
        AffineTransformation t = new AffineTransformation();
        this.set_trans(t);
    }

    public void transform_segment(Segment segment) {
        BitCube seg_cube = segment.get_bc();
        BitCube final_cube = new BitCube(MasterControl.get_is().get_dim_x(), MasterControl.get_is().get_dim_y(), MasterControl.get_is().get_dim_z());
        int z = 0;
        while (z < seg_cube.get_dim_z()) {
            int y = 0;
            while (y < seg_cube.get_dim_y()) {
                int x = 0;
                while (x < seg_cube.get_dim_y()) {
                    Point3f result = this._transformation.transform(x, y, z);
                    int x_result = (int)((double)result.x + 0.5);
                    int y_result = (int)((double)result.y + 0.5);
                    int z_result = (int)((double)result.z + 0.5);
                    if (x_result >= 0 && x_result < final_cube.get_dim_x() && y_result >= 0 && y_result < final_cube.get_dim_y() && z_result >= 0 && z_result < final_cube.get_dim_z()) {
                        final_cube.setXYZ(x_result, y_result, z_result, seg_cube.getXYZ(x, y, z));
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        segment.set_bc(final_cube);
    }

    public int get_voxel_value_range() {
        return this._voxel_value_range;
    }

    @Override
    public void update(YObservable o, Message m) {
        if (m._type == ImageStack.M_LOADING_END) {
            if (m._obj != null) {
                this._vc = this._atlas_is.get_voxel_cube();
                this._voxel_value_range = this._atlas_is.get_voxel_value_range();
                double y_scale = this._atlas_is.get_y_spacing() / MasterControl.get_is().get_y_spacing();
                double x_scale = this._atlas_is.get_x_spacing() / MasterControl.get_is().get_x_spacing();
                double z_scale = this._atlas_is.get_z_spacing() / MasterControl.get_is().get_z_spacing();
                Transform3D t = new Transform3D();
                t.setScale(new Vector3d(x_scale, y_scale, z_scale));
                this.set_trans(new AffineTransformation(t));
                o.deleteObserver(this);
                this._atlas_is = null;
            }
            this.setChanged();
            this.notifyObservers(new Message(M_ATLAS_LOADED, null));
        }
    }
}

