/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.atlas;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import main.MasterControl;
import main.Message;
import main.YaDiV;
import main.seggen.atlas.Atlas;
import main.seggen.atlas.similarity.EntropieComputer;
import misc.messages.YObservable;

public final class VoxelCubeJointHistogram
extends YObservable {
    public static int M_VCJH_UPDATE = Message.register_message("VoxelCubeJointHistogram Update");
    private static VoxelCubeJointHistogram _instance = new VoxelCubeJointHistogram();
    public static final int AXE_SIZE = 5;
    public static final int AXE_DIFF = 2;
    private int _max_value = 0;
    private EntropieComputer _joint_entropy = new EntropieComputer();

    private VoxelCubeJointHistogram() {
    }

    public void build_histogram(EntropieComputer joint_entropy, String similarity) {
        this._joint_entropy = joint_entropy;
        this.setChanged();
        this.notifyObservers(new Message(M_VCJH_UPDATE));
    }

    public Hashtable<Integer, Integer> getData() {
        return this._joint_entropy.get_data();
    }

    public int getMaxValue() {
        return this._max_value;
    }

    public final void render_image(BufferedImage img, Color backgroundColor) {
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        int width = img.getWidth();
        int height = img.getHeight();
        this._max_value = 0;
        for (int hash : this._joint_entropy.get_data().keySet()) {
            int tmp = this._joint_entropy.get_data().get(hash);
            if (tmp <= this._max_value) continue;
            this._max_value = tmp;
        }
        int secondMax = 0;
        for (int hash : this._joint_entropy.get_data().keySet()) {
            int tmp = this._joint_entropy.get_data().get(hash);
            if (tmp <= secondMax || tmp == this._max_value) continue;
            secondMax = tmp;
        }
        g2d.setBackground(backgroundColor);
        g2d.clearRect(0, 0, width, height);
        g2d.setColor(Color.BLACK);
        g2d.fill(new Rectangle2D.Double(7.0, 7.0, width - 7, height - 7));
        int voxelValueRange_image = MasterControl.get_is().get_voxel_value_range();
        int voxelValueRange_atlas = Atlas.get_instance().get_voxel_value_range();
        float scale = (float)(1.0 / Math.log(secondMax));
        int[] p = new int[2];
        for (Integer hash : this._joint_entropy.get_data().keySet()) {
            EntropieComputer.invert_hash(hash, p);
            p[0] = (int)(1.0 * (double)p[0] / (double)voxelValueRange_atlas * (double)(width - 7) + 5.0 + 2.0);
            p[1] = (int)(1.0 * (double)p[1] / (double)voxelValueRange_image * (double)(width - 7) + 5.0 + 2.0);
            float[] hsb = Color.RGBtoHSB(0, 0, 0, null);
            float brightness = scale * (float)this._joint_entropy.get_data().get(hash).intValue();
            Color c = new Color(Color.HSBtoRGB(hsb[0], hsb[1], brightness));
            try {
                img.setRGB(p[0], p[1], c.getRGB());
            }
            catch (Exception ex) {
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "p[0]: " + p[0] + " p[1]" + p[1] + " width " + width + " height " + height + " ->" + ex);
            }
        }
        GradientPaint gradient = new GradientPaint(0.0f, 7.0f, Color.BLACK, 0.0f, height, Color.WHITE);
        g2d.setPaint(gradient);
        g2d.fill(new Rectangle2D.Double(0.0, 7.0, 5.0, height - 7));
        gradient = new GradientPaint(5.0f, 0.0f, Color.BLACK, width, 0.0f, Color.WHITE);
        g2d.setPaint(gradient);
        g2d.fill(new Rectangle2D.Double(7.0, 0.0, width - 7, 5.0));
    }

    public static VoxelCubeJointHistogram get_instance() {
        return _instance;
    }
}

