/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.atlas.optimization;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.media.j3d.Transform3D;
import main.YaDiV;
import main.seggen.atlas.Atlas;
import main.seggen.atlas.VoxelCubeJointHistogram;
import main.seggen.atlas.similarity.NMIComputer;
import main.seggen.atlas.similarity.SimilarityMeasure;
import misc.StopWatch;
import misc.transform.AffineTransformation;
import settings.SettingsOwner;
import threads.RSThread;

public abstract class AffineOptimization
extends RSThread {
    private static final int THREADCOUNT = 8;
    protected Transform3D _trans = new Transform3D();
    protected static final ExecutorService _ex = Executors.newFixedThreadPool(8);
    protected Atlas _atlas;

    public AffineOptimization(SettingsOwner parent, boolean monitor) {
        super(parent, monitor, true);
    }

    public AffineOptimization(SettingsOwner parent, boolean monitor, AffineTransformation trans) {
        super(parent, monitor, true);
        this._trans = trans.getTrans();
    }

    @Override
    public void my_run() {
        StopWatch sw = new StopWatch();
        sw.start();
        YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "Starting optimization process");
        SimilarityMeasure next_sim = new NMIComputer(this._atlas, this._trans);
        try {
            next_sim = (SimilarityMeasure)next_sim.call();
        }
        catch (Exception ex) {
            YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "AffineOptimization: " + ex);
        }
        SimilarityMeasure sim = next_sim;
        while (!this.finished()) {
            do {
                if (next_sim.compute() > sim.compute()) {
                    sim = next_sim;
                    this._trans = next_sim.get_transformation();
                }
                next_sim = this.compute_next();
                this._atlas.set_trans(new AffineTransformation(new Transform3D(sim.get_transformation())));
                VoxelCubeJointHistogram.get_instance().build_histogram(sim.get_joint_entropy(), "" + sim.compute());
            } while (next_sim != null && sim.compute() < next_sim.compute());
            this.halve_parameters();
        }
        this.set_progress_val(this.get_progress_max());
        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "Finished optimazion process, max similarity = " + sim.compute() + " in " + sw);
        VoxelCubeJointHistogram.get_instance().build_histogram(sim.get_joint_entropy(), "" + sim.compute());
    }

    protected abstract void halve_parameters();

    protected abstract boolean finished();

    protected abstract SimilarityMeasure compute_next();
}

