/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.atlas.optimization;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import main.MasterControl;
import main.YaDiV;
import main.seggen.SegGenAtlas;
import main.seggen.atlas.Atlas;
import main.seggen.atlas.optimization.AffineOptimization;
import main.seggen.atlas.similarity.NMIComputer;
import main.seggen.atlas.similarity.SimilarityMeasure;
import misc.transform.AffineTransformation;
import settings.Settings;
import settings.SettingsOwner;

public final class BestNeighbourOptimization
extends AffineOptimization {
    private float _min_translation;
    private float _min_angle;
    private float _min_scale;
    private float _translation;
    private float _angle;
    private float _scale_factor;
    private int _halving_steps;
    private final HashMap<Transform3D, Float> looked_for = new HashMap();

    public BestNeighbourOptimization(Atlas atlas, SettingsOwner parent, boolean monitor) {
        super(parent, monitor);
        this._atlas = atlas;
        this.init(atlas);
    }

    public BestNeighbourOptimization(Atlas atlas, SettingsOwner parent, boolean monitor, AffineTransformation trans) {
        super(parent, monitor, trans);
        this.init(atlas);
    }

    private void init(Atlas atlas) {
        this._atlas = atlas;
        this.set_label("Optimizing similarity");
        if (this._monitor) {
            this._translation = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_TRANS_MAX).floatValue();
            this._min_translation = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_TRANS_MIN).floatValue();
            this._angle = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_ROTATION_MAX).floatValue();
            this._min_angle = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_ROTATION_MIN).floatValue();
            this._scale_factor = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_SCALE_MAX).floatValue();
            this._min_scale = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_SCALE_MIN).floatValue();
            this._monitor = false;
            while (!this.finished()) {
                this.halve_parameters();
            }
            this.init_progress_measure("Rigid Optimization ...", 0, this._halving_steps, 0);
            this._halving_steps = 0;
            this._monitor = true;
        }
        this._translation = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_TRANS_MAX).floatValue();
        this._min_translation = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_TRANS_MIN).floatValue();
        this._angle = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_ROTATION_MAX).floatValue();
        this._min_angle = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_ROTATION_MIN).floatValue();
        this._scale_factor = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_SCALE_MAX).floatValue();
        this._min_scale = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_SCALE_MIN).floatValue();
    }

    private LinkedList<Transform3D> get_next_steps() {
        Transform3D trans;
        LinkedList<Transform3D> nextSteps = new LinkedList<Transform3D>();
        if (this._translation > this._min_translation) {
            trans = new Transform3D();
            trans.setTranslation(new Vector3f(this._translation, 0.0f, 0.0f));
            nextSteps.add(trans);
            trans = new Transform3D();
            trans.setTranslation(new Vector3f(-this._translation, 0.0f, 0.0f));
            nextSteps.add(trans);
            trans = new Transform3D();
            trans.setTranslation(new Vector3f(0.0f, this._translation, 0.0f));
            nextSteps.add(trans);
            trans = new Transform3D();
            trans.setTranslation(new Vector3f(0.0f, -this._translation, 0.0f));
            nextSteps.add(trans);
            trans = new Transform3D();
            trans.setTranslation(new Vector3f(0.0f, 0.0f, this._translation));
            nextSteps.add(trans);
            trans = new Transform3D();
            trans.setTranslation(new Vector3f(0.0f, 0.0f, -this._translation));
            nextSteps.add(trans);
        }
        Vector3f center = new Vector3f((float)MasterControl.get_is().get_dim_x() / 2.0f, (float)MasterControl.get_is().get_dim_y() / 2.0f, (float)MasterControl.get_is().get_dim_z() / 2.0f);
        Transform3D translate_center_to_origin = new Transform3D();
        translate_center_to_origin.setTranslation(new Vector3f(-center.x, -center.y, -center.z));
        Transform3D translate_origin_to_center = new Transform3D();
        translate_origin_to_center.setTranslation(center);
        if (this._scale_factor > this._min_scale) {
            Transform3D scale;
            if (Settings.get_bool_option(SegGenAtlas.class, SegGenAtlas.OPT_SCALE_UNIFORM).booleanValue()) {
                scale = new Transform3D();
                scale.setScale(1.0 + (double)this._scale_factor);
                scale.mul(translate_center_to_origin);
                trans = new Transform3D(translate_origin_to_center);
                trans.mul(scale);
                nextSteps.add(trans);
                scale = new Transform3D();
                scale.setScale(1.0 - (double)this._scale_factor);
                scale.mul(translate_center_to_origin);
                trans = new Transform3D(translate_origin_to_center);
                trans.mul(scale);
                nextSteps.add(trans);
            }
            if (Settings.get_bool_option(SegGenAtlas.class, SegGenAtlas.OPT_SCALE_AXIS).booleanValue()) {
                scale = new Transform3D();
                scale.setScale(new Vector3d(1.0 + (double)this._scale_factor, 1.0, 1.0));
                scale.mul(translate_center_to_origin);
                trans = new Transform3D(translate_origin_to_center);
                trans.mul(scale);
                nextSteps.add(trans);
                scale = new Transform3D();
                scale.setScale(new Vector3d(1.0 - (double)this._scale_factor, 1.0, 1.0));
                scale.mul(translate_center_to_origin);
                trans = new Transform3D(translate_origin_to_center);
                trans.mul(scale);
                nextSteps.add(trans);
                scale = new Transform3D();
                scale.setScale(new Vector3d(1.0, 1.0 + (double)this._scale_factor, 1.0));
                scale.mul(translate_center_to_origin);
                trans = new Transform3D(translate_origin_to_center);
                trans.mul(scale);
                nextSteps.add(trans);
                scale = new Transform3D();
                scale.setScale(new Vector3d(1.0, 1.0 - (double)this._scale_factor, 1.0));
                scale.mul(translate_center_to_origin);
                trans = new Transform3D(translate_origin_to_center);
                trans.mul(scale);
                nextSteps.add(trans);
                scale = new Transform3D();
                scale.setScale(new Vector3d(1.0, 1.0, 1.0 + (double)this._scale_factor));
                scale.mul(translate_center_to_origin);
                trans = new Transform3D(translate_origin_to_center);
                trans.mul(scale);
                nextSteps.add(trans);
                scale = new Transform3D();
                scale.setScale(new Vector3d(1.0, 1.0, 1.0 - (double)this._scale_factor));
                scale.mul(translate_center_to_origin);
                trans = new Transform3D(translate_origin_to_center);
                trans.mul(scale);
                nextSteps.add(trans);
            }
        }
        if (this._angle > this._min_angle) {
            Transform3D rot = new Transform3D();
            rot.rotX((double)this._angle);
            rot.mul(translate_center_to_origin);
            trans = new Transform3D(translate_origin_to_center);
            trans.mul(rot);
            nextSteps.add(trans);
            rot = new Transform3D();
            rot.rotX((double)(-this._angle));
            rot.mul(translate_center_to_origin);
            trans = new Transform3D(translate_origin_to_center);
            trans.mul(rot);
            nextSteps.add(trans);
            rot = new Transform3D();
            rot.rotY((double)this._angle);
            rot.mul(translate_center_to_origin);
            trans = new Transform3D(translate_origin_to_center);
            trans.mul(rot);
            nextSteps.add(trans);
            rot = new Transform3D();
            rot.rotY((double)(-this._angle));
            rot.mul(translate_center_to_origin);
            trans = new Transform3D(translate_origin_to_center);
            trans.mul(rot);
            nextSteps.add(trans);
            rot = new Transform3D();
            rot.rotZ((double)this._angle);
            rot.mul(translate_center_to_origin);
            trans = new Transform3D(translate_origin_to_center);
            trans.mul(rot);
            nextSteps.add(trans);
            rot = new Transform3D();
            rot.rotZ((double)(-this._angle));
            rot.mul(translate_center_to_origin);
            trans = new Transform3D(translate_origin_to_center);
            trans.mul(rot);
            nextSteps.add(trans);
        }
        return nextSteps;
    }

    @Override
    protected boolean finished() {
        return this._translation < this._min_translation && this._angle < this._min_angle && this._scale_factor < this._min_scale;
    }

    @Override
    protected SimilarityMeasure compute_next() {
        LinkedList<Transform3D> next_steps = this.get_next_steps();
        SimilarityMeasure sim = null;
        LinkedList<NMIComputer> thread_list = new LinkedList<NMIComputer>();
        LinkedList<SimilarityMeasure> result_list = new LinkedList<SimilarityMeasure>();
        for (Transform3D t : next_steps) {
            t.mul(this._trans);
            if (this.looked_for.containsKey(t)) continue;
            thread_list.add(new NMIComputer(this._atlas, t));
        }
        if (thread_list.size() == 0) {
            YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "SimilarityMeasure: thread mayday (no transformations possible)");
            return null;
        }
        try {
            List computed_similarities = _ex.invokeAll(thread_list);
            if (computed_similarities.size() == 0) {
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "computed mayday: computed_similarities.size() == 0");
            }
            for (Future future : computed_similarities) {
                result_list.add((SimilarityMeasure)future.get());
            }
            if (result_list.size() == 0) {
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "computed mayday: result_list.size() == 0");
            }
            sim = (SimilarityMeasure)result_list.get(0);
            Iterator result_it = result_list.iterator();
            Iterator comput_it = computed_similarities.iterator();
            do {
                SimilarityMeasure res = (SimilarityMeasure)result_it.next();
                Future com = comput_it.next();
                float similarity = res.compute();
                this.looked_for.put(res.get_transformation(), Float.valueOf(similarity));
                if (!(similarity > sim.compute())) continue;
                sim = (SimilarityMeasure)com.get();
            } while (result_it.hasNext());
        }
        catch (Exception e) {
            YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "Error: " + e + " (sim = null!)");
        }
        return sim;
    }

    @Override
    protected void halve_parameters() {
        this._angle /= 2.0f;
        this._translation /= 2.0f;
        this._scale_factor /= 2.0f;
        ++this._halving_steps;
        this.set_progress_val(this._halving_steps);
    }
}

