/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.atlas.optimization;

import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;

public final class GradientGrid {
    private final Point3i _dimension;
    private final Vector3f[] _gradient;

    public GradientGrid(Point3i dim) {
        this._dimension = dim;
        this._gradient = new Vector3f[dim.x * dim.y * dim.z];
    }

    public Vector3f get_gradient(int x, int y, int z) {
        return this._gradient[z * this._dimension.y * this._dimension.x + y * this._dimension.x + x];
    }

    public void set_gradient(int x, int y, int z, Vector3f newValue) {
        this._gradient[z * this._dimension.y * this._dimension.x + y * this._dimension.x + x] = newValue;
    }

    public float get_length() {
        float result = 0.0f;
        Vector3f[] vector3fArray = this._gradient;
        int n = this._gradient.length;
        int n2 = 0;
        while (n2 < n) {
            Vector3f v = vector3fArray[n2];
            result += v.length();
            ++n2;
        }
        return result;
    }
}

