/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.atlas.optimization;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import main.StatusBar;
import main.YaDiV;
import main.seggen.SegGenAtlas;
import main.seggen.atlas.Atlas;
import main.seggen.atlas.optimization.GradientGrid;
import main.seggen.atlas.optimization.PDCResult;
import main.seggen.atlas.optimization.PartialDerativeComputer;
import misc.transform.NonrigidTransformation;
import misc.transform.Transformation;
import settings.Settings;
import settings.SettingsOwner;
import threads.RSThread;

public final class NonRigidOptimization
extends RSThread {
    private final Atlas _atlas;
    private final NonrigidTransformation _transform;
    protected static ExecutorService ex = null;

    public NonRigidOptimization(Atlas atlas, Transformation beforeTrans, SettingsOwner parent, boolean monitor) {
        super(parent, monitor, true);
        ex = Executors.newFixedThreadPool(Settings.get_int_option(SegGenAtlas.class, SegGenAtlas.OPT_THREAD_COUNT));
        this._atlas = atlas;
        this._transform = beforeTrans instanceof NonrigidTransformation ? new NonrigidTransformation((NonrigidTransformation)beforeTrans) : new NonrigidTransformation(this._atlas.get_voxel_cube().get_dim_x(), this._atlas.get_voxel_cube().get_dim_y(), this._atlas.get_voxel_cube().get_dim_z(), 5, 5, 5, beforeTrans);
        StatusBar.get_instance().set_stopable(this);
    }

    @Override
    public void my_run() {
        float mue = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_MUE).floatValue();
        Point3i dim = this._transform.get_grid_dim();
        int loopCount = 0;
        while (loopCount < Settings.get_int_option(SegGenAtlas.class, SegGenAtlas.OPT_ITERATION_COUNT)) {
            ++loopCount;
            this.init_progress_measure("Non-Rigid Optimization ...", 0, dim.x * dim.y * dim.z, 0);
            LinkedList<PartialDerativeComputer> list = new LinkedList<PartialDerativeComputer>();
            int z = 0;
            while (z < dim.z) {
                int y = 0;
                while (y < dim.y) {
                    int x = 0;
                    while (x < dim.x) {
                        NonrigidTransformation trans = new NonrigidTransformation(this._transform);
                        list.add(new PartialDerativeComputer(this._atlas, trans, x, y, z, this));
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            GradientGrid gradient = new GradientGrid(dim);
            try {
                List mapParts = ex.invokeAll(list);
                for (Future f : mapParts) {
                    PDCResult result = (PDCResult)f.get();
                    gradient.set_gradient(result._x, result._y, result._z, result._gradient);
                }
            }
            catch (Exception ex) {
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "ERROR WITH TREADS WHILE OPTIMIZING NONRIGID TRANSFORMATION: " + ex);
            }
            int z2 = 0;
            while (z2 < dim.z) {
                if (this._stop_soon) break;
                int y = 0;
                while (y < dim.y) {
                    int x = 0;
                    while (x < dim.x) {
                        Point3f newGridPoint = this._transform.get_grid_point(x, y, z2);
                        Vector3f partialGradient = gradient.get_gradient(x, y, z2);
                        newGridPoint.x += mue * partialGradient.x;
                        newGridPoint.y += mue * partialGradient.y;
                        newGridPoint.z += mue * partialGradient.z;
                        ++x;
                    }
                    ++y;
                }
                ++z2;
            }
            if (this._stop_soon) continue;
            this._atlas.set_trans(this._transform);
        }
    }
}

