/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.atlas.optimization;

import java.util.concurrent.Callable;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import main.seggen.SegGenAtlas;
import main.seggen.atlas.Atlas;
import main.seggen.atlas.optimization.NonRigidOptimization;
import main.seggen.atlas.optimization.PDCResult;
import main.seggen.atlas.similarity.EntropieComputer;
import main.seggen.atlas.similarity.HistogramPartComputer;
import misc.transform.NonrigidTransformation;
import settings.Settings;

public final class PartialDerativeComputer
implements Callable<PDCResult> {
    private final NonrigidTransformation _transform;
    private final Atlas _atlas;
    private final int _z;
    private final int _y;
    private final int _x;
    private final EntropieComputer _imageEntropy = new EntropieComputer();
    private final EntropieComputer _atlasEntropy = new EntropieComputer();
    private final EntropieComputer _jointEntropy = new EntropieComputer();
    private final Point3i _start = new Point3i();
    private final Point3i _finish = new Point3i();
    private final NonRigidOptimization _opt;

    public PartialDerativeComputer(Atlas atlas, NonrigidTransformation transform, int x, int y, int z, NonRigidOptimization opt) {
        this._transform = transform;
        this._x = x;
        this._y = y;
        this._z = z;
        this._opt = opt;
        this._atlas = atlas;
        this._start.x = Math.max((int)((float)(x - 3) * transform.get_cell_size().x), 0);
        this._start.y = Math.max((int)((float)(y - 3) * transform.get_cell_size().y), 0);
        this._start.z = Math.max((int)((float)(z - 3) * transform.get_cell_size().z), 0);
        this._finish.x = Math.min((int)((float)(x + 1) * transform.get_cell_size().x), atlas.get_voxel_cube().get_dim_x() - 1);
        this._finish.y = Math.min((int)((float)(y + 1) * transform.get_cell_size().y), atlas.get_voxel_cube().get_dim_y() - 1);
        this._finish.z = Math.min((int)((float)(z + 1) * transform.get_cell_size().z), atlas.get_voxel_cube().get_dim_z() - 1);
    }

    @Override
    public PDCResult call() throws Exception {
        Vector3f gradient = new Vector3f();
        float delta_factor = Settings.get_double_option(SegGenAtlas.class, SegGenAtlas.OPT_DELTA).floatValue();
        Point3f gridPoint = this._transform.get_grid_point(this._x, this._y, this._z);
        float orig_x = gridPoint.x;
        float orig_y = gridPoint.y;
        float orig_z = gridPoint.z;
        float rightSim = 0.0f;
        float leftSim = 0.0f;
        float delta = this._transform.get_dx() * delta_factor;
        if (!this.stop()) {
            gridPoint.x = orig_x + delta;
            rightSim = this.computeSimilarity();
            gridPoint.x = orig_x - delta;
            leftSim = this.computeSimilarity();
            gradient.x = delta / 2.0f * (rightSim - leftSim);
            gridPoint.x = orig_x;
        }
        if (!this.stop()) {
            delta = this._transform.get_dy() * delta_factor;
            gridPoint.y = orig_y + delta;
            rightSim = this.computeSimilarity();
            gridPoint.y = orig_y - delta;
            leftSim = this.computeSimilarity();
            gradient.y = delta / 2.0f * (rightSim - leftSim);
            gridPoint.y = orig_y;
        }
        if (!this.stop()) {
            delta = this._transform.get_dz() * delta_factor;
            gridPoint.z = orig_z + delta;
            rightSim = this.computeSimilarity();
            gridPoint.z = orig_z - delta;
            leftSim = this.computeSimilarity();
            gradient.z = delta / 2.0f * (rightSim - leftSim);
            gridPoint.z = orig_z;
            this._opt.inc_progress_value(1);
        }
        return new PDCResult(this._x, this._y, this._z, gradient);
    }

    private float computeSimilarity() {
        this._imageEntropy.clear();
        this._atlasEntropy.clear();
        this._jointEntropy.clear();
        float considered_voxels = (float)Settings.get_int_option(SegGenAtlas.class, SegGenAtlas.OPT_SIM_VOXELS).intValue() * 1.0f / 100.0f;
        HistogramPartComputer computer = new HistogramPartComputer(this._atlas, this._jointEntropy, this._imageEntropy, this._atlasEntropy, this._transform, this._start, this._finish, considered_voxels);
        try {
            computer.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        if (this._jointEntropy.compute() == 0.0f) {
            return 2.0f;
        }
        float sim = 0.0f;
        if (!this.stop()) {
            sim = (this._imageEntropy.compute() + this._atlasEntropy.compute()) / this._jointEntropy.compute();
        }
        return sim;
    }

    private boolean stop() {
        return this._opt.will_stop();
    }
}

