/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.atlas.similarity;

import java.util.Hashtable;

public final class EntropieComputer {
    private static final int BIT_SHIFT = 16;
    private static final int BIT_MASK = 65535;
    private final Hashtable<Integer, Integer> _grey_pairs = new Hashtable();
    private boolean _is_computed = false;
    private float _entropy = 0.0f;
    private int _total_key_num = 0;

    public void clear() {
        this._is_computed = false;
        this._grey_pairs.clear();
        this._total_key_num = 0;
    }

    public void insert_pair_key(int key) {
        this._is_computed = false;
        if (this._grey_pairs.containsKey(key)) {
            this._grey_pairs.put(key, this._grey_pairs.get(key) + 1);
        } else {
            this._grey_pairs.put(key, 1);
        }
        ++this._total_key_num;
    }

    public float compute() {
        if (!this._is_computed) {
            float result = 0.0f;
            for (int v : this._grey_pairs.values()) {
                float p = 1.0f * (float)v / (float)this._total_key_num;
                result = (float)((double)result - (double)p * Math.log(p));
            }
            this._is_computed = true;
            this._entropy = result;
        }
        return this._entropy;
    }

    public Hashtable<Integer, Integer> get_data() {
        return this._grey_pairs;
    }

    public static void invert_hash(int hash, int[] result) {
        result[0] = hash >> 16 & 0xFFFF;
        result[1] = hash & 0xFFFF;
    }

    public static int get_hash(int x, int y) {
        return x << 16 | y;
    }
}

