/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.atlas.similarity;

import java.util.Hashtable;
import java.util.Random;
import java.util.concurrent.Callable;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import main.MasterControl;
import main.seggen.atlas.Atlas;
import main.seggen.atlas.similarity.EntropieComputer;
import main.seggen.atlas.similarity.NearestNeighbourhoodFilter;
import main.seggen.atlas.similarity.ReconstructionFilter;
import misc.VoxelColorTable;
import misc.grid.RegularGrid3i;
import misc.transform.Transformation;

public final class HistogramPartComputer
implements Callable<Hashtable<Integer, Integer>> {
    private final EntropieComputer _joint_entropy;
    private final EntropieComputer _atlas_entropy;
    private final EntropieComputer _image_entropy;
    private final ReconstructionFilter _filter;
    private final Transformation _trans;
    private final Atlas _atlas;
    private final RegularGrid3i _image_cube;
    private final Point3i _finish;
    private final Point3i _start;
    private boolean _use_all = true;
    private float _to_use;
    public static VoxelColorTable _atlas_colors;
    public static VoxelColorTable _image_colors;

    public static void init_voxel_color_tables() {
        _atlas_colors = new VoxelColorTable(Atlas.get_instance().get_voxel_value_range());
        int i = 0;
        while (i < HistogramPartComputer._atlas_colors._colors.length) {
            HistogramPartComputer._atlas_colors._colors[i] = i;
            ++i;
        }
        _image_colors = new VoxelColorTable(MasterControl.get_is().get_voxel_value_range());
        i = 0;
        while (i < HistogramPartComputer._image_colors._colors.length) {
            HistogramPartComputer._image_colors._colors[i] = i;
            ++i;
        }
    }

    public HistogramPartComputer(Atlas atlas, EntropieComputer joint_entropy, EntropieComputer image_entropy, EntropieComputer atlas_entropy, Transformation trans, Point3i start, Point3i finish) {
        this._atlas = atlas;
        this._image_entropy = image_entropy;
        this._atlas_entropy = atlas_entropy;
        this._joint_entropy = joint_entropy;
        this._trans = trans;
        this._start = start;
        this._finish = finish;
        this._image_cube = MasterControl.get_is().get_voxel_cube();
        this._filter = new NearestNeighbourhoodFilter(this._image_cube);
    }

    public HistogramPartComputer(Atlas atlas, EntropieComputer joint_entropy, EntropieComputer image_entropy, EntropieComputer atlas_entropy, Transformation trans, Point3i start, Point3i finish, float toUse) {
        this(atlas, joint_entropy, image_entropy, atlas_entropy, trans, start, finish);
        this._use_all = false;
        this._to_use = toUse;
    }

    @Override
    public Hashtable<Integer, Integer> call() throws Exception {
        if (this._use_all) {
            this.compute_for_all_voxel();
        } else {
            this.compute_for_random_voxel();
        }
        return null;
    }

    private void compute_for_random_voxel() {
        int to_use = (int)(this._to_use * (float)(this._finish.x - this._start.x) * (float)(this._finish.y - this._start.y) * (float)(this._finish.z - this._start.z));
        int rand_x = this._finish.x - this._start.x + 1;
        int rand_y = this._finish.y - this._start.y + 1;
        int rand_z = this._finish.z - this._start.z + 1;
        Random rand = new Random();
        int i = 0;
        while (i < to_use) {
            int x = rand.nextInt(rand_x) + this._start.x;
            int y = rand.nextInt(rand_y) + this._start.y;
            int z = rand.nextInt(rand_z) + this._start.z;
            this.look_for(x, y, z);
            ++i;
        }
    }

    private void compute_for_all_voxel() {
        int z = this._start.z;
        while (z <= this._finish.z) {
            int y = this._start.y;
            while (y < this._finish.y) {
                int x = this._start.x;
                while (x <= this._finish.x) {
                    this.look_for(x, y, z);
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    private void look_for(int x, int y, int z) {
        RegularGrid3i atlas_vc = this._atlas.get_voxel_cube();
        int atlas_value = HistogramPartComputer._atlas_colors._colors[atlas_vc.get(x, y, z)];
        Point3f p = this._trans.transform(x, y, z);
        int image_value = HistogramPartComputer._image_colors._colors[(int)((double)this._filter.sample(p) + 0.5)];
        this._atlas_entropy.insert_pair_key(atlas_value);
        this._image_entropy.insert_pair_key(image_value);
        this._joint_entropy.insert_pair_key(EntropieComputer.get_hash(atlas_value, image_value));
    }
}

