/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.atlas.similarity;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3i;
import main.YaDiV;
import main.seggen.SegGenAtlas;
import main.seggen.atlas.Atlas;
import main.seggen.atlas.similarity.EntropieComputer;
import main.seggen.atlas.similarity.HistogramPartComputer;
import main.seggen.atlas.similarity.SimilarityMeasure;
import misc.transform.AffineTransformation;
import settings.Settings;

public final class NMIComputer
implements SimilarityMeasure {
    private final Atlas _atlas;
    private Transform3D _trans;
    private final EntropieComputer _image_entropy = new EntropieComputer();
    private final EntropieComputer _atlas_entropy = new EntropieComputer();
    private final EntropieComputer _joint_entropy = new EntropieComputer();

    public NMIComputer(Atlas atlas, Transform3D trans) {
        this._atlas = atlas;
        this._trans = trans;
    }

    @Override
    public SimilarityMeasure call() throws Exception {
        boolean use_random = Settings.get_bool_option(SegGenAtlas.class, SegGenAtlas.OPT_SIM_RANDOM_VOXELS);
        int to_use = Settings.get_int_option(SegGenAtlas.class, SegGenAtlas.OPT_SIM_VOXELS);
        boolean thread_count = true;
        ExecutorService es = Executors.newFixedThreadPool(1);
        LinkedList<HistogramPartComputer> list = new LinkedList<HistogramPartComputer>();
        int dim_x = this._atlas.get_voxel_cube().get_dim_x();
        int dim_y = this._atlas.get_voxel_cube().get_dim_y();
        int dim_z = this._atlas.get_voxel_cube().get_dim_z();
        int part_width = dim_z / 1;
        int z_start = 0;
        while (z_start < dim_z - 1) {
            Point3i start = new Point3i(0, 0, z_start);
            Point3i finish = new Point3i(dim_x - 1, dim_y - 1, Math.min(z_start + part_width, dim_z) - 1);
            if (use_random) {
                list.add(new HistogramPartComputer(this._atlas, this._joint_entropy, this._image_entropy, this._atlas_entropy, new AffineTransformation(this._trans), start, finish, (float)to_use * 0.01f));
            } else {
                list.add(new HistogramPartComputer(this._atlas, this._joint_entropy, this._image_entropy, this._atlas_entropy, new AffineTransformation(this._trans), start, finish));
            }
            z_start += part_width;
        }
        try {
            List map_parts = es.invokeAll(list);
            for (Future f : map_parts) {
                f.get();
            }
        }
        catch (Exception ex) {
            YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "NMIComputer: Thread problem detected while computing Histogram: " + ex);
        }
        es.shutdown();
        this.compute();
        return this;
    }

    @Override
    public float compute() {
        return (this._image_entropy.compute() + this._atlas_entropy.compute()) / this._joint_entropy.compute();
    }

    @Override
    public EntropieComputer get_joint_entropy() {
        return this._joint_entropy;
    }

    @Override
    public Transform3D get_transformation() {
        return this._trans;
    }

    @Override
    public void set_transformation(Transform3D t) {
        this._trans = t;
    }
}

