/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.atlas.similarity;

import javax.vecmath.Point3f;
import main.seggen.atlas.similarity.ReconstructionFilter;
import misc.grid.RegularGrid3i;

public final class NearestNeighbourhoodFilter
implements ReconstructionFilter {
    private final RegularGrid3i _vc;
    private final int _dim_x;
    private final int _dim_y;
    private final int _dim_z;

    public NearestNeighbourhoodFilter(RegularGrid3i imageCube) {
        this._vc = imageCube;
        this._dim_x = imageCube.get_dim_x() - 1;
        this._dim_y = imageCube.get_dim_y() - 1;
        this._dim_z = imageCube.get_dim_z() - 1;
    }

    @Override
    public float sample(Point3f sample_point) {
        int x = (int)((double)sample_point.x + 0.5);
        int y = (int)((double)sample_point.y + 0.5);
        int z = (int)((double)sample_point.z + 0.5);
        int result = x < 0 || x > this._dim_x || y < 0 || y > this._dim_y || z < 0 || z > this._dim_z ? 0 : this._vc.get(x, y, z);
        return result;
    }

    @Override
    public float sample_unsafe(Point3f sample_point) {
        int x = (int)((double)sample_point.x + 0.5);
        int y = (int)((double)sample_point.y + 0.5);
        int z = (int)((double)sample_point.z + 0.5);
        return this._vc.get(x, y, z);
    }
}

