/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.connect;

import java.util.ArrayList;
import javax.vecmath.Point3i;
import main.ImageStack;
import main.MasterControl;
import main.seggen.connect.CompareType;
import misc.AxisAlignedBoundingBox;
import misc.Voxel;
import misc.VoxelQueue;
import misc.grid.BitCube;
import misc.grid.N6Iterator;
import misc.grid.PaddedBitCube;
import misc.grid.RegularGrid3i;
import threads.RSThread;

public class ConnectedPart {
    private Voxel _seed;
    private int _voxel_number;
    private BitCube _bc;
    private AxisAlignedBoundingBox _bb;
    private boolean _touches_volume_border;
    private boolean _touches_value_border;
    private int _min;
    private int _max;
    private double _mean;
    private final Point3i _bb_min;
    private final Point3i _bb_max;
    private Voxel[] _border;

    public ConnectedPart(BitCube bc, Voxel seed) {
        this._bc = bc;
        this._seed = seed;
        this._bb_min = new Point3i();
        this._bb_max = new Point3i();
        this._border = new Voxel[1];
    }

    public int trace(RegularGrid3i vc, PaddedBitCube gotcha, BitCube border_gotcha, RSThread rst, int total_num, int img_size) {
        int processed_voxel = total_num;
        Voxel v = new Voxel();
        Voxel n = new Voxel();
        N6Iterator n6i = new N6Iterator(this._bc);
        VoxelQueue todo = new VoxelQueue(1024);
        todo.store(this._seed._x, this._seed._y, this._seed._z);
        gotcha.setXYZ(this._seed._x, this._seed._y, this._seed._z, true);
        this._voxel_number = 0;
        this._min = Integer.MAX_VALUE;
        this._max = Integer.MIN_VALUE;
        this._bb_min.set(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this._bb_max.set(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this._mean = 0.0;
        ImageStack is = MasterControl.get_is();
        ArrayList<Voxel> border_list = new ArrayList<Voxel>();
        while (todo.size() != 0) {
            todo.fetch(v);
            int value = is.get_scaled_value(vc.get(v._x, v._y, v._z));
            this._mean += (double)value;
            if (value < this._min) {
                this._min = value;
            }
            if (value > this._max) {
                this._max = value;
            }
            if (v._x < this._bb_min.x) {
                this._bb_min.x = v._x;
            }
            if (v._y < this._bb_min.y) {
                this._bb_min.y = v._y;
            }
            if (v._z < this._bb_min.z) {
                this._bb_min.z = v._z;
            }
            if (v._x > this._bb_max.x) {
                this._bb_max.x = v._x;
            }
            if (v._y > this._bb_max.y) {
                this._bb_max.y = v._y;
            }
            if (v._z > this._bb_max.z) {
                this._bb_max.z = v._z;
            }
            n6i.init(v);
            while (n6i.next(n)) {
                if (!this._bc.getXYZ(n._x, n._y, n._z) && !border_gotcha.getXYZ(v._x, v._y, v._z)) {
                    border_gotcha.setXYZ(v._x, v._y, v._z, true);
                    border_list.add(new Voxel(v));
                }
                if (gotcha.getXYZ(n._x, n._y, n._z)) continue;
                gotcha.setXYZ(n._x, n._y, n._z, true);
                if (rst != null && ++processed_voxel % img_size == 0) {
                    rst.inc_progress_value(1);
                }
                if (!this._bc.getXYZ(n._x, n._y, n._z)) continue;
                todo.store(new Voxel(n));
            }
            ++this._voxel_number;
        }
        this._mean /= (double)this._voxel_number;
        this._touches_volume_border = this._bb_min.x == 0 || this._bb_min.y == 0 || this._bb_min.z == 0 || this._bb_max.x == vc.get_dim_x() - 1 || this._bb_max.y == vc.get_dim_y() - 1 || this._bb_max.z == vc.get_dim_z() - 1;
        this._border = border_list.toArray(this._border);
        return processed_voxel - total_num;
    }

    public boolean detect_value_border(RegularGrid3i vc, int value, CompareType compare) {
        int dim_x = this._bc.get_dim_x();
        int dim_y = this._bc.get_dim_y();
        int dim_z = this._bc.get_dim_z();
        BitCube gotcha = new BitCube(dim_x, dim_y, dim_z);
        Voxel n = new Voxel();
        N6Iterator n6i = new N6Iterator(this._bc);
        VoxelQueue todo = new VoxelQueue(1024);
        todo.store(this._seed);
        gotcha.setXYZ(this._seed._x, this._seed._y, this._seed._z, true);
        this._touches_value_border = false;
        int i = 0;
        while (i < this._border.length && !this._touches_value_border) {
            n6i.init(this._border[i]);
            while (n6i.next(n)) {
                switch (compare) {
                    case LOWER: {
                        this._touches_value_border = vc.get(n._x, n._y, n._z) < value;
                        break;
                    }
                    case LOWER_OR_EQUALS: {
                        this._touches_value_border = vc.get(n._x, n._y, n._z) <= value;
                        break;
                    }
                    case EQUALS: {
                        this._touches_value_border = vc.get(n._x, n._y, n._z) == value;
                        break;
                    }
                    case GREATER_OR_EQUALS: {
                        this._touches_value_border = vc.get(n._x, n._y, n._z) >= value;
                        break;
                    }
                    case GREATER: {
                        boolean bl = this._touches_value_border = vc.get(n._x, n._y, n._z) > value;
                    }
                }
            }
            ++i;
        }
        return this._touches_value_border;
    }

    public void delete() {
        BitCube gotcha = new BitCube(this._bc.get_dim_x(), this._bc.get_dim_y(), this._bc.get_dim_z());
        Voxel n = new Voxel();
        N6Iterator n6i = new N6Iterator(this._bc);
        VoxelQueue todo = new VoxelQueue(1024);
        Voxel v = new Voxel();
        todo.store(this._seed);
        gotcha.setXYZ(this._seed._x, this._seed._y, this._seed._z, true);
        while (todo.size() != 0) {
            todo.fetch(v);
            this._bc.setXYZ(v._x, v._y, v._z, false);
            n6i.init(v);
            while (n6i.next(n)) {
                if (this._bc.getXYZ(n._x, n._y, n._z) && !gotcha.getXYZ(n._x, n._y, n._z)) {
                    todo.store(new Voxel(n));
                }
                gotcha.setXYZ(n._x, n._y, n._z, true);
            }
        }
    }

    public Voxel get_seed() {
        return this._seed;
    }

    public int get_voxel_number() {
        return this._voxel_number;
    }

    public boolean touches_volume_border() {
        return this._touches_volume_border;
    }

    public boolean touches_value_border() {
        return this._touches_value_border;
    }

    public AxisAlignedBoundingBox get_bb() {
        return this._bb;
    }

    public int get_min() {
        return this._min;
    }

    public int get_max() {
        return this._max;
    }

    public double get_mean() {
        return this._mean;
    }

    public Point3i get_bb_min() {
        return this._bb_min;
    }

    public Point3i get_bb_max() {
        return this._bb_max;
    }

    public Voxel[] get_border() {
        return this._border;
    }
}

