/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.connect;

import java.awt.Color;
import java.awt.Image;
import main.Message;
import main.seggen.connect.ConnectedPart;
import misc.Voxel;
import renderer.Renderer2d;
import settings.Settings;
import settings.SettingsOwner;

public class PartRenderer2d
extends Renderer2d
implements SettingsOwner {
    public static final String OPT_COLOR = Settings.register_color_opt(PartRenderer2d.class, "part highlite color", "The color of the bounding box.", new Color(255, 0, 255));
    private ConnectedPart[] _parts = null;

    public PartRenderer2d() {
        Settings.register_owner(this);
    }

    @Override
    public Image render_image(int mode, int idx) {
        int i = 0;
        while (i < this._pixels[mode].length) {
            this._pixels[mode][i] = 0;
            ++i;
        }
        int col = Settings.get_color_option(this, OPT_COLOR).getRGB();
        if (this._parts != null) {
            int i2 = 0;
            while (i2 < this._parts.length) {
                Voxel[] border = this._parts[i2].get_border();
                int j = 0;
                while (j < border.length) {
                    Voxel v = border[j];
                    if (mode == 0 && idx == v._z) {
                        this._bimg[mode].setRGB(v._x, v._y, col);
                    } else if (mode == 1 && idx == v._x) {
                        this._bimg[mode].setRGB(v._y, v._z, col);
                    } else if (mode == 2 && idx == v._y) {
                        this._bimg[mode].setRGB(v._x, v._z, col);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        return this._bimg[mode];
    }

    public void show_parts(ConnectedPart[] parts) {
        this._parts = parts;
        this.setChanged();
        this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        this.setChanged();
        this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
    }

    @Override
    public String get_name() {
        return this.toString();
    }
}

