/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.connect;

import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import main.Message;
import main.seggen.connect.ConnectedPart;
import main.view3d.Viewport3d;
import misc.Voxel;
import misc.messages.YObservable;
import renderer.Renderer3d;

public class PartRenderer3d
extends Renderer3d {
    private ConnectedPart[] _parts;
    private final Shape3D _points_shp;
    private final Appearance _point_app;
    private final ColoringAttributes _ca_points = new ColoringAttributes();
    private final PointAttributes _pa_points = new PointAttributes();

    public PartRenderer3d(Viewport3d v3d) {
        super(v3d, 1);
        this._points_shp = new Shape3D();
        this._points_shp.setCapability(13);
        this._points_shp.setCapability(15);
        this._point_app = this.create_point_appearance();
        this._points_shp.setAppearance(this._point_app);
        this._bg.addChild((Node)this._points_shp);
    }

    @Override
    public void update(YObservable sender, Message arg) {
    }

    @Override
    public void create_scene() {
    }

    public void show_parts(ConnectedPart[] parts) {
        this._parts = parts;
        PointArray pa = null;
        if (this._parts != null) {
            int size = 0;
            int i = 0;
            while (i < this._parts.length) {
                size += this._parts[i].get_border().length;
                ++i;
            }
            pa = new PointArray(size, 1);
            int idx = 0;
            int i2 = 0;
            while (i2 < this._parts.length) {
                Voxel[] border = this._parts[i2].get_border();
                int j = 0;
                while (j < border.length) {
                    Voxel v = border[j];
                    pa.setCoordinate(idx++, new Point3f((float)v._x, (float)v._y, (float)v._z));
                    ++j;
                }
                ++i2;
            }
        }
        this._points_shp.setGeometry(pa);
    }

    private final Appearance create_point_appearance() {
        Color col = Color.PINK;
        Color3f col3f = new Color3f(col);
        Appearance ap = new Appearance();
        this._ca_points.setColor(col3f);
        this._ca_points.setCapability(1);
        ap.setCapability(11);
        this._pa_points.setPointSize(5.0f);
        this._pa_points.setPointAntialiasingEnable(true);
        this._pa_points.setCapability(1);
        this._pa_points.setCapability(3);
        ap.setCapability(19);
        ap.setColoringAttributes(this._ca_points);
        ap.setPointAttributes(this._pa_points);
        return ap;
    }
}

