/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm;

import java.util.LinkedList;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import main.seggen.dm.IAbortCriterion;
import main.seggen.dm.IDMComponent;
import main.seggen.dm.IForce;
import main.seggen.dm.INotification;
import main.seggen.dm.ISurfaceAdjuster;
import main.seggen.dm.common.abortCriteria.YaDiVThreadAborter;
import main.seggen.dm.common.notifications.YaDiVProgressBar;
import main.seggen.dm.forces.IBulkEdgeForce;
import main.seggen.dm.forces.IBulkTriaForce;
import main.seggen.dm.forces.IBulkVertForce;
import main.seggen.dm.forces.ISingleEdgeForce;
import main.seggen.dm.forces.ISingleForce;
import main.seggen.dm.forces.ISingleTriaForce;
import main.seggen.dm.forces.ISingleVertForce;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.Label;
import main.seggen.dm.surface.userdata.FixedData;
import main.seggen.dm.surface.userdata.NormalData;
import misc.linkedsurface.LinkedTriaSurface;

public class DeformableModel {
    LinkedList<ISingleVertForce> single_vert_forces = new LinkedList();
    LinkedList<ISingleEdgeForce> single_edge_forces = new LinkedList();
    LinkedList<ISingleTriaForce> single_tria_forces = new LinkedList();
    LinkedList<IBulkVertForce> bulk_vert_forces = new LinkedList();
    LinkedList<IBulkEdgeForce> bulk_edge_forces = new LinkedList();
    LinkedList<IBulkTriaForce> bulk_tria_forces = new LinkedList();
    LinkedList<IAbortCriterion> abort_criteria = new LinkedList();
    LinkedList<INotification> notifications = new LinkedList();
    LinkedList<ISurfaceAdjuster> adjusters = new LinkedList();
    int step = 0;
    Label<LinkedTriaSurface.LinkedVert> fixed_vert_label;
    Label<LinkedTriaSurface.LinkedEdge> fixed_edge_label;
    Label<LinkedTriaSurface.LinkedTria> fixed_tria_label;
    public DMSurface surface;

    public int get_step() {
        return this.step;
    }

    public void init(DMSurface sph, int start_step) {
        this.surface = sph;
    }

    public void addComponent(IDMComponent comp) {
        if (comp instanceof IForce) {
            this.add_force((IForce)comp);
        }
        if (comp instanceof IAbortCriterion) {
            this.add_abort_criterion((IAbortCriterion)comp);
        }
        if (comp instanceof INotification) {
            this.add_notification((INotification)comp);
        }
        if (comp instanceof ISurfaceAdjuster) {
            this.add_adjuster((ISurfaceAdjuster)comp);
        }
    }

    public void add_force(IForce force) {
        if (force instanceof ISingleForce) {
            if (force instanceof ISingleVertForce) {
                this.single_vert_forces.add((ISingleVertForce)force);
            } else if (force instanceof ISingleEdgeForce) {
                this.single_edge_forces.add((ISingleEdgeForce)force);
            } else if (force instanceof ISingleTriaForce) {
                this.single_tria_forces.add((ISingleTriaForce)force);
            }
        } else if (force instanceof IBulkVertForce) {
            this.bulk_vert_forces.add((IBulkVertForce)force);
        } else if (force instanceof IBulkEdgeForce) {
            this.bulk_edge_forces.add((IBulkEdgeForce)force);
        } else if (force instanceof IBulkTriaForce) {
            this.bulk_tria_forces.add((IBulkTriaForce)force);
        }
    }

    public void add_abort_criterion(IAbortCriterion abort_criterion) {
        this.abort_criteria.add(abort_criterion);
    }

    public void add_notification(INotification notification) {
        this.notifications.add(notification);
    }

    public void add_adjuster(ISurfaceAdjuster adjuster) {
        this.adjusters.add(adjuster);
    }

    public void do_step(boolean uses_fixation) {
        Vector3d[] res;
        Object res2;
        Vector3d[] calced_vert_forces = new Vector3d[this.surface._vlist.size()];
        int c = 0;
        while (c < this.surface._vlist.size()) {
            calced_vert_forces[c] = new Vector3d();
            ++c;
        }
        Vector3d[] calced_edge_forces = new Vector3d[this.surface._elist.size()];
        int c2 = 0;
        while (c2 < this.surface._elist.size()) {
            calced_edge_forces[c2] = new Vector3d();
            ++c2;
        }
        Vector3d[] calced_tria_forces = new Vector3d[this.surface._flist.size()];
        int c3 = 0;
        while (c3 < this.surface._flist.size()) {
            calced_tria_forces[c3] = new Vector3d();
            ++c3;
        }
        Vector3d[] calced_combined_forces = new Vector3d[this.surface._vlist.size()];
        int c4 = 0;
        while (c4 < this.surface._vlist.size()) {
            calced_combined_forces[c4] = new Vector3d();
            ++c4;
        }
        LinkedTriaSurface.LinkedTria[] trias = new LinkedTriaSurface.LinkedTria[this.surface._flist.size()];
        LinkedTriaSurface.LinkedEdge[] edges = new LinkedTriaSurface.LinkedEdge[this.surface._elist.size()];
        LinkedTriaSurface.LinkedVert[] verts = new LinkedTriaSurface.LinkedVert[this.surface._vlist.size()];
        boolean[] fixed_verts = new boolean[this.surface._vlist.size()];
        boolean[] fixed_edges = new boolean[this.surface._elist.size()];
        boolean[] fixed_trias = new boolean[this.surface._flist.size()];
        Vector3d[] tria_normals = new Vector3d[this.surface._flist.size()];
        Vector3d[] edge_normals = new Vector3d[this.surface._elist.size()];
        Vector3d[] vert_normals = new Vector3d[this.surface._vlist.size()];
        int c5 = 0;
        while (c5 < this.surface._vlist.size()) {
            verts[c5] = (LinkedTriaSurface.LinkedVert)this.surface._vlist.get(c5);
            fixed_verts[c5] = uses_fixation && this.fixed_vert_label.contains(verts[c5]);
            vert_normals[c5] = ((NormalData)verts[c5].get_user_data((int)NormalData._DATA_ID)).normal;
            ++c5;
        }
        c5 = 0;
        while (c5 < this.surface._elist.size()) {
            edges[c5] = (LinkedTriaSurface.LinkedEdge)this.surface._elist.get(c5);
            fixed_edges[c5] = uses_fixation && this.fixed_edge_label.contains(edges[c5]);
            edge_normals[c5] = ((NormalData)edges[c5].get_user_data((int)NormalData._DATA_ID)).normal;
            ++c5;
        }
        c5 = 0;
        while (c5 < this.surface._flist.size()) {
            trias[c5] = (LinkedTriaSurface.LinkedTria)this.surface._flist.get(c5);
            fixed_trias[c5] = uses_fixation && this.fixed_tria_label.contains(trias[c5]);
            tria_normals[c5] = ((NormalData)trias[c5].get_user_data((int)NormalData._DATA_ID)).normal;
            ++c5;
        }
        for (INotification vis : this.notifications) {
            vis.begin_step(this.surface, this.step);
        }
        c = 0;
        while (c < this.surface._vlist.size()) {
            if (!fixed_verts[c]) {
                res2 = calced_vert_forces[c];
                for (ISingleVertForce vforce : this.single_vert_forces) {
                    res2.add((Tuple3d)vforce.getForce(this.surface, verts[c], vert_normals[c], this.step));
                }
                calced_vert_forces[c] = res2;
            }
            ++c;
        }
        c = 0;
        while (c < this.surface._elist.size()) {
            if (!fixed_edges[c]) {
                res2 = calced_edge_forces[c];
                for (ISingleEdgeForce eforce : this.single_edge_forces) {
                    res2.add((Tuple3d)eforce.getForce(this.surface, edges[c], edge_normals[c], this.step));
                }
                calced_edge_forces[c] = res2;
            }
            ++c;
        }
        c = 0;
        while (c < this.surface._flist.size()) {
            if (!fixed_trias[c]) {
                res2 = calced_tria_forces[c];
                for (ISingleTriaForce tforce : this.single_tria_forces) {
                    res2.add((Tuple3d)tforce.getForce(this.surface, trias[c], tria_normals[c], this.step));
                }
                calced_tria_forces[c] = res2;
            }
            ++c;
        }
        for (IBulkVertForce bvf : this.bulk_vert_forces) {
            res = bvf.getForce(this.surface, verts, vert_normals, fixed_verts, this.step);
            int i = 0;
            while (i < res.length) {
                calced_vert_forces[i].add((Tuple3d)res[i]);
                ++i;
            }
        }
        for (IBulkEdgeForce bef : this.bulk_edge_forces) {
            res = bef.getForce(this.surface, edges, edge_normals, fixed_edges, this.step);
            int i = 0;
            while (i < res.length) {
                calced_edge_forces[i].add((Tuple3d)res[i]);
                ++i;
            }
        }
        for (IBulkTriaForce btf : this.bulk_tria_forces) {
            res = btf.getForce(this.surface, trias, tria_normals, fixed_trias, this.step);
            int i = 0;
            while (i < res.length) {
                calced_tria_forces[i].add((Tuple3d)res[i]);
                ++i;
            }
        }
        int i = 0;
        while (i < this.surface._vlist.size()) {
            LinkedTriaSurface.LinkedVert lv = (LinkedTriaSurface.LinkedVert)this.surface._vlist.get(i);
            if (!uses_fixation || !this.fixed_vert_label.contains(lv)) {
                Vector3d temp_res = new Vector3d();
                temp_res.add((Tuple3d)calced_vert_forces[this.surface._vlist.indexOf(lv)]);
                if (lv._ep.size() > 0) {
                    Vector3d result = new Vector3d();
                    for (LinkedTriaSurface.LinkedEdge le : lv._ep) {
                        result.add((Tuple3d)calced_edge_forces[this.surface._elist.indexOf(le)]);
                    }
                    result.scale(1.0 / (double)lv._ep.size());
                    temp_res.add((Tuple3d)result);
                }
                if (lv._fp.size() > 0) {
                    Vector3d result = new Vector3d();
                    for (LinkedTriaSurface.LinkedTria lt : lv._fp) {
                        result.add((Tuple3d)calced_tria_forces[this.surface._flist.indexOf(lt)]);
                    }
                    result.scale(1.0 / (double)lv._fp.size());
                    temp_res.add((Tuple3d)result);
                }
                this.surface.addToVertexPosition(lv, temp_res, this.step);
                calced_combined_forces[i] = temp_res;
            } else {
                calced_combined_forces[i] = new Vector3d();
            }
            ++i;
        }
        this.surface.calc_normals();
        for (INotification vis : this.notifications) {
            vis.calculated_forces(this.surface, this.step, calced_vert_forces, calced_edge_forces, calced_tria_forces, calced_combined_forces);
        }
        for (ISurfaceAdjuster adjuster : this.adjusters) {
            adjuster.adjustMesh(this.surface);
            this.surface.calc_normals();
        }
        for (INotification vis : this.notifications) {
            vis.end_step(this.surface, this.step);
        }
        ++this.step;
    }

    public void calc() {
        boolean abort;
        this.fixed_vert_label = this.surface._vert_labels.get("internal.fixed");
        this.fixed_edge_label = this.surface._edge_labels.get("internal.fixed");
        this.fixed_tria_label = this.surface._tria_labels.get("internal.fixed");
        boolean uses_fixation = false;
        for (LinkedTriaSurface.LinkedVert lv : this.surface._vlist) {
            if (lv.get_user_data(FixedData._DATA_ID) == null) continue;
            uses_fixation = true;
            break;
        }
        for (INotification vis : this.notifications) {
            vis.will_start(this.surface);
        }
        block2: do {
            this.do_step(uses_fixation);
            abort = false;
            for (IAbortCriterion crit : this.abort_criteria) {
                if (!crit.check_abort(this.surface, this.step)) continue;
                abort = true;
                continue block2;
            }
        } while (!abort);
        for (INotification vis : this.notifications) {
            vis.did_end(this.surface, this.step);
        }
    }

    public void removeThreadReferences() {
        LinkedList<IAbortCriterion> ac = new LinkedList<IAbortCriterion>();
        LinkedList<INotification> no = new LinkedList<INotification>();
        for (IAbortCriterion acr : this.abort_criteria) {
            if (!(acr instanceof YaDiVThreadAborter)) continue;
            ac.add(acr);
        }
        for (INotification not : this.notifications) {
            if (!(not instanceof YaDiVProgressBar)) continue;
            no.add(not);
        }
        for (IAbortCriterion acr : ac) {
            this.abort_criteria.remove(acr);
        }
        for (INotification not : no) {
            this.notifications.remove(not);
        }
    }
}

