/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm;

import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;
import jgridmaker.GMPanel;
import jgridmaker.JGridMaker;
import main.ImageStack;
import main.MainWindow;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.YDialogs;
import main.seggen.SegGenYDM;
import main.seggen.dm.DMThread;
import main.seggen.dm.DeformableModel;
import main.seggen.dm.IForce;
import main.seggen.dm.INotification;
import main.seggen.dm.ISurfaceAdjuster;
import main.seggen.dm.common.abortCriteria.FixedAborter;
import main.seggen.dm.common.abortCriteria.StepAborter;
import main.seggen.dm.common.abortCriteria.YaDiVThreadAborter;
import main.seggen.dm.common.notifications.YaDiVProgressBar;
import main.seggen.dm.gui.SurfaceSelector;
import main.seggen.dm.settings.ComponentData;
import main.seggen.dm.settings.SettingsLoader;
import main.seggen.dm.settings.SettingsSaver;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.DMSurfaceToITA;
import main.seggen.dm.surface.userdata.FixedDataHandler;
import main.seggen.dm.surface.userdata.FixedParameter;
import main.tools.ToolSegGen;
import main.view3d.Viewport3d;
import misc.messages.YObservable;
import renderer.Renderer2d;
import renderer.Renderer3d;
import renderer.SegRenderer2d;
import settings.Settings;
import settings.SettingsListener;

public class GeneralDM
extends GMPanel {
    private List<ComponentData> components = new LinkedList<ComponentData>();
    private DeformableModel dm;
    private GeneralDMVisualization gdm_vis;
    private final SurfaceSelector model_sel;
    protected static final JFileChooser _model_file_chooser = new JFileChooser();

    public GeneralDM() {
        try {
            ComponentData[] loaded_comps;
            ComponentData[] componentDataArray = loaded_comps = SettingsLoader.loadSettings(new FileInputStream("resources/generic_dm_default_settings.xml"));
            int n = loaded_comps.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentData comp = componentDataArray[n2];
                this.components.add(comp);
                ++n2;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        JButton edit = new JButton("Edit dm");
        edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralDMConfigurationPanel gdmcp = new GeneralDMConfigurationPanel(GeneralDM.this.components);
                gdmcp.setVisible(true);
            }
        });
        JButton load = new JButton("Load dm");
        load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (_model_file_chooser.showOpenDialog(null) == 0) {
                    try {
                        ComponentData[] loaded_comps;
                        FileInputStream is = new FileInputStream(_model_file_chooser.getSelectedFile());
                        GeneralDM.this.components = new LinkedList();
                        ComponentData[] componentDataArray = loaded_comps = SettingsLoader.loadSettings(is);
                        int n = loaded_comps.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ComponentData comp = componentDataArray[n2];
                            GeneralDM.this.components.add(comp);
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JButton save = new JButton("Save dm");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (_model_file_chooser.showSaveDialog(null) == 0) {
                    try {
                        File target = _model_file_chooser.getSelectedFile();
                        String path = target.getPath();
                        if (!path.endsWith(".set")) {
                            path = String.valueOf(path) + ".set";
                        }
                        target = new File(path);
                        FileOutputStream os = new FileOutputStream(target);
                        SettingsSaver.saveSettings(GeneralDM.this.components.toArray(new ComponentData[1]), os);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.model_sel = new SurfaceSelector();
        JButton init = new JButton("Initialize dm");
        init.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GeneralDM.this.init();
            }
        });
        JButton run = new JButton("Run dm");
        run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GeneralDM.this.run();
            }
        });
        JButton voxelize = new JButton("Voxelize");
        voxelize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GeneralDM.this.voxelize();
            }
        });
        final JCheckBox jcb_show = new JCheckBox("Show model", false);
        jcb_show.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                GeneralDM.this.gdm_vis.set_visible(jcb_show.isSelected());
                if (jcb_show.isSelected()) {
                    GeneralDM.this.model_sel.hide();
                }
            }
        });
        this.gdm_vis = new GeneralDMVisualization(MasterControl.get_v3d(), 1);
        this.add("init", init);
        this.add("run", run);
        this.add("jcb_show", jcb_show);
        this.add("model_sel", (JComponent)((Object)this.model_sel));
        this.add("edit", edit);
        this.add("load", load);
        this.add("save", save);
        this.add("voxelize", voxelize);
        this.set_layout("<table border='0'>  <tr>    <td>Select model</td>    <td>::init::</td>    <td>::edit::</td>  </tr><tr>    <td>::model_sel::</td>    <td>::run::</td>    <td>::load::</td>  </tr><tr>    <td></td>    <td>::jcb_show::</td>    <td>::save::</td>  </tr><tr>    <td></td>    <td></td>    <td>::voxelize::</td>  </tr></table>");
    }

    private void voxelize() {
        DMSurface surface = this.model_sel.getSelectedSurface();
        Segment seg = MasterControl.get_is().get_segment(ToolSegGen.TMP_SEG_NAME);
        surface.voxelize(seg.get_bc());
        seg.new_data(true);
    }

    private void init() {
        if (!this.model_sel.isSelectionAvailable()) {
            YDialogs.notify_user("Select a model first");
            return;
        }
        this.model_sel.hide();
        DMSurface surface = this.model_sel.getSelectedSurface();
        this.gdm_vis.setSurface(surface);
        surface.clearUserDataHandler();
        if (this.fixedEnabled()) {
            surface.addUserDataHandler(new FixedDataHandler(this.fixedParameter()));
        }
        surface.didLoad();
        this.dm = new DeformableModel();
        for (ComponentData comp : this.components) {
            if (!comp.getEnabled()) continue;
            this.dm.addComponent(comp.getComponent());
        }
        this.dm.addComponent(this.gdm_vis);
        this.dm.init(surface, 0);
    }

    private void run() {
        if (this.dm == null) {
            YDialogs.notify_user("You need to intialize first");
            return;
        }
        this.dm.removeThreadReferences();
        DMThread dm_thread = new DMThread(null, true, true, this.dm);
        this.dm.add_abort_criterion(new YaDiVThreadAborter(dm_thread));
        if (this.getMaximumNumberOfStepsEnabled()) {
            this.dm.add_notification(new YaDiVProgressBar(dm_thread, this.getMaximumNumberOfSteps(), "General dm"));
            StepAborter sa = this.getStepAborter();
            sa.setInitialStep(this.dm.get_step());
        } else {
            this.dm.add_notification(new YaDiVProgressBar(dm_thread, 0, "General dm"));
        }
        dm_thread.start();
    }

    private boolean fixedEnabled() {
        for (ComponentData cd : this.components) {
            if (!(cd.getComponent() instanceof FixedAborter) || !cd.getEnabled()) continue;
            return true;
        }
        return false;
    }

    private FixedParameter fixedParameter() {
        for (ComponentData cd : this.components) {
            if (!(cd.getComponent() instanceof FixedAborter) || !cd.getEnabled()) continue;
            FixedAborter fa = (FixedAborter)cd.getComponent();
            return fa.getFixedParameter();
        }
        return null;
    }

    private int getMaximumNumberOfSteps() {
        for (ComponentData cd : this.components) {
            if (!(cd.getComponent() instanceof StepAborter) || !cd.getEnabled()) continue;
            StepAborter sa = (StepAborter)cd.getComponent();
            return sa.getMaxStep();
        }
        return 0;
    }

    private boolean getMaximumNumberOfStepsEnabled() {
        for (ComponentData cd : this.components) {
            if (!(cd.getComponent() instanceof StepAborter) || !cd.getEnabled()) continue;
            return true;
        }
        return false;
    }

    private StepAborter getStepAborter() {
        for (ComponentData cd : this.components) {
            if (!(cd.getComponent() instanceof StepAborter) || !cd.getEnabled()) continue;
            StepAborter sa = (StepAborter)cd.getComponent();
            return sa;
        }
        return null;
    }

    private class GeneralDMConfigurationPanel
    extends JDialog {
        private List<EnableAndComponent> eacs;
        private GMPanel gui;

        public GeneralDMConfigurationPanel(List<ComponentData> componentDatas) {
            super((Frame)MasterControl.get_window(), true);
            MainWindow win = MasterControl.get_window();
            this.setTitle("Edit dm config");
            this.gui = new GMPanel();
            this.eacs = new LinkedList<EnableAndComponent>();
            GMPanel gm_aborter = new GMPanel();
            String gm_aborter_layout = "<table>";
            GMPanel gm_notifier = new GMPanel();
            String gm_notifier_layout = "<table>";
            GMPanel gm_adjuster = new GMPanel();
            String gm_adjuster_layout = "<table>";
            GMPanel gm_forces = new GMPanel();
            String gm_forces_layout = "<table>";
            for (ComponentData comp : componentDatas) {
                String className = comp.getComponent().getClass().getName();
                EnableAndComponent eac = new EnableAndComponent(comp);
                this.eacs.add(eac);
                if (comp.getComponent() instanceof IForce) {
                    gm_forces.add(className, (JComponent)eac.getEnableAndConfigPanel());
                    gm_forces_layout = String.valueOf(gm_forces_layout) + "<tr><td>::" + className + "::</td></tr>";
                    continue;
                }
                if (comp.getComponent() instanceof ISurfaceAdjuster) {
                    gm_adjuster.add(className, (JComponent)eac.getEnableAndConfigPanel());
                    gm_adjuster_layout = String.valueOf(gm_adjuster_layout) + "<tr><td>::" + className + "::</td></tr>";
                    continue;
                }
                if (comp.getComponent() instanceof INotification) {
                    gm_notifier.add(className, (JComponent)eac.getEnableAndConfigPanel());
                    gm_notifier_layout = String.valueOf(gm_notifier_layout) + "<tr><td>::" + className + "::</td></tr>";
                    continue;
                }
                gm_aborter.add(className, (JComponent)eac.getEnableAndConfigPanel());
                gm_aborter_layout = String.valueOf(gm_aborter_layout) + "<tr><td>::" + className + "::</td></tr>";
            }
            gm_forces_layout = String.valueOf(gm_forces_layout) + "</table>";
            gm_forces.set_layout(gm_forces_layout);
            gm_forces.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Forces", 2, 2));
            gm_aborter_layout = String.valueOf(gm_aborter_layout) + "</table>";
            gm_aborter.set_layout(gm_aborter_layout);
            gm_aborter.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Abort Criteria", 2, 2));
            gm_notifier_layout = String.valueOf(gm_notifier_layout) + "</table>";
            gm_notifier.set_layout(gm_notifier_layout);
            gm_notifier.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Notifications", 2, 2));
            gm_adjuster_layout = String.valueOf(gm_adjuster_layout) + "</table>";
            gm_adjuster.set_layout(gm_adjuster_layout);
            gm_adjuster.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Surface Adjuster", 2, 2));
            JButton ok = new JButton("Ok");
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GeneralDMConfigurationPanel.this.close();
                }
            });
            this.gui.add("ok", (JComponent)ok);
            this.gui.add("gm_aborter", (JComponent)gm_aborter);
            this.gui.add("gm_notifier", (JComponent)gm_notifier);
            this.gui.add("gm_adjuster", (JComponent)gm_adjuster);
            this.gui.add("gm_forces", (JComponent)gm_forces);
            this.gui.set_layout("<table  fill='both'><tr fill='both'><td fill='both'>::gm_aborter::</td><td fill='both'>::gm_notifier::</td><td fill='both'>::gm_forces::</td><td fill='both'>::gm_adjuster::</td></tr><tr><td colspan='4'><table fill='both' width='100%'><tr><td width='99%'></td><td width='1%'>::ok::</td></tr></table></td></tr></table>");
            HashMap<String, GMPanel> obj_map = new HashMap<String, GMPanel>();
            obj_map.put("gui", this.gui);
            JGridMaker.make_grid((Container)this, (String)"<table><tr><td>::gui::</td></tr></table>", obj_map);
            this.pack();
            int pw = win.getWidth();
            int ph = win.getHeight();
            int px = win.getLocation().x;
            int py = win.getLocation().y;
            int w = this.getWidth();
            int h = this.getHeight();
            this.setLocation(px + pw / 2 - w / 2, py + ph / 2 - h / 2);
        }

        public void close() {
            this.setVisible(false);
        }

        private class EnableAndComponent {
            private ComponentData data;

            public EnableAndComponent(ComponentData data) {
                this.data = data;
            }

            public GMPanel getEnableAndConfigPanel() {
                GMPanel panel = new GMPanel();
                final JCheckBox jcb_enable = new JCheckBox(this.data.getComponent().getConfigGUITitle(), this.data.getEnabled());
                jcb_enable.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        EnableAndComponent.this.data.setEnabled(jcb_enable.isSelected());
                    }
                });
                panel.add("jcb_enable", (JComponent)jcb_enable);
                panel.add("config_gui", (JComponent)this.data.getComponent().getConfigGUI());
                panel.set_layout("<table fill='both'><tr><td anchor='west'>::jcb_enable::</td></tr><tr><td>::config_gui::</td></tr></table>");
                return panel;
            }
        }
    }

    private class GeneralDMVisualization
    extends Renderer3d
    implements INotification,
    SettingsListener {
        private Segment seg;
        private TransformGroup _tg_mc;
        private Shape3D shape;
        private final ColoringAttributes _ca_mc;
        private final PolygonAttributes _pa_mc;
        private Material _mat_mc;
        private DMSurface surface;
        private static final String HELPER_SEG_NAME = "GeneralDMVisualizationSegment";
        private Renderer2d renderer2d;

        public GeneralDMVisualization(Viewport3d v3d, int scene_id) {
            super(v3d, scene_id);
            this._ca_mc = new ColoringAttributes();
            this._pa_mc = new PolygonAttributes();
            Settings.register_class_listener(SegGenYDM.class, this);
            this._tg_mc = new TransformGroup();
            this._tg_mc.setCapability(17);
            this._tg_mc.setCapability(18);
            this.shape = new Shape3D();
            this.shape.setCapability(13);
            this.shape.setCapability(15);
            this.shape.setAppearance(this.create_mc_appearance());
            this._tg_mc.addChild((Node)this.shape);
            this._bg.addChild((Node)this._tg_mc);
            ImageStack is = MasterControl.get_is();
            this.seg = new Segment(HELPER_SEG_NAME, is.get_dim_x(), is.get_dim_y(), is.get_dim_z());
            this.renderer2d = new SegRenderer2d(this.seg, " dms placement preview2d renderer");
        }

        public void setSurface(DMSurface surface) {
            this.surface = surface;
            if (surface != null) {
                this.shape.setGeometry((Geometry)DMSurfaceToITA.getITA(surface, false));
            }
        }

        private final Appearance create_mc_appearance() {
            Color3f seg_color3f = new Color3f(0.0f, 1.0f, 0.0f);
            Appearance ap = new Appearance();
            this._ca_mc.setCapability(1);
            this._ca_mc.setShadeModel(3);
            this._ca_mc.setColor(seg_color3f);
            ap.setColoringAttributes(this._ca_mc);
            this._pa_mc.setCapability(3);
            this._pa_mc.setCullFace(1);
            if (Settings.get_bool_option(SegGenYDM.class, SegGenYDM.OPT_SHOW_WIREFRAME).booleanValue()) {
                this._pa_mc.setPolygonMode(1);
            } else {
                this._pa_mc.setPolygonMode(2);
            }
            ap.setCapability(14);
            ap.setCapability(15);
            ap.setPolygonAttributes(this._pa_mc);
            this._mat_mc = new Material();
            this._mat_mc.setCapability(1);
            this._mat_mc.setShininess(50.0f);
            this._mat_mc.setDiffuseColor(seg_color3f);
            this._mat_mc.setSpecularColor(new Color3f(0.8f, 0.8f, 0.8f));
            ap.setMaterial(this._mat_mc);
            return ap;
        }

        @Override
        public void settings_changed(Object obj, String opt_name, Object opt) {
            if (opt_name.equals(SegGenYDM.OPT_SHOW_WIREFRAME)) {
                if (Settings.get_bool_option(SegGenYDM.class, SegGenYDM.OPT_SHOW_WIREFRAME).booleanValue()) {
                    this.shape.getAppearance().getPolygonAttributes().setPolygonMode(1);
                } else {
                    this.shape.getAppearance().getPolygonAttributes().setPolygonMode(2);
                }
            }
        }

        @Override
        public JPanel getConfigGUI() {
            return new JPanel();
        }

        @Override
        public String getConfigGUITitle() {
            return "display dm";
        }

        @Override
        public String getName() {
            return "General dm visualization";
        }

        @Override
        public String getLongDescription() {
            return "Displays the deformable model";
        }

        @Override
        public String getHTMLHelp() {
            return "Insert help here";
        }

        @Override
        public void initFromString(String options) {
        }

        @Override
        public String saveToString() {
            return "";
        }

        @Override
        public void will_start(DMSurface cs) {
            if (this.surface != null) {
                this.shape.setGeometry((Geometry)DMSurfaceToITA.getITA(this.surface, false));
            }
        }

        @Override
        public void begin_step(DMSurface cs, int step) {
        }

        @Override
        public void end_step(DMSurface cs, int step) {
            if (this.surface != null) {
                this.shape.setGeometry((Geometry)DMSurfaceToITA.getITA(this.surface, false));
            }
            this.update_segment(cs);
        }

        @Override
        public void calculated_forces(DMSurface cs, int step, Vector3d[] vert_forces, Vector3d[] edge_forces, Vector3d[] tria_forces, Vector3d[] combined_forces) {
            if (this.surface != null) {
                this.shape.setGeometry((Geometry)DMSurfaceToITA.getITA(this.surface, false));
            }
            this.update_segment(cs);
        }

        @Override
        public void did_end(DMSurface cs, int step) {
        }

        @Override
        public void update(YObservable sender, Message arg) {
        }

        @Override
        public void create_scene() {
            if (this.surface != null) {
                this.shape.setGeometry((Geometry)DMSurfaceToITA.getITA(this.surface, false));
            }
        }

        @Override
        public void set_visible(boolean visible) {
            if (this.is_visible() && !visible) {
                MasterControl.get_v2d().del_renderer(this.renderer2d);
            }
            if (!this.is_visible() && visible) {
                MasterControl.get_v2d().add_renderer(this.renderer2d, 42);
            }
            super.set_visible(visible);
        }

        private void update_segment(DMSurface surface) {
            this.seg.get_bc().clear();
            surface.voxelize(this.seg.get_bc());
            this.seg.new_data(true);
        }
    }
}

