/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.common.abortCriteria;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgridmaker.GMPanel;
import main.seggen.dm.IAbortCriterion;
import main.seggen.dm.settings.SettingsConverter;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.Label;
import main.seggen.dm.surface.userdata.FixedParameter;
import misc.linkedsurface.LinkedTriaSurface;

public class FixedAborter
implements IAbortCriterion {
    private double rate;
    private double min_movement;
    private int start_after_step;
    private int history_length;
    private boolean fix_outside;
    Label<LinkedTriaSurface.LinkedVert> vert_label;

    public FixedAborter(double rate, double min_movement, int start_after_step, int history_length) {
        this.rate = rate;
        this.min_movement = min_movement;
        this.start_after_step = start_after_step;
        this.history_length = history_length;
        this.fix_outside = false;
    }

    public FixedAborter() {
        this.rate = 0.995;
        this.history_length = 5;
        this.min_movement = 0.001;
        this.start_after_step = 100;
        this.fix_outside = false;
    }

    @Override
    public boolean check_abort(DMSurface surface, int step) {
        if (this.vert_label == null) {
            this.vert_label = surface._vert_labels.get("internal.fixed");
        }
        int fixed = 0;
        for (LinkedTriaSurface.LinkedVert lv : surface._vlist) {
            if (!this.vert_label.contains(lv)) continue;
            ++fixed;
        }
        return (double)fixed / (double)surface._vlist.size() >= this.rate;
    }

    @Override
    public JPanel getConfigGUI() {
        GMPanel panel = new GMPanel();
        final JTextField jtf_rate = new JTextField(Double.toString(this.rate), 3);
        jtf_rate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_rate.getText().length() > 0) {
                    try {
                        FixedAborter.this.rate = Double.parseDouble(jtf_rate.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_rate.setText(Double.toString(FixedAborter.this.rate));
                    }
                }
            }
        });
        final JTextField jtf_min_movement = new JTextField(Double.toString(this.min_movement), 3);
        jtf_min_movement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_min_movement.getText().length() > 0) {
                    try {
                        FixedAborter.this.min_movement = Double.parseDouble(jtf_min_movement.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_min_movement.setText(Double.toString(FixedAborter.this.min_movement));
                    }
                }
            }
        });
        final JTextField jtf_start_after_step = new JTextField(Integer.toString(this.start_after_step), 3);
        jtf_start_after_step.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_start_after_step.getText().length() > 0) {
                    try {
                        FixedAborter.this.start_after_step = Integer.parseInt(jtf_start_after_step.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_start_after_step.setText(Integer.toString(FixedAborter.this.start_after_step));
                    }
                }
            }
        });
        final JTextField jtf_history_length = new JTextField(Integer.toString(this.history_length), 3);
        jtf_history_length.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_history_length.getText().length() > 0) {
                    try {
                        FixedAborter.this.history_length = Integer.parseInt(jtf_history_length.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_history_length.setText(Integer.toString(FixedAborter.this.history_length));
                    }
                }
            }
        });
        final JCheckBox jcb_fix_outside = new JCheckBox("fix outside", this.fix_outside);
        jcb_fix_outside.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FixedAborter.this.fix_outside = jcb_fix_outside.isSelected();
            }
        });
        panel.add("jtf_rate", (JComponent)jtf_rate);
        panel.add("jtf_min_movement", (JComponent)jtf_min_movement);
        panel.add("jtf_start_after_step", (JComponent)jtf_start_after_step);
        panel.add("jtf_history_length", (JComponent)jtf_history_length);
        panel.add("jcb_fix_outside", (JComponent)jcb_fix_outside);
        panel.set_layout("<table><tr><td>rate:</td><td>::jtf_rate::</td></tr><tr><td>min movement:</td><td>::jtf_min_movement::</td></tr><tr><td>start after step:</td><td>::jtf_start_after_step::</td></tr><tr><td>history length:</td><td>::jtf_history_length::</td></tr><tr><td>check outside:</td><td>::jcb_fix_outside::</td></tr></table>");
        return panel;
    }

    @Override
    public String getConfigGUITitle() {
        return "fixation quota";
    }

    @Override
    public String getName() {
        return "FixedAborter";
    }

    @Override
    public String getLongDescription() {
        return "Aborts if configurable number of vertices is marked as fixed";
    }

    @Override
    public String getHTMLHelp() {
        return "Insert help here";
    }

    @Override
    public void initFromString(String options) {
        HashMap<String, String> settings = SettingsConverter.stringToMap(options);
        if (settings.get("version") == null || settings.get("version").equalsIgnoreCase("1")) {
            String fix_outside_str;
            String ml = settings.get("rate");
            if (ml != null) {
                this.rate = Double.parseDouble(ml);
            }
            if ((ml = settings.get("min_movement")) != null) {
                this.min_movement = Double.parseDouble(ml);
            }
            if ((ml = settings.get("start_after_step")) != null) {
                this.start_after_step = Integer.parseInt(ml);
            }
            if ((ml = settings.get("history_length")) != null) {
                this.history_length = Integer.parseInt(ml);
            }
            if ((fix_outside_str = settings.get("fix_outside")) != null) {
                this.fix_outside = "true".equalsIgnoreCase(fix_outside_str);
            }
        } else {
            System.err.println("Failed to decode Settings from FixedAborter: Wrong version, SettingsString: " + options);
        }
    }

    @Override
    public String saveToString() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("version", "1");
        settings.put("rate", Double.toString(this.rate));
        settings.put("min_movement", Double.toString(this.min_movement));
        settings.put("start_after_step", Integer.toString(this.start_after_step));
        settings.put("history_length", Integer.toString(this.history_length));
        if (this.fix_outside) {
            settings.put("fix_outside", "true");
        } else {
            settings.put("fix_outside", "false");
        }
        return SettingsConverter.mapToString(settings);
    }

    public FixedParameter getFixedParameter() {
        FixedParameter fp = new FixedParameter();
        fp.min_movement = this.min_movement;
        fp.min_movement_start_after_step = this.start_after_step;
        fp.min_movement_steps = this.history_length;
        fp.fix_outside = this.fix_outside;
        return fp;
    }
}

