/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.common.abortCriteria;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgridmaker.GMPanel;
import main.seggen.dm.IAbortCriterion;
import main.seggen.dm.settings.SettingsConverter;
import main.seggen.dm.surface.DMSurface;

public class StepAborter
implements IAbortCriterion {
    private int max_step;
    private int initial_step = 0;

    public StepAborter(int max_step) {
        this.max_step = max_step;
    }

    public StepAborter() {
        this.max_step = 500;
    }

    public int getMaxStep() {
        return this.max_step;
    }

    @Override
    public boolean check_abort(DMSurface sphere, int step) {
        return step >= this.max_step + this.initial_step;
    }

    public void setInitialStep(int initial_step) {
        this.initial_step = initial_step;
    }

    @Override
    public JPanel getConfigGUI() {
        GMPanel panel = new GMPanel();
        final JTextField jtf_max_steps = new JTextField(Integer.toString(this.max_step), 3);
        jtf_max_steps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_max_steps.getText().length() > 0) {
                    try {
                        StepAborter.this.max_step = Integer.parseInt(jtf_max_steps.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_max_steps.setText(Integer.toString(StepAborter.this.max_step));
                    }
                }
            }
        });
        panel.add("jtf_max_steps", (JComponent)jtf_max_steps);
        panel.set_layout("<table><tr><td>max steps:</td><td>::jtf_max_steps::</td></tr></table>");
        return panel;
    }

    @Override
    public String getName() {
        return "Step number aborter";
    }

    @Override
    public String getConfigGUITitle() {
        return "step number abort";
    }

    @Override
    public String getLongDescription() {
        return "Aborts after a configurable number of steps";
    }

    @Override
    public String getHTMLHelp() {
        return "Insert help here";
    }

    @Override
    public void initFromString(String options) {
        HashMap<String, String> settings = SettingsConverter.stringToMap(options);
        if (settings.get("version") == null || settings.get("version").equalsIgnoreCase("1")) {
            String ml = settings.get("max_step");
            if (ml != null) {
                this.max_step = Integer.parseInt(ml);
            }
        } else {
            System.err.println("Failed to decode Settings from StepAborter: Wrong version, SettingsString: " + options);
        }
    }

    @Override
    public String saveToString() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("version", "1");
        settings.put("max_step", Integer.toString(this.max_step));
        return SettingsConverter.mapToString(settings);
    }
}

