/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.common.forces;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Vector3d;
import jgridmaker.GMPanel;
import main.seggen.dm.forces.IBulkVertForce;
import main.seggen.dm.settings.SettingsConverter;
import main.seggen.dm.surface.DMSurface;
import misc.linkedsurface.LinkedTriaSurface;

public class BulkGrowingForce
implements IBulkVertForce {
    private double scale;

    public BulkGrowingForce() {
        this.scale = 0.3;
    }

    public BulkGrowingForce(double scale) {
        this.scale = scale;
    }

    @Override
    public Vector3d[] getForce(DMSurface surface, LinkedTriaSurface.LinkedVert[] lv, Vector3d[] normal, boolean[] fixed, int step) {
        Vector3d[] ret = new Vector3d[lv.length];
        int i = 0;
        while (i < lv.length) {
            ret[i] = new Vector3d(normal[i]);
            ret[i].scale(this.scale);
            ++i;
        }
        return ret;
    }

    @Override
    public JPanel getConfigGUI() {
        GMPanel panel = new GMPanel();
        final JTextField jtf_growing_strength = new JTextField(Double.toString(this.scale), 3);
        jtf_growing_strength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_growing_strength.getText().length() > 0) {
                    try {
                        BulkGrowingForce.this.scale = Double.parseDouble(jtf_growing_strength.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_growing_strength.setText(Double.toString(BulkGrowingForce.this.scale));
                    }
                }
            }
        });
        panel.add("jtf_growing_strength", (JComponent)jtf_growing_strength);
        panel.set_layout("<table><tr><td anchor='east'>strength:</td><td>::jtf_growing_strength::</td></tr></table>");
        return panel;
    }

    @Override
    public String getName() {
        return "Growing force";
    }

    @Override
    public String getConfigGUITitle() {
        return "growing force";
    }

    @Override
    public String getLongDescription() {
        return "Constant force direct along the normals of each vertex";
    }

    @Override
    public String getHTMLHelp() {
        return "Insert help here";
    }

    @Override
    public void initFromString(String options) {
        HashMap<String, String> settings = SettingsConverter.stringToMap(options);
        if (settings.get("version") == null || settings.get("version").equalsIgnoreCase("1")) {
            String ml = settings.get("scale");
            if (ml != null) {
                this.scale = Double.parseDouble(ml);
            }
        } else {
            System.err.println("Failed to decode Settings from BulkGrowingForce: Wrong version, SettingsString: " + options);
        }
    }

    @Override
    public String saveToString() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("version", "1");
        settings.put("scale", Double.toString(this.scale));
        return SettingsConverter.mapToString(settings);
    }
}

