/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.common.forces;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jgridmaker.GMPanel;
import main.seggen.dm.forces.ISingleVertForce;
import main.seggen.dm.settings.SettingsConverter;
import main.seggen.dm.surface.DMSHelper;
import main.seggen.dm.surface.DMSurface;
import misc.linkedsurface.LinkedTriaSurface;

public class LaPlaceShapePreservation
implements ISingleVertForce {
    private double scale;
    private int radius;

    public LaPlaceShapePreservation() {
        this.scale = 0.3;
        this.radius = 1;
    }

    public LaPlaceShapePreservation(double scale, int radius) {
        this.scale = scale;
        this.radius = radius;
    }

    @Override
    public Vector3d getForce(DMSurface surface, LinkedTriaSurface.LinkedVert lv, Vector3d normal, int step) {
        Point3d cur_vertex = (Point3d)lv._p.clone();
        ArrayList<LinkedTriaSurface.LinkedVert> onehop = DMSHelper.getAllUpToNHopsAwayIndices(lv, this.radius);
        Vector3d resulting_vector = new Vector3d();
        for (LinkedTriaSurface.LinkedVert hoppVert : onehop) {
            Point3d p2 = hoppVert._p;
            Vector3d v2 = new Vector3d(p2.x, p2.y, p2.z);
            v2.sub((Tuple3d)cur_vertex);
            resulting_vector.add((Tuple3d)v2);
        }
        if (onehop.size() > 0) {
            resulting_vector.scale(this.scale / (double)onehop.size());
            return resulting_vector;
        }
        return new Vector3d(0.0, 0.0, 0.0);
    }

    @Override
    public JPanel getConfigGUI() {
        GMPanel panel = new GMPanel();
        final JTextField jtf_smoothing_strength = new JTextField(Double.toString(this.scale), 3);
        jtf_smoothing_strength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_smoothing_strength.getText().length() > 0) {
                    try {
                        LaPlaceShapePreservation.this.scale = Double.parseDouble(jtf_smoothing_strength.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_smoothing_strength.setText(Double.toString(LaPlaceShapePreservation.this.scale));
                    }
                }
            }
        });
        final JTextField jtf_smoothing_radius = new JTextField(Integer.toString(this.radius), 3);
        jtf_smoothing_radius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_smoothing_radius.getText().length() > 0) {
                    try {
                        LaPlaceShapePreservation.this.radius = Integer.parseInt(jtf_smoothing_radius.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_smoothing_radius.setText(Integer.toString(LaPlaceShapePreservation.this.radius));
                    }
                }
            }
        });
        panel.add("jtf_smoothing_radius", (JComponent)jtf_smoothing_radius);
        panel.add("jtf_smoothing_strength", (JComponent)jtf_smoothing_strength);
        panel.set_layout("<table><tr><td anchor='east'>strength:</td><td>::jtf_smoothing_strength::</td></tr><tr><td anchor='east'>radius:</td><td>::jtf_smoothing_radius::</td></tr></table>");
        return panel;
    }

    @Override
    public String getConfigGUITitle() {
        return "smoothing force";
    }

    @Override
    public String getName() {
        return "Smoothing force";
    }

    @Override
    public String getLongDescription() {
        return "Smoothing force to handle runaway vertices";
    }

    @Override
    public String getHTMLHelp() {
        return "Insert help here";
    }

    @Override
    public void initFromString(String options) {
        HashMap<String, String> settings = SettingsConverter.stringToMap(options);
        if (settings.get("version") == null || settings.get("version").equalsIgnoreCase("1")) {
            String ml = settings.get("scale");
            if (ml != null) {
                this.scale = Double.parseDouble(ml);
            }
            if ((ml = settings.get("radius")) != null) {
                this.radius = Integer.parseInt(ml);
            }
        } else {
            System.err.println("Failed to decode Settings from LaPlaceShapePreservation: Wrong version, SettingsString: " + options);
        }
    }

    @Override
    public String saveToString() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("version", "1");
        settings.put("scale", Double.toString(this.scale));
        settings.put("radius", Integer.toString(this.radius));
        return SettingsConverter.mapToString(settings);
    }
}

