/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.common.forces;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jgridmaker.GMPanel;
import main.CoordinateConverter;
import main.ImageStack;
import main.MasterControl;
import main.seggen.dm.forces.ISingleTriaForce;
import main.seggen.dm.settings.SettingsConverter;
import main.seggen.dm.surface.DMSurface;
import misc.grid.RegularGrid3i;
import misc.grid.filter.FilterFactory;
import misc.grid.filter.FilterType;
import misc.grid.filter.GridFilter;
import misc.linkedsurface.LinkedTriaSurface;

public class RecursiveCenterGradientImageForce
implements ISingleTriaForce {
    private ImageStack is = MasterControl.get_is();
    private RegularGrid3i vc;
    private int delta_min = 0;
    private int delta_max = 0;
    private double min_grad_length = 0.0;
    private double max_grad_length = 0.0;
    private double image_force_scale = 0.0;
    private GridFilter grid_f;
    private int[] lut;
    private double dim_x_scaled;
    private double dim_y_scaled;
    private double dim_z_scaled;

    public RecursiveCenterGradientImageForce(int delta_min, int delta_max, int min_grad_length, int max_grad_length, double image_force_scale) {
        this();
        this.delta_min = delta_min;
        this.delta_max = delta_max;
        this.min_grad_length = min_grad_length;
        this.max_grad_length = max_grad_length;
        this.image_force_scale = image_force_scale;
    }

    public RecursiveCenterGradientImageForce() {
        int dim_x = Math.max(this.is.get_dim_x() - 1, 0);
        int dim_y = Math.max(this.is.get_dim_y() - 1, 0);
        int dim_z = Math.max(this.is.get_dim_z() - 1, 0);
        this.dim_x_scaled = dim_x;
        this.dim_y_scaled = dim_y;
        this.dim_z_scaled = dim_z;
        this.vc = this.is.get_voxel_cube();
        this.lut = new int[this.is.get_voxel_value_range()];
        int index = 0;
        while (index < this.is.get_voxel_value_range()) {
            this.lut[index] = this.is.get_scaled_value(index);
            ++index;
        }
        this.grid_f = FilterFactory.create_grid_filter(this.vc, FilterType.TRILINEAR, null);
        this.delta_min = 2;
        this.delta_max = 0;
        this.min_grad_length = 20.0;
        this.max_grad_length = 60.0;
        this.image_force_scale = 0.3;
    }

    private double weight_for_distance(int distance) {
        return Math.signum((double)distance);
    }

    private LinkedList<Point3d> triaPoints(Point3d p1, Point3d p2, Point3d p3, int recursionDepth) {
        LinkedList<Point3d> ret = new LinkedList<Point3d>();
        this.recTriaPoints(p1, p2, p3, recursionDepth, 0, ret);
        return ret;
    }

    private void recTriaPoints(Point3d p1, Point3d p2, Point3d p3, int recursionDepth, int step, List<Point3d> points) {
        if (step > recursionDepth) {
            return;
        }
        Point3d neu = new Point3d();
        neu.add((Tuple3d)p1);
        neu.add((Tuple3d)p2);
        neu.add((Tuple3d)p3);
        neu.scale(0.3333333333333333);
        points.add(neu);
        this.recTriaPoints(p1, p2, neu, recursionDepth, step + 1, points);
        this.recTriaPoints(p2, p3, neu, recursionDepth, step + 1, points);
        this.recTriaPoints(p3, p1, neu, recursionDepth, step + 1, points);
    }

    public double value_for_tria(LinkedTriaSurface.LinkedTria lt) {
        CoordinateConverter cc_conv = CoordinateConverter.get_converter(MasterControl.get_is());
        Point3d p1 = cc_conv.world_to_grid_p3d(lt._a._p);
        Point3d p2 = cc_conv.world_to_grid_p3d(lt._b._p);
        Point3d p3 = cc_conv.world_to_grid_p3d(lt._c._p);
        LinkedList<Point3d> tria_points = this.triaPoints(p1, p2, p3, 2);
        Vector3d tria_normal = cc_conv.world_to_grid_v3d(lt.calc_normal());
        double ret = 0.0;
        for (Point3d point : tria_points) {
            double vox_value = 0.0;
            Point3d moving_point = new Point3d(point);
            tria_normal.scale((double)this.delta_min);
            moving_point.sub((Tuple3d)tria_normal);
            tria_normal = cc_conv.world_to_grid_v3d(lt.calc_normal());
            int i = -1 * this.delta_min;
            while (i <= this.delta_max) {
                double length = this.grad(moving_point, tria_normal);
                length = length > this.max_grad_length ? 1.0 : (length <= this.min_grad_length ? 0.0 : (length - this.min_grad_length) / (this.max_grad_length - this.min_grad_length));
                vox_value += length * this.weight_for_distance(i);
                moving_point.add((Tuple3d)tria_normal);
                ++i;
            }
            if (Math.abs(this.delta_min) + Math.abs(this.delta_max) != 0) {
                vox_value /= (double)(Math.abs(this.delta_min) + Math.abs(this.delta_max));
            }
            ret += vox_value;
        }
        return ret /= (double)tria_points.size();
    }

    private double grad(Point3d p, Vector3d norm) {
        Point3d p1 = new Point3d(p);
        Point3d p2 = new Point3d(p);
        p1.sub((Tuple3d)norm);
        p2.add((Tuple3d)norm);
        if (this.lies_outside(p1) || this.lies_outside(p2)) {
            return 0.0;
        }
        int val1 = (int)this.grid_f.sample_grid_value_at(new Point3f(p1));
        int val2 = (int)this.grid_f.sample_grid_value_at(new Point3f(p2));
        val1 = this.lut[val1];
        val2 = this.lut[val2];
        return Math.abs(val2 - val1);
    }

    private boolean lies_outside(Point3d p) {
        boolean outside = false;
        if (p.x < 0.0) {
            outside = true;
            p.x = 0.0;
        }
        if (p.y < 0.0) {
            outside = true;
            p.y = 0.0;
        }
        if (p.z < 0.0) {
            outside = true;
            p.z = 0.0;
        }
        if (p.x > this.dim_x_scaled) {
            outside = true;
            p.x = this.dim_x_scaled;
        }
        if (p.y > this.dim_y_scaled) {
            outside = true;
            p.y = this.dim_y_scaled;
        }
        if (p.z > this.dim_z_scaled) {
            outside = true;
            p.z = this.dim_z_scaled;
        }
        return outside;
    }

    @Override
    public Vector3d getForce(DMSurface surface, LinkedTriaSurface.LinkedTria lt, Vector3d normal, int step) {
        double scale = this.value_for_tria(lt);
        Vector3d ret = new Vector3d(normal);
        ret.scale(scale);
        ret.scale(this.image_force_scale);
        return ret;
    }

    @Override
    public JPanel getConfigGUI() {
        GMPanel panel = new GMPanel();
        final JTextField jtf_image_strength = new JTextField(Double.toString(this.image_force_scale), 3);
        jtf_image_strength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_image_strength.getText().length() > 0) {
                    try {
                        RecursiveCenterGradientImageForce.this.image_force_scale = Double.parseDouble(jtf_image_strength.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_image_strength.setText(Double.toString(RecursiveCenterGradientImageForce.this.image_force_scale));
                    }
                }
            }
        });
        final JTextField jtf_min_grad = new JTextField(Double.toString(this.min_grad_length), 3);
        jtf_min_grad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_min_grad.getText().length() > 0) {
                    try {
                        RecursiveCenterGradientImageForce.this.min_grad_length = Double.parseDouble(jtf_min_grad.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_min_grad.setText(Double.toString(RecursiveCenterGradientImageForce.this.min_grad_length));
                    }
                }
            }
        });
        final JTextField jtf_max_grad = new JTextField(Double.toString(this.max_grad_length), 3);
        jtf_max_grad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_max_grad.getText().length() > 0) {
                    try {
                        RecursiveCenterGradientImageForce.this.max_grad_length = Double.parseDouble(jtf_max_grad.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_max_grad.setText(Double.toString(RecursiveCenterGradientImageForce.this.max_grad_length));
                    }
                }
            }
        });
        final JTextField jtf_layers_infront = new JTextField(Integer.toString(this.delta_max), 3);
        jtf_layers_infront.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_layers_infront.getText().length() > 0) {
                    try {
                        RecursiveCenterGradientImageForce.this.delta_max = Integer.parseInt(jtf_layers_infront.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_layers_infront.setText(Integer.toString(RecursiveCenterGradientImageForce.this.delta_max));
                    }
                }
            }
        });
        final JTextField jtf_layers_behind = new JTextField(Integer.toString(this.delta_min), 3);
        jtf_layers_behind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_layers_behind.getText().length() > 0) {
                    try {
                        RecursiveCenterGradientImageForce.this.delta_min = Integer.parseInt(jtf_layers_behind.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_layers_behind.setText(Integer.toString(RecursiveCenterGradientImageForce.this.delta_min));
                    }
                }
            }
        });
        panel.add("jtf_image_strength", (JComponent)jtf_image_strength);
        panel.add("jtf_min_grad", (JComponent)jtf_min_grad);
        panel.add("jtf_max_grad", (JComponent)jtf_max_grad);
        panel.add("jtf_layers_infront", (JComponent)jtf_layers_infront);
        panel.add("jtf_layers_behind", (JComponent)jtf_layers_behind);
        panel.set_layout("<table><tr><td anchor='west'>strength:</td><td>::jtf_image_strength::</td></tr><tr><td colspan='2'><table><tr><td>grad:</td><td>::jtf_min_grad::</td><td>-</td><td>::jtf_max_grad::</td></tr></table></td></tr><tr><td colspan='2'><table><tr><td>layer:</td><td>::jtf_layers_behind::</td><td>-</td><td>::jtf_layers_infront::</td></tr></table></td></tr></table>");
        return panel;
    }

    @Override
    public String getName() {
        return "Image force (triangle)";
    }

    @Override
    public String getConfigGUITitle() {
        return "image force (triangle)";
    }

    @Override
    public String getLongDescription() {
        return "Image forces that uses image gradients in layers in front of and behind the triangle";
    }

    @Override
    public String getHTMLHelp() {
        return "Insert help here";
    }

    @Override
    public void initFromString(String options) {
        HashMap<String, String> settings = SettingsConverter.stringToMap(options);
        if (settings.get("version") == null || settings.get("version").equalsIgnoreCase("1")) {
            String ml = settings.get("scale");
            if (ml != null) {
                this.image_force_scale = Double.parseDouble(ml);
            }
            if ((ml = settings.get("delta_min")) != null) {
                this.delta_min = Integer.parseInt(ml);
            }
            if ((ml = settings.get("delta_max")) != null) {
                this.delta_max = Integer.parseInt(ml);
            }
            if ((ml = settings.get("min_grad")) != null) {
                this.min_grad_length = Double.parseDouble(ml);
            }
            if ((ml = settings.get("max_grad")) != null) {
                this.max_grad_length = Double.parseDouble(ml);
            }
        } else {
            System.err.println("Failed to decode Settings from RecursiveCenterGradientImageForce: Wrong version, SettingsString: " + options);
        }
    }

    @Override
    public String saveToString() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("version", "1");
        settings.put("scale", Double.toString(this.image_force_scale));
        settings.put("delta_min", Integer.toString(this.delta_min));
        settings.put("delta_max", Integer.toString(this.delta_max));
        settings.put("min_grad", Double.toString(this.min_grad_length));
        settings.put("max_grad", Double.toString(this.max_grad_length));
        return SettingsConverter.mapToString(settings);
    }
}

