/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.common.notifications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Vector3d;
import jgridmaker.GMPanel;
import main.YaDiV;
import main.seggen.dm.INotification;
import main.seggen.dm.settings.SettingsConverter;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.IUserDataHandler;
import main.seggen.dm.surface.Label;
import main.seggen.dm.surface.userdata.FixedDataHandler;
import misc.StopWatch;
import misc.linkedsurface.LinkedTriaSurface;

public class CSVStatistics
implements INotification {
    private FileWriter fw;
    private Label<LinkedTriaSurface.LinkedVert> fixed_vert_label;
    private Label<LinkedTriaSurface.LinkedEdge> fixed_edge_label;
    private Label<LinkedTriaSurface.LinkedTria> fixed_tria_label;
    private StopWatch sw_forces = new StopWatch();
    private StopWatch sw_adjuster = new StopWatch();
    private StopWatch sw_total = new StopWatch();
    private boolean fixed = false;
    private String filename = "results/stats.csv";

    public CSVStatistics(String filename) {
        this();
        this.filename = filename;
    }

    public CSVStatistics() {
    }

    @Override
    public void will_start(DMSurface cs) {
        try {
            File file;
            File parent_dir;
            if (!this.filename.endsWith(".csv")) {
                this.filename = String.valueOf(this.filename) + ".csv";
            }
            if ((parent_dir = (file = new File(this.filename)).getParentFile()) != null && !parent_dir.isDirectory()) {
                if (parent_dir.mkdirs()) {
                    YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "CSVStatistics: Created directory '" + parent_dir.getPath() + "'.");
                } else {
                    YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "CSVStatistics: Failed to create directory '" + parent_dir.getPath() + "'.\nStatistcs won't be saved.");
                    return;
                }
            }
            this.fw = new FileWriter(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.fixed = this.isFixed(cs);
        if (this.fixed) {
            this.get_labels(cs);
        }
        try {
            this.fw.write("step, number of verts, number of edges, number of trias, number of fixed verts, number of fixed edges, number of fixed trias, time calculating forces (ms), time adjusting surface (ms), total step time (ms)\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void begin_step(DMSurface cs, int step) {
        this.sw_forces.start();
        this.sw_total.start();
    }

    @Override
    public void end_step(DMSurface cs, int step) {
        this.sw_adjuster.stop();
        this.sw_total.stop();
        if (this.fw == null) {
            this.sw_forces.reset();
            this.sw_adjuster.reset();
            this.sw_total.reset();
            return;
        }
        if (!this.fixed && this.isFixed(cs)) {
            this.get_labels(cs);
        }
        this.fixed = this.isFixed(cs);
        int fixed_verts = 0;
        int fixed_edges = 0;
        int fixed_trias = 0;
        if (this.fixed) {
            Iterator<LinkedTriaSurface.LinkedVert> vert_it = this.fixed_vert_label.get_elements();
            while (vert_it.hasNext()) {
                vert_it.next();
                ++fixed_verts;
            }
            Iterator<LinkedTriaSurface.LinkedEdge> edge_it = this.fixed_edge_label.get_elements();
            while (edge_it.hasNext()) {
                edge_it.next();
                ++fixed_edges;
            }
            Iterator<LinkedTriaSurface.LinkedTria> tria_it = this.fixed_tria_label.get_elements();
            while (tria_it.hasNext()) {
                tria_it.next();
                ++fixed_trias;
            }
        }
        try {
            this.fw.write("" + step);
            this.fw.write(" , ");
            this.fw.write("" + cs._vlist.size());
            this.fw.write(" ,");
            this.fw.write("" + cs._elist.size());
            this.fw.write(" ,");
            this.fw.write("" + cs._flist.size());
            this.fw.write(" ,");
            if (this.fixed) {
                this.fw.write("" + fixed_verts);
                this.fw.write(" ,");
                this.fw.write("" + fixed_edges);
                this.fw.write(" ,");
                this.fw.write("" + fixed_trias);
                this.fw.write(" ,");
            } else {
                this.fw.write(" , , ,");
            }
            this.fw.write("" + this.sw_forces.get_ms());
            this.fw.write(" ,");
            this.fw.write("" + this.sw_adjuster.get_ms());
            this.fw.write(" ,");
            this.fw.write("" + this.sw_total.get_ms());
            this.fw.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sw_forces.reset();
        this.sw_adjuster.reset();
        this.sw_total.reset();
    }

    @Override
    public void calculated_forces(DMSurface cs, int step, Vector3d[] vert_forces, Vector3d[] edge_forces, Vector3d[] tria_forces, Vector3d[] combined_forces) {
        this.sw_forces.stop();
        this.sw_adjuster.start();
    }

    @Override
    public void did_end(DMSurface cs, int step) {
        if (this.fw == null) {
            return;
        }
        try {
            this.fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void get_labels(DMSurface cs) {
        this.fixed_vert_label = cs._vert_labels.get("internal.fixed");
        this.fixed_edge_label = cs._edge_labels.get("internal.fixed");
        this.fixed_tria_label = cs._tria_labels.get("internal.fixed");
    }

    @Override
    public JPanel getConfigGUI() {
        GMPanel panel = new GMPanel();
        final JTextField jtf_filename = new JTextField("stats.csv", 10);
        jtf_filename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVStatistics.this.filename = jtf_filename.getText();
            }
        });
        panel.add("jtf_filename", (JComponent)jtf_filename);
        panel.set_layout("<table><tr><td>file:</td><td>::jtf_filename::</td></tr></table>");
        return panel;
    }

    @Override
    public String getConfigGUITitle() {
        return "statistics export";
    }

    @Override
    public String getName() {
        return "CSV statistics";
    }

    @Override
    public String getLongDescription() {
        return "Exports statistical values for each step to a csv file";
    }

    @Override
    public String getHTMLHelp() {
        return "Insert help here";
    }

    @Override
    public void initFromString(String options) {
        HashMap<String, String> settings = SettingsConverter.stringToMap(options);
        if (settings.get("version") == null || settings.get("version").equalsIgnoreCase("1")) {
            String filename = settings.get("filename");
            if (filename != null) {
                this.filename = filename;
            }
        } else {
            System.err.println("Failed to decode Settings from CSVStatittics: Wrong version, SettingsString: " + options);
        }
    }

    @Override
    public String saveToString() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("version", "1");
        settings.put("filename", this.filename);
        return SettingsConverter.mapToString(settings);
    }

    private boolean isFixed(DMSurface dms) {
        Iterator<IUserDataHandler> iter = dms.getUserDataHandler();
        while (iter.hasNext()) {
            IUserDataHandler handler = iter.next();
            if (!(handler instanceof FixedDataHandler)) continue;
            return true;
        }
        return false;
    }
}

