/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.common.surfaceAdjuster;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.seggen.dm.ISurfaceAdjuster;
import main.seggen.dm.settings.SettingsConverter;
import main.seggen.dm.surface.DMSHelper;
import main.seggen.dm.surface.DMSurface;
import misc.linkedsurface.LinkedTriaSurface;

public class LaPlacianIterativeSmoothing
implements ISurfaceAdjuster {
    public int smooth_cycles = 3;
    public int radius = 1;
    public double scale = 0.3;

    @Override
    public JPanel getConfigGUI() {
        GMPanel panel = new GMPanel();
        final JTextField jtf_smoothing_strength = new JTextField(Double.toString(this.scale), 3);
        jtf_smoothing_strength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_smoothing_strength.getText().length() > 0) {
                    try {
                        LaPlacianIterativeSmoothing.this.scale = Double.parseDouble(jtf_smoothing_strength.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_smoothing_strength.setText(Double.toString(LaPlacianIterativeSmoothing.this.scale));
                    }
                }
            }
        });
        final JTextField jtf_smoothing_radius = new JTextField(Integer.toString(this.radius), 3);
        jtf_smoothing_radius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_smoothing_radius.getText().length() > 0) {
                    try {
                        LaPlacianIterativeSmoothing.this.radius = Integer.parseInt(jtf_smoothing_radius.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_smoothing_radius.setText(Integer.toString(LaPlacianIterativeSmoothing.this.radius));
                    }
                }
            }
        });
        final JTextField jtf_smooth_cycles = new JTextField(Integer.toString(this.smooth_cycles), 3);
        jtf_smooth_cycles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_smooth_cycles.getText().length() > 0) {
                    try {
                        LaPlacianIterativeSmoothing.this.smooth_cycles = Integer.parseInt(jtf_smooth_cycles.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_smooth_cycles.setText(Integer.toString(LaPlacianIterativeSmoothing.this.smooth_cycles));
                    }
                }
            }
        });
        panel.add("jtf_smoothing_radius", (JComponent)jtf_smoothing_radius);
        panel.add("jtf_smoothing_strength", (JComponent)jtf_smoothing_strength);
        panel.add("jtf_smooth_cycles", (JComponent)jtf_smooth_cycles);
        panel.set_layout("<table><tr><td anchor='east'>strength:</td><td>::jtf_smoothing_strength::</td></tr><tr><td anchor='east'>radius:</td><td>::jtf_smoothing_radius::</td></tr><tr><td anchor='east'>cycles:</td><td>::jtf_smooth_cycles::</td></tr></table>");
        return panel;
    }

    @Override
    public String getConfigGUITitle() {
        return "IterativeLaPlacian";
    }

    @Override
    public String getName() {
        return "Iterative LaPlacian Smoothing";
    }

    @Override
    public String getLongDescription() {
        return "";
    }

    @Override
    public String getHTMLHelp() {
        return "fill me";
    }

    @Override
    public void initFromString(String options) {
        HashMap<String, String> settings = SettingsConverter.stringToMap(options);
        if (settings.get("version") == null || settings.get("version").equalsIgnoreCase("1")) {
            String ml = settings.get("scale");
            if (ml != null) {
                this.scale = Double.parseDouble(ml);
            }
            if ((ml = settings.get("radius")) != null) {
                this.radius = Integer.parseInt(ml);
            }
            if ((ml = settings.get("smooth_cycles")) != null) {
                this.smooth_cycles = Integer.parseInt(ml);
            }
        } else {
            System.err.println("Failed to decode Settings from LaPlaceShapePreservation: Wrong version, SettingsString: " + options);
        }
    }

    @Override
    public String saveToString() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("version", "1");
        settings.put("scale", Double.toString(this.scale));
        settings.put("radius", Integer.toString(this.radius));
        settings.put("smooth_cycles", Integer.toString(this.smooth_cycles));
        return SettingsConverter.mapToString(settings);
    }

    @Override
    public void adjustMesh(DMSurface cs) {
        Vector3d change;
        LinkedTriaSurface.LinkedVert lv;
        int i;
        ImageStack is = MasterControl.get_is();
        double x_spacing = is.get_x_spacing();
        double y_spacing = is.get_y_spacing();
        double z_spacing = is.get_z_spacing();
        double min_spacing = Math.min(Math.min(x_spacing, y_spacing), z_spacing);
        int smooth_xmax = (int)Math.round((double)this.smooth_cycles * x_spacing / min_spacing);
        int smooth_ymax = (int)Math.round((double)this.smooth_cycles * y_spacing / min_spacing);
        int smooth_zmax = (int)Math.round((double)this.smooth_cycles * z_spacing / min_spacing);
        Vector3d[] temp = new Vector3d[cs._vlist.size()];
        int smooth_steps = 0;
        while (smooth_steps < smooth_xmax) {
            i = 0;
            while (i < cs._vlist.size()) {
                lv = (LinkedTriaSurface.LinkedVert)cs._vlist.get(i);
                change = this.getLaPlacianSmoothingForVert(lv, this.radius);
                change.y = 0.0;
                change.z = 0.0;
                temp[i] = change;
                ++i;
            }
            i = 0;
            while (i < cs._vlist.size()) {
                temp[i].x *= this.scale;
                ((LinkedTriaSurface.LinkedVert)cs._vlist.get(i)).add((Tuple3d)temp[i]);
                ++i;
            }
            ++smooth_steps;
        }
        smooth_steps = 0;
        while (smooth_steps < smooth_ymax) {
            i = 0;
            while (i < cs._vlist.size()) {
                lv = (LinkedTriaSurface.LinkedVert)cs._vlist.get(i);
                change = this.getLaPlacianSmoothingForVert(lv, this.radius);
                change.x = 0.0;
                change.z = 0.0;
                temp[i] = change;
                ++i;
            }
            i = 0;
            while (i < cs._vlist.size()) {
                temp[i].y *= this.scale;
                ((LinkedTriaSurface.LinkedVert)cs._vlist.get(i)).add((Tuple3d)temp[i]);
                ++i;
            }
            ++smooth_steps;
        }
        smooth_steps = 0;
        while (smooth_steps < smooth_zmax) {
            i = 0;
            while (i < cs._vlist.size()) {
                lv = (LinkedTriaSurface.LinkedVert)cs._vlist.get(i);
                change = this.getLaPlacianSmoothingForVert(lv, this.radius);
                change.x = 0.0;
                change.y = 0.0;
                temp[i] = change;
                ++i;
            }
            i = 0;
            while (i < cs._vlist.size()) {
                temp[i].z *= this.scale;
                ((LinkedTriaSurface.LinkedVert)cs._vlist.get(i)).add((Tuple3d)temp[i]);
                ++i;
            }
            ++smooth_steps;
        }
    }

    private Vector3d getLaPlacianSmoothingForVert(LinkedTriaSurface.LinkedVert lv, int radius) {
        Vector3d cur_vertex = new Vector3d((Tuple3d)lv._p);
        ArrayList<LinkedTriaSurface.LinkedVert> onehop = DMSHelper.getAllUpToNHopsAwayIndices(lv, radius);
        Vector3d resulting_vector = new Vector3d();
        for (LinkedTriaSurface.LinkedVert hoppVert : onehop) {
            Point3d p2 = hoppVert._p;
            Vector3d v2 = new Vector3d(p2.x, p2.y, p2.z);
            v2.sub((Tuple3d)cur_vertex);
            resulting_vector.add((Tuple3d)v2);
        }
        if (onehop.size() > 0) {
            resulting_vector.scale(1.0 / (double)onehop.size());
            return resulting_vector;
        }
        return new Vector3d(0.0, 0.0, 0.0);
    }
}

