/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.common.surfaceAdjuster;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import jgridmaker.GMPanel;
import main.seggen.dm.ISurfaceAdjuster;
import main.seggen.dm.settings.SettingsConverter;
import main.seggen.dm.surface.DMSurface;
import misc.linkedsurface.LinkedTriaSurface;

public class TooBigTriaAdjuster
implements ISurfaceAdjuster {
    public static final String name = "adjuster.toobigtria";
    private double threshold = 20.0;

    public TooBigTriaAdjuster(double threshold) {
        this.threshold = threshold;
    }

    public TooBigTriaAdjuster() {
        this.threshold = 20.0;
    }

    @Override
    public void adjustMesh(DMSurface cs) {
        int i = 0;
        while (i < cs._flist.size()) {
            LinkedTriaSurface.LinkedTria lt = (LinkedTriaSurface.LinkedTria)cs._flist.get(i);
            if (lt.calc_area() > this.threshold) {
                cs.willBeginTransformation(name, lt);
                Point3d p_center = new Point3d();
                p_center.add((Tuple3d)lt._a._p);
                p_center.add((Tuple3d)lt._b._p);
                p_center.add((Tuple3d)lt._c._p);
                p_center.scale(0.3333333333333333);
                LinkedTriaSurface.LinkedVert center = cs.add_vert(p_center);
                cs.del_face(lt);
                cs.add_face(lt._a, lt._b, center);
                cs.add_face(lt._b, lt._c, center);
                cs.add_face(lt._c, lt._a, center);
                cs.didEndTransformation(name, center);
            }
            ++i;
        }
    }

    @Override
    public JPanel getConfigGUI() {
        GMPanel panel = new GMPanel();
        final JTextField jtf_max_tria_area = new JTextField(Double.toString(this.threshold), 3);
        jtf_max_tria_area.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_max_tria_area.getText().length() > 0) {
                    try {
                        TooBigTriaAdjuster.this.threshold = Double.parseDouble(jtf_max_tria_area.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_max_tria_area.setText(Double.toString(TooBigTriaAdjuster.this.threshold));
                    }
                }
            }
        });
        panel.add("jtf_max_tria_area", (JComponent)jtf_max_tria_area);
        panel.set_layout("<table><tr><td align='right'>::jtf_max_tria_area::</td><td align='left'>mm\u00b2</td></tr></table>");
        return panel;
    }

    @Override
    public String getConfigGUITitle() {
        return "max triangle area";
    }

    @Override
    public String getName() {
        return "TooBigTriaAdjuster";
    }

    @Override
    public String getLongDescription() {
        return "Splits  up too big triangles into three new ones";
    }

    @Override
    public String getHTMLHelp() {
        return null;
    }

    @Override
    public void initFromString(String options) {
        HashMap<String, String> settings = SettingsConverter.stringToMap(options);
        if (settings.get("version") == null || settings.get("version").equalsIgnoreCase("1")) {
            String ml = settings.get("max_area");
            if (ml != null) {
                this.threshold = Double.parseDouble(ml);
            }
        } else {
            System.err.println("Failed to decode Settings from TooBigTriaAdjuster: Wrong version, SettingsString: " + options);
        }
    }

    @Override
    public String saveToString() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("version", "1");
        settings.put("max_area", Double.toString(this.threshold));
        return SettingsConverter.mapToString(settings);
    }
}

