/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.common.surfaceAdjuster;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import jgridmaker.GMPanel;
import main.seggen.dm.ISurfaceAdjuster;
import main.seggen.dm.settings.SettingsConverter;
import main.seggen.dm.surface.DMSurface;
import misc.linkedsurface.LinkedTriaSurface;

public class TooLongEdgeAdjuster
implements ISurfaceAdjuster {
    public static final String name = "adjuster.toolongedge";
    private double max_length;
    private boolean fast = false;

    public TooLongEdgeAdjuster() {
        this.max_length = 4.0;
    }

    public TooLongEdgeAdjuster(double max_length) {
        this(max_length, false);
    }

    public TooLongEdgeAdjuster(double max_length, boolean fast) {
        this.max_length = max_length;
        this.fast = fast;
    }

    @Override
    public void adjustMesh(DMSurface cs) {
        double max_length_squared = this.max_length * this.max_length;
        LinkedList<LinkedTriaSurface.LinkedEdge> prob_too_long_edges = new LinkedList<LinkedTriaSurface.LinkedEdge>();
        for (LinkedTriaSurface.LinkedEdge le : cs._elist) {
            if (!(le.length_squared() > max_length_squared)) continue;
            prob_too_long_edges.add(le);
        }
        if (!this.fast) {
            Collections.sort(prob_too_long_edges, new InvertedLinkedEdgeComparator());
        }
        while (prob_too_long_edges.size() > 0) {
            LinkedTriaSurface.LinkedEdge le;
            le = (LinkedTriaSurface.LinkedEdge)prob_too_long_edges.getFirst();
            prob_too_long_edges.removeFirst();
            if (!cs._elist.contains(le)) continue;
            if (le.length_squared() > max_length_squared) {
                LinkedTriaSurface.LinkedTria t2;
                LinkedTriaSurface.LinkedTria t1;
                cs.willBeginTransformation(name, le);
                if (le.compare_orientation(le._fp.getFirst())) {
                    t1 = le._fp.getFirst();
                    t2 = le._fp.getLast();
                } else {
                    t1 = le._fp.getLast();
                    t2 = le._fp.getFirst();
                }
                LinkedTriaSurface.LinkedVert p1 = le._a;
                LinkedTriaSurface.LinkedVert p2 = le._b;
                LinkedTriaSurface.LinkedVert p3 = this.getThirdVert(t1, le);
                LinkedTriaSurface.LinkedVert p4 = this.getThirdVert(t2, le);
                Point3d temp_p5 = new Point3d(p2._p);
                temp_p5.sub((Tuple3d)p1._p);
                temp_p5.scale(0.5);
                temp_p5.add((Tuple3d)p1._p);
                cs.del_face(t1);
                cs.del_face(t2);
                LinkedTriaSurface.LinkedVert p5 = cs.add_vert(temp_p5);
                cs.add_face(p1, p5, p3);
                cs.add_face(p5, p2, p3);
                cs.add_face(p1, p4, p5);
                cs.add_face(p4, p2, p5);
                cs.didEndTransformation(name, p5);
                continue;
            }
            if (!this.fast) break;
        }
    }

    private LinkedTriaSurface.LinkedVert getThirdVert(LinkedTriaSurface.LinkedTria lt, LinkedTriaSurface.LinkedEdge le) {
        if (lt._ab == le) {
            return lt._c;
        }
        if (lt._bc == le) {
            return lt._a;
        }
        return lt._b;
    }

    @Override
    public JPanel getConfigGUI() {
        GMPanel panel = new GMPanel();
        final JTextField jtf_max_edge_length = new JTextField(Double.toString(this.max_length), 3);
        jtf_max_edge_length.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_max_edge_length.getText().length() > 0) {
                    try {
                        TooLongEdgeAdjuster.this.max_length = Double.parseDouble(jtf_max_edge_length.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_max_edge_length.setText(Double.toString(TooLongEdgeAdjuster.this.max_length));
                    }
                }
            }
        });
        panel.add("jtf_max_edge_length", (JComponent)jtf_max_edge_length);
        panel.set_layout("<table><tr><td align='right'>::jtf_max_edge_length::</td><td align='left'>mm</td></tr></table>");
        return panel;
    }

    @Override
    public String getConfigGUITitle() {
        return "max edge length";
    }

    @Override
    public String getName() {
        return "TooLongEdgeAdjuster";
    }

    @Override
    public String getLongDescription() {
        return "Splits too long edges by insert a new vertex in the middle";
    }

    @Override
    public String getHTMLHelp() {
        return "Insert help here";
    }

    @Override
    public void initFromString(String options) {
        HashMap<String, String> settings = SettingsConverter.stringToMap(options);
        if (settings.get("version") == null || settings.get("version").equalsIgnoreCase("1")) {
            String fast_str;
            String ml = settings.get("max_length");
            if (ml != null) {
                this.max_length = Double.parseDouble(ml);
            }
            if ((fast_str = settings.get("fast")) != null) {
                this.fast = "true".equalsIgnoreCase(fast_str);
            }
        } else {
            System.err.println("Failed to decode Settings from TooLongEdgeAdjuster: Wrong version, SettingsString: " + options);
        }
    }

    @Override
    public String saveToString() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("version", "1");
        settings.put("max_length", Double.toString(this.max_length));
        if (this.fast) {
            settings.put("fast", "true");
        } else {
            settings.put("fast", "false");
        }
        return SettingsConverter.mapToString(settings);
    }

    public class InvertedLinkedEdgeComparator
    implements Comparator<LinkedTriaSurface.LinkedEdge> {
        @Override
        public int compare(LinkedTriaSurface.LinkedEdge le1, LinkedTriaSurface.LinkedEdge le2) {
            return -1 * (int)(le1.length_squared() - le2.length_squared());
        }
    }
}

