/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.common.surfaceAdjuster;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import jgridmaker.GMPanel;
import main.seggen.dm.ISurfaceAdjuster;
import main.seggen.dm.settings.SettingsConverter;
import main.seggen.dm.surface.DMSurface;
import misc.StopWatch;
import misc.linkedsurface.LinkedTriaSurface;

public class TooShortEdgeAdjuster
implements ISurfaceAdjuster {
    public static final String name = "adjuster.tooshortedge";
    private double min_length;
    private boolean fast = false;

    public TooShortEdgeAdjuster() {
        this.min_length = 2.0;
    }

    public TooShortEdgeAdjuster(double min_length) {
        this(min_length, false);
    }

    public TooShortEdgeAdjuster(double min_length, boolean fast) {
        this.min_length = min_length;
        this.fast = fast;
    }

    @Override
    public void adjustMesh(DMSurface cs) {
        double min_length_squared = this.min_length * this.min_length;
        LinkedList<LinkedTriaSurface.LinkedEdge> prob_too_short_edges = new LinkedList<LinkedTriaSurface.LinkedEdge>();
        for (LinkedTriaSurface.LinkedEdge le : cs._elist) {
            if (!(le.length_squared() < min_length_squared)) continue;
            prob_too_short_edges.add(le);
        }
        if (!this.fast) {
            Collections.sort(prob_too_short_edges, new InvertedLinkedEdgeComparator());
        }
        StopWatch sw = new StopWatch();
        sw.start();
        while (prob_too_short_edges.size() > 0) {
            LinkedTriaSurface.LinkedEdge le = (LinkedTriaSurface.LinkedEdge)prob_too_short_edges.removeFirst();
            if (!cs._elist.contains(le)) continue;
            if (le.length_squared() < min_length_squared) {
                cs.willBeginTransformation(name, le);
                LinkedTriaSurface.LinkedTria t1 = le._fp.getFirst();
                LinkedTriaSurface.LinkedTria t2 = le._fp.getLast();
                LinkedTriaSurface.LinkedVert p1 = le._a;
                LinkedTriaSurface.LinkedVert p2 = le._b;
                Point3d temp_p5 = new Point3d(p2._p);
                temp_p5.sub((Tuple3d)p1._p);
                temp_p5.scale(0.5);
                temp_p5.add((Tuple3d)p1._p);
                LinkedList<LinkedTriaSurface.LinkedTria> trias = new LinkedList<LinkedTriaSurface.LinkedTria>();
                for (LinkedTriaSurface.LinkedTria lt : le._a._fp) {
                    if (lt == t1 || lt == t2) continue;
                    trias.add(lt);
                }
                for (LinkedTriaSurface.LinkedTria lt : le._b._fp) {
                    if (lt == t1 || lt == t2) continue;
                    trias.add(lt);
                }
                LinkedTriaSurface.LinkedVert lea = le._a;
                LinkedTriaSurface.LinkedVert leb = le._b;
                cs.del_face(t1);
                cs.del_face(t2);
                cs.del_edge(le);
                cs.del_vert(lea);
                cs.del_vert(leb);
                LinkedTriaSurface.LinkedVert newVert = cs.add_vert(temp_p5);
                for (LinkedTriaSurface.LinkedTria lt : trias) {
                    if (lt._a == p1 || lt._a == p2) {
                        cs.add_face(newVert, lt._b, lt._c);
                    } else if (lt._b == p1 || lt._b == p2) {
                        cs.add_face(lt._a, newVert, lt._c);
                    } else {
                        cs.add_face(lt._a, lt._b, newVert);
                    }
                    cs.del_face(lt);
                }
                cs.didEndTransformation(name, newVert);
                continue;
            }
            if (!this.fast) break;
        }
        sw.stop();
    }

    @Override
    public JPanel getConfigGUI() {
        GMPanel panel = new GMPanel();
        final JTextField jtf_min_edge_length = new JTextField(Double.toString(this.min_length), 3);
        jtf_min_edge_length.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (jtf_min_edge_length.getText().length() > 0) {
                    try {
                        TooShortEdgeAdjuster.this.min_length = Double.parseDouble(jtf_min_edge_length.getText());
                    }
                    catch (NumberFormatException e) {
                        jtf_min_edge_length.setText(Double.toString(TooShortEdgeAdjuster.this.min_length));
                    }
                }
            }
        });
        panel.add("jtf_min_edge_length", (JComponent)jtf_min_edge_length);
        panel.set_layout("<table><tr><td align='right'>::jtf_min_edge_length::</td><td align='left'>mm</td></tr></table>");
        return panel;
    }

    @Override
    public String getConfigGUITitle() {
        return "min edge length";
    }

    @Override
    public String getName() {
        return "Too short edge adjuster";
    }

    @Override
    public String getLongDescription() {
        return "Surface djuster that removes too short edges by combining its two vertices into a new one";
    }

    @Override
    public String getHTMLHelp() {
        return "Insert help here";
    }

    @Override
    public void initFromString(String options) {
        HashMap<String, String> settings = SettingsConverter.stringToMap(options);
        if (settings.get("version") == null || settings.get("version").equalsIgnoreCase("1")) {
            String fast_str;
            String ml = settings.get("min_length");
            if (ml != null) {
                this.min_length = Double.parseDouble(ml);
            }
            if ((fast_str = settings.get("fast")) != null) {
                this.fast = "true".equalsIgnoreCase(fast_str);
            }
        } else {
            System.err.println("Failed to decode Settings from TooShortEdgeAdjuster: Wrong version, SettingsString: " + options);
        }
    }

    @Override
    public String saveToString() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("version", "1");
        settings.put("min_length", Double.toString(this.min_length));
        if (this.fast) {
            settings.put("fast", "true");
        } else {
            settings.put("fast", "false");
        }
        return SettingsConverter.mapToString(settings);
    }

    public class InvertedLinkedEdgeComparator
    implements Comparator<LinkedTriaSurface.LinkedEdge> {
        @Override
        public int compare(LinkedTriaSurface.LinkedEdge le1, LinkedTriaSurface.LinkedEdge le2) {
            return -1 * (int)(le1.length_squared() - le2.length_squared());
        }
    }

    public class LinkedEdgeComparator
    implements Comparator<LinkedTriaSurface.LinkedEdge> {
        @Override
        public int compare(LinkedTriaSurface.LinkedEdge le1, LinkedTriaSurface.LinkedEdge le2) {
            return (int)(le1.length_squared() - le2.length_squared());
        }
    }
}

