/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.editor;

import gui.JTFSliderInt;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import main.MasterControl;
import main.seggen.dm.editor.LabelDialog;
import main.seggen.dm.editor.LabelEditorPanel;
import main.seggen.dm.editor.LabelList;
import main.seggen.dm.editor.YDMEditor;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.Label;
import misc.linkedsurface.LinkedTriaSurface;

public class EdgePanel
extends LabelEditorPanel {
    private LabelList<LinkedTriaSurface.LinkedEdge> _all_label_list = new LabelList();
    private LabelList<LinkedTriaSurface.LinkedEdge> _obj_label_list = new LabelList();
    private LinkedTriaSurface.LinkedEdge[] _edges;
    private LinkedTriaSurface.LinkedEdge _le;

    public EdgePanel() {
        this.jtfi_index.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                if (JTFSliderInt.JTF_CHANGE.equals(property)) {
                    EdgePanel.this._le = EdgePanel.this._edges[EdgePanel.this.jtfi_index.getValue()];
                    EdgePanel.this.update_obj_labels(true);
                }
            }
        });
        this._jb_add_to.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Label label : EdgePanel.this._all_label_list.get_selected_labels()) {
                    label.add_element(EdgePanel.this._le);
                }
                EdgePanel.this.update_obj_labels(true);
                YDMEditor._canvas.edge_label_changed(EdgePanel.this._le);
                YDMEditor._canvas.show_edge(EdgePanel.this._le);
            }
        });
        this._jb_del_from.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Label label : EdgePanel.this._obj_label_list.get_selected_labels()) {
                    label.del_element(EdgePanel.this._le);
                }
                EdgePanel.this.update_obj_labels(true);
                YDMEditor._canvas.edge_label_changed(EdgePanel.this._le);
                YDMEditor._canvas.show_edge(EdgePanel.this._le);
            }
        });
        this._jb_new.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMSurface sf = YDMEditor._model;
                LabelDialog ld = new LabelDialog(null, sf._edge_labels);
                ld.setVisible(true);
                EdgePanel.this.update_all_labels();
            }
        });
        this._jb_edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Label label = EdgePanel.this.get_selected_single();
                if (label != null) {
                    DMSurface sf = YDMEditor._model;
                    LabelDialog ld = new LabelDialog(label, sf._edge_labels);
                    ld.setVisible(true);
                    YDMEditor._canvas.update_edge_label_color(label);
                    EdgePanel.this.update_all_labels();
                }
            }
        });
        this._jb_delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int n = JOptionPane.showConfirmDialog(MasterControl.get_window(), "Really delete the selected label(s) ?", "Please Confirm", 0);
                if (n == 0) {
                    DMSurface sf = YDMEditor._model;
                    for (Label label : EdgePanel.this._all_label_list.get_selected_labels()) {
                        sf._edge_labels.remove(label.id);
                        label.clear();
                    }
                    YDMEditor._canvas.update_all_edge_label_colors();
                    EdgePanel.this.update_all_labels();
                }
            }
        });
        this.add("obj_labels", this._obj_label_list);
        this.add("all_labels", this._all_label_list);
        this.set_layout("<table width='100%' height='100%' border='0'>  <colgroup>    <col width='49%' />    <col width='2%' />    <col width='49%' />  </colgroup>  <tr height='1%'>    <td fill='horizontal' colspan='3'>Select Edge</td>  </tr><tr height='1%'>    <td fill='horizontal' colspan='3'>::idx_slider::</td>  </tr><tr height='1%'>    <td>Object Labels</td>    <td></td>    <td>All Labels</td>  </tr><tr height='97%'>    <td fill='both'>::obj_labels::</td>    <td><table><tr><td>::add_to::</td></tr><tr><td>::del_from::</td></tr></table></td>    <td fill='both'>::all_labels::</td>  </tr><tr height='1%'>    <td colspan='2'></td>    <td fill='horizontal'>      <table cellpadding='1' cellspacing='0' margin='0' width='100%'>        <tr>          <td width='1%'>::new::</td>          <td width='1%'>::edit::</td>          <td width='1%'>::delete::</td>          <td width='97%' anchor='east'>::paint::</td>        </tr>      </table>    </td>  </tr></table>");
    }

    private Label<LinkedTriaSurface.LinkedEdge> get_selected_single() {
        LinkedList<Label<LinkedTriaSurface.LinkedEdge>> selected = this._all_label_list.get_selected_labels();
        if (selected.size() == 0) {
            JOptionPane.showMessageDialog(YDMEditor._win, "You need to select a Label first", "Nothing selected", 2);
            return null;
        }
        if (selected.size() > 1) {
            JOptionPane.showMessageDialog(YDMEditor._win, "Please select only one Label!", "More than one Label selected", 2);
            return null;
        }
        return selected.getFirst();
    }

    public void update_all_labels() {
        DMSurface sf = YDMEditor._model;
        this._all_label_list.clear();
        for (String id : sf._edge_labels.keySet()) {
            this._all_label_list.add_label(sf._edge_labels.get(id));
        }
    }

    public void surface_loaded() {
        DMSurface sf = YDMEditor._model;
        this.update_all_labels();
        this._edges = new LinkedTriaSurface.LinkedEdge[sf._elist.size()];
        Iterator lei = sf._elist.iterator();
        int edge_idx = 0;
        while (lei.hasNext()) {
            this._edges[edge_idx++] = (LinkedTriaSurface.LinkedEdge)lei.next();
        }
        this.jtfi_index.setMaximum(sf._elist.size() - 1);
        this._le = this._edges[0];
        this.update_obj_labels(false);
    }

    public void update_obj_labels(boolean show) {
        this._obj_label_list.clear();
        DMSurface sf = YDMEditor._model;
        for (String id : sf._edge_labels.keySet()) {
            Label<LinkedTriaSurface.LinkedEdge> label = sf._edge_labels.get(id);
            if (!label.contains(this._le)) continue;
            this._obj_label_list.add_label(label);
        }
        if (show) {
            YDMEditor._canvas.show_vert(null);
            YDMEditor._canvas.show_tria(null);
            YDMEditor._canvas.show_edge(this._le);
        }
    }

    public void toggle_selection() {
        if (this._all_label_list.get_selected_labels().size() != 1) {
            return;
        }
        Label<LinkedTriaSurface.LinkedEdge> le_label = this._all_label_list.get_selected_labels().getFirst();
        if (le_label.contains(this._le)) {
            le_label.del_element(this._le);
        } else {
            le_label.add_element(this._le);
        }
        this.update_obj_labels(true);
        YDMEditor._canvas.edge_label_changed(this._le);
        YDMEditor._canvas.show_edge(this._le);
    }
}

