/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.editor;

import gui.JColorChooseButton;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgridmaker.JGridMaker;
import main.seggen.dm.editor.YDMEditor;
import main.seggen.dm.surface.Label;
import misc.helper.Helper;

public class LabelDialog<E>
extends JDialog {
    private static LabelDialog<?> _instance;
    private JTextField _jtf_name;
    private JColorChooseButton _jcbc_color;
    public static int[] DEF_COLORS;
    private final Label<E> _label;
    private final JLabel _jl_error_msg = new JLabel(" ");

    static {
        DEF_COLORS = new int[]{65280, 255, 65535, 43588, 17578, 8789, 21794, 0x224422};
    }

    public String to_color_string(Color c) {
        String b;
        String g;
        String r = Integer.toHexString(c.getRed());
        if (r.length() == 1) {
            r = "0" + r;
        }
        if ((g = Integer.toHexString(c.getGreen())).length() == 1) {
            g = "0" + g;
        }
        if ((b = Integer.toHexString(c.getBlue())).length() == 1) {
            b = "0" + b;
        }
        return "#" + r + g + b;
    }

    public LabelDialog(Label<E> label, final HashMap<String, Label<E>> map) {
        super((Frame)YDMEditor._win, true);
        this._label = label;
        if (this._label == null) {
            this.setTitle("Create New Label");
            this._jtf_name = new JTextField(Helper.get_unique_key("label", map.keySet()), 20);
            this._jcbc_color = new JColorChooseButton(Color.RED);
        } else {
            this.setTitle("Edit Label");
            this._jtf_name = new JTextField(this._label.id, 20);
            this._jcbc_color = new JColorChooseButton(Color.decode(this._label.color));
        }
        JButton jb_ok = new JButton("Ok");
        jb_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String id = LabelDialog.this._jtf_name.getText();
                String col = LabelDialog.this.to_color_string(LabelDialog.this._jcbc_color.getSelectedColor());
                if (LabelDialog.this._label == null) {
                    if (map.containsKey(id)) {
                        LabelDialog.this._jl_error_msg.setText("Label ID must be unique!");
                    } else {
                        Label l = new Label(id, col);
                        map.put(id, l);
                        _instance.setVisible(false);
                    }
                } else if (!id.equals(((LabelDialog)LabelDialog.this)._label.id)) {
                    if (map.containsKey(id)) {
                        LabelDialog.this._jl_error_msg.setText("Label ID must be unique!");
                    } else {
                        map.remove(((LabelDialog)LabelDialog.this)._label.id);
                        ((LabelDialog)LabelDialog.this)._label.id = id;
                        ((LabelDialog)LabelDialog.this)._label.color = col;
                        map.put(((LabelDialog)LabelDialog.this)._label.id, LabelDialog.this._label);
                        _instance.setVisible(false);
                    }
                } else {
                    ((LabelDialog)LabelDialog.this)._label.color = col;
                    map.put(((LabelDialog)LabelDialog.this)._label.id, LabelDialog.this._label);
                    _instance.setVisible(false);
                }
            }
        });
        JButton jb_cancel = new JButton("Cancel");
        jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                _instance.setVisible(false);
            }
        });
        HashMap<String, JComponent> obj_map = new HashMap<String, JComponent>();
        obj_map.put("label_name", this._jtf_name);
        obj_map.put("label_color", this._jcbc_color);
        obj_map.put("jb_ok", jb_ok);
        obj_map.put("jb_cancel", jb_cancel);
        obj_map.put("error_msg", this._jl_error_msg);
        String layout_str1 = new String("<table width='100%' cellpadding='2' border='0'>  <tr>    <td>::jb_ok::</td>    <td>::jb_cancel::</td>  </tr></table>");
        JPanel button_panel = new JPanel();
        JGridMaker.make_grid((Container)button_panel, (String)layout_str1, obj_map);
        obj_map.put("button_panel", button_panel);
        JGridMaker.make_grid((Container)this, (String)"<table width='100%' cellpadding='2' margin='10' border='0'>  <tr>    <td>Name:</td>    <td>::label_name::</td>  </tr><tr>    <td>Color:</td>    <td anchor='west'>::label_color::</td>  </tr><tr>    <td colspan='2'>::error_msg::</td>  </tr><tr>    <td colspan='2'>::button_panel::</td>  </tr></table>", obj_map);
        this.pack();
        int pw = YDMEditor._win.getWidth();
        int ph = YDMEditor._win.getHeight();
        int px = YDMEditor._win.getLocation().x;
        int py = YDMEditor._win.getLocation().y;
        int w = this.getWidth();
        int h = this.getHeight();
        this.setLocation(px + pw / 2 - w / 2, py + ph / 2 - h / 2);
        _instance = this;
    }
}

