/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import main.seggen.dm.surface.Label;

public class LabelList<E>
extends JPanel
implements ListSelectionListener {
    public static String LIST_SELECTION_CHANGED = "__label__selector__";
    protected final JList _jl_label_list;
    protected final DefaultListModel _label_list_model;
    protected final LinkedList<Label<E>> _selected_labels = new LinkedList();
    protected JLabel _label;

    public LabelList() {
        this._label_list_model = new DefaultListModel();
        this._jl_label_list = new JList(this._label_list_model);
        this._jl_label_list.setCellRenderer(new MyCellRenderer());
        this._jl_label_list.setSelectionMode(0);
        this._jl_label_list.addListSelectionListener(this);
        JScrollPane jsp_list_scroller = new JScrollPane(this._jl_label_list);
        jsp_list_scroller.setHorizontalScrollBarPolicy(31);
        jsp_list_scroller.setVerticalScrollBarPolicy(22);
        this.setLayout(new BorderLayout());
        this.add((Component)jsp_list_scroller, "Center");
    }

    public LinkedList<Label<E>> get_selected_labels() {
        return this._selected_labels;
    }

    public boolean check_for_changes() {
        boolean change = false;
        int i = 0;
        while (i < this._label_list_model.getSize()) {
            Label label = (Label)this._label_list_model.getElementAt(i);
            if (this._jl_label_list.isSelectedIndex(i)) {
                if (!this._selected_labels.contains(label)) {
                    this._selected_labels.add(label);
                    change = true;
                }
            } else if (this._selected_labels.contains(label)) {
                this._selected_labels.remove(label);
                change = true;
            }
            ++i;
        }
        return change;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.check_for_changes()) {
            this.firePropertyChange(LIST_SELECTION_CHANGED, null, null);
        }
    }

    public void add_label(Label<?> l) {
        this._label_list_model.addElement(l);
    }

    public void del_label(Label<?> l) {
        this._selected_labels.remove(l);
        this._label_list_model.removeElement(l);
        this.check_for_changes();
        this.firePropertyChange(LIST_SELECTION_CHANGED, null, null);
    }

    public void clear() {
        this._selected_labels.clear();
        this._label_list_model.clear();
        this.firePropertyChange(LIST_SELECTION_CHANGED, null, null);
    }

    final class MyCellRenderer
    extends JPanel
    implements ListCellRenderer {
        final JLabel _jl_text;
        final JPanel _jp_color_box;

        public MyCellRenderer() {
            this.setOpaque(true);
            this._jl_text = new JLabel("---");
            Dimension box_size = new Dimension(12, 12);
            this._jp_color_box = new JPanel();
            this._jp_color_box.setPreferredSize(box_size);
            this._jp_color_box.setMaximumSize(box_size);
            this._jp_color_box.setMinimumSize(box_size);
            this._jp_color_box.setOpaque(true);
            this._jp_color_box.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
            JPanel jp_color_box_parent = new JPanel(new FlowLayout());
            jp_color_box_parent.setOpaque(false);
            jp_color_box_parent.add(this._jp_color_box);
            this.setLayout(new BorderLayout());
            this.add((Component)jp_color_box_parent, "West");
            this.add((Component)this._jl_text, "Center");
            Label protoype_label = new Label("WhatAGoodName", "#ff00f");
            LabelList.this._jl_label_list.setPrototypeCellValue(protoype_label);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Label) {
                Color def_fg;
                Color def_bg;
                Label label = (Label)value;
                this._jl_text.setText(label.id);
                this._jp_color_box.setBackground(Color.decode(label.color));
                if (isSelected) {
                    def_bg = list.getSelectionBackground();
                    def_fg = list.getSelectionForeground();
                } else {
                    def_bg = list.getBackground();
                    def_fg = list.getForeground();
                }
                Color bg = new Color(def_bg.getRed(), def_bg.getGreen(), def_bg.getBlue());
                Color fg = new Color(def_fg.getRed(), def_fg.getGreen(), def_fg.getBlue());
                this.setBackground(bg);
                this.setForeground(fg);
            }
            return this;
        }
    }
}

