/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.editor;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import main.seggen.dm.editor.YDMEditor;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.Label;
import misc.linkedsurface.IndexData;
import misc.linkedsurface.LTSStripeSearch;
import misc.linkedsurface.LinkedTriaSurface;

public class MyCanvas
extends Canvas3D
implements MouseListener {
    private static Color3f DEFAULT_TRIA_COLOR = new Color3f(0.8f, 0.8f, 0.8f);
    private static Color3f DEFAULT_EDGE_COLOR = new Color3f(0.4f, 0.4f, 0.4f);
    private static Color3f DEFAULT_BG_COLOR = new Color3f(0.0f, 0.0f, 0.0f);
    private PolygonAttributes _trias_poly_att;
    private Appearance _trias_ap;
    private Transform3D _tf_scale;
    private Transform3D _tf_scale2;
    private TransformGroup _tg_scale;
    private TransformGroup _tg_scale2;
    private Shape3D _trias_shp;
    private Shape3D _verts_shp;
    private Shape3D _edges_shp;
    private Shape3D _v_shape;
    private Shape3D _t_shape;
    private Shape3D _e_shape;
    private PointArray _verts_pa;
    private IndexedGeometryArray _trias_ita;
    private LineArray _edges_la;
    private Appearance _e_shape_ap;
    private Color3f[] _vert_colors;
    private Color3f[] _tria_colors;
    private Color3f[] _tria_def_colors;
    private Color3f[] _edge_colors;
    private Color3f _bg_color = new Color3f(DEFAULT_BG_COLOR);
    private DMSurface _model;
    private LTSStripeSearch _lts_search;
    private Background _background;
    private boolean _show_vert_labels = true;
    private boolean _show_tria_labels = true;
    private boolean _show_edge_labels = true;
    private PickCanvas pickCanvas;
    private LinkedTriaSurface.LinkedTria _last_tria;

    public Color get_bg_color() {
        return this._bg_color.get();
    }

    public void set_bg_color(Color col) {
        this._bg_color.set(col);
        this._background.setColor(this._bg_color);
    }

    public Appearance create_vert_ap(int size) {
        Appearance ap = new Appearance();
        PointAttributes point_att = new PointAttributes();
        point_att.setPointAntialiasingEnable(true);
        point_att.setPointSize((float)size);
        ap.setPointAttributes(point_att);
        ColoringAttributes col_att = new ColoringAttributes();
        col_att.setColor(new Color3f(1.0f, 1.0f, 1.0f));
        ap.setColoringAttributes(col_att);
        return ap;
    }

    public Appearance create_show_tria_ap() {
        Appearance ap = new Appearance();
        PolygonAttributes poly_att = new PolygonAttributes();
        poly_att.setPolygonMode(1);
        ap.setPolygonAttributes(poly_att);
        LineAttributes line_att = new LineAttributes();
        line_att.setLineWidth(6.0f);
        ap.setLineAttributes(line_att);
        ColoringAttributes col_att = new ColoringAttributes();
        col_att.setColor(new Color3f(1.0f, 1.0f, 1.0f));
        ap.setColoringAttributes(col_att);
        return ap;
    }

    public Appearance create_show_edge_ap(int width) {
        Appearance ap = new Appearance();
        LineAttributes line_att = new LineAttributes();
        line_att.setLineWidth((float)width);
        ap.setLineAttributes(line_att);
        ColoringAttributes col_att = new ColoringAttributes();
        col_att.setColor(new Color3f(1.0f, 1.0f, 1.0f));
        ap.setColoringAttributes(col_att);
        return ap;
    }

    private void create_scene() {
        SimpleUniverse su = new SimpleUniverse((Canvas3D)this);
        ViewingPlatform vp = su.getViewingPlatform();
        vp.setNominalViewingTransform();
        BranchGroup obj_root = new BranchGroup();
        BoundingSphere _bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        OrbitBehavior ob = new OrbitBehavior((Canvas3D)this, 48);
        ob.setSchedulingBounds((Bounds)_bounds);
        vp.setViewPlatformBehavior((ViewPlatformBehavior)ob);
        DirectionalLight light0 = new DirectionalLight(new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f));
        light0.setInfluencingBounds((Bounds)_bounds);
        DirectionalLight light1 = new DirectionalLight(new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(-0.5f, -0.2f, 1.0f));
        light1.setInfluencingBounds((Bounds)_bounds);
        AmbientLight light2 = new AmbientLight(new Color3f(0.5f, 0.5f, 0.5f));
        light2.setInfluencingBounds((Bounds)_bounds);
        PlatformGeometry pg = new PlatformGeometry();
        pg.addChild((Node)light0);
        pg.addChild((Node)light1);
        pg.addChild((Node)light2);
        vp.setPlatformGeometry(pg);
        this._tf_scale = new Transform3D();
        this._tg_scale = new TransformGroup(this._tf_scale);
        this._tg_scale.setCapability(18);
        this._tf_scale2 = new Transform3D();
        this._tg_scale2 = new TransformGroup(this._tf_scale2);
        this._tg_scale2.setCapability(18);
        this._trias_ap = new Appearance();
        ColoringAttributes col_att = new ColoringAttributes();
        col_att.setShadeModel(3);
        this._trias_ap.setColoringAttributes(col_att);
        Material mat = new Material();
        mat.setAmbientColor(new Color3f(0.2f, 0.2f, 0.2f));
        mat.setDiffuseColor(new Color3f(0.7f, 0.7f, 0.7f));
        mat.setSpecularColor(new Color3f(0.6f, 0.6f, 0.6f));
        this._trias_ap.setMaterial(mat);
        this._trias_poly_att = new PolygonAttributes();
        this._trias_poly_att.setCapability(3);
        this._trias_poly_att.setPolygonMode(2);
        this._trias_poly_att.setCullFace(0);
        this._trias_ap.setPolygonAttributes(this._trias_poly_att);
        this._trias_shp = new Shape3D(null, this._trias_ap);
        this._trias_shp.setCapability(13);
        this._trias_shp.setPickable(true);
        this._verts_shp = new Shape3D(null, this.create_vert_ap(6));
        this._verts_shp.setCapability(13);
        this._verts_shp.setPickable(false);
        this._edges_shp = new Shape3D(null, this.create_show_edge_ap(2));
        this._edges_shp.setCapability(13);
        this._edges_shp.setPickable(false);
        this._background = new Background();
        this._background.setApplicationBounds((Bounds)_bounds);
        this._background.setCapability(17);
        this._background.setColor(this._bg_color);
        this._v_shape = new Shape3D(null, this.create_vert_ap(10));
        this._v_shape.setCapability(13);
        this._v_shape.setPickable(false);
        this._t_shape = new Shape3D(null, this.create_show_tria_ap());
        this._t_shape.setCapability(13);
        this._t_shape.setPickable(false);
        this._e_shape_ap = this.create_show_edge_ap(8);
        this._e_shape_ap.getColoringAttributes().setCapability(1);
        this._e_shape = new Shape3D(null, this._e_shape_ap);
        this._e_shape.setCapability(13);
        this._e_shape.setPickable(false);
        this._tg_scale.addChild((Node)this._trias_shp);
        this._tg_scale2.addChild((Node)this._verts_shp);
        this._tg_scale.addChild((Node)this._edges_shp);
        this._tg_scale2.addChild((Node)this._v_shape);
        this._tg_scale.addChild((Node)this._t_shape);
        this._tg_scale.addChild((Node)this._e_shape);
        obj_root.addChild((Node)this._background);
        obj_root.addChild((Node)this._tg_scale);
        obj_root.addChild((Node)this._tg_scale2);
        this.pickCanvas = new PickCanvas((Canvas3D)this, obj_root);
        this.pickCanvas.setMode(1024);
        this.pickCanvas.setTolerance(4.0f);
        this.addMouseListener(this);
        su.addBranchGraph(obj_root);
    }

    public MyCanvas() {
        super(SimpleUniverse.getPreferredConfiguration());
        this.create_scene();
    }

    private void update_vert_color(LinkedTriaSurface.LinkedVert lv) {
        DMSurface model = YDMEditor._model;
        Iterator<String> id_it = model._vert_labels.keySet().iterator();
        Vector3f vert_col_buffer = new Vector3f((Tuple3f)DEFAULT_TRIA_COLOR);
        int count = 1;
        while (id_it.hasNext()) {
            Label<LinkedTriaSurface.LinkedVert> label = model._vert_labels.get(id_it.next());
            Color3f col = new Color3f(Color.decode(label.color));
            if (!label.contains(lv)) continue;
            vert_col_buffer.add((Tuple3f)col);
            ++count;
        }
        vert_col_buffer.scale(1.0f / (float)count);
        int vert_idx = ((IndexData)lv.get_user_data((int)IndexData._DATA_ID))._i;
        this._vert_colors[vert_idx] = new Color3f((Tuple3f)vert_col_buffer);
    }

    public void update_vert_label_color(Label<LinkedTriaSurface.LinkedVert> label) {
        Iterator<LinkedTriaSurface.LinkedVert> lvi = label.get_elements();
        while (lvi.hasNext()) {
            this.update_vert_color(lvi.next());
        }
        this._verts_pa.setColors(0, this._vert_colors);
    }

    public void update_tria_label_color(Label<LinkedTriaSurface.LinkedTria> label) {
        Iterator<LinkedTriaSurface.LinkedTria> lti = label.get_elements();
        while (lti.hasNext()) {
            this.update_tria_color(lti.next());
        }
        this._trias_ita.setColors(0, this._tria_colors);
    }

    public void update_edge_label_color(Label<LinkedTriaSurface.LinkedEdge> label) {
        Iterator<LinkedTriaSurface.LinkedEdge> lei = label.get_elements();
        while (lei.hasNext()) {
            this.update_edge_color(lei.next());
        }
        this._edges_la.setColors(0, this._edge_colors);
    }

    public void update_all_vert_label_colors() {
        Iterator lvi = this._model._vlist.iterator();
        while (lvi.hasNext()) {
            this.update_vert_color((LinkedTriaSurface.LinkedVert)lvi.next());
        }
        this._verts_pa.setColors(0, this._vert_colors);
    }

    public void update_all_tria_label_colors() {
        Iterator lti = this._model._flist.iterator();
        while (lti.hasNext()) {
            this.update_tria_color((LinkedTriaSurface.LinkedTria)lti.next());
        }
        this._trias_ita.setColors(0, this._tria_colors);
    }

    public void update_all_edge_label_colors() {
        Iterator lei = this._model._elist.iterator();
        while (lei.hasNext()) {
            this.update_edge_color((LinkedTriaSurface.LinkedEdge)lei.next());
        }
        this._edges_la.setColors(0, this._edge_colors);
    }

    private void update_tria_color(LinkedTriaSurface.LinkedTria lt) {
        DMSurface model = YDMEditor._model;
        Iterator<String> id_it = model._tria_labels.keySet().iterator();
        Vector3f tria_col_buffer = new Vector3f((Tuple3f)DEFAULT_TRIA_COLOR);
        int count = 1;
        while (id_it.hasNext()) {
            Label<LinkedTriaSurface.LinkedTria> label = model._tria_labels.get(id_it.next());
            Color3f col = new Color3f(Color.decode(label.color));
            if (!label.contains(lt)) continue;
            tria_col_buffer.add((Tuple3f)col);
            ++count;
        }
        tria_col_buffer.scale(1.0f / (float)count);
        int tria_idx = ((IndexData)lt.get_user_data((int)IndexData._DATA_ID))._i;
        this._tria_colors[tria_idx + 0] = new Color3f((Tuple3f)tria_col_buffer);
        this._tria_colors[tria_idx + 1] = new Color3f((Tuple3f)tria_col_buffer);
        this._tria_colors[tria_idx + 2] = new Color3f((Tuple3f)tria_col_buffer);
    }

    private void update_edge_color(LinkedTriaSurface.LinkedEdge le) {
        DMSurface model = YDMEditor._model;
        Vector3f[] edge_col_buffer = new Vector3f[]{new Vector3f((Tuple3f)DEFAULT_EDGE_COLOR), new Vector3f((Tuple3f)DEFAULT_EDGE_COLOR)};
        Iterator<String> id_it = model._edge_labels.keySet().iterator();
        int count = 1;
        while (id_it.hasNext()) {
            Label<LinkedTriaSurface.LinkedEdge> label = model._edge_labels.get(id_it.next());
            Color3f col = new Color3f(Color.decode(label.color));
            if (!label.contains(le)) continue;
            edge_col_buffer[0].add((Tuple3f)col);
            edge_col_buffer[1].add((Tuple3f)col);
            ++count;
        }
        edge_col_buffer[0].scale(1.0f / (float)count);
        edge_col_buffer[1].scale(1.0f / (float)count);
        int edge_idx = ((IndexData)le.get_user_data((int)IndexData._DATA_ID))._i;
        this._edge_colors[edge_idx + 0] = new Color3f((Tuple3f)edge_col_buffer[0]);
        this._edge_colors[edge_idx + 1] = new Color3f((Tuple3f)edge_col_buffer[1]);
    }

    public void set_model(DMSurface model) {
        this._model = model;
        this._lts_search = new LTSStripeSearch(this._model);
        LinkedList vert_list = model._vlist;
        LinkedList tria_list = model._flist;
        LinkedList edge_list = model._elist;
        int vert_idx = 0;
        Vector3d bb_min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d bb_max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        Point3d[] verts = new Point3d[vert_list.size()];
        this._vert_colors = new Color3f[verts.length];
        this._verts_pa = new PointArray(verts.length, 5);
        this._verts_pa.setCapability(3);
        for (LinkedTriaSurface.LinkedVert lv : vert_list) {
            Point3d p = lv._p;
            if (bb_min.x > p.x) {
                bb_min.x = p.x;
            }
            if (bb_min.y > p.y) {
                bb_min.y = p.y;
            }
            if (bb_min.z > p.z) {
                bb_min.z = p.z;
            }
            if (bb_max.x < p.x) {
                bb_max.x = p.x;
            }
            if (bb_max.y < p.y) {
                bb_max.y = p.y;
            }
            if (bb_max.z < p.z) {
                bb_max.z = p.z;
            }
            IndexData idx = new IndexData(vert_idx);
            lv.set_user_data(IndexData._DATA_ID, idx);
            this.update_vert_color(lv);
            verts[vert_idx] = p;
            this._verts_pa.setCoordinate(vert_idx, p);
            ++vert_idx;
        }
        this._verts_pa.setColors(0, this._vert_colors);
        this._verts_shp.setGeometry((Geometry)this._verts_pa);
        int tria_idx = 0;
        int[] trias = new int[tria_list.size() * 3];
        this._tria_colors = new Color3f[trias.length];
        this._tria_def_colors = new Color3f[trias.length];
        for (LinkedTriaSurface.LinkedTria lt : tria_list) {
            IndexData idx = new IndexData(tria_idx);
            lt.set_user_data(IndexData._DATA_ID, idx);
            int a = ((IndexData)lt._a.get_user_data((int)IndexData._DATA_ID))._i;
            int b = ((IndexData)lt._b.get_user_data((int)IndexData._DATA_ID))._i;
            int c = ((IndexData)lt._c.get_user_data((int)IndexData._DATA_ID))._i;
            this._tria_def_colors[tria_idx + 0] = DEFAULT_TRIA_COLOR;
            this._tria_def_colors[tria_idx + 1] = DEFAULT_TRIA_COLOR;
            this._tria_def_colors[tria_idx + 2] = DEFAULT_TRIA_COLOR;
            this.update_tria_color(lt);
            trias[tria_idx + 0] = a;
            trias[tria_idx + 1] = b;
            trias[tria_idx + 2] = c;
            tria_idx += 3;
        }
        int[] color_indices = new int[trias.length];
        int i = 0;
        while (i < color_indices.length) {
            color_indices[i] = i;
            ++i;
        }
        GeometryInfo gi = new GeometryInfo(1);
        gi.setCoordinates(verts);
        gi.setCoordinateIndices(trias);
        gi.setColors(this._tria_colors);
        gi.setColorIndices(color_indices);
        NormalGenerator ng = new NormalGenerator();
        ng.setCreaseAngle(1.0471975511965976);
        ng.generateNormals(gi);
        this._trias_ita = gi.getIndexedGeometryArray();
        this._trias_ita.setCapability(3);
        this._trias_shp.setGeometry((Geometry)this._trias_ita);
        this._edges_la = new LineArray(edge_list.size() * 2, 5);
        this._edge_colors = new Color3f[edge_list.size() * 2];
        int edge_idx = 0;
        for (LinkedTriaSurface.LinkedEdge le : edge_list) {
            IndexData idx = new IndexData(edge_idx);
            le.set_user_data(IndexData._DATA_ID, idx);
            this.update_edge_color(le);
            this._edges_la.setCoordinate(edge_idx + 0, le._a._p);
            this._edges_la.setCoordinate(edge_idx + 1, le._b._p);
            edge_idx += 2;
        }
        this._edges_la.setColors(0, this._edge_colors);
        this._edges_la.setCapability(3);
        this._edges_shp.setGeometry((Geometry)this._edges_la);
        this._e_shape.setGeometry(null);
        this._v_shape.setGeometry(null);
        double dx = bb_max.x - bb_min.x;
        double dy = bb_max.y - bb_min.y;
        double dz = bb_max.z - bb_min.z;
        double s1 = 1.0 / Math.max(dx, Math.max(dy, dz));
        double[] mat_scale = new double[]{s1, 0.0, 0.0, 0.0, 0.0, s1, 0.0, 0.0, 0.0, 0.0, s1, 0.0, 0.0, 0.0, 0.0, 1.0};
        Transform3D t1 = new Transform3D(mat_scale);
        t1.setTranslation(new Vector3d(-s1 * (bb_min.x + dx / 2.0), -s1 * (bb_min.y + dy / 2.0), -s1 * (bb_min.z + dz / 2.0)));
        this._tg_scale.setTransform(t1);
        double s2 = 1.01 / Math.max(dx, Math.max(dy, dz));
        double[] mat_scale2 = new double[]{s2, 0.0, 0.0, 0.0, 0.0, s2, 0.0, 0.0, 0.0, 0.0, s2, 0.0, 0.0, 0.0, 0.0, 1.0};
        Transform3D t2 = new Transform3D(mat_scale2);
        t2.setTranslation(new Vector3d(-s2 * (bb_min.x + dx / 2.0), -s2 * (bb_min.y + dy / 2.0), -s2 * (bb_min.z + dz / 2.0)));
        this._tg_scale2.setTransform(t2);
    }

    public void show_vert(LinkedTriaSurface.LinkedVert v) {
        if (v != null) {
            PointArray pa = new PointArray(1, 1);
            pa.setCoordinate(0, v._p);
            this._v_shape.setGeometry((Geometry)pa);
        } else {
            this._v_shape.setGeometry(null);
        }
    }

    public void show_tria(LinkedTriaSurface.LinkedTria t) {
        int idx;
        if (this._last_tria != null && this._last_tria != t) {
            idx = ((IndexData)this._last_tria.get_user_data((int)IndexData._DATA_ID))._i;
            if (this._show_tria_labels) {
                this._trias_ita.setColor(idx + 0, this._tria_colors[idx + 0]);
                this._trias_ita.setColor(idx + 1, this._tria_colors[idx + 1]);
                this._trias_ita.setColor(idx + 2, this._tria_colors[idx + 2]);
            } else {
                this._trias_ita.setColor(idx + 0, this._tria_def_colors[idx + 0]);
                this._trias_ita.setColor(idx + 1, this._tria_def_colors[idx + 1]);
                this._trias_ita.setColor(idx + 2, this._tria_def_colors[idx + 2]);
            }
        }
        if (t != null) {
            Color c2;
            Color c1;
            Color c0;
            idx = ((IndexData)t.get_user_data((int)IndexData._DATA_ID))._i;
            this._last_tria = t;
            if (this._show_tria_labels) {
                c0 = new Color(this._tria_colors[idx + 0].x, this._tria_colors[idx + 0].y, this._tria_colors[idx + 0].z);
                c1 = new Color(this._tria_colors[idx + 1].x, this._tria_colors[idx + 1].y, this._tria_colors[idx + 1].z);
                c2 = new Color(this._tria_colors[idx + 2].x, this._tria_colors[idx + 2].y, this._tria_colors[idx + 2].z);
            } else {
                c0 = new Color(this._tria_def_colors[idx + 0].x, this._tria_def_colors[idx + 0].y, this._tria_def_colors[idx + 0].z);
                c1 = new Color(this._tria_def_colors[idx + 1].x, this._tria_def_colors[idx + 1].y, this._tria_def_colors[idx + 1].z);
                c2 = new Color(this._tria_def_colors[idx + 2].x, this._tria_def_colors[idx + 2].y, this._tria_def_colors[idx + 2].z);
            }
            c0 = c0.brighter();
            c1 = c1.brighter();
            c2 = c2.brighter();
            this._trias_ita.setColor(idx + 0, new Color3f(c0));
            this._trias_ita.setColor(idx + 1, new Color3f(c1));
            this._trias_ita.setColor(idx + 2, new Color3f(c2));
        }
    }

    public void show_edge(LinkedTriaSurface.LinkedEdge le) {
        if (le != null) {
            int idx = ((IndexData)le.get_user_data((int)IndexData._DATA_ID))._i;
            Color c = new Color(this._edge_colors[idx].x, this._edge_colors[idx].y, this._edge_colors[idx].z);
            c = c.brighter();
            this._e_shape_ap.getColoringAttributes().setColor(new Color3f(c));
            LineArray la = new LineArray(2, 1);
            la.setCoordinate(0, le._a._p);
            la.setCoordinate(1, le._b._p);
            this._e_shape.setGeometry((Geometry)la);
        } else {
            this._e_shape.setGeometry(null);
        }
    }

    public void enable_wireframe(boolean wire) {
        if (wire) {
            this._trias_poly_att.setPolygonMode(1);
        } else {
            this._trias_poly_att.setPolygonMode(2);
        }
    }

    public void show_vert_lables(boolean show) {
        this._show_vert_labels = show;
        if (show) {
            this._verts_shp.setGeometry((Geometry)this._verts_pa);
        } else {
            this._verts_shp.setGeometry(null);
        }
    }

    public void show_tria_lables(boolean show) {
        this._show_tria_labels = show;
        if (show) {
            this._trias_ita.setColors(0, this._tria_colors);
        } else {
            this._trias_ita.setColors(0, this._tria_def_colors);
        }
    }

    public void show_edge_lables(boolean show) {
        this._show_edge_labels = show;
        if (show) {
            this._edges_shp.setGeometry((Geometry)this._edges_la);
        } else {
            this._edges_shp.setGeometry(null);
        }
    }

    public void vert_label_changed(LinkedTriaSurface.LinkedVert lv) {
        this.update_vert_color(lv);
        int vert_idx = ((IndexData)lv.get_user_data((int)IndexData._DATA_ID))._i;
        this._verts_pa.setColor(vert_idx, this._vert_colors[vert_idx]);
    }

    public void tria_label_changed(LinkedTriaSurface.LinkedTria lt) {
        this.update_tria_color(lt);
    }

    public void edge_label_changed(LinkedTriaSurface.LinkedEdge le) {
        this.update_edge_color(le);
        int edge_idx = ((IndexData)le.get_user_data((int)IndexData._DATA_ID))._i;
        this._edges_la.setColor(edge_idx + 0, this._edge_colors[edge_idx + 0]);
        this._edges_la.setColor(edge_idx + 1, this._edge_colors[edge_idx + 1]);
    }

    public boolean get_vert_label_visible() {
        return this._show_vert_labels;
    }

    public boolean get_tria_label_visible() {
        return this._show_tria_labels;
    }

    public boolean get_edge_label_visible() {
        return this._show_edge_labels;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.pickCanvas.setShapeLocation(e);
        PickResult result = this.pickCanvas.pickClosest();
        if (result != null) {
            PickIntersection intersection = result.getIntersection(0);
            Point3d point = intersection.getPointCoordinates();
            int selected_tab = YDMEditor.tabs.getSelectedIndex();
            if (selected_tab == 0) {
                LinkedTriaSurface.LinkedVert closest = this._lts_search.find_closest_vert(point);
                YDMEditor._vert_panel.jtfi_index.setValueAndFireEvent(((IndexData)closest.get_user_data((int)IndexData._DATA_ID))._i);
            } else if (selected_tab == 1) {
                LinkedTriaSurface.LinkedTria closest = this._lts_search.find_closest_tria(point);
                YDMEditor._tria_panel.jtfi_index.setValueAndFireEvent(((IndexData)closest.get_user_data((int)IndexData._DATA_ID))._i / 3);
            } else if (selected_tab == 2) {
                LinkedTriaSurface.LinkedEdge min = this._lts_search.find_closest_edge(point);
                YDMEditor._edge_panel.jtfi_index.setValueAndFireEvent(((IndexData)min.get_user_data((int)IndexData._DATA_ID))._i / 2);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

