/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import jgridmaker.GMPanel;
import main.seggen.dm.editor.YDMEditor;
import misc.linkedsurface.LinkedTriaSurface;

public class TransformPanel
extends GMPanel {
    double[] bbmin;
    double[] bbmax;
    double[] bbsize;
    Point3d center_of_mass;
    private JLabel jl_pd_size;
    private JLabel jl_pd_com;
    private JLabel jl_pd_max;
    private JLabel jl_pd_min;
    private JTextField jt_tl_x;
    private JTextField jt_tl_y;
    private JTextField jt_tl_z;
    private JTextField jt_sc_x;
    private JTextField jt_sc_y;
    private JTextField jt_sc_z;
    private JTextField jt_sc_center_x;
    private JTextField jt_sc_center_y;
    private JTextField jt_sc_center_z;

    public TransformPanel() {
        GMPanel gm_position_dimension = new GMPanel();
        this.jl_pd_size = new JLabel("size: (0,0,0)");
        this.jl_pd_min = new JLabel("bb min: (0,0,0)");
        this.jl_pd_max = new JLabel("bb max: (0,0,0)");
        this.jl_pd_com = new JLabel("center of mass: (0,0,0)");
        gm_position_dimension.add("jl_pd_size", (JComponent)this.jl_pd_size);
        gm_position_dimension.add("jl_pd_min", (JComponent)this.jl_pd_min);
        gm_position_dimension.add("jl_pd_max", (JComponent)this.jl_pd_max);
        gm_position_dimension.add("jl_pd_com", (JComponent)this.jl_pd_com);
        gm_position_dimension.set_layout("<table cellpadding='2' border='0' width='100%' >  <tr>    <td anchor='west'>::jl_pd_size::</td>  </tr><tr>    <td anchor='west'>::jl_pd_min::</td>  </tr><tr>    <td anchor='west'>::jl_pd_max::</td>  </tr><tr>    <td anchor='west'>::jl_pd_com::</td>  </tr></table>");
        gm_position_dimension.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Dimension & Position", 2, 2));
        GMPanel gm_translation = new GMPanel();
        gm_translation.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Translation", 2, 2));
        this.jt_tl_x = new JTextField("0.0");
        this.jt_tl_x.setHorizontalAlignment(0);
        this.jt_tl_x.setColumns(4);
        this.jt_tl_y = new JTextField("0.0");
        this.jt_tl_y.setHorizontalAlignment(0);
        this.jt_tl_y.setColumns(4);
        this.jt_tl_z = new JTextField("0.0");
        this.jt_tl_z.setHorizontalAlignment(0);
        this.jt_tl_z.setColumns(4);
        JButton jb_tl_translate = new JButton("Translate");
        jb_tl_translate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Point3d trans = new Point3d(Double.parseDouble(TransformPanel.this.jt_tl_x.getText()), Double.parseDouble(TransformPanel.this.jt_tl_y.getText()), Double.parseDouble(TransformPanel.this.jt_tl_z.getText()));
                for (LinkedTriaSurface.LinkedVert lv : YDMEditor._model._vlist) {
                    lv.add((Tuple3d)trans);
                }
                YDMEditor.reload_model();
            }
        });
        JButton jb_tl_com_to_origin = new JButton("Move center of mass to origin");
        jb_tl_com_to_origin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (LinkedTriaSurface.LinkedVert lv : YDMEditor._model._vlist) {
                    lv.sub((Tuple3d)TransformPanel.this.center_of_mass);
                }
                YDMEditor.reload_model();
            }
        });
        JButton jb_tl_cobb_to_origin = new JButton("Move center of bounding box to origin");
        jb_tl_cobb_to_origin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Point3d trans = new Point3d(TransformPanel.this.bbmin[0] + 0.5 * TransformPanel.this.bbsize[0], TransformPanel.this.bbmin[1] + 0.5 * TransformPanel.this.bbsize[1], TransformPanel.this.bbmin[2] + 0.5 * TransformPanel.this.bbsize[2]);
                for (LinkedTriaSurface.LinkedVert lv : YDMEditor._model._vlist) {
                    lv.sub((Tuple3d)trans);
                }
                YDMEditor.reload_model();
            }
        });
        gm_translation.add("jb_tl_translate", (JComponent)jb_tl_translate);
        gm_translation.add("jb_tl_com_to_origin", (JComponent)jb_tl_com_to_origin);
        gm_translation.add("jb_tl_cobb_to_origin", (JComponent)jb_tl_cobb_to_origin);
        gm_translation.add("jt_tl_x", (JComponent)this.jt_tl_x);
        gm_translation.add("jt_tl_y", (JComponent)this.jt_tl_y);
        gm_translation.add("jt_tl_z", (JComponent)this.jt_tl_z);
        gm_translation.set_layout("<table cellpadding='2' border='0' width='100%' >  <tr>    <td width='1%'>(</td>    <td width='1%'>::jt_tl_x::</td>    <td width='1%'>,</td>    <td width='1%'>::jt_tl_y::</td>    <td width='1%'>,</td>    <td width='1%'>::jt_tl_z::</td>    <td width='1%'>)</td>    <td width='93%'></td>  </tr><tr>    <td anchor='west' colspan='8'>::jb_tl_translate::</td>  </tr><tr>    <td anchor='west' colspan='8'>::jb_tl_com_to_origin::</td>  </tr><tr>    <td anchor='west' colspan='8'>::jb_tl_cobb_to_origin::</td>  </tr></table>");
        GMPanel gm_scalation = new GMPanel();
        gm_scalation.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Scale", 2, 2));
        this.jt_sc_x = new JTextField("1.0");
        this.jt_sc_x.setHorizontalAlignment(0);
        this.jt_sc_x.setColumns(4);
        this.jt_sc_y = new JTextField("1.0");
        this.jt_sc_y.setHorizontalAlignment(0);
        this.jt_sc_y.setColumns(4);
        this.jt_sc_z = new JTextField("1.0");
        this.jt_sc_z.setHorizontalAlignment(0);
        this.jt_sc_z.setColumns(4);
        this.jt_sc_center_x = new JTextField("0.0");
        this.jt_sc_center_x.setHorizontalAlignment(0);
        this.jt_sc_center_x.setColumns(4);
        this.jt_sc_center_y = new JTextField("0.0");
        this.jt_sc_center_y.setHorizontalAlignment(0);
        this.jt_sc_center_y.setColumns(4);
        this.jt_sc_center_z = new JTextField("0.0");
        this.jt_sc_center_z.setHorizontalAlignment(0);
        this.jt_sc_center_z.setColumns(4);
        JButton jb_sc_use_cobb_as_center = new JButton("center of bb");
        jb_sc_use_cobb_as_center.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double x = TransformPanel.this.bbmin[0] + 0.5 * TransformPanel.this.bbsize[0];
                double y = TransformPanel.this.bbmin[1] + 0.5 * TransformPanel.this.bbsize[1];
                double z = TransformPanel.this.bbmin[2] + 0.5 * TransformPanel.this.bbsize[2];
                TransformPanel.this.jt_sc_center_x.setText("" + x);
                TransformPanel.this.jt_sc_center_y.setText("" + y);
                TransformPanel.this.jt_sc_center_z.setText("" + z);
                TransformPanel.this.jt_sc_center_x.setCaretPosition(0);
                TransformPanel.this.jt_sc_center_y.setCaretPosition(0);
                TransformPanel.this.jt_sc_center_z.setCaretPosition(0);
            }
        });
        JButton jb_sc_use_com_as_center = new JButton("center of mass");
        jb_sc_use_com_as_center.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransformPanel.this.jt_sc_center_x.setText("" + TransformPanel.this.center_of_mass.x);
                TransformPanel.this.jt_sc_center_y.setText("" + TransformPanel.this.center_of_mass.y);
                TransformPanel.this.jt_sc_center_z.setText("" + TransformPanel.this.center_of_mass.z);
                TransformPanel.this.jt_sc_center_x.setCaretPosition(0);
                TransformPanel.this.jt_sc_center_y.setCaretPosition(0);
                TransformPanel.this.jt_sc_center_z.setCaretPosition(0);
            }
        });
        JButton jb_sc_scale = new JButton("Scale");
        jb_sc_scale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double sx = Double.parseDouble(TransformPanel.this.jt_sc_x.getText());
                double sy = Double.parseDouble(TransformPanel.this.jt_sc_y.getText());
                double sz = Double.parseDouble(TransformPanel.this.jt_sc_z.getText());
                Point3d center = new Point3d(Double.parseDouble(TransformPanel.this.jt_sc_center_x.getText()), Double.parseDouble(TransformPanel.this.jt_sc_center_y.getText()), Double.parseDouble(TransformPanel.this.jt_sc_center_z.getText()));
                for (LinkedTriaSurface.LinkedVert lv : YDMEditor._model._vlist) {
                    lv.sub((Tuple3d)center);
                    lv.scale(sx, sy, sz);
                    lv.add((Tuple3d)center);
                }
                YDMEditor.reload_model();
            }
        });
        gm_scalation.add("jt_sc_x", (JComponent)this.jt_sc_x);
        gm_scalation.add("jt_sc_y", (JComponent)this.jt_sc_y);
        gm_scalation.add("jt_sc_z", (JComponent)this.jt_sc_z);
        gm_scalation.add("jt_sc_center_x", (JComponent)this.jt_sc_center_x);
        gm_scalation.add("jt_sc_center_y", (JComponent)this.jt_sc_center_y);
        gm_scalation.add("jt_sc_center_z", (JComponent)this.jt_sc_center_z);
        gm_scalation.add("jb_sc_use_com_as_center", (JComponent)jb_sc_use_com_as_center);
        gm_scalation.add("jb_sc_use_cobb_as_center", (JComponent)jb_sc_use_cobb_as_center);
        gm_scalation.add("jb_sc_scale", (JComponent)jb_sc_scale);
        gm_scalation.set_layout("<table cellpadding='2' border='0' width='100%' >  <tr>    <td anchor='west' width='1%'>scale factor:</td>    <td width='1%'>(</td>    <td width='1%'>::jt_sc_x::</td>    <td width='1%'>,</td>    <td width='1%'>::jt_sc_y::</td>    <td width='1%'>,</td>    <td width='1%'>::jt_sc_z::</td>    <td width='1%'>)</td>    <td width='93%'></td>  </tr><tr>    <td anchor='west' width='1%'>center:</td>    <td width='1%'>(</td>    <td width='1%'>::jt_sc_center_x::</td>    <td width='1%'>,</td>    <td width='1%'>::jt_sc_center_y::</td>    <td width='1%'>,</td>    <td width='1%'>::jt_sc_center_z::</td>    <td width='1%'>)</td>    <td width='93%'></td>  </tr><tr>    <td anchor='west' colspan='9'>::jb_sc_scale::</td>  </tr><tr>    <td anchor='west' colspan='9'>      <table>        <tr>          <td>Set center:</td>          <td>::jb_sc_use_com_as_center::</td>          <td>::jb_sc_use_cobb_as_center::</td>        </tr>       </table>    </td>  </tr></table>");
        this.add("gm_position_dimension", (JComponent)gm_position_dimension);
        this.add("gm_translation", (JComponent)gm_translation);
        this.add("gm_scalation", (JComponent)gm_scalation);
        this.set_layout("<table width='100%' height='100%' border='0'>  <tr height='1%'>    <td fill='horizontal'>::gm_position_dimension::</td>  </tr><tr height='1%'>    <td fill='horizontal'>::gm_translation::</td>  </tr><tr height='1%'>    <td fill='horizontal'>::gm_scalation::</td>  </tr><tr height='97%'>    <td></td>  </tr></table>");
    }

    public void surface_loaded() {
        this.bbmin = new double[3];
        this.bbmax = new double[3];
        this.bbsize = new double[3];
        int i = 0;
        while (i < 3) {
            this.bbmin[i] = Double.MAX_VALUE;
            this.bbmax[i] = Double.MIN_VALUE;
            this.bbsize[i] = 0.0;
            ++i;
        }
        for (LinkedTriaSurface.LinkedVert lv : YDMEditor._model._vlist) {
            if (lv._p.x < this.bbmin[0]) {
                this.bbmin[0] = lv._p.x;
            }
            if (lv._p.y < this.bbmin[1]) {
                this.bbmin[1] = lv._p.y;
            }
            if (lv._p.z < this.bbmin[2]) {
                this.bbmin[2] = lv._p.z;
            }
            if (lv._p.x > this.bbmax[0]) {
                this.bbmax[0] = lv._p.x;
            }
            if (lv._p.y > this.bbmax[1]) {
                this.bbmax[1] = lv._p.y;
            }
            if (!(lv._p.z > this.bbmax[2])) continue;
            this.bbmax[2] = lv._p.z;
        }
        this.bbsize[0] = this.bbmax[0] - this.bbmin[0];
        this.bbsize[1] = this.bbmax[1] - this.bbmin[1];
        this.bbsize[2] = this.bbmax[2] - this.bbmin[2];
        this.center_of_mass = YDMEditor._model.CenterOfMassOfVertices();
        this.jl_pd_size.setText(String.format("size: (%.03f, %.03f, %.03f)", this.bbsize[0], this.bbsize[1], this.bbsize[2]));
        this.jl_pd_min.setText(String.format("bb min: (%.03f, %.03f, %.03f)", this.bbmin[0], this.bbmin[1], this.bbmin[2]));
        this.jl_pd_max.setText(String.format("bb max: (%.03f, %.03f, %.03f)", this.bbmax[0], this.bbmax[1], this.bbmax[2]));
        this.jl_pd_com.setText(String.format("center of mass: (%.03f, %.03f, %.03f)", this.center_of_mass.x, this.center_of_mass.y, this.center_of_mass.z));
    }
}

