/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import main.seggen.dm.editor.DMPanel;
import main.seggen.dm.editor.EdgePanel;
import main.seggen.dm.editor.MyCanvas;
import main.seggen.dm.editor.TransformPanel;
import main.seggen.dm.editor.TriaPanel;
import main.seggen.dm.editor.VertPanel;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.DMSurfaceWriter;
import main.seggen.dm.surface.loader.DMLoader;

public class YDMEditor {
    public static DMSurface _model = null;
    public static MyCanvas _canvas = new MyCanvas();
    public static DMLoader _loader = new DMLoader();
    public static JFrame _win = new JFrame("YDM Editor");
    public static DMPanel _dm_panel = new DMPanel();
    public static TriaPanel _tria_panel = new TriaPanel();
    public static VertPanel _vert_panel = new VertPanel();
    public static EdgePanel _edge_panel = new EdgePanel();
    public static TransformPanel _transform_panel = new TransformPanel();
    public static JTabbedPane tabs;

    public static void load_model(File f) {
        try {
            _model = _loader.load(new FileInputStream(f));
            _canvas.set_model(_model);
            _tria_panel.surface_loaded();
            _vert_panel.surface_loaded();
            _edge_panel.surface_loaded();
            _transform_panel.surface_loaded();
            tabs.setEnabled(true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void reload_model() {
        _canvas.set_model(_model);
        _tria_panel.surface_loaded();
        _vert_panel.surface_loaded();
        _edge_panel.surface_loaded();
        _transform_panel.surface_loaded();
        tabs.setEnabled(true);
    }

    public static void save_model(File f) {
        try {
            YDMEditor._model._name = YDMEditor._dm_panel.jt_name.getText();
            YDMEditor._model._type = YDMEditor._dm_panel.jt_type.getText();
            DMSurfaceWriter csw = new DMSurfaceWriter(_model, f);
            csw.write_data();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static JMenuBar build_menu() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenuBar menu_bar = new JMenuBar();
        JMenu jmenu = new JMenu("Options");
        menu_bar.add(jmenu);
        JMenuItem jitem = new JCheckBoxMenuItem("Show Vert Labels", true);
        jitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
                _canvas.show_vert_lables(source.getState());
            }
        });
        jmenu.add(jitem);
        jitem = new JCheckBoxMenuItem("Show Tria Labels", true);
        jitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
                _canvas.show_tria_lables(source.getState());
            }
        });
        jmenu.add(jitem);
        jitem = new JCheckBoxMenuItem("Show Edge Labels", true);
        jitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
                _canvas.show_edge_lables(source.getState());
            }
        });
        jmenu.add(jitem);
        jmenu.addSeparator();
        jitem = new JCheckBoxMenuItem("Wireframe", false);
        jitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
                _canvas.enable_wireframe(source.getState());
            }
        });
        jmenu.add(jitem);
        jitem = new JMenuItem("Change Backgorund Color");
        jitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color col = JColorChooser.showDialog(_win, "Chooser Background Color", _canvas.get_bg_color());
                _canvas.set_bg_color(col);
            }
        });
        jmenu.add(jitem);
        return menu_bar;
    }

    public static void main(String[] args) {
        _win.setDefaultCloseOperation(3);
        _canvas.setPreferredSize(new Dimension(600, 600));
        _canvas.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    if (tabs.getSelectedIndex() == 0) {
                        _vert_panel.toggle_selection();
                    } else if (tabs.getSelectedIndex() == 1) {
                        _tria_panel.toggle_selection();
                    } else if (tabs.getSelectedIndex() == 2) {
                        _edge_panel.toggle_selection();
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        tabs = new JTabbedPane();
        tabs.addTab("Verts", (Component)((Object)_vert_panel));
        tabs.addTab("Trias", (Component)((Object)_tria_panel));
        tabs.addTab("Edges", (Component)((Object)_edge_panel));
        tabs.addTab("Transform", (Component)((Object)_transform_panel));
        tabs.setEnabled(false);
        JPanel jp_east = new JPanel();
        jp_east.setPreferredSize(new Dimension(400, 600));
        jp_east.setLayout(new BorderLayout());
        jp_east.add((Component)((Object)_dm_panel), "North");
        jp_east.add((Component)tabs, "Center");
        _win.setLayout(new BorderLayout());
        _win.add((Component)((Object)_canvas), "Center");
        _win.add((Component)jp_east, "East");
        _win.setJMenuBar(YDMEditor.build_menu());
        _win.pack();
        _win.setVisible(true);
    }
}

