/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.gui;

import gui.MyToolbar;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import jgridmaker.GMPanel;
import jgridmaker.JGridMaker;
import main.CoordinateConverter;
import main.ImageStack;
import main.MainWindow;
import main.MasterControl;
import main.Message;
import main.YDialogs;
import main.seggen.SegGenYDM;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.DMSurfaceWriter;
import main.seggen.dm.surface.SurfaceAndMetadata;
import main.seggen.dm.surface.SurfaceStorage;
import main.seggen.dm.surface.loader.DMLoader;
import misc.linkedsurface.LinkedTriaSurface;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import settings.Settings;

public class SurfaceList
extends GMPanel
implements YObserverWantsAWTThread,
ListSelectionListener {
    public static String DMSURFACE_SELECTION_CHANGED = "__dmsurface__selector__";
    public final JList _jl_dms_list;
    protected final DefaultListModel _dms_list_model;
    protected final LinkedList<SurfaceAndMetadata> _selected_dms = new LinkedList();
    protected JLabel _label;
    protected static final JFileChooser _surface_file_chooser = new JFileChooser();
    private static SurfaceList _instance;

    public static SurfaceList getInstance() {
        if (_instance == null) {
            _instance = new SurfaceList();
        }
        return _instance;
    }

    private SurfaceList() {
        this._dms_list_model = new DefaultListModel();
        this._jl_dms_list = new JList(this._dms_list_model);
        this._jl_dms_list.setSelectionMode(0);
        this._jl_dms_list.setPrototypeCellValue("Fingerknochen");
        this._jl_dms_list.addListSelectionListener(this);
        JScrollPane jsp_list_scroller = new JScrollPane(this._jl_dms_list);
        jsp_list_scroller.setHorizontalScrollBarPolicy(31);
        jsp_list_scroller.setVerticalScrollBarPolicy(22);
        MasterControl.get_is().addObserver(this, "SurfaceList()");
        SurfaceStorage.getInstance().addObserver(this, "SurfaceList()");
        this.add("list", jsp_list_scroller);
        MyToolbar tool_bar = new MyToolbar();
        tool_bar.setOrientation(0);
        AbstractAction dms_load = new AbstractAction("Load", new ImageIcon("resources/gfx/seg_load.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (_surface_file_chooser.showOpenDialog(null) == 0) {
                    try {
                        FileInputStream ins = new FileInputStream(_surface_file_chooser.getSelectedFile());
                        DMLoader dm_loader = new DMLoader();
                        DMSurface dms = dm_loader.load(ins);
                        boolean center = Settings.get_bool_option(SegGenYDM.class, SegGenYDM.OPT_CENTER_LOADED_MODELS);
                        if (center) {
                            ImageStack is = MasterControl.get_is();
                            CoordinateConverter cc = CoordinateConverter.get_converter(is);
                            Point3d com = dms.CenterOfMassOfVertices();
                            Point3d cov = cc.grid_to_world_p3d(new Point3d((double)is.get_dim_x() / 2.0, (double)is.get_dim_y() / 2.0, (double)is.get_dim_z() / 2.0));
                            Point3d translate = new Point3d(cov);
                            translate.sub((Tuple3d)com);
                            for (LinkedTriaSurface.LinkedVert lv : dms._vlist) {
                                lv.add((Tuple3d)translate);
                            }
                        }
                        dms.didLoad();
                        dms.calc_normals();
                        SurfaceStorage surface_store = SurfaceStorage.getInstance();
                        surface_store.addSurface(new SurfaceAndMetadata(dms, _surface_file_chooser.getSelectedFile().getPath(), center));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        AbstractAction dms_save = new AbstractAction("Save", new ImageIcon("resources/gfx/seg_save.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SurfaceList.this._jl_dms_list.getSelectedIndex() == -1) {
                    YDialogs.notify_user("Select a model first");
                    return;
                }
                if (_surface_file_chooser.showSaveDialog(null) == 0) {
                    DMSurface dms = ((SurfaceAndMetadata)SurfaceList.this._jl_dms_list.getSelectedValue()).surface;
                    File target = _surface_file_chooser.getSelectedFile();
                    String path = target.getPath();
                    if (!path.endsWith(".ydm")) {
                        path = String.valueOf(path) + ".ydm";
                    }
                    target = new File(path);
                    DMSurfaceWriter dmsw = new DMSurfaceWriter(dms, target);
                    try {
                        dmsw.write_data();
                    }
                    catch (IOException e1) {
                        YDialogs.notify_user("Failed to save model");
                        e1.printStackTrace();
                    }
                }
            }
        };
        AbstractAction dms_edit = new AbstractAction("Edit", new ImageIcon("resources/gfx/seg_edit.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SurfaceList.this._jl_dms_list.getSelectedIndex() == -1) {
                    YDialogs.notify_user("Select a model first");
                    return;
                }
                SurfaceAndMetadata samd = (SurfaceAndMetadata)SurfaceList.this._jl_dms_list.getSelectedValue();
                SurfaceEditDialog sed = new SurfaceEditDialog(samd.surface);
                sed.setVisible(true);
                SurfaceList.this.repaint();
            }
        };
        AbstractAction dms_delete = new AbstractAction("Delete", new ImageIcon("resources/gfx/seg_delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SurfaceList.this._jl_dms_list.getSelectedIndex() == -1) {
                    YDialogs.notify_user("Select a model first");
                    return;
                }
                SurfaceAndMetadata samd = (SurfaceAndMetadata)SurfaceList.this._jl_dms_list.getSelectedValue();
                SurfaceStorage.getInstance().removeSurface(samd);
            }
        };
        AbstractAction dms_reset = new AbstractAction("Reset", new ImageIcon("resources/gfx/model_reset.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SurfaceList.this._jl_dms_list.getSelectedIndex() == -1) {
                    YDialogs.notify_user("Select a model first");
                    return;
                }
                SurfaceAndMetadata samd = (SurfaceAndMetadata)SurfaceList.this._jl_dms_list.getSelectedValue();
                try {
                    FileInputStream ins = new FileInputStream(new File(samd.filename));
                    DMLoader dm_loader = new DMLoader();
                    DMSurface dms = dm_loader.load(ins);
                    if (samd.center) {
                        ImageStack is = MasterControl.get_is();
                        CoordinateConverter cc = CoordinateConverter.get_converter(is);
                        Point3d com = dms.CenterOfMassOfVertices();
                        Point3d cov = cc.grid_to_world_p3d(new Point3d((double)is.get_dim_x() / 2.0, (double)is.get_dim_y() / 2.0, (double)is.get_dim_z() / 2.0));
                        Point3d translate = new Point3d(cov);
                        translate.sub((Tuple3d)com);
                        for (LinkedTriaSurface.LinkedVert lv : dms._vlist) {
                            lv.add((Tuple3d)translate);
                        }
                    }
                    dms.didLoad();
                    dms.calc_normals();
                    for (LinkedTriaSurface.LinkedVert lv : dms._vlist) {
                        lv.transform(samd.transform);
                    }
                    samd.surface = dms;
                    SurfaceStorage.getInstance().resetSurface(samd);
                }
                catch (FileNotFoundException e1) {
                    YDialogs.notify_user("Unable to find original file");
                    e1.printStackTrace();
                }
            }
        };
        tool_bar.add(dms_load);
        tool_bar.add(dms_save);
        tool_bar.add(dms_edit);
        tool_bar.add(dms_delete);
        tool_bar.add(dms_reset);
        this.add("tool_bar", tool_bar);
        String layout = "<table>  <tr>    <td>Select a Model</td>  </tr><tr>    <td>::list::</td>  </tr><tr>    <td>::tool_bar::</td>  </tr></table>";
        this.set_layout(layout);
    }

    @Override
    public void update(YObservable sender, Message m) {
        if (m._type == ImageStack.M_CLEAR || m._type == ImageStack.M_LOADING_START) {
            this._dms_list_model.clear();
        } else if (m._type == SurfaceStorage.M_ADD_SURFACE) {
            this._dms_list_model.addElement((SurfaceAndMetadata)m._obj);
        } else if (m._type == SurfaceStorage.M_DEL_SURFACE) {
            this._dms_list_model.removeElement((SurfaceAndMetadata)m._obj);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent paramListSelectionEvent) {
    }

    public SurfaceAndMetadata getSelection() {
        if (this._jl_dms_list.getSelectedIndex() == -1) {
            return null;
        }
        return (SurfaceAndMetadata)this._jl_dms_list.getSelectedValue();
    }

    public class SurfaceEditDialog
    extends JDialog {
        private GMPanel gui;
        private JTextField jtf_name;
        private JTextField jtf_type;
        private DMSurface dms;

        public SurfaceEditDialog(final DMSurface surface) {
            super((Frame)MasterControl.get_window(), true);
            MainWindow win = MasterControl.get_window();
            this.dms = surface;
            this.gui = new GMPanel();
            this.jtf_name = new JTextField(surface._name, 50);
            this.jtf_type = new JTextField(surface._type, 50);
            JButton abort = new JButton("Abort");
            abort.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SurfaceEditDialog.this.setVisible(false);
                }
            });
            JButton save = new JButton("Save");
            save.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((SurfaceEditDialog)SurfaceEditDialog.this).dms._name = SurfaceEditDialog.this.jtf_name.getText();
                    ((SurfaceEditDialog)SurfaceEditDialog.this).dms._type = SurfaceEditDialog.this.jtf_type.getText();
                    SurfaceStorage.getInstance().notifyObservers(new Message(SurfaceStorage.M_EDIT_SURFACE, surface), "SurfaceEditDialog save()");
                    SurfaceEditDialog.this.setVisible(false);
                }
            });
            this.gui.add("tf_name", (JComponent)this.jtf_name);
            this.gui.add("tf_type", (JComponent)this.jtf_type);
            this.gui.add("abort", (JComponent)abort);
            this.gui.add("save", (JComponent)save);
            this.gui.set_layout("<table width='100%'>  <tr>    <td anchor='west' width='1%'>Name:</td>    <td fill='horizontal' width='99%'>::tf_name::</td>  </tr><tr>    <td anchor='west' width='1%'>Type:</td>    <td fill='horizontal' width='99%'>::tf_type::</td>  </tr>  <tr>    <td colspan='2'>      <table><tr>        <td width='98%'></td>        <td anchor='east' width='1%'>::abort::</td>        <td anchor='east' width='1%'>::save::</td>      </tr></table>    </td>  </tr></table>");
            HashMap<String, GMPanel> obj_map = new HashMap<String, GMPanel>();
            obj_map.put("gui", this.gui);
            JGridMaker.make_grid((Container)this, (String)"<table width='100%' cellpadding='2' margin='10' border='0'>  <tr>    <td>::gui::</td>  </tr></table>", obj_map);
            this.pack();
            int pw = win.getWidth();
            int ph = win.getHeight();
            int px = win.getLocation().x;
            int py = win.getLocation().y;
            int w = this.getWidth();
            int h = this.getHeight();
            this.setLocation(px + pw / 2 - w / 2, py + ph / 2 - h / 2);
        }
    }
}

