/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.gui;

import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import main.Message;
import main.seggen.SegGenYDM;
import main.seggen.dm.gui.SurfaceList;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.DMSurfaceToITA;
import main.seggen.dm.surface.SurfaceAndMetadata;
import main.seggen.dm.surface.SurfaceStorage;
import main.seggen.dm.surface.placement.PlacementController;
import main.view3d.Viewport3d;
import misc.messages.YObservable;
import renderer.Renderer3d;
import settings.Settings;
import settings.SettingsListener;

public class SurfaceListRenderer
extends Renderer3d
implements ListSelectionListener,
SettingsListener {
    private TransformGroup _tg_mc;
    private Shape3D _shp_mc_body;
    private final ColoringAttributes _ca_mc = new ColoringAttributes();
    private final PolygonAttributes _pa_mc = new PolygonAttributes();
    private Material _mat_mc;
    private final SurfaceStorage surf_store = SurfaceStorage.getInstance();
    private DMSurface visible_surface = null;
    private SurfaceList surf_list;

    public SurfaceListRenderer(Viewport3d v3d, int scene_id) {
        super(v3d, scene_id);
        Settings.register_class_listener(SegGenYDM.class, this);
        this.surf_list = SurfaceList.getInstance();
        this._tg_mc = new TransformGroup();
        this._tg_mc.setCapability(17);
        this._tg_mc.setCapability(18);
        this._shp_mc_body = new Shape3D();
        this._shp_mc_body.setCapability(13);
        this._shp_mc_body.setCapability(15);
        this._shp_mc_body.setAppearance(this.create_mc_appearance());
        this._tg_mc.addChild((Node)this._shp_mc_body);
        this._bg.addChild((Node)this._tg_mc);
        this.surf_list._jl_dms_list.addListSelectionListener(this);
        if (this.surf_list._jl_dms_list.getSelectedIndex() >= 0) {
            this.visible_surface = ((SurfaceAndMetadata)this.surf_list._jl_dms_list.getSelectedValue()).surface;
            this._shp_mc_body.setGeometry((Geometry)DMSurfaceToITA.getITA(this.visible_surface, false));
        }
        this.surf_store.addObserver(this, "SurfaceListRenderer()");
    }

    @Override
    public void update(YObservable sender, Message m) {
        if (m._type == SurfaceStorage.M_DEL_SURFACE) {
            if (this.visible_surface == ((SurfaceAndMetadata)m._obj).surface) {
                this._shp_mc_body.setGeometry(null);
                this.visible_surface = null;
            }
        } else if (m._type == SurfaceStorage.M_TRANSFORMED_SURFACE) {
            if (this.surf_list._jl_dms_list.getSelectedIndex() >= 0) {
                this.visible_surface = ((SurfaceAndMetadata)this.surf_list._jl_dms_list.getSelectedValue()).surface;
                this._shp_mc_body.setGeometry((Geometry)DMSurfaceToITA.getITA(this.visible_surface, false));
            }
        } else if (m._type == SurfaceStorage.M_RESET_SURFACE) {
            if (this.surf_list._jl_dms_list.getSelectedIndex() >= 0) {
                this.visible_surface = ((SurfaceAndMetadata)this.surf_list._jl_dms_list.getSelectedValue()).surface;
                this._shp_mc_body.setGeometry((Geometry)DMSurfaceToITA.getITA(this.visible_surface, false));
            }
        } else if (m._type == PlacementController.M_DMPLACEMENT_START) {
            this._shp_mc_body.setGeometry(null);
        } else if (m._type == PlacementController.M_DMPLACEMENT_END && this.visible_surface != null) {
            this._shp_mc_body.setGeometry((Geometry)DMSurfaceToITA.getITA(this.visible_surface, false));
        }
    }

    @Override
    public void create_scene() {
    }

    private final Appearance create_mc_appearance() {
        Color3f seg_color3f = new Color3f(1.0f, 0.0f, 0.0f);
        Appearance ap = new Appearance();
        this._ca_mc.setCapability(1);
        this._ca_mc.setShadeModel(3);
        this._ca_mc.setColor(seg_color3f);
        ap.setColoringAttributes(this._ca_mc);
        this._pa_mc.setCapability(3);
        this._pa_mc.setCullFace(1);
        if (Settings.get_bool_option(SegGenYDM.class, SegGenYDM.OPT_SHOW_WIREFRAME).booleanValue()) {
            this._pa_mc.setPolygonMode(1);
        } else {
            this._pa_mc.setPolygonMode(2);
        }
        ap.setCapability(14);
        ap.setCapability(15);
        ap.setPolygonAttributes(this._pa_mc);
        this._mat_mc = new Material();
        this._mat_mc.setCapability(1);
        this._mat_mc.setShininess(50.0f);
        this._mat_mc.setDiffuseColor(seg_color3f);
        this._mat_mc.setSpecularColor(new Color3f(0.8f, 0.8f, 0.8f));
        ap.setMaterial(this._mat_mc);
        return ap;
    }

    public void apply_transform(Matrix4d rot) {
        Transform3D tf3d_trans = new Transform3D();
        this._tg_mc.getTransform(tf3d_trans);
        tf3d_trans.mul(new Transform3D(rot), tf3d_trans);
        this._tg_mc.setTransform(tf3d_trans);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.visible_surface != null) {
            this._shp_mc_body.setGeometry(null);
            this.visible_surface = null;
        }
        if (this.surf_list._jl_dms_list.getSelectedIndex() >= 0) {
            this.visible_surface = ((SurfaceAndMetadata)this.surf_list._jl_dms_list.getSelectedValue()).surface;
            this._shp_mc_body.setGeometry((Geometry)DMSurfaceToITA.getITA(this.visible_surface, false));
        }
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name.equals(SegGenYDM.OPT_SHOW_WIREFRAME)) {
            if (Settings.get_bool_option(SegGenYDM.class, SegGenYDM.OPT_SHOW_WIREFRAME).booleanValue()) {
                this._shp_mc_body.getAppearance().getPolygonAttributes().setPolygonMode(1);
            } else {
                this._shp_mc_body.getAppearance().getPolygonAttributes().setPolygonMode(2);
            }
        }
    }
}

