/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.LinkedList;
import javax.swing.JComboBox;
import jgridmaker.GMPanel;
import main.MasterControl;
import main.Message;
import main.seggen.dm.gui.SurfaceSelectorRenderer;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.SurfaceAndMetadata;
import main.seggen.dm.surface.SurfaceStorage;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;

public class SurfaceSelector
extends GMPanel
implements YObserverWantsAWTThread,
HierarchyListener,
ActionListener {
    private JComboBox jcb;
    private boolean super_visible = true;
    private boolean visible;
    private SurfaceSelectorRenderer renderer;
    private int lastIdx = 0;

    public SurfaceSelector() {
        SurfaceStorage.getInstance().addObserver(this, "SurfaceSelector()");
        this.jcb = new JComboBox();
        this.jcb.setMinimumSize(new Dimension(100, 10));
        this.jcb.addItem(new EmptyEntry());
        LinkedList<SurfaceAndMetadata> surfaces = SurfaceStorage.getInstance().getSurfacesAndMetadata();
        for (SurfaceAndMetadata samd : surfaces) {
            this.jcb.addItem(samd);
        }
        this.add("jcb", this.jcb);
        this.set_layout("<table width='100%' border='0'><tr><td>::jcb::</td></tr></table>");
        this.renderer = new SurfaceSelectorRenderer(MasterControl.get_v3d(), 1, this);
        this.jcb.addActionListener(this.renderer);
        this.jcb.addActionListener(this);
        this.addHierarchyListener(this);
    }

    public boolean isSelectionAvailable() {
        return this.jcb.getSelectedIndex() > 0;
    }

    public DMSurface getSelectedSurface() {
        if (this.jcb.getSelectedItem() instanceof EmptyEntry) {
            return null;
        }
        return ((SurfaceAndMetadata)this.jcb.getSelectedItem()).surface;
    }

    @Override
    public void update(YObservable sender, Message m) {
        if (m._type == SurfaceStorage.M_ADD_SURFACE) {
            this.jcb.addItem(m._obj);
        } else if (m._type == SurfaceStorage.M_DEL_SURFACE) {
            this.jcb.removeItem(m._obj);
        } else if (m._type == SurfaceStorage.M_EDIT_SURFACE) {
            this.jcb.repaint();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L) {
            this.updateVisibility();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isSelectionAvailable()) {
            if (this.lastIdx != this.jcb.getSelectedIndex()) {
                this.super_visible = true;
                this.lastIdx = this.jcb.getSelectedIndex();
            }
        } else {
            this.super_visible = true;
            this.lastIdx = 0;
        }
        this.updateVisibility();
    }

    private void updateVisibility() {
        if (this.visible && !this.isShowing()) {
            this.visible = false;
            this.renderer.set_visible(this.visible);
        } else if (this.visible && this.isShowing()) {
            if (this.super_visible) {
                this.renderer.set_visible(true);
            } else {
                this.renderer.set_visible(false);
            }
        } else if (!this.visible && this.isShowing()) {
            this.visible = true;
            if (this.super_visible) {
                this.renderer.set_visible(this.visible);
            } else {
                this.renderer.set_visible(false);
            }
        }
    }

    public void hide() {
        this.super_visible = false;
        this.visible = false;
        this.updateVisibility();
    }

    public void show() {
        this.super_visible = true;
        this.visible = true;
        this.updateVisibility();
    }

    private class EmptyEntry {
        private EmptyEntry() {
        }

        public String toString() {
            return "Select Model";
        }
    }
}

