/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface;

import java.util.ArrayList;
import java.util.LinkedList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import main.CoordinateConverter;
import main.MasterControl;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.Voxelize;
import misc.linkedsurface.LinkedTriaSurface;

public class DMSHelper {
    public static LinkedList<LinkedTriaSurface.LinkedVert> getOneHopAwayIndices(LinkedTriaSurface.LinkedVert start) {
        return start.get_neighbours();
    }

    public static LinkedList<LinkedTriaSurface.LinkedVert> getOnlyNHopsAwayIndices(LinkedTriaSurface.LinkedVert start, int hops) {
        LinkedList<LinkedTriaSurface.LinkedVert> prev = new LinkedList<LinkedTriaSurface.LinkedVert>();
        LinkedList<LinkedTriaSurface.LinkedVert> last = new LinkedList<LinkedTriaSurface.LinkedVert>();
        last.add(start);
        prev.add(start);
        int c = 0;
        while (c < hops) {
            LinkedList<LinkedTriaSurface.LinkedVert> this_round_found = new LinkedList<LinkedTriaSurface.LinkedVert>();
            for (LinkedTriaSurface.LinkedVert i : last) {
                LinkedList<LinkedTriaSurface.LinkedVert> ret = DMSHelper.getOneHopAwayIndices(i);
                for (LinkedTriaSurface.LinkedVert lv : ret) {
                    if (prev.contains(lv)) continue;
                    prev.add(lv);
                    this_round_found.add(lv);
                }
            }
            last = this_round_found;
            ++c;
        }
        if (last.contains(start)) {
            last.remove(start);
        }
        return last;
    }

    public static ArrayList<LinkedTriaSurface.LinkedVert> getAllUpToNHopsAwayIndices(LinkedTriaSurface.LinkedVert startindex, int hops) {
        ArrayList<LinkedTriaSurface.LinkedVert> ret = new ArrayList<LinkedTriaSurface.LinkedVert>();
        ret.addAll(startindex.get_neighbours());
        int c = 1;
        while (c < hops) {
            ArrayList<LinkedTriaSurface.LinkedVert> temp = new ArrayList<LinkedTriaSurface.LinkedVert>(ret);
            for (LinkedTriaSurface.LinkedVert lv : ret) {
                for (LinkedTriaSurface.LinkedVert ilv : lv.get_neighbours()) {
                    if (temp.contains(ilv)) continue;
                    temp.add(ilv);
                }
            }
            ret.addAll(temp);
            ++c;
        }
        return ret;
    }

    public static LinkedTriaSurface.LinkedVert lvAddFuzzy(DMSurface cs, Point3d p) {
        return DMSHelper.lvAddFuzzy(cs, p, 0.01);
    }

    public static LinkedTriaSurface.LinkedVert lvAddFuzzy(DMSurface cs, Point3d p, double fuzziness) {
        for (LinkedTriaSurface.LinkedVert lv : cs._vlist) {
            Vector3d lvp = new Vector3d((Tuple3d)lv._p);
            lvp.sub((Tuple3d)p);
            if (!(lvp.length() < fuzziness)) continue;
            return lv;
        }
        return cs.add_vert(p);
    }

    public void rotate(LinkedTriaSurface lts, Vector3d axis, double angle, Point3d sp) {
        CoordinateConverter cc_conv = CoordinateConverter.get_converter(MasterControl.get_is());
        sp = cc_conv.grid_to_world_p3d(sp);
        Matrix4d trans = new Matrix4d();
        trans.setIdentity();
        trans.setTranslation(new Vector3d(-sp.x, -sp.y, -sp.z));
        Matrix4d rm = Voxelize.rotationMatrixAroundAxis(axis, angle);
        Matrix4d trans_back = new Matrix4d();
        trans_back.setIdentity();
        trans_back.setTranslation(new Vector3d(sp.x, sp.y, sp.z));
        Matrix4d m = new Matrix4d(trans_back);
        m.mul(rm);
        m.mul(trans);
        for (LinkedTriaSurface.LinkedVert lv : lts._vlist) {
            lv.transform(m);
        }
    }
}

