/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import main.CoordinateConverter;
import main.ImageStack;
import main.MasterControl;
import main.seggen.dm.surface.ExtendedBitcube;
import main.seggen.dm.surface.IUserDataHandler;
import main.seggen.dm.surface.Label;
import main.seggen.dm.surface.Voxelize;
import main.seggen.dm.surface.userdata.IndexDataHandler;
import main.seggen.dm.surface.userdata.NormalData;
import main.seggen.dm.surface.userdata.NormalDataHandler;
import misc.Voxel;
import misc.grid.BitCube;
import misc.linkedsurface.LinkedTriaSurface;

public class DMSurface
extends LinkedTriaSurface {
    public static final String RemoveInFrontOfPlaneName = "adjuster.removeInfrontOfPlane";
    private LinkedList<IUserDataHandler> _user_object_handler;
    private boolean _initialized = false;
    public Voxel _center;
    public HashMap<String, Label<LinkedTriaSurface.LinkedTria>> _tria_labels = new HashMap();
    public HashMap<String, Label<LinkedTriaSurface.LinkedVert>> _vert_labels = new HashMap();
    public HashMap<String, Label<LinkedTriaSurface.LinkedEdge>> _edge_labels = new HashMap();
    public String _type = "";
    public String _name = "";

    public DMSurface() {
        this._user_object_handler = new LinkedList();
        this._user_object_handler.add(new NormalDataHandler());
        this._user_object_handler.add(IndexDataHandler.getInstance());
    }

    public void addUserDataHandler(IUserDataHandler udh) {
        if (udh instanceof NormalDataHandler) {
            return;
        }
        if (udh instanceof IndexDataHandler) {
            return;
        }
        this._user_object_handler.add(udh);
        if (this._initialized) {
            udh.didInit(this);
        }
    }

    public Iterator<IUserDataHandler> getUserDataHandler() {
        return this._user_object_handler.iterator();
    }

    public void clearUserDataHandler() {
        this._user_object_handler = new LinkedList();
        this._user_object_handler.add(new NormalDataHandler());
        this._user_object_handler.add(IndexDataHandler.getInstance());
    }

    public void didLoad() {
        for (IUserDataHandler uoHandler : this._user_object_handler) {
            uoHandler.didInit(this);
        }
        this._initialized = true;
    }

    public void addToVertexPosition(LinkedTriaSurface.LinkedVert lv, Vector3d update, int step) {
        lv.add((Tuple3d)update);
        if (this._initialized) {
            for (IUserDataHandler uoHandler : this._user_object_handler) {
                uoHandler.didChangeVert(step, this, lv, update);
            }
        }
    }

    public void voxelize(BitCube bc) {
        this.voxelize(bc, true);
    }

    public void voxelize(BitCube bc, boolean filled) {
        CoordinateConverter cc_conv = CoordinateConverter.get_converter(MasterControl.get_is());
        ExtendedBitcube ebc = new ExtendedBitcube(bc.get_dim_x(), bc.get_dim_y(), bc.get_dim_z());
        for (LinkedTriaSurface.LinkedTria lt : this._flist) {
            Point3d p1 = cc_conv.world_to_grid_p3d(lt._a._p);
            Point3d p2 = cc_conv.world_to_grid_p3d(lt._b._p);
            Point3d p3 = cc_conv.world_to_grid_p3d(lt._c._p);
            ebc.setTria(p1, p2, p3, true);
        }
        if (filled) {
            ebc.calc_bb();
            Point3d _myCube_center = this.CenterOfMassBC(ebc, ebc._bb_min[0], ebc._bb_max[0], ebc._bb_min[1], ebc._bb_max[1], ebc._bb_min[2], ebc._bb_max[2]);
            _myCube_center = cc_conv.world_to_grid_p3d(_myCube_center);
            Point3f _myCube_center_f = new Point3f((float)_myCube_center.x, (float)_myCube_center.y, (float)_myCube_center.z);
            ebc.floodFill(_myCube_center_f);
        }
        bc.copy_data_from(ebc);
    }

    public int[] boundingBox() {
        int[] ret = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        for (LinkedTriaSurface.LinkedVert lv : this._vlist) {
            Point3d p = lv._p;
            if ((int)p.x < ret[0]) {
                ret[0] = (int)p.x;
            }
            if ((int)p.x > ret[3]) {
                ret[3] = (int)p.x;
            }
            if ((int)p.y < ret[1]) {
                ret[1] = (int)p.y;
            }
            if ((int)p.y > ret[4]) {
                ret[4] = (int)p.y;
            }
            if ((int)p.z < ret[2]) {
                ret[2] = (int)p.z;
            }
            if ((int)p.z <= ret[5]) continue;
            ret[5] = (int)p.z;
        }
        return ret;
    }

    public void calc_normals() {
        for (LinkedTriaSurface.LinkedTria face : this._flist) {
            Vector3d normal;
            ((NormalData)face.get_user_data((int)NormalData._DATA_ID)).normal = normal = face.calc_normal();
        }
        for (LinkedTriaSurface.LinkedVert lv : this._vlist) {
            ((NormalData)lv.get_user_data((int)NormalData._DATA_ID)).normal = new Vector3d();
            for (LinkedTriaSurface.LinkedTria lt : lv._fp) {
                ((NormalData)lv.get_user_data((int)NormalData._DATA_ID)).normal.add((Tuple3d)((NormalData)lt.get_user_data((int)NormalData._DATA_ID)).normal);
            }
            ((NormalData)lv.get_user_data((int)NormalData._DATA_ID)).normal.normalize();
        }
        for (LinkedTriaSurface.LinkedEdge le : this._elist) {
            ((NormalData)le.get_user_data((int)NormalData._DATA_ID)).normal = new Vector3d();
            ((NormalData)le.get_user_data((int)NormalData._DATA_ID)).normal.add((Tuple3d)((NormalData)le._a.get_user_data((int)NormalData._DATA_ID)).normal);
            ((NormalData)le.get_user_data((int)NormalData._DATA_ID)).normal.add((Tuple3d)((NormalData)le._b.get_user_data((int)NormalData._DATA_ID)).normal);
            ((NormalData)le.get_user_data((int)NormalData._DATA_ID)).normal.normalize();
        }
    }

    public void removeTriasInFrontOfPlaneAndClose(Point3d pointOnPlane, Vector3d planeNormal) {
        this.willBeginTransformation(RemoveInFrontOfPlaneName, null);
        LinkedList<LinkedTriaSurface.LinkedTria> toBeDeleted = new LinkedList<LinkedTriaSurface.LinkedTria>();
        for (LinkedTriaSurface.LinkedTria lt : this._flist) {
            if (!(Voxelize.distancePointPlane(lt._a._p, pointOnPlane, planeNormal) > 0.0) || !(Voxelize.distancePointPlane(lt._b._p, pointOnPlane, planeNormal) > 0.0) || !(Voxelize.distancePointPlane(lt._c._p, pointOnPlane, planeNormal) > 0.0)) continue;
            toBeDeleted.add(lt);
        }
        while (toBeDeleted.size() > 0) {
            this.del_face((LinkedTriaSurface.LinkedTria)toBeDeleted.removeFirst());
        }
        LinkedList<LinkedTriaSurface.LinkedEdge> halfEdges = new LinkedList<LinkedTriaSurface.LinkedEdge>();
        for (LinkedTriaSurface.LinkedEdge le : this._elist) {
            if (le._fp.size() >= 2) continue;
            halfEdges.add(le);
        }
        Point3d heCenter = new Point3d();
        for (LinkedTriaSurface.LinkedEdge le : halfEdges) {
            heCenter.add((Tuple3d)le._a._p);
            heCenter.add((Tuple3d)le._b._p);
        }
        heCenter.scale(1.0 / ((double)halfEdges.size() * 2.0));
        LinkedTriaSurface.LinkedVert heCenterVert = this.add_vert(heCenter);
        for (LinkedTriaSurface.LinkedEdge le : halfEdges) {
            if (le.compare_orientation(le._fp.getFirst())) {
                this.add_face(le._b, le._a, heCenterVert);
                continue;
            }
            this.add_face(le._b, le._a, heCenterVert);
        }
        this.didEndTransformation(RemoveInFrontOfPlaneName, null);
    }

    public void willBeginTransformation(String handler, Object data) {
        for (IUserDataHandler uoHandler : this._user_object_handler) {
            uoHandler.willBeginTransformation(this, handler, data);
        }
    }

    public void didEndTransformation(String handler, Object data) {
        for (IUserDataHandler uoHandler : this._user_object_handler) {
            uoHandler.didEndTransformation(this, handler, data);
        }
    }

    @Override
    public LinkedTriaSurface.LinkedVert add_vert(Point3d p) {
        LinkedTriaSurface.LinkedVert lv;
        if (this._vertex_hash.containsKey(p)) {
            lv = (LinkedTriaSurface.LinkedVert)this._vertex_hash.get(p);
        } else {
            Point3d new_point = new Point3d(p);
            lv = new LinkedTriaSurface.LinkedVert((LinkedTriaSurface)this, new_point);
            this._vlist.add(lv);
            this._vertex_hash.put(new_point, lv);
            if (this._initialized) {
                for (IUserDataHandler uoHandler : this._user_object_handler) {
                    uoHandler.didAddVert(this, lv);
                }
            }
        }
        return lv;
    }

    @Override
    public LinkedTriaSurface.LinkedEdge add_edge(LinkedTriaSurface.LinkedVert a, LinkedTriaSurface.LinkedVert b) {
        LinkedTriaSurface.LinkedEdge re = this.find_edge(a, b);
        if (re == null) {
            re = new LinkedTriaSurface.LinkedEdge(this, a, b);
            this._elist.add(re);
            if (this._initialized) {
                for (IUserDataHandler uoHandler : this._user_object_handler) {
                    uoHandler.didAddEdge(this, re);
                }
            }
        }
        return re;
    }

    @Override
    public LinkedTriaSurface.LinkedTria add_face(LinkedTriaSurface.LinkedVert a, LinkedTriaSurface.LinkedVert b, LinkedTriaSurface.LinkedVert c) {
        LinkedTriaSurface.LinkedTria lface = null;
        for (LinkedTriaSurface.LinkedTria tria : a._fp) {
            if (!tria.equals(a, b, c)) continue;
            lface = tria;
            break;
        }
        if (lface == null) {
            lface = new LinkedTriaSurface.LinkedTria(this, a, b, c);
            this._flist.add(lface);
            if (this._initialized) {
                for (IUserDataHandler uoHandler : this._user_object_handler) {
                    uoHandler.didAddTria(this, lface);
                }
            }
        }
        return lface;
    }

    @Override
    public void del_vert(LinkedTriaSurface.LinkedVert vert) {
        if (vert._ep.size() == 0 && vert._fp.size() == 0 && this._vertex_hash.get(vert._p) == vert) {
            if (this._initialized) {
                for (IUserDataHandler uoHandler : this._user_object_handler) {
                    uoHandler.willDeleteVert(this, vert);
                }
            }
            this._vlist.remove(vert);
            this._vertex_hash.remove(vert._p);
        }
    }

    @Override
    public void del_edge(LinkedTriaSurface.LinkedEdge edge) {
        if (edge._fp.size() == 0 && edge._a._ep.contains(edge)) {
            if (this._initialized) {
                for (IUserDataHandler uoHandler : this._user_object_handler) {
                    uoHandler.willDeleteEdge(this, edge);
                }
            }
            edge._a._ep.remove(edge);
            edge._b._ep.remove(edge);
            this._elist.remove(edge);
            if (edge._a._ep.size() == 0) {
                this.del_vert(edge._a);
            }
            if (edge._b._ep.size() == 0) {
                this.del_vert(edge._b);
            }
        }
    }

    @Override
    public void del_face(LinkedTriaSurface.LinkedTria face) {
        if (face._a._fp.contains(face)) {
            if (this._initialized) {
                for (IUserDataHandler uoHandler : this._user_object_handler) {
                    uoHandler.willDeleteTria(this, face);
                }
            }
            face._ab._fp.remove(face);
            face._bc._fp.remove(face);
            face._ca._fp.remove(face);
            face._a._fp.remove(face);
            face._b._fp.remove(face);
            face._c._fp.remove(face);
            this._flist.remove(face);
            this.del_edge(face._ab);
            this.del_edge(face._bc);
            this.del_edge(face._ca);
            this.del_vert(face._a);
            this.del_vert(face._b);
            this.del_vert(face._c);
        }
    }

    private Point3d CenterOfMassBC(BitCube myCube, int xBegin, int xEnd, int yBegin, int yEnd, int zBegin, int zEnd) {
        CoordinateConverter cc_conv = CoordinateConverter.get_converter(MasterControl.get_is());
        Point3d centerOfMass = new Point3d(0.0, 0.0, 0.0);
        double registeredPoints = 0.0;
        int z = zBegin;
        while (z <= zEnd) {
            int y = yBegin;
            while (y <= yEnd) {
                int x = xBegin;
                while (x <= xEnd) {
                    if (myCube.getXYZ(x, y, z)) {
                        centerOfMass.add((Tuple3d)cc_conv.grid_to_world_p3d(x, y, z));
                        registeredPoints += 1.0;
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        if (registeredPoints > 0.0) {
            centerOfMass.scale(1.0 / registeredPoints);
        }
        return centerOfMass;
    }

    public Point3d CenterOfMass() {
        CoordinateConverter cc_conv = CoordinateConverter.get_converter(MasterControl.get_is());
        ImageStack is = MasterControl.get_is();
        BitCube bc = new BitCube(is.get_dim_x(), is.get_dim_y(), is.get_dim_z());
        ExtendedBitcube ebc = new ExtendedBitcube(bc);
        for (LinkedTriaSurface.LinkedTria lt : this._flist) {
            Point3d p1 = cc_conv.world_to_grid_p3d(lt._a._p);
            Point3d p2 = cc_conv.world_to_grid_p3d(lt._b._p);
            Point3d p3 = cc_conv.world_to_grid_p3d(lt._c._p);
            ebc.setTria(p1, p2, p3, true);
        }
        ebc.calc_bb();
        Point3d _myCube_center = this.CenterOfMassBC(ebc, ebc._bb_min[0], ebc._bb_max[0], ebc._bb_min[1], ebc._bb_max[1], ebc._bb_min[2], ebc._bb_max[2]);
        return _myCube_center;
    }

    public Point3d CenterOfMassOfVertices() {
        Point3d center = new Point3d();
        for (LinkedTriaSurface.LinkedVert lv : this._vlist) {
            center.add((Tuple3d)lv._p);
        }
        center.scale(1.0 / (double)this._vlist.size());
        return center;
    }
}

