/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface;

import java.util.ArrayList;
import java.util.Iterator;
import javax.media.j3d.IndexedTriangleArray;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import main.CoordinateConverter;
import main.ImageStack;
import main.MasterControl;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.IUserDataHandler;
import main.seggen.dm.surface.userdata.IndexDataHandler;
import main.seggen.dm.surface.userdata.NormalData;
import misc.linkedsurface.IndexData;
import misc.linkedsurface.LinkedTriaSurface;

public class DMSurfaceToITA {
    public static IndexedTriangleArray getITA(DMSurface dms, boolean color) {
        Iterator<IUserDataHandler> iter = dms.getUserDataHandler();
        while (iter.hasNext()) {
            IUserDataHandler handler = iter.next();
            if (!(handler instanceof IndexDataHandler)) continue;
            return DMSurfaceToITA.calc_indexed(dms, color);
        }
        return DMSurfaceToITA.calc_nonindexed(dms, color);
    }

    private static IndexedTriangleArray calc_nonindexed(DMSurface dms, boolean color) {
        IndexedTriangleArray itageom;
        ImageStack is = MasterControl.get_is();
        CoordinateConverter cc_conv = CoordinateConverter.get_converter(is);
        ArrayList<Point3d> _vertices = new ArrayList<Point3d>();
        ArrayList<LinkedTriaSurface.LinkedVert> _verticeslv = new ArrayList<LinkedTriaSurface.LinkedVert>();
        ArrayList<Vector3f> _normals = new ArrayList<Vector3f>();
        ArrayList<Integer> _trias = new ArrayList<Integer>();
        for (LinkedTriaSurface.LinkedVert lv : dms._vlist) {
            _verticeslv.add(lv);
            Vector3d tn = ((NormalData)lv.get_user_data((int)NormalData._DATA_ID)).normal;
            Vector3f vtnf = cc_conv.world_to_grid_v3f(tn);
            vtnf.normalize();
            _normals.add(vtnf);
        }
        for (LinkedTriaSurface.LinkedTria lf : dms._flist) {
            int ind = _verticeslv.indexOf(lf._a);
            if (ind < 0) {
                System.err.println("negative index");
            }
            _trias.add(ind);
            ind = _verticeslv.indexOf(lf._b);
            if (ind < 0) {
                System.err.println("negative index");
            }
            _trias.add(ind);
            ind = _verticeslv.indexOf(lf._c);
            if (ind < 0) {
                System.err.println("negative index");
            }
            _trias.add(ind);
        }
        int c = 0;
        while (c < _verticeslv.size()) {
            _vertices.add(new Point3d());
            ++c;
        }
        c = 0;
        while (c < _verticeslv.size()) {
            _vertices.set(c, cc_conv.world_to_grid_p3d(((LinkedTriaSurface.LinkedVert)_verticeslv.get((int)c))._p));
            ++c;
        }
        int[] indices = new int[_trias.size()];
        Vector3f[] normals = new Vector3f[_normals.size()];
        Point3d[] vertices = new Point3d[_vertices.size()];
        if (indices.length == 0) {
            IndexedTriangleArray itageom2 = null;
            return itageom2;
        }
        if (color) {
            itageom = new IndexedTriangleArray(vertices.length, 7, indices.length);
            itageom.setCapability(3);
            itageom.setCapability(2);
        } else {
            itageom = new IndexedTriangleArray(vertices.length, 3, indices.length);
        }
        c = 0;
        while (c < _vertices.size()) {
            normals[c] = (Vector3f)_normals.get(c);
            vertices[c] = (Point3d)_vertices.get(c);
            ++c;
        }
        c = 0;
        while (c < _trias.size()) {
            indices[c] = (Integer)_trias.get(c);
            ++c;
        }
        itageom.setNormals(0, normals);
        itageom.setCoordinates(0, vertices);
        itageom.setCoordinateIndices(0, indices);
        itageom.setNormalIndices(0, indices);
        if (color) {
            itageom.setColorIndices(0, indices);
        }
        return itageom;
    }

    private static IndexedTriangleArray calc_indexed(DMSurface dms, boolean add_color) {
        IndexedTriangleArray itageom;
        ImageStack is = MasterControl.get_is();
        CoordinateConverter cc_conv = CoordinateConverter.get_converter(is);
        int max_idx = IndexDataHandler.getInstance().getMaxIndex(dms);
        int[] indices = new int[dms._flist.size() * 3];
        Vector3f[] normals = new Vector3f[max_idx + 1];
        Point3d[] vertices = new Point3d[max_idx + 1];
        int i = 0;
        while (i < max_idx + 1) {
            normals[i] = new Vector3f();
            vertices[i] = new Point3d();
            ++i;
        }
        if (indices.length == 0) {
            IndexedTriangleArray itageom2 = null;
            return itageom2;
        }
        if (add_color) {
            itageom = new IndexedTriangleArray(vertices.length, 7, indices.length);
            itageom.setCapability(3);
            itageom.setCapability(2);
        } else {
            itageom = new IndexedTriangleArray(vertices.length, 3, indices.length);
        }
        i = 0;
        while (i < dms._vlist.size()) {
            LinkedTriaSurface.LinkedVert lv = (LinkedTriaSurface.LinkedVert)dms._vlist.get(i);
            int idx = ((IndexData)lv.get_user_data((int)IndexData._DATA_ID))._i;
            vertices[idx] = cc_conv.world_to_grid_p3d(lv._p);
            normals[idx] = cc_conv.world_to_grid_v3f(((NormalData)lv.get_user_data((int)NormalData._DATA_ID)).normal);
            normals[idx].normalize();
            ++i;
        }
        int c = 0;
        while (c < dms._flist.size()) {
            LinkedTriaSurface.LinkedTria lt = (LinkedTriaSurface.LinkedTria)dms._flist.get(c);
            indices[c * 3] = ((IndexData)lt._a.get_user_data((int)IndexData._DATA_ID))._i;
            indices[c * 3 + 1] = ((IndexData)lt._b.get_user_data((int)IndexData._DATA_ID))._i;
            indices[c * 3 + 2] = ((IndexData)lt._c.get_user_data((int)IndexData._DATA_ID))._i;
            ++c;
        }
        itageom.setNormals(0, normals);
        itageom.setCoordinates(0, vertices);
        itageom.setCoordinateIndices(0, indices);
        itageom.setNormalIndices(0, indices);
        if (add_color) {
            itageom.setColorIndices(0, indices);
        }
        return itageom;
    }
}

