/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import main.seggen.dm.surface.DMSWIndexData;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.Label;
import misc.linkedsurface.LinkedTriaSurface;

public class DMSurfaceWriter {
    public static String LN = "\n";
    public static int VERTS_PER_LINE = 1;
    public static int TRIAS_PER_LINE = 3;
    public static int LABELS_PER_LINE = 8;
    public static String KEY_GEOMETRY = "geometry";
    public static String KEY_VERTICES = "vertices";
    public static String KEY_INDEXED_TRIANGLES = "itriangles";
    public static String KEY_LABELS = "labels";
    public static String VLABELS = "vlabels";
    public static String TLABELS = "tlabels";
    public static String ELABELS = "elabels";
    public static String VLABEL = "vlabel";
    public static String TLABEL = "tlabel";
    public static String ELABEL = "elabel";
    private File _f;
    private FileWriter _fw;
    DMSurface _cs;
    private Transform3D trans;

    public DMSurfaceWriter(DMSurface cs, File f) {
        this(cs, f, new Transform3D());
    }

    public DMSurfaceWriter(DMSurface cs, File f, Transform3D trans) {
        this._f = f;
        this._cs = cs;
        this.trans = trans;
    }

    private void write_vert(FileWriter fw, LinkedTriaSurface.LinkedVert v) throws IOException {
        Point3d p = new Point3d(v._p);
        this.trans.transform(p);
        fw.write("" + p);
    }

    private void write_tria(LinkedTriaSurface.LinkedTria t) throws IOException {
        int a = ((DMSWIndexData)t._a.get_user_data((int)DMSWIndexData._DATA_ID))._i;
        int b = ((DMSWIndexData)t._b.get_user_data((int)DMSWIndexData._DATA_ID))._i;
        int c = ((DMSWIndexData)t._c.get_user_data((int)DMSWIndexData._DATA_ID))._i;
        this._fw.write("(" + a + ", " + b + ", " + c + ")");
    }

    private void write_vert_label(Label<LinkedTriaSurface.LinkedVert> label) throws IOException {
        this.start(VLABEL, label.attributes);
        Iterator<LinkedTriaSurface.LinkedVert> lv_it = label.get_elements();
        if (lv_it.hasNext()) {
            LinkedTriaSurface.LinkedVert lv = lv_it.next();
            int idx = ((DMSWIndexData)lv.get_user_data((int)DMSWIndexData._DATA_ID))._i;
            this._fw.write("" + idx);
            int counter = 1;
            while (lv_it.hasNext()) {
                lv = lv_it.next();
                idx = ((DMSWIndexData)lv.get_user_data((int)DMSWIndexData._DATA_ID))._i;
                if (counter % LABELS_PER_LINE == 0) {
                    this._fw.write(" ;" + LN + idx);
                } else {
                    this._fw.write(" ; " + idx);
                }
                ++counter;
            }
            this._fw.write(LN);
        }
        this.end(VLABEL);
    }

    private void write_tria_label(Label<LinkedTriaSurface.LinkedTria> label) throws IOException {
        this.start(TLABEL, label.attributes);
        Iterator<LinkedTriaSurface.LinkedTria> lt_it = label.get_elements();
        if (lt_it.hasNext()) {
            LinkedTriaSurface.LinkedTria lt = lt_it.next();
            int idx = ((DMSWIndexData)lt.get_user_data((int)DMSWIndexData._DATA_ID))._i;
            this._fw.write("" + idx);
            int counter = 1;
            while (lt_it.hasNext()) {
                lt = lt_it.next();
                idx = ((DMSWIndexData)lt.get_user_data((int)DMSWIndexData._DATA_ID))._i;
                if (counter % LABELS_PER_LINE == 0) {
                    this._fw.write(" ;" + LN + idx);
                } else {
                    this._fw.write(" ; " + idx);
                }
                ++counter;
            }
            this._fw.write(LN);
        }
        this.end(TLABEL);
    }

    private void write_edge_label(Label<LinkedTriaSurface.LinkedEdge> label) throws IOException {
        this.start(ELABEL, label.attributes);
        Iterator<LinkedTriaSurface.LinkedEdge> le_it = label.get_elements();
        if (le_it.hasNext()) {
            LinkedTriaSurface.LinkedEdge le = le_it.next();
            int idx_a = ((DMSWIndexData)le._a.get_user_data((int)DMSWIndexData._DATA_ID))._i;
            int idx_b = ((DMSWIndexData)le._b.get_user_data((int)DMSWIndexData._DATA_ID))._i;
            this._fw.write("(" + idx_a + ", " + idx_b + ")");
            int counter = 1;
            while (le_it.hasNext()) {
                le = le_it.next();
                idx_a = ((DMSWIndexData)le._a.get_user_data((int)DMSWIndexData._DATA_ID))._i;
                idx_b = ((DMSWIndexData)le._b.get_user_data((int)DMSWIndexData._DATA_ID))._i;
                if (counter % LABELS_PER_LINE == 0) {
                    this._fw.write(" ;" + LN + "(" + idx_a + ", " + idx_b + ")");
                } else {
                    this._fw.write(" ; (" + idx_a + ", " + idx_b + ")");
                }
                ++counter;
            }
            this._fw.write(LN);
        }
        this.end(ELABEL);
    }

    private void start(String key, HashMap<String, String> attributes) throws IOException {
        if (attributes == null) {
            this._fw.write("<" + key + ">" + LN);
        } else {
            this._fw.write("<" + key);
            for (String akey : attributes.keySet()) {
                this._fw.write(" " + akey + "=\"" + attributes.get(akey) + "\"");
            }
            this._fw.write(">" + LN);
        }
    }

    private void start(String key) throws IOException {
        this.start(key, null);
    }

    private void end(String key) throws IOException {
        this._fw.write("</" + key + ">" + LN);
    }

    public void write_data() throws IOException {
        this._fw = new FileWriter(this._f);
        this._fw.write("<model type=\"" + this._cs._type + "\" name=\"" + this._cs._name + "\">" + LN);
        this.start(KEY_GEOMETRY);
        this.start(KEY_VERTICES);
        if (this._cs._vlist.size() != 0) {
            Iterator vi = this._cs._vlist.iterator();
            int vert_idx = 0;
            LinkedTriaSurface.LinkedVert lv = (LinkedTriaSurface.LinkedVert)vi.next();
            lv.set_user_data(DMSWIndexData._DATA_ID, new DMSWIndexData(vert_idx++));
            this.write_vert(this._fw, lv);
            while (vi.hasNext()) {
                this._fw.write(" ; ");
                if ((vert_idx + 1) % VERTS_PER_LINE == 0) {
                    this._fw.write(LN);
                }
                lv = (LinkedTriaSurface.LinkedVert)vi.next();
                lv.set_user_data(DMSWIndexData._DATA_ID, new DMSWIndexData(vert_idx++));
                this.write_vert(this._fw, lv);
            }
            this._fw.write(LN);
        }
        this.end(KEY_VERTICES);
        this.start(KEY_INDEXED_TRIANGLES);
        if (this._cs._flist.size() != 0) {
            Iterator ti = this._cs._flist.iterator();
            int tria_idx = 0;
            LinkedTriaSurface.LinkedTria lt = (LinkedTriaSurface.LinkedTria)ti.next();
            lt.set_user_data(DMSWIndexData._DATA_ID, new DMSWIndexData(tria_idx++));
            this.write_tria(lt);
            while (ti.hasNext()) {
                this._fw.write(" ; ");
                if ((tria_idx + 1) % TRIAS_PER_LINE == 0) {
                    this._fw.write(LN);
                }
                lt = (LinkedTriaSurface.LinkedTria)ti.next();
                lt.set_user_data(DMSWIndexData._DATA_ID, new DMSWIndexData(tria_idx++));
                this.write_tria(lt);
            }
            this._fw.write(LN);
        }
        this.end(KEY_INDEXED_TRIANGLES);
        this.end(KEY_GEOMETRY);
        if (this._cs._vert_labels.keySet().size() > 0 || this._cs._edge_labels.keySet().size() > 0 || this._cs._tria_labels.keySet().size() > 0) {
            this.start(KEY_LABELS);
            if (this._cs._vert_labels.keySet().size() > 0) {
                this.start(VLABELS);
                for (String vert_key : this._cs._vert_labels.keySet()) {
                    this.write_vert_label(this._cs._vert_labels.get(vert_key));
                }
                this.end(VLABELS);
            }
            if (this._cs._tria_labels.keySet().size() > 0) {
                this.start(TLABELS);
                for (String tria_key : this._cs._tria_labels.keySet()) {
                    this.write_tria_label(this._cs._tria_labels.get(tria_key));
                }
                this.end(TLABELS);
            }
            if (this._cs._edge_labels.keySet().size() > 0) {
                this.start(ELABELS);
                for (String edge_key : this._cs._edge_labels.keySet()) {
                    this.write_edge_label(this._cs._edge_labels.get(edge_key));
                }
                this.end(ELABELS);
            }
            this.end(KEY_LABELS);
        }
        this._fw.write("</model>" + LN);
        this._fw.flush();
        this._fw.close();
    }
}

