/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface;

import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import main.seggen.dm.surface.Voxelize;
import misc.Voxel;
import misc.VoxelQueue;
import misc.grid.BitCube;
import misc.grid.N6Iterator;
import misc.linkedsurface.LinkedTriaSurface;

public class ExtendedBitcube
extends BitCube {
    public ExtendedBitcube(BitCube bc) {
        super(bc);
    }

    public ExtendedBitcube(int x, int y, int z) {
        super(x, y, z);
    }

    public void floodFill(Point3f start) {
        this.floodFill(start, 2000);
    }

    public void floodFill(Point3f start_3f, int queueSize) {
        Voxel start = new Voxel((int)start_3f.x, (int)start_3f.y, (int)start_3f.z);
        if (this.getXYZ(start._x, start._y, start._z)) {
            return;
        }
        N6Iterator _n6i = new N6Iterator(this);
        VoxelQueue vq = new VoxelQueue(queueSize);
        vq.store(start);
        Voxel v = new Voxel();
        while (vq.size() > 0) {
            vq.fetch(v);
            _n6i.init(v._x, v._y, v._z);
            while (_n6i.next(v)) {
                if (this.getXYZ(v._x, v._y, v._z)) continue;
                this.setXYZ(v._x, v._y, v._z, true);
                vq.store(v);
            }
        }
    }

    public void setLine(Point3i p1, Point3i p2) {
        ArrayList<Voxel> voxels = Voxelize.setLine(p1, p2);
        for (Voxel v : voxels) {
            this.setXYZ(v._x, v._y, v._z, true);
        }
    }

    public void setTria(Point3d p1, Point3d p2, Point3d p3, boolean filled) {
        Point3i p1i = new Point3i((int)p1.x, (int)p1.y, (int)p1.z);
        Point3i p2i = new Point3i((int)p2.x, (int)p2.y, (int)p2.z);
        Point3i p3i = new Point3i((int)p3.x, (int)p3.y, (int)p3.z);
        this.setTria(p1i, p2i, p3i, filled);
    }

    public void setTria(LinkedTriaSurface.LinkedTria lt, boolean filled) {
        Point3i p1 = new Point3i((int)lt._a._p.x, (int)lt._a._p.y, (int)lt._a._p.z);
        Point3i p2 = new Point3i((int)lt._b._p.x, (int)lt._b._p.y, (int)lt._b._p.z);
        Point3i p3 = new Point3i((int)lt._c._p.x, (int)lt._c._p.y, (int)lt._c._p.z);
        this.setTria(p1, p2, p3, filled);
    }

    public void setTria(Point3i p1, Point3i p2, Point3i p3, boolean filled) {
        ArrayList<Voxel> voxels = Voxelize.setTria(p1, p2, p3, true);
        for (Voxel v : voxels) {
            if (v._x < 0 || v._x >= this._dim_x || v._y < 0 || v._y >= this._dim_y || v._z < 0 || v._z >= this._dim_z) continue;
            this.setXYZ(v._x, v._y, v._z, true);
        }
    }
}

